/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.server;

import com.idoox.debug.Category;
import com.idoox.wasp.server.ServiceConnector;
import com.systinet.wasp.webservice.RegistryImpl;
import com.systinet.wasp.webservice.ServiceEndpointContextImpl;
import java.util.Map;
import org.idoox.config.Configurable;
import org.idoox.config.Configurator;
import org.idoox.wasp.Context;
import org.idoox.webservice.server.LifeCycleService;
import org.idoox.webservice.server.WebServiceContext;
import org.systinet.wasp.webservice.Current;
import org.systinet.wasp.webservice.ServiceInstance;
import org.systinet.wasp.webservice.ServiceInstanceContext;

public class WebServiceContextImpl
extends WebServiceContext {
    private static final Category log = Category.getCategory("com.idoox.wasp.server.WebServiceContextImpl");
    private String id;
    private String name;
    private ServiceInstanceContext serviceInstanceContext;
    private Configurable configurable;

    public WebServiceContextImpl(String name, ServiceInstanceContext serviceInstanceContext) {
        this.name = name;
        Configurable cfg = serviceInstanceContext.getServiceInstance().getConfigurable();
        if (cfg != null) {
            if (cfg.getType() != null) {
                while (!cfg.getType().equals("config")) {
                    cfg = cfg.getParent();
                }
                this.id = cfg.getName();
            } else {
                this.id = "config:[]{][]{][" + System.identityHashCode(serviceInstanceContext.getServiceInstance()) + "]";
            }
        }
        this.configurable = cfg;
        this.serviceInstanceContext = serviceInstanceContext;
    }

    public LifeCycleService getLifeCycleService() {
        return this.getConnector().getLifeCycleService();
    }

    public String getContextId() {
        return this.id;
    }

    public Configurable getServiceInstanceConfigurable() {
        if (this.configurable != null) {
            return this.configurable;
        }
        Configurator configurator = (Configurator)Context.getInstance("org.idoox.config.Configurator");
        Configurable serviceConfig = Configurator.getConfigurable("config", this.id);
        if (serviceConfig == null) {
            throw new RuntimeException("Internal exception: Can not get configurable for " + this.id + ". Possibly runtime published service.");
        }
        return serviceConfig;
    }

    public Configurable getServiceConfigurable() {
        return this.getServiceInstanceConfigurable();
    }

    public Map getContextData() {
        return this.getServiceInstance().getContext().getContextData();
    }

    public void log(String msg) {
        this.getServiceInstance().log(msg);
    }

    public void log(String message, Throwable throwable) {
        this.getServiceInstance().log(message, throwable);
    }

    public String getRootPath() {
        return this.getServiceInstance().getResource("/");
    }

    public String getServiceInstanceName() {
        return this.name;
    }

    public String getServiceName() {
        return this.getServiceInstanceName();
    }

    private ServiceConnector getConnector() {
        ServiceEndpointContextImpl sctx = (ServiceEndpointContextImpl)Current.getServiceEndpointContext();
        if (sctx != null) {
            try {
                return ((RegistryImpl)Context.getInstance("org.systinet.wasp.webservice.IRegistry")).getConnector(sctx.getServiceEndpoint().getPath());
            }
            catch (Exception e) {
                log.error("Unable to get service connector:" + e.getMessage());
                return null;
            }
        }
        return null;
    }

    public ServiceInstance getServiceInstance() {
        return this.serviceInstanceContext.getServiceInstance();
    }

    public ServiceInstanceContext getServiceInstanceContext() {
        return this.serviceInstanceContext;
    }
}

