/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.server;

import com.idoox.wasp.WASPConfigurationImpl;
import com.idoox.wasp.server.ServiceConnector;
import com.idoox.wasp.server.WSServiceConfigurationImpl;
import com.systinet.wasp.webservice.RegistryImpl;
import java.util.List;
import java.util.Map;
import org.idoox.wasp.Context;
import org.idoox.wasp.client.config.ClientStubConfiguration;
import org.idoox.wasp.server.ServiceMediator;
import org.idoox.wasp.server.WSContext;
import org.idoox.wasp.server.WSRegistry;
import org.idoox.wasp.server.config.ServiceEndpointConfiguration;
import org.idoox.webservice.server.LifeCycleService;
import org.idoox.webservice.server.WebServiceContext;
import org.systinet.wasp.webservice.ServiceEndpoint;
import org.systinet.wasp.webservice.ServiceEndpointContext;
import org.systinet.wasp.webservice.ServiceInstance;

public class WSContextImpl
extends WSContext {
    private ServiceConnector connector;
    private ServiceEndpointContext serviceEndpointContext;
    private WebServiceContext oldServiceEndpointContex;
    private ClientStubConfiguration defaultStubConfiguration;

    public Map getContextData() {
        return this.serviceEndpointContext.getContextData();
    }

    public WSContextImpl(ServiceEndpoint endpoint) {
        try {
            this.serviceEndpointContext = endpoint.getContext();
            this.connector = (ServiceConnector)this.serviceEndpointContext.getContextData().get("core.endpoint_serviceconnector");
            ServiceInstance si = endpoint.getServiceInstance();
            RegistryImpl registry = (RegistryImpl)Context.getInstance("org.systinet.wasp.webservice.IRegistry");
            this.oldServiceEndpointContex = registry.getWebServiceContext(si.toString(), si);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getPath() {
        return this.serviceEndpointContext.getServiceEndpoint().getPath();
    }

    public WSRegistry getWSRegistry() {
        return (WSRegistry)this.serviceEndpointContext.getContextData().get("core.ws_registry");
    }

    public boolean checkAccess(String namespace, String methodName) throws SecurityException {
        return this.connector.checkAccess(methodName, namespace);
    }

    public ClassLoader getClassLoader() {
        return this.connector.getService().getClassSpace().getClassLoader();
    }

    public List getMediators() {
        return this.connector.getMediators();
    }

    public void addMediator(ServiceMediator mediator) {
        this.connector.addMediator(mediator);
    }

    public void removeMediator(ServiceMediator mediator) {
        this.connector.removeMediator(mediator);
    }

    public WebServiceContext getServiceInstance() {
        return this.oldServiceEndpointContex;
    }

    public ServiceEndpointConfiguration getEndpointConfiguration() {
        return new WSServiceConfigurationImpl(this);
    }

    public ClientStubConfiguration getDefaultClientConfiguration() {
        if (this.defaultStubConfiguration == null) {
            this.defaultStubConfiguration = WASPConfigurationImpl.createServiceConfigurationImpl();
        }
        return this.defaultStubConfiguration;
    }

    ServiceConnector getConnector() {
        return this.connector;
    }

    public LifeCycleService getLifeCycleService() {
        return this.getConnector().getLifeCycleService();
    }

    public ServiceEndpoint getServiceEndpoint() {
        return this.serviceEndpointContext.getServiceEndpoint();
    }
}

