/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.server;

import com.idoox.debug.Category;
import com.idoox.wasp.SOAPServiceInfoCache;
import com.idoox.wasp.serialization.SerializationHelper;
import com.idoox.wasp.server.ServiceConnector;
import com.idoox.wasp.server.adaptor.XMLAdaptorException;
import com.idoox.xmlrpc.encoding.EncodingRepository;
import com.systinet.wasp.webservice.ServiceEndpointImpl;
import com.systinet.wasp.webservice.VersionCollection;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.xml.namespace.QName;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.soap.SOAPMessage;
import org.idoox.wasp.Context;
import org.idoox.wasp.InstanceNotFoundException;
import org.idoox.wasp.wsdl.SOAPMethodInfo;
import org.idoox.wasp.wsdl.SOAPPortInfo;
import org.idoox.wasp.wsdl.SOAPServiceInfo;
import org.idoox.xml.Tokenizer;
import org.idoox.xml.TokenizerException;
import org.idoox.xml.schema.Member;
import org.idoox.xml.schema.SchemaException;
import org.idoox.xmlrpc.MessageProcessingException;
import org.idoox.xmlrpc.encoding.EncodingTokenizer;
import org.idoox.xmlrpc.encoding.NoSuchEncodingException;
import org.systinet.wasp.soap.WaspInternalSOAPMessage;
import org.systinet.wasp.soap.WaspSOAPMessage;

public class VersioningInstanceSelector {
    private static final Category cat = Category.getCategory("com.idoox.wasp.server.VersioningInstanceSelector");
    private static final String OPERATION_INFO_MAP = "wasp.VersioningInstanceSelector.operationInfoMap";

    static OperationInfo selectServiceImplementation(VersionCollection olderVersions, SOAPMessageContext messageContext, ServiceEndpointImpl serviceEndpoint, Tokenizer bodyTokenizer) throws XMLAdaptorException {
        OperationInfo result;
        Map operationInfoMap = VersioningInstanceSelector.getOperationInfoMap(serviceEndpoint, olderVersions);
        SOAPMessage soapMessage = messageContext.getMessage();
        ((WaspInternalSOAPMessage)soapMessage).setAutoClose(true, null);
        String xmlProtocol = ((WaspInternalSOAPMessage)soapMessage).getXMLProtocol();
        QName firstElementQName = VersioningInstanceSelector.getFirstElementQName(bodyTokenizer, serviceEndpoint.getEncodingURI(), serviceEndpoint.getEncodingID());
        String soapAction = VersioningInstanceSelector.getSOAPAction(soapMessage);
        if (soapAction != null && (result = (OperationInfo)operationInfoMap.get(new OperationInfoMapKey(xmlProtocol, soapAction, null))) != null) {
            return result;
        }
        return (OperationInfo)operationInfoMap.get(new OperationInfoMapKey(xmlProtocol, null, firstElementQName));
    }

    private static QName getFirstElementQName(Tokenizer bodyTokenizer, String encodingURI, String encodingID) {
        QName qName = null;
        try {
            if (encodingURI == null) {
                byte token = SerializationHelper.nextNonWhitespace(bodyTokenizer);
                if (token == 2) {
                    qName = new QName(bodyTokenizer.getNamespace(), bodyTokenizer.getLocalName());
                }
            } else {
                byte token;
                EncodingRepository encodingRepository = (EncodingRepository)Context.getInstance("com.idoox.xmlrpc.encoding.EncodingRepository");
                EncodingTokenizer tokenizer = encodingRepository.getEncodingTokenizer(encodingID, encodingURI);
                while ((token = bodyTokenizer.next()) == 4) {
                }
                if (token != 1) {
                    tokenizer.setInput(bodyTokenizer, null);
                    int tok = tokenizer.next();
                    if (tok != 0) {
                        qName = new QName(tokenizer.getTokenNamespaceURI(), tokenizer.getTokenName());
                    }
                }
            }
        }
        catch (TokenizerException e) {
        }
        catch (IOException e) {
        }
        catch (MessageProcessingException e) {
        }
        catch (InstanceNotFoundException e) {
        }
        catch (NoSuchEncodingException e) {
            // empty catch block
        }
        return qName;
    }

    private static String getSOAPAction(SOAPMessage message) {
        String soapAction = ((WaspSOAPMessage)message).getSOAPAction();
        return VersioningInstanceSelector.normalizeSOAPAction(soapAction);
    }

    private static String normalizeSOAPAction(String soapAction) {
        if (soapAction != null) {
            if ("".equals(soapAction)) {
                soapAction = null;
            } else if ("\"\"".equals(soapAction)) {
                soapAction = null;
            } else {
                int l;
                if (soapAction.charAt(0) == '\"') {
                    soapAction = soapAction.substring(1);
                }
                if ((l = soapAction.length()) > 0 && soapAction.charAt(l - 1) == '\"') {
                    soapAction = soapAction.substring(0, l - 1);
                }
            }
        }
        return soapAction;
    }

    private static Map getOperationInfoMap(ServiceEndpointImpl serviceEndpoint, VersionCollection olderVersions) throws XMLAdaptorException {
        Map serviceData = serviceEndpoint.getContext().getContextData();
        HashMap operationInfoMap = null;
        Map map = serviceData;
        synchronized (map) {
            operationInfoMap = (HashMap)serviceData.get(OPERATION_INFO_MAP);
            if (operationInfoMap != null) {
                HashMap hashMap = operationInfoMap;
                return hashMap;
            }
            operationInfoMap = new HashMap();
            serviceData.put(OPERATION_INFO_MAP, operationInfoMap);
            SOAPServiceInfo serviceInfo = VersioningInstanceSelector.getBaseServiceInfo(serviceEndpoint);
            if (serviceInfo != null) {
                VersioningInstanceSelector.processServiceInfo(serviceInfo, operationInfoMap, serviceEndpoint);
            }
            if (olderVersions.size() != 0) {
                VersionCollection.Iterator olderConnectors = olderVersions.iterator();
                while (olderConnectors.hasNext()) {
                    ServiceConnector olderConnector = (ServiceConnector)olderConnectors.next();
                    ServiceEndpointImpl olderEndpoint = (ServiceEndpointImpl)olderConnector.getServiceEndpoint();
                    serviceInfo = VersioningInstanceSelector.getBaseServiceInfo(olderEndpoint);
                    if (serviceInfo == null) continue;
                    VersioningInstanceSelector.processServiceInfo(serviceInfo, operationInfoMap, olderEndpoint);
                }
            }
        }
        return operationInfoMap;
    }

    private static SOAPServiceInfo getBaseServiceInfo(ServiceEndpointImpl serviceEndpoint) throws XMLAdaptorException {
        try {
            Definition def = serviceEndpoint.getWSDL();
            if (def == null) {
                return null;
            }
            SOAPServiceInfo[] services = SOAPServiceInfoCache.getServiceInfos(def);
            if (services.length == 1) {
                return services[0];
            }
            QName serviceName = serviceEndpoint.getWSDLServiceName();
            if (serviceName == null) {
                String portName = serviceEndpoint.getWSDLPortName();
                if (portName == null) {
                    throw new XMLAdaptorException("There are multiple services (and neither service QName nor port name name was specified) on: " + serviceEndpoint.getPath());
                }
                SOAPServiceInfo match = null;
                int i = 0;
                while (i < services.length) {
                    SOAPServiceInfo service = services[i];
                    SOAPPortInfo[] ports = service.getPortInfos();
                    int j = 0;
                    while (j < ports.length) {
                        SOAPPortInfo port = ports[j];
                        if (portName.equals(port.getPortName())) {
                            if (match != null) {
                                throw new XMLAdaptorException("There are multiple services with the same port name \"" + portName + "\" (and no desired service name specified) on: " + serviceEndpoint.getPath());
                            }
                        } else {
                            match = service;
                        }
                        ++j;
                    }
                    ++i;
                }
                if (match != null) {
                    return match;
                }
                throw new XMLAdaptorException("Service with port \"" + portName + "\" not found in WSDL on: " + serviceEndpoint.getPath());
            }
            int i = 0;
            while (i < services.length) {
                if (serviceName.equals(services[i].getServiceQName())) {
                    return services[i];
                }
                ++i;
            }
            throw new XMLAdaptorException("Undefined wsdl service: " + serviceName + " for service endpoint: " + serviceEndpoint.getPath());
        }
        catch (Exception e) {
            throw new XMLAdaptorException("Error during parsing WSDL of service endpoint " + serviceEndpoint.getPath(), e);
        }
    }

    private static void processServiceInfo(SOAPServiceInfo serviceInfo, Map operationInfoMap, ServiceEndpointImpl serviceEndpoint) throws XMLAdaptorException {
        String serializationID = serviceEndpoint.getSerializationID();
        SOAPPortInfo[] ports = serviceInfo.getPortInfos();
        int it = 0;
        while (it < ports.length) {
            SOAPPortInfo portInfo = ports[it];
            String portName = portInfo.getPortName();
            String protocol = portInfo.getProtocol();
            ArrayList<OperationInfoMapKey> removeFromPortInfoMap = new ArrayList<OperationInfoMapKey>();
            try {
                SOAPMethodInfo[] methods = portInfo.getMethodInfos(serializationID);
                int methodIt = 0;
                while (methodIt < methods.length) {
                    String soapAction;
                    Member m;
                    SOAPMethodInfo methodInfo = methods[methodIt];
                    portInfo.prepareSchema(serializationID, methodInfo.requestMessageEncodingURI);
                    QName firstElementQName = null;
                    if (methodInfo.rpcOperation) {
                        firstElementQName = methodInfo.requestName;
                    } else if (methodInfo.inWrapperQName != null) {
                        firstElementQName = methodInfo.inWrapperQName;
                    } else if (methodInfo.parts != null && methodInfo.parts.length > 0 && (m = methodInfo.parts[0].inSchemaElement) != null) {
                        firstElementQName = m.getName();
                    }
                    OperationInfoMapKey key = new OperationInfoMapKey(protocol, null, firstElementQName);
                    OperationInfo previous = operationInfoMap.put(key, new OperationInfo(serviceEndpoint, serviceInfo, portInfo, methodInfo));
                    if (previous != null) {
                        removeFromPortInfoMap.add(key);
                    }
                    if ((soapAction = methodInfo.soapAction) != null && !soapAction.equals("") && !soapAction.equals("\"\"") && (previous = operationInfoMap.put(key = new OperationInfoMapKey(protocol, soapAction, null), new OperationInfo(serviceEndpoint, serviceInfo, portInfo, methodInfo))) != null) {
                        removeFromPortInfoMap.add(key);
                    }
                    ++methodIt;
                }
            }
            catch (SchemaException e) {
                throw new XMLAdaptorException(e);
            }
            catch (WSDLException e) {
                throw new XMLAdaptorException(e);
            }
            Iterator it1 = removeFromPortInfoMap.iterator();
            while (it1.hasNext()) {
                operationInfoMap.remove(it1.next());
            }
            ++it;
        }
    }

    public static class OperationInfo {
        ServiceEndpointImpl serviceEndpoint;
        SOAPServiceInfo serviceInfo;
        SOAPPortInfo portInfo;
        SOAPMethodInfo methodInfo;

        public OperationInfo(ServiceEndpointImpl serviceEndpoint, SOAPServiceInfo serviceInfo, SOAPPortInfo portInfo, SOAPMethodInfo methodInfo) {
            this.serviceEndpoint = serviceEndpoint;
            this.serviceInfo = serviceInfo;
            this.portInfo = portInfo;
            this.methodInfo = methodInfo;
        }
    }

    private static class OperationInfoMapKey {
        String xmlProtocol;
        String soapAction;
        QName firstElementQName;

        public OperationInfoMapKey(String xmlProtocol, String soapAction, QName firstElementQName) {
            this.xmlProtocol = xmlProtocol;
            this.soapAction = soapAction;
            this.firstElementQName = firstElementQName;
        }

        public boolean equals(Object obj) {
            if (obj instanceof OperationInfoMapKey) {
                OperationInfoMapKey key2 = (OperationInfoMapKey)obj;
                return OperationInfoMapKey.compare(this.xmlProtocol, key2.xmlProtocol) && OperationInfoMapKey.compare(this.soapAction, key2.soapAction) && OperationInfoMapKey.compare(this.firstElementQName, key2.firstElementQName);
            }
            return false;
        }

        private static final boolean compare(Object o1, Object o2) {
            if (o1 == null) {
                return o2 == null;
            }
            return o1.equals(o2);
        }

        public int hashCode() {
            return (this.xmlProtocol == null ? 0 : this.xmlProtocol.hashCode()) ^ (this.soapAction == null ? 0 : this.soapAction.hashCode()) ^ (this.firstElementQName == null ? 0 : this.firstElementQName.hashCode());
        }
    }
}

