/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.server;

import com.idoox.debug.Category;
import com.idoox.util.ThreadPool;
import com.idoox.wasp.server.ServiceRegistryEntry;
import com.systinet.wasp.ServiceManagerImpl;
import com.systinet.wasp.webservice.ServiceInstanceImpl;
import java.util.Enumeration;
import java.util.Hashtable;
import org.idoox.util.RuntimeWrappedException;
import org.idoox.wasp.InstanceNotFoundException;
import org.idoox.wasp.server.WSRegistry;
import org.idoox.webservice.server.Initializable;
import org.idoox.webservice.server.LifeCycleController;
import org.idoox.webservice.server.Startable;
import org.idoox.webservice.server.WebServiceContext;

public class ServiceRegistry
implements WSRegistry {
    private static final Category dbg = Category.getCategory("com.idoox.wasp.server.ServiceRegistry");
    private static long lastID;
    private long defaultTTL;
    private Hashtable implementationObject2id = new Hashtable(47, 0.75f);
    private Hashtable id2ServiceRegistryEntry = new Hashtable(47, 0.75f);
    private ServiceInstanceImpl defaultService;
    private String defaultServiceID = "0";
    private LifeCycleController controller;
    private static final DestroyingThreads destroyingThreads;
    static /* synthetic */ Class class$com$idoox$wasp$server$ServiceRegistry;

    public ServiceRegistry(long defaultTTL) {
        this.defaultTTL = defaultTTL;
    }

    public void destroy() {
        ServiceRegistry serviceRegistry = this;
        synchronized (serviceRegistry) {
            Enumeration instances = this.id2ServiceRegistryEntry.keys();
            while (instances.hasMoreElements()) {
                ServiceRegistryEntry entry = (ServiceRegistryEntry)this.id2ServiceRegistryEntry.get(instances.nextElement());
                if (this.controller != null) {
                    try {
                        this.controller.serviceToBeDeregistered(entry.implementationObject);
                    }
                    catch (Throwable e) {
                        dbg.error("Lifecycle controller throwed exception", e);
                    }
                }
                this.destroy(entry.implementationObject, false);
            }
            if (this.defaultService.isInitialized()) {
                Object implementationObject = null;
                try {
                    implementationObject = this.defaultService.getImplementationObject();
                }
                catch (ClassNotFoundException e) {
                }
                catch (InstantiationException e) {
                }
                catch (IllegalAccessException e) {
                    // empty catch block
                }
                if (implementationObject != null) {
                    this.destroy(implementationObject, false);
                    this.defaultService.setDestroyed(true);
                }
            }
            this.id2ServiceRegistryEntry.clear();
            this.implementationObject2id.clear();
        }
    }

    public void disposeServiceInstance(Object implementationObject) {
        String id = (String)this.implementationObject2id.get(implementationObject);
        if (id == null) {
            throw new InstanceNotFoundException("Instance not registered in life cycle service");
        }
        ServiceRegistryEntry entry = (ServiceRegistryEntry)this.id2ServiceRegistryEntry.get(id);
        long newTTL = 0L;
        if (this.controller != null) {
            try {
                newTTL = this.controller.serviceToBeDeregistered(entry.implementationObject);
            }
            catch (Throwable e) {
                dbg.error("Lifecycle controller threw exception", e);
            }
        }
        if (newTTL > 0L) {
            entry.ttl = newTTL;
            entry.expireTime = System.currentTimeMillis() / 1000L + newTTL;
            throw new RuntimeException("Cannot dispose service, lifecycle controller does not permit it");
        }
        this.expireService(entry);
    }

    public void setTTLforAllInstances(long ttl) {
        this.defaultTTL = ttl;
        Enumeration enumeration = this.id2ServiceRegistryEntry.keys();
        while (enumeration.hasMoreElements()) {
            ServiceRegistryEntry entry = (ServiceRegistryEntry)this.id2ServiceRegistryEntry.get(enumeration.nextElement());
            this.setServiceInstanceTTL(entry.implementationObject, ttl);
        }
    }

    public void setServiceInstanceTTL(Object implementationObject, long ttl) {
        String id = (String)this.implementationObject2id.get(implementationObject);
        if (id == null) {
            return;
        }
        ServiceRegistryEntry entry = (ServiceRegistryEntry)this.id2ServiceRegistryEntry.get(id);
        if (ttl >= 0L) {
            long currTime = System.currentTimeMillis() / 1000L;
            entry.expireTime = entry.expireTime - entry.ttl + ttl;
            entry.ttl = ttl;
            if (entry.expireTime <= currTime) {
                long newTTL = 0L;
                if (this.controller != null) {
                    try {
                        newTTL = this.controller.serviceToBeDeregistered(entry.implementationObject);
                    }
                    catch (Throwable e) {
                        dbg.error("Lifecycle controller  throwed exception", e);
                    }
                }
                if (newTTL == 0L) {
                    this.expireService(entry);
                } else {
                    entry.ttl = newTTL;
                    entry.expireTime = currTime + newTTL;
                }
            }
        } else {
            entry.ttl = ttl;
        }
    }

    public long getServiceInstanceTTL(Object instance) {
        String id = (String)this.implementationObject2id.get(instance);
        if (id == null) {
            throw new InstanceNotFoundException("Instance not registered in life cycle service");
        }
        ServiceRegistryEntry entry = (ServiceRegistryEntry)this.id2ServiceRegistryEntry.get(id);
        return entry.ttl;
    }

    public LifeCycleController registerLifeCycleController(LifeCycleController controller) {
        LifeCycleController retval = this.controller;
        this.controller = controller;
        return retval;
    }

    public String registerService(Object instanceHolder, boolean defaultService) {
        if (defaultService) {
            this.defaultService = (ServiceInstanceImpl)instanceHolder;
            return this.defaultServiceID;
        }
        Object instance = null;
        if (instanceHolder instanceof ServiceInstanceImpl) {
            try {
                instance = ((ServiceInstanceImpl)instanceHolder).getImplementationObject();
            }
            catch (ClassNotFoundException ignore) {
            }
            catch (InstantiationException ignore) {
            }
            catch (IllegalAccessException ignore) {}
        } else {
            instance = instanceHolder;
            this.initialize(instance);
        }
        String id = (String)this.implementationObject2id.get(instance);
        if (id != null) {
            return id;
        }
        id = this.generateID();
        this.registerService(id, instance);
        return id;
    }

    private String generateID() {
        Class clazz = class$com$idoox$wasp$server$ServiceRegistry == null ? (class$com$idoox$wasp$server$ServiceRegistry = ServiceRegistry.class$("com.idoox.wasp.server.ServiceRegistry")) : class$com$idoox$wasp$server$ServiceRegistry;
        synchronized (clazz) {
            String string = ServiceManagerImpl.getServerGUID() + ":" + Long.toHexString(++lastID).toUpperCase();
            return string;
        }
    }

    private void registerService(String id, Object instance) {
        ServiceRegistry serviceRegistry = this;
        synchronized (serviceRegistry) {
            if (this.id2ServiceRegistryEntry.contains(id)) {
                throw new RuntimeException("The instance id already used");
            }
            ServiceRegistryEntry entry = new ServiceRegistryEntry();
            entry.implementationObject = instance;
            entry.ttl = this.defaultTTL;
            long currTime = System.currentTimeMillis() / 1000L;
            entry.expireTime = currTime + entry.ttl;
            entry.id = id;
            this.id2ServiceRegistryEntry.put(id, entry);
            this.implementationObject2id.put(instance, id);
        }
        if (this.controller != null) {
            try {
                this.controller.serviceRegistered(instance);
            }
            catch (Throwable e) {
                dbg.error("Lifecycle controller throwed exception", e);
            }
        }
    }

    public void expireServices(long currentTime) {
        Enumeration entries = this.id2ServiceRegistryEntry.elements();
        while (entries.hasMoreElements()) {
            ServiceRegistryEntry entry = (ServiceRegistryEntry)entries.nextElement();
            if (entry.ttl == -1L || entry.expireTime > currentTime) continue;
            long newTTL = 0L;
            if (this.controller != null) {
                try {
                    newTTL = this.controller.serviceToBeDeregistered(entry.implementationObject);
                }
                catch (Throwable e) {
                    dbg.error("Lifecycle controller throwed exception", e);
                }
            }
            if (newTTL == 0L) {
                this.expireService(entry);
                continue;
            }
            entry.ttl = newTTL;
            entry.expireTime = currentTime + newTTL;
        }
    }

    public String getServiceInstanceId(Object instance) {
        return (String)this.implementationObject2id.get(instance);
    }

    public Object getService(String serviceInstanceId) {
        if (serviceInstanceId == null) {
            if (this.defaultService != null) {
                try {
                    Object implementationObject = this.defaultService.getImplementationObject();
                    return implementationObject;
                }
                catch (ClassNotFoundException ignore) {
                    throw new RuntimeWrappedException(ignore);
                }
                catch (InstantiationException ignore) {
                    throw new RuntimeWrappedException(ignore);
                }
                catch (IllegalAccessException ignore) {
                    throw new RuntimeWrappedException(ignore);
                }
            }
            return null;
        }
        ServiceRegistryEntry entry = (ServiceRegistryEntry)this.id2ServiceRegistryEntry.get(serviceInstanceId);
        if (entry != null) {
            if (entry.ttl >= 0L) {
                if (System.currentTimeMillis() / 1000L > entry.expireTime) {
                    throw new RuntimeException("unknown/expired instance ID called: " + serviceInstanceId);
                }
                entry.expireTime = System.currentTimeMillis() / 1000L + entry.ttl;
            }
            return entry.implementationObject;
        }
        return null;
    }

    public Object createService() throws Exception {
        if (this.defaultService != null) {
            return this.defaultService.getImplementationObject().getClass().newInstance();
        }
        return null;
    }

    public ServiceInstanceImpl getServiceInstance() {
        return this.defaultService;
    }

    private void expireService(ServiceRegistryEntry entry) {
        ServiceRegistry serviceRegistry = this;
        synchronized (serviceRegistry) {
            this.implementationObject2id.remove(entry.implementationObject);
            this.id2ServiceRegistryEntry.remove(entry.id);
        }
        this.destroy(entry.implementationObject, true);
    }

    private void destroy(Object implementationObject, boolean inThread) {
        if (inThread) {
            destroyingThreads.job(implementationObject);
        } else {
            destroyingThreads.destroyInternal(implementationObject);
        }
    }

    private void initialize(Object implementationObject) {
        if (implementationObject instanceof org.systinet.wasp.webservice.Initializable) {
            ((org.systinet.wasp.webservice.Initializable)implementationObject).init(this.defaultService);
        } else if (implementationObject instanceof Initializable) {
            ((Initializable)implementationObject).init(WebServiceContext.getInstance());
        }
        if (implementationObject instanceof Startable) {
            ((Startable)implementationObject).start();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        destroyingThreads = new DestroyingThreads();
    }

    static class DestroyingThreads
    extends ThreadPool {
        public DestroyingThreads() {
            super("DestroyingThreads", 0, 10, true);
        }

        protected void handle(Object implementationObject) {
            this.destroyInternal(implementationObject);
        }

        protected void destroyInternal(Object implementationObject) {
            if (implementationObject instanceof Startable) {
                ((Startable)implementationObject).stop();
            }
            if (implementationObject instanceof org.systinet.wasp.webservice.Initializable) {
                ((org.systinet.wasp.webservice.Initializable)implementationObject).destroy();
            } else if (implementationObject instanceof Initializable) {
                ((Initializable)implementationObject).destroy();
            }
        }
    }
}

