/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.server;

import com.idoox.debug.Category;
import com.idoox.wasp.InitialReferencesRegistrar;
import com.idoox.wasp.server.CallMediator;
import com.idoox.wasp.server.DisabledServiceException;
import com.idoox.wasp.server.Dispatcher;
import com.idoox.wasp.server.ServiceConnector;
import com.systinet.wasp.webservice.RegistryImpl;
import com.systinet.wasp.webservice.ServiceInstanceImpl;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Random;
import java.util.Set;
import java.util.TimeZone;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.xml.namespace.QName;
import org.idoox.config.Configurable;
import org.idoox.transport.Connection;
import org.idoox.transport.TransportMethod;
import org.idoox.wasp.Context;
import org.idoox.wasp.Module;
import org.idoox.wasp.server.InvalidEndpointPathException;
import org.idoox.wasp.server.InvalidStateTransitionException;
import org.idoox.wasp.server.ServiceInstanceNotFoundException;
import org.idoox.wasp.server.ServiceMediator;
import org.idoox.wasp.server.ServiceState;
import org.idoox.wasp.server.ServiceStateManager;
import org.idoox.wasp.server.TimeoutExpiredException;
import org.idoox.wasp.server.WSContext;
import org.idoox.webservice.server.Startable;
import org.idoox.webservice.server.WebServiceContext;

public class ServiceManager
implements Startable,
Dispatcher,
Module,
ServiceStateManager,
org.idoox.wasp.server.ServiceManager {
    private static final Category cat = Category.getCategory("com.idoox.wasp.server.ServiceManager");
    private static String serverGUID;
    static /* synthetic */ Class class$com$idoox$wasp$server$ServiceManager;

    public RegistryImpl getRegistry() {
        return (RegistryImpl)Context.getInstance("org.systinet.wasp.webservice.IRegistry");
    }

    public synchronized void destroy() {
    }

    public void dispatch(Connection connection) {
        this.getRegistry().dispatch(connection);
    }

    public void start() {
        this.getRegistry().start();
    }

    public void stop() {
        this.getRegistry().stop();
    }

    ServiceConnector getConnector(String uri) throws DisabledServiceException, ClassNotFoundException {
        return this.getRegistry().getConnector(uri);
    }

    ServiceConnector getGetConnector(String uri) throws DisabledServiceException {
        return this.getRegistry().getGetConnector(uri);
    }

    public ServiceInstanceImpl getServiceInstanceObject(String name) throws DisabledServiceException, ClassNotFoundException {
        return this.getRegistry().getServiceInstanceObject(name);
    }

    ServiceMediator getServiceMediator(String name) {
        return this.getRegistry().getServiceMediator(name);
    }

    public void load(Configurable serviceManagerConfig) {
        InitialReferencesRegistrar.addInitialReference("org.idoox.wasp.server.ServiceManager", this);
        InitialReferencesRegistrar.addInitialReference("org.idoox.wasp.server.ServiceStateManager", this);
    }

    public void init() {
    }

    public Set getManagedServices() {
        return this.getRegistry().getManagedServices();
    }

    public ServiceState getServiceState(String serviceName) throws ServiceInstanceNotFoundException {
        return ServiceState.convert(this.getRegistry().getServiceState(serviceName));
    }

    public void disable(String serviceName) throws ServiceInstanceNotFoundException, InvalidStateTransitionException {
        this.getRegistry().disable(serviceName);
    }

    public void enable(String serviceName) throws ServiceInstanceNotFoundException, InvalidStateTransitionException {
        this.getRegistry().enable(serviceName);
    }

    public void stop(String serviceName) throws ServiceInstanceNotFoundException, InvalidStateTransitionException {
        this.getRegistry().disable(serviceName);
    }

    public void start(String serviceName) throws ServiceInstanceNotFoundException, InvalidStateTransitionException {
        this.getRegistry().enable(serviceName);
    }

    public void kill(String serviceName) throws ServiceInstanceNotFoundException, InvalidStateTransitionException {
        this.getRegistry().getServiceInstanceByName(serviceName).kill();
    }

    public void waitForState(String serviceName, ServiceState state, long timeout) throws ServiceInstanceNotFoundException, TimeoutExpiredException, InterruptedException {
        this.getRegistry().waitForState(serviceName, ServiceState.convert(state), timeout);
    }

    public void addServiceBinding(Configurable c) {
        this.getRegistry().addServiceBinding(c);
    }

    public void removeServiceBinding(String name) {
        this.getRegistry().removeServiceBinding(name);
    }

    public void addServiceInstance(Configurable c) {
        this.getRegistry().addServiceInstance(c);
    }

    public void removeServiceInstance(String name) {
        this.getRegistry().removeServiceInstance(name);
    }

    public CallMediator[] getCallMediators() {
        return this.getRegistry().getCallMediators();
    }

    public static String getServerGUID() {
        if (serverGUID == null) {
            Class clazz = class$com$idoox$wasp$server$ServiceManager == null ? (class$com$idoox$wasp$server$ServiceManager = ServiceManager.class$("com.idoox.wasp.server.ServiceManager")) : class$com$idoox$wasp$server$ServiceManager;
            synchronized (clazz) {
                if (serverGUID == null) {
                    try {
                        InetAddress iA = InetAddress.getLocalHost();
                        SimpleDateFormat dF = new SimpleDateFormat("yyyy.MM.dd hh:mm:ss");
                        dF.setTimeZone(TimeZone.getTimeZone("GMT"));
                        serverGUID = iA.getHostName() + ":" + dF.format(new Date()) + " GMT:" + Long.toHexString(new Random().nextLong()).toUpperCase();
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Cannot create server GUID: " + e.getMessage() != null ? e.getMessage() : "");
                    }
                }
            }
        }
        return serverGUID;
    }

    public Object createDirectSmartStub(Class stubInterface, String serviceURL, String instanceId) throws MalformedURLException {
        return this.getRegistry().createDirectSmartStub(stubInterface, serviceURL, instanceId);
    }

    public String[] getServiceInstanceNames() {
        return this.getRegistry().getServiceInstanceNames();
    }

    public WebServiceContext addServiceInstance(Class serviceClass) {
        return this.getRegistry().addServiceInstance(serviceClass);
    }

    public WebServiceContext addServiceInstance(Object serviceObject) {
        return this.getRegistry().addServiceInstance(serviceObject);
    }

    public void removeServiceInstance(WebServiceContext svc) {
        this.getRegistry().removeServiceInstance(svc);
    }

    public WSContext addServiceEndpoint(WebServiceContext svcInstance, String uri) throws InvalidEndpointPathException {
        try {
            return this.getRegistry().addServiceEndpoint(svcInstance, uri);
        }
        catch (InvalidEndpointPathException e) {
            throw new InvalidEndpointPathException(e.getMessage());
        }
    }

    public WSContext addServiceEndpoint(WebServiceContext svcInstance, String path, String wsdlURI, QName serviceQName) throws InvalidEndpointPathException, WSDLException {
        try {
            return this.getRegistry().addServiceEndpoint(svcInstance, path, wsdlURI, serviceQName);
        }
        catch (InvalidEndpointPathException e) {
            throw new InvalidEndpointPathException(e.getMessage());
        }
    }

    public WSContext addServiceEndpoint(WebServiceContext svcInstance, String path, Definition wsdl, QName serviceQName) throws InvalidEndpointPathException {
        try {
            return this.getRegistry().addServiceEndpoint(svcInstance, path, wsdl, serviceQName);
        }
        catch (InvalidEndpointPathException e) {
            throw new InvalidEndpointPathException(e.getMessage());
        }
    }

    public void removeServiceEndpoint(WSContext serviceContext) {
        this.getRegistry().removeServiceEndpoint(serviceContext);
    }

    public void removeServiceEndpoint(String serviceURI) throws InvalidEndpointPathException {
        this.getRegistry().removeServiceEndpoint(this.getServiceEndpoint(serviceURI));
    }

    public WSContext addService(String uri, Class serviceClass) throws InvalidEndpointPathException {
        try {
            return this.getRegistry().addService(uri, serviceClass);
        }
        catch (InvalidEndpointPathException e) {
            throw new InvalidEndpointPathException(e.getMessage());
        }
    }

    public WSContext addService(String uri, Object svc) throws InvalidEndpointPathException {
        try {
            return this.getRegistry().addService(uri, svc);
        }
        catch (InvalidEndpointPathException e) {
            throw new InvalidEndpointPathException(e.getMessage());
        }
    }

    public WebServiceContext getServiceInstance(String serviceName) throws ServiceInstanceNotFoundException {
        return this.getRegistry().getServiceInstance(serviceName);
    }

    public WSContext getServiceEndpoint(String uri) throws InvalidEndpointPathException {
        WSContext retVal = this.getRegistry().getServiceEndpoint(uri, TransportMethod.POST);
        if (retVal == null) {
            retVal = this.getRegistry().getServiceEndpoint(uri, TransportMethod.GET);
        }
        return retVal;
    }

    public WSContext getServiceEndpoint(String uri, TransportMethod transportMethod) throws InvalidEndpointPathException {
        try {
            return this.getRegistry().getServiceEndpoint(uri, transportMethod);
        }
        catch (InvalidEndpointPathException e) {
            throw new InvalidEndpointPathException(e.getMessage());
        }
    }

    public String[] getServiceEndpointsPaths(WebServiceContext svc) {
        return this.getRegistry().getServiceEndpointsPaths(svc);
    }

    public WSContext[] getServiceEndpoints(WebServiceContext svc) {
        return this.getRegistry().getServiceEndpoints(svc);
    }

    public WSContext[] getServiceEndpoints(String name) throws ServiceInstanceNotFoundException {
        return this.getRegistry().getServiceEndpoints(this.getServiceInstance(name));
    }

    public String[] getServiceEndpointsPaths(String name) throws ServiceInstanceNotFoundException {
        return this.getRegistry().getServiceEndpointsPaths(name);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

