/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.server;

import com.idoox.debug.Category;
import com.idoox.util.HierarchicalMap;
import com.idoox.wasp.interceptor.InterceptorRepository;
import com.idoox.wasp.interceptor.TransportInterceptorChainImpl;
import com.idoox.wasp.server.AdaptorTemplate;
import com.idoox.wasp.server.ServiceRegistry;
import com.idoox.wasp.server.config.ServiceBindingConfig;
import com.systinet.wasp.ServiceManagerImpl;
import com.systinet.wasp.webservice.CallContextImpl;
import com.systinet.wasp.webservice.CurrentImpl;
import com.systinet.wasp.webservice.RegistryImpl;
import com.systinet.wasp.webservice.ServiceEndpointImpl;
import com.systinet.wasp.webservice.ServiceInstanceImpl;
import com.systinet.wasp.webservice.VersionCollection;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import org.idoox.config.Configurable;
import org.idoox.config.Configurator;
import org.idoox.transport.Connection;
import org.idoox.transport.OutputMessage;
import org.idoox.util.RuntimeWrappedException;
import org.idoox.wasp.Context;
import org.idoox.wasp.interceptor.Interceptor;
import org.idoox.wasp.interceptor.InterceptorChain;
import org.idoox.wasp.server.ServiceMediator;
import org.idoox.wasp.server.WSRegistry;
import org.idoox.webservice.server.LifeCycleService;
import org.systinet.wasp.handler.HandlerRepository;
import org.systinet.wasp.webservice.CallContext;
import org.systinet.wasp.webservice.PublishException;
import org.systinet.wasp.webservice.ServiceEndpoint;
import org.systinet.wasp.webservice.ServiceEndpointContext;
import org.systinet.wasp.webservice.ServiceInstanceContext;

public class ServiceConnector
implements PropertyChangeListener {
    private static final Category dbg = Category.getCategory("com.idoox.wasp.server.ServiceConnector");
    private Category log;
    private AdaptorTemplate adaptor;
    private List mediators;
    private ServiceInstanceImpl serviceInstance;
    private String rootPath;
    private String name;
    private boolean initialized = false;
    private ServiceEndpointImpl serviceEndpoint;
    private ServiceInstanceContext serviceInstanceContext;
    private ServiceBindingConfig config;
    private static ThreadLocal callContextHolder;
    private static CurrentImpl current;
    private Map allowedSmartStubs = new TreeMap();
    private Map usedSmartStubs = new TreeMap();
    private VersionCollection olderVersions = new VersionCollection();
    static /* synthetic */ Class class$org$systinet$wasp$webservice$ICurrent;
    static /* synthetic */ Class class$com$idoox$wasp$server$config$ServiceBindingConfig;

    public boolean isInitialized() {
        return this.initialized;
    }

    public void init(ServiceEndpoint serviceEndpoint, long defaultTTL, AdaptorTemplate adaptor, Configurable serviceConfig, ServiceBindingConfig bindingConfig, List mediators, ServiceManagerImpl registry) throws PublishException, RuntimeException {
        ServiceBindingConfig.SmartStubConfig uses;
        Configurable cfg;
        current = (CurrentImpl)Context.getInstance(class$org$systinet$wasp$webservice$ICurrent == null ? (class$org$systinet$wasp$webservice$ICurrent = ServiceConnector.class$("org.systinet.wasp.webservice.ICurrent")) : class$org$systinet$wasp$webservice$ICurrent);
        callContextHolder = (ThreadLocal)Context.getInstance("threadlocal:CallContext");
        this.name = bindingConfig.getName();
        if (serviceEndpoint == null) {
            throw new RuntimeException("Inconsistency detected.Endpoint for uri " + this.name + " not found in registry.");
        }
        this.adaptor = adaptor;
        this.log = Category.getCategory(this.name);
        this.mediators = ((ServiceEndpointImpl)serviceEndpoint).getMediators();
        if (serviceConfig != null && serviceConfig.getReferenceLocation() != null) {
            this.rootPath = serviceConfig.getReferenceLocation() + "/";
        }
        if ((cfg = Configurator.getConfigurable(bindingConfig)) != null) {
            Configurable aux = Configurator.newRuntimeConfigurable();
            Configurable newConfigurable = Configurator.setDefaultsOnConfigurable(aux, cfg);
            this.config = (ServiceBindingConfig)newConfigurable.narrow(class$com$idoox$wasp$server$config$ServiceBindingConfig == null ? (class$com$idoox$wasp$server$config$ServiceBindingConfig = ServiceConnector.class$("com.idoox.wasp.server.config.ServiceBindingConfig")) : class$com$idoox$wasp$server$config$ServiceBindingConfig);
        } else {
            this.config = bindingConfig;
        }
        ((ServiceEndpointImpl)serviceEndpoint).setServiceBindingConfig(this.config);
        String serviceName = this.config.getServiceClassRef();
        if (serviceName == null) {
            dbg.error("Service name must be specified for binding with name: " + this.name);
            throw new RuntimeException("Cannot create service instance");
        }
        this.serviceInstance = (ServiceInstanceImpl)serviceEndpoint.getServiceInstance();
        this.serviceInstanceContext = this.serviceInstance.getContext();
        this.serviceInstance.setTTL(defaultTTL);
        ServiceBindingConfig.SmartStubConfig allows = this.config.getAllows();
        if (allows != null) {
            ServiceBindingConfig.SmartStubBindingConfig[] sscfgs = allows.getServiceBindings();
            int i = 0;
            while (i < sscfgs.length) {
                String ref = sscfgs[i].getRef();
                String level = sscfgs[i].getLevel();
                if (level == null) {
                    level = "java";
                }
                this.allowedSmartStubs.put(ref, level);
                ++i;
            }
        }
        if ((uses = this.config.getUses()) != null) {
            ServiceBindingConfig.SmartStubBindingConfig[] sscfgs = uses.getServiceBindings();
            int i = 0;
            while (i < sscfgs.length) {
                String ref = sscfgs[i].getRef();
                String level = sscfgs[i].getLevel();
                if (level == null) {
                    level = "java";
                }
                this.usedSmartStubs.put(ref, level);
                ++i;
            }
        }
        CurrentImpl.ThreadLocals threadLocals = current.getThreadLocals();
        ServiceEndpointContext oldServiceEndpointContext = threadLocals.serviceEndpointContext;
        ServiceInstanceContext oldServiceInstanceContext = threadLocals.serviceInstanceContext;
        this.serviceEndpoint = (ServiceEndpointImpl)serviceEndpoint;
        Map contextData = serviceEndpoint.getContext().getContextData();
        contextData.put("core.endpoint_serviceconnector", this);
        contextData.put("core.ws_registry", this.serviceInstance.getServiceRegistry());
        threadLocals.serviceEndpointContext = serviceEndpoint.getContext();
        threadLocals.serviceInstanceContext = this.serviceInstanceContext;
        if (serviceConfig != null) {
            serviceConfig.addPropertyChangeListener(this);
        }
        this.adaptor.init(threadLocals, (ServiceEndpointImpl)serviceEndpoint);
        try {
            if (this.config.isDebug()) {
                this.setDebug(true);
            }
        }
        catch (Exception ignore) {
            // empty catch block
        }
        ((RegistryImpl)registry).invokeServiceEndpointListenersOnPublish(serviceEndpoint);
        ((ServiceEndpointImpl)serviceEndpoint).invokeListenersOnPublish();
        try {
            block20: {
                try {
                    if (this.mediators == null) break block20;
                    Iterator medIter = this.mediators.iterator();
                    while (medIter.hasNext()) {
                        ((ServiceMediator)medIter.next()).init(serviceConfig);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeWrappedException(e);
                }
            }
            Object var19_22 = null;
            threadLocals.serviceEndpointContext = oldServiceEndpointContext;
            threadLocals.serviceInstanceContext = oldServiceInstanceContext;
        }
        catch (Throwable throwable) {
            Object var19_23 = null;
            threadLocals.serviceEndpointContext = oldServiceEndpointContext;
            threadLocals.serviceInstanceContext = oldServiceInstanceContext;
            throw throwable;
        }
        this.serviceInstance.addURL(this.name);
        this.initialized = true;
    }

    public void destroy() {
        int state;
        Map serviceData = this.serviceEndpoint.getContext().getContextData();
        FileOutputStream stream = (FileOutputStream)serviceData.get("com.idoox.wasp.interceptor.DebugInterceptor.debugFile");
        try {
            if (stream != null) {
                stream.close();
            }
        }
        catch (IOException e) {
            this.log.warn("Can't close debug file: ", e);
        }
        CurrentImpl.ThreadLocals threadLocals = current.getThreadLocals();
        ServiceEndpointContext oldServiceEndpointContext = threadLocals.serviceEndpointContext;
        ServiceInstanceContext oldServiceInstanceContext = threadLocals.serviceInstanceContext;
        threadLocals.serviceEndpointContext = this.serviceEndpoint.getContext();
        threadLocals.serviceInstanceContext = this.serviceInstanceContext;
        if (this.mediators != null) {
            Iterator medIter = this.mediators.iterator();
            while (medIter.hasNext()) {
                ((ServiceMediator)medIter.next()).destroy(this.serviceEndpoint.getPath());
            }
        }
        if ((state = this.serviceInstance.getState()) != 1) {
            try {
                this.serviceInstance.disable();
                this.serviceInstance.waitForState(1, 10000L);
                if (this.serviceInstance.getState() != 1) {
                    this.serviceInstance.kill();
                    this.serviceInstance.waitForState(1, -1L);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        threadLocals.serviceEndpointContext = oldServiceEndpointContext;
        threadLocals.serviceInstanceContext = oldServiceInstanceContext;
    }

    public SOAPMessageContext dispatch(SOAPMessageContext messageContext, HandlerRepository.DirectionPositionEntry position, boolean request, boolean isShort, boolean fault) {
        CurrentImpl.ThreadLocals threadLocals = current.getThreadLocals();
        if (request) {
            return this.adaptor.dispatchBookmarkRequest(messageContext, position, threadLocals, this.serviceEndpoint, this.olderVersions);
        }
        return this.adaptor.dispatchBookmarkResponse(messageContext, position.getOutChainPosition() - 1, threadLocals, this.serviceEndpoint, isShort, fault);
    }

    public void dispatch(Connection connection) {
        CurrentImpl.ThreadLocals threadLocals = current.getThreadLocals();
        ServiceEndpointContext oldServiceEndpointContext = null;
        ServiceInstanceContext oldServiceInstanceContext = null;
        try {
            threadLocals.processingType = 2;
            CallContext existingContext = threadLocals.callContext;
            org.idoox.webservice.CallContext callContext = new org.idoox.webservice.CallContext();
            CallContextImpl newCallContext = new CallContextImpl(this.serviceEndpoint.getContext().getContextData());
            threadLocals.callContext = newCallContext;
            Map contextData = newCallContext.getContextData();
            if (existingContext != null) {
                newCallContext.setContextData((Map)((HierarchicalMap)existingContext.getContextData()).clone());
            }
            String path = connection.getURI().getPath();
            contextData.put("wasp.transport.connection", connection);
            contextData.put("serverbookmark.connector.path", path);
            contextData.put("serverbookmark.request.schema", connection.getURI().getScheme());
            ThreadLocal servletDataHolder = (ThreadLocal)Context.getInstance("threadlocal:ServletData");
            if (servletDataHolder != null) {
                CallContextImpl.ServletData servletData = (CallContextImpl.ServletData)servletDataHolder.get();
                if (servletData != null) {
                    contextData.put("wasp.transport.servlet_request", servletData.servletRequest);
                    contextData.put("wasp.transport.servlet_response", servletData.servletResponse);
                    contextData.put("wasp.transport.servlet", servletData.servlet);
                }
                servletDataHolder.set(null);
            }
            oldServiceEndpointContext = threadLocals.serviceEndpointContext;
            oldServiceInstanceContext = threadLocals.serviceInstanceContext;
            callContextHolder.set(callContext);
            threadLocals.serviceEndpointContext = this.serviceEndpoint.getContext();
            threadLocals.serviceInstanceContext = this.serviceInstanceContext;
            if (this.getService().getState() == 1 || this.getService().getState() == 32) {
                OutputMessage output = connection.getOutputMessage();
                if (output != null) {
                    output.setStatusCode(503);
                } else {
                    dbg.info("Service for uri " + path + " is disabled, refusing request");
                }
            } else {
                this.adaptor.dispatch(threadLocals, connection, this.serviceEndpoint, this.olderVersions);
            }
            Object var13_12 = null;
            threadLocals.serviceEndpointContext = oldServiceEndpointContext;
            threadLocals.serviceInstanceContext = oldServiceInstanceContext;
            callContextHolder.set(null);
            threadLocals.callContext = null;
            threadLocals.processingType = 0;
        }
        catch (Throwable throwable) {
            Object var13_13 = null;
            threadLocals.serviceEndpointContext = oldServiceEndpointContext;
            threadLocals.serviceInstanceContext = oldServiceInstanceContext;
            callContextHolder.set(null);
            threadLocals.callContext = null;
            threadLocals.processingType = 0;
            throw throwable;
        }
    }

    private void setDebug(boolean state) {
        Map serviceData = this.serviceEndpoint.getContext().getContextData();
        String chainName = (String)serviceData.get("core.processing.interceptors_id");
        InterceptorRepository interceptorRepository = (InterceptorRepository)Context.getInstance("com.idoox.wasp.interceptor.InterceptorRepository");
        Interceptor debugInterceptor = interceptorRepository.getInterceptor("debugInterceptor");
        if (debugInterceptor == null) {
            dbg.warn("Can't enable debugging for the service " + this.name);
            return;
        }
        if (state) {
            InterceptorChain chain;
            if (chainName == null) {
                chainName = this.serviceEndpoint.getPath() + "TIs";
                serviceData.put("core.processing.interceptors_id", chainName);
            }
            if ((chain = interceptorRepository.getChain(chainName)) == null) {
                chain = new TransportInterceptorChainImpl(chainName);
                interceptorRepository.addChain(chainName, chain);
            }
            boolean found = false;
            int i = chain.size() - 1;
            while (i >= 0) {
                if ("debugInterceptor".equals(chain.getName(i))) {
                    found = true;
                    break;
                }
                --i;
            }
            if (!found) {
                chain.add("debugInterceptor", 3);
            }
        } else if (chainName != null) {
            InterceptorChain chain = interceptorRepository.getChain(chainName);
            int i = chain.size() - 1;
            while (i >= 0) {
                if ("debugInterceptor".equals(chain.getName(i))) {
                    chain.remove(i);
                    break;
                }
                --i;
            }
            if (chain.size() == 0) {
                interceptorRepository.removeChain(chainName);
                serviceData.remove("core.processing.interceptors_id");
            }
        }
    }

    public ServiceRegistry getRegistry() {
        return this.serviceInstance == null ? null : this.serviceInstance.getServiceRegistry();
    }

    WSRegistry getWSRegistry() {
        return this.serviceInstance.getServiceRegistry();
    }

    LifeCycleService getLifeCycleService() {
        return this.serviceInstance.getServiceRegistry();
    }

    public ServiceInstanceImpl getService() {
        return this.serviceInstance;
    }

    List getMediators() {
        return this.mediators;
    }

    void addMediator(ServiceMediator mediator) {
        if (this.mediators == null) {
            this.mediators = new LinkedList();
        }
        this.mediators.add(mediator);
    }

    void removeMediator(ServiceMediator mediator) {
        if (this.mediators == null) {
            return;
        }
        this.mediators.remove(mediator);
    }

    public String getRootPath() {
        return this.rootPath;
    }

    void log(String msg) {
        this.log.info(msg);
    }

    void log(String message, Throwable throwable) {
        this.log.info(message, throwable);
    }

    boolean checkAccess(String methodName, String namespace) throws RuntimeException {
        throw new RuntimeException("Not implemented");
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("debug")) {
            boolean debug = false;
            if (evt.getNewValue() != null) {
                debug = (Boolean)evt.getNewValue();
            }
            this.setDebug(debug);
        }
    }

    public Object createDirectSmartStub(ServiceConnector caller, Class stubInterface, String instanceId) {
        String uses = null;
        String callerURI = null;
        if (caller != null) {
            uses = (String)caller.usedSmartStubs.get(this.serviceEndpoint.getPath());
            if (uses == null) {
                uses = (String)caller.usedSmartStubs.get("*");
            }
            callerURI = caller.serviceEndpoint.getPath();
        } else {
            uses = "java";
            callerURI = "";
        }
        String allows = null;
        allows = (String)this.allowedSmartStubs.get(callerURI);
        if (allows == null) {
            allows = (String)this.allowedSmartStubs.get("*");
        }
        if ("java".equals(allows) && "java".equals(uses)) {
            if (instanceId != null) {
                dbg.error("Smart stubs for different than base services are not implemented yet");
                return null;
            }
            Object inst = null;
            try {
                this.getService().getImplementationObject();
            }
            catch (ClassNotFoundException ignore) {
            }
            catch (InstantiationException ignore) {
            }
            catch (IllegalAccessException ignore) {
                // empty catch block
            }
            if (inst == null) {
                dbg.error("Smart stubs : Null base service ?");
                return null;
            }
            if (stubInterface.isInstance(inst)) {
                return inst;
            }
            dbg.error("Smart stubs : Incompatible interfaces");
            dbg.error("Iface " + stubInterface + "[" + stubInterface.getClassLoader() + "]" + ", impl " + inst.getClass() + "[" + inst.getClass().getClassLoader() + "]");
        }
        return null;
    }

    public ServiceEndpoint getServiceEndpoint() {
        return this.serviceEndpoint;
    }

    public ServiceBindingConfig getConfig() {
        return this.config;
    }

    public String getName() {
        return this.name;
    }

    public VersionCollection getOlderVersions() {
        return this.olderVersions;
    }

    public void setOlderVersions(VersionCollection olderVersions) {
        this.olderVersions = olderVersions;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

