/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.serialization.xml;

import com.idoox.xml.CachingTokenizer;
import com.idoox.xml.CachingTokenizerPool;
import com.idoox.xmlrpc.encoding.EncodingRepository;
import org.idoox.config.Configurable;
import org.idoox.wasp.serialization.DeserializationChain;
import org.idoox.wasp.serialization.DeserializationContext;
import org.idoox.wasp.serialization.Deserializer;
import org.idoox.wasp.serialization.XMLDeserializer;
import org.idoox.xml.Token;
import org.idoox.xml.Tokenizer;
import org.idoox.xmlrpc.MessageCreatingException;
import org.idoox.xmlrpc.MessageProcessingException;
import org.idoox.xmlrpc.encoding.EncodingTokenizer;
import org.idoox.xmlrpc.encoding.NoSuchEncodingException;

public class XMLEncDeserializerWrapper
implements XMLDeserializer {
    EncodingTokenizer encTokenizer;
    Deserializer deserializer;
    EncodingRepository repo;
    String encodingID;
    String encodingURI;

    public XMLEncDeserializerWrapper(EncodingRepository repo, EncodingTokenizer encTokenizer, Deserializer deserializer, String encodingID, String encodingURI) {
        this.encTokenizer = encTokenizer;
        this.deserializer = deserializer;
        this.repo = repo;
        this.encodingID = encodingID;
        this.encodingURI = encodingURI;
    }

    public Object deserialize(Tokenizer dataTokenizer, Token currentToken, Class targetClass, DeserializationContext context, DeserializationChain chain) throws MessageProcessingException {
        CachingTokenizer cache = CachingTokenizerPool.getTokenizer();
        cache.init(dataTokenizer);
        this.encTokenizer.setInput(cache, null);
        this.encTokenizer.nextToken();
        Object ret = this.deserializer.deserialize(this.encTokenizer, targetClass, context, chain);
        try {
            this.repo.releaseEncodingTokenizer(this.encodingID, this.encodingURI, this.encTokenizer);
        }
        catch (NoSuchEncodingException e) {
            throw new MessageCreatingException(e);
        }
        this.encTokenizer = null;
        CachingTokenizerPool.releaseTokenizer(cache);
        return ret;
    }

    public String getMechanismType() {
        return "systinet:xmlser/1.0";
    }

    public void init(Configurable conf) {
    }
}

