/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.serialization.wsdl;

import com.idoox.wasp.serialization.IDNotFoundException;
import com.idoox.wasp.serialization.PolymorphismHelper;
import com.idoox.wasp.serialization.SerializationHelper;
import com.idoox.wasp.serialization.SerializationRepositoryImpl;
import com.idoox.wasp.serialization.TypeSerializationHelper;
import com.idoox.wasp.serialization.wsdl.SchemaHandler;
import com.idoox.xml.schema.util.XMLSchemaUtil;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.idoox.wasp.serialization.DeserializationChain;
import org.idoox.wasp.serialization.DeserializationContext;
import org.idoox.wasp.serialization.PostDeserializationHandler;
import org.idoox.wasp.serialization.Reference;
import org.idoox.wasp.serialization.SchemaContext;
import org.idoox.wasp.serialization.XMLDeserializer;
import org.idoox.wasp.types.Holder;
import org.idoox.xml.schema.Member;
import org.idoox.xml.schema.Schema;
import org.idoox.xml.schema.SchemaConstruct;
import org.idoox.xml.schema.SchemaException;
import org.idoox.xml.schema.Type;
import org.idoox.xmlrpc.MessageProcessingException;

public final class WSDLDeserializationContext
implements DeserializationContext {
    private TypeSerializationHelper typeHelper;
    private PolymorphismHelper polymorphismHelper = new PolymorphismHelper();
    private String serializationID;
    private String encodingURI;
    private int level;
    private HashMap referencedLocalValues;
    private HashMap references;
    private ArrayList remoteReferences;
    private SerializationRepositoryImpl serializationRepository;
    private ClassLoader classLoader = null;
    private SchemaHandler schemaHandler = new SchemaHandler();
    private int repositoryVersion = -1;
    Object[] deserializedObjects;
    int deserializedObjectsUsed;
    ArrayList handlers;

    private void initReferences() {
        if (this.referencedLocalValues == null) {
            this.referencedLocalValues = new HashMap(19);
        } else {
            this.referencedLocalValues.clear();
        }
        if (this.references == null) {
            this.references = new HashMap(19);
        } else {
            this.references.clear();
        }
        if (this.remoteReferences == null) {
            this.remoteReferences = new ArrayList();
        } else {
            this.remoteReferences.clear();
        }
    }

    public void init(SerializationRepositoryImpl repository, String serializationID, String encodingURI) {
        this.deserializedObjectsUsed = 0;
        this.schemaHandler.init();
        this.schemaHandler.setEncodingUri(encodingURI);
        this.initReferences();
        if (this.handlers != null) {
            this.handlers.clear();
        }
        if (serializationID == this.serializationID && encodingURI == this.encodingURI && this.repositoryVersion == repository.getVersion()) {
            return;
        }
        this.repositoryVersion = repository.getVersion();
        this.serializationRepository = repository;
        this.serializationID = serializationID;
        this.encodingURI = encodingURI;
        this.typeHelper = new TypeSerializationHelper();
        this.typeHelper.init(serializationID, "java", this.serializationRepository, encodingURI);
    }

    public void clear() {
        this.deserializedObjectsUsed = 0;
        this.schemaHandler.init();
        this.initReferences();
        if (this.handlers != null) {
            this.handlers.clear();
        }
    }

    public void enter(String namespaceURI, String name, String typeNamespaceURI, String typeName) {
        ++this.level;
    }

    public void enter(QName elementQName, QName typeQName) {
        ++this.level;
    }

    public void leave() {
        --this.level;
    }

    public DeserializationChain getDeserializationChain(Class deserializedClass) {
        Type type = this.getCurrentConstructSchemaType();
        DeserializationChain ret = this.serializationRepository.getDeserializationChain(this.serializationID, this.encodingURI, type, deserializedClass);
        if (SerializationHelper.dcat.isDebugEnabled()) {
            SerializationHelper.dcat.debug("deserializer for type " + type + ",\n                deserializedClass " + deserializedClass + ",\n                id " + this.serializationID + " : " + ret + "\n                 in " + this.toString(false));
        }
        return ret;
    }

    public void releaseDeserializationChain(DeserializationChain chain) {
        this.serializationRepository.releaseDeserializationChain(chain);
    }

    public XMLDeserializer getXMLDeserializer(Class deserializedClass) {
        DeserializationChain deserChain = this.getDeserializationChain(deserializedClass);
        XMLDeserializer ret = null;
        if (deserChain.hasMoreDeserializers()) {
            ret = (XMLDeserializer)deserChain.getNextDeserializerAs("systinet:xmlser/1.0");
        }
        this.releaseDeserializationChain(deserChain);
        return ret;
    }

    public String getSerializationID() {
        return this.serializationID;
    }

    public int debug_level() {
        return this.level;
    }

    public void addReference(String id, Reference reference) throws MessageProcessingException {
        if (reference.getSchemaType() == null) {
            throw new MessageProcessingException("Can not register a reference without xml schema type");
        }
        if (id.startsWith("#")) {
            if (this.referencedLocalValues.containsKey(id)) {
                reference.setObjectValue(this.referencedLocalValues.get(id));
            } else {
                LinkedList<Reference> refs = (LinkedList<Reference>)this.references.get(id);
                if (refs == null) {
                    refs = new LinkedList<Reference>();
                    this.references.put(id, refs);
                }
                refs.add(reference);
            }
        } else {
            this.remoteReferences.add(new Entry(id, reference));
        }
    }

    public void setReferencedValue(String id, Object value) {
        this.referencedLocalValues.put(id, value);
    }

    public void resolveLocalReferences() throws MessageProcessingException {
        if (this.references == null) {
            return;
        }
        Iterator i = this.references.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            String id = (String)entry.getKey();
            List refs = (List)entry.getValue();
            if (!this.referencedLocalValues.containsKey(id = id.substring(1))) {
                throw new IDNotFoundException("ID " + id + " not found");
            }
            Object s = this.referencedLocalValues.get(id);
            Iterator j = refs.iterator();
            while (j.hasNext()) {
                Reference ref = (Reference)j.next();
                ref.setObjectValue(s);
            }
        }
        this.references.clear();
    }

    public Iterator getRemoteReferences() {
        if (this.remoteReferences == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return ((AbstractList)this.remoteReferences).iterator();
    }

    public Class getReferencedClass(String id) {
        if (this.references == null) {
            return null;
        }
        List refs = (List)this.references.get("#" + id);
        if (refs == null) {
            return null;
        }
        return ((Reference)refs.get(0)).getValueClass();
    }

    public Type getReferencedSchemaType(String id) {
        if (this.references == null) {
            return null;
        }
        return ((Reference)((List)this.references.get("#" + id)).get(0)).getSchemaType();
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public String getType(QName name, QName type) throws SchemaException {
        Type t = this.getSchemaType(type);
        if (t != null) {
            return this.typeHelper.getType(t);
        }
        return null;
    }

    public String getType(Type type) {
        return this.typeHelper.getType(type);
    }

    public QName getSchemaType(QName name, String progLangType) throws SchemaException {
        return this.typeHelper.getSchemaType(progLangType);
    }

    public Type getSchemaType(QName typeName) throws SchemaException {
        if (typeName.getNamespaceURI().equals("http://idoox.com/package/")) {
            return this.polymorphismHelper.getGeneratedSchemaType(this, typeName);
        }
        return XMLSchemaUtil.getSchemaType(this.schemaHandler.getSchema(), typeName);
    }

    public QName getSchemaType(String progLangType) throws SchemaException {
        return this.typeHelper.getSchemaType(progLangType);
    }

    public void pushDeserializedObject(Object contextObject) {
        if (this.deserializedObjects == null) {
            this.deserializedObjects = new Object[5];
        } else if (this.deserializedObjects.length == this.deserializedObjectsUsed) {
            Object[] a = new Object[this.deserializedObjectsUsed + 5];
            System.arraycopy(this.deserializedObjects, 0, a, 0, this.deserializedObjectsUsed);
            this.deserializedObjects = a;
        }
        this.deserializedObjects[this.deserializedObjectsUsed++] = contextObject;
    }

    public Object[] getDeserializedObjects() {
        return this.deserializedObjects;
    }

    public int getDeserializedObjectsCount() {
        return this.deserializedObjectsUsed;
    }

    public Object popDeserializedObject() {
        return this.deserializedObjects[--this.deserializedObjectsUsed];
    }

    public Schema getSchema() {
        return this.schemaHandler.getSchema();
    }

    public void setSchema(Schema schema, boolean useSchemaTypeMapping) {
        this.schemaHandler.setSchema(schema);
        this.typeHelper.setSchema(schema, useSchemaTypeMapping);
    }

    public SchemaContext.State putMember(Member member) {
        return this.schemaHandler.putMember(member);
    }

    public SchemaContext.State putSchemaConstruct(SchemaConstruct schemaConstruct) {
        return this.schemaHandler.putSchemaConstruct(schemaConstruct);
    }

    public SchemaContext.State enterCurrentMember() {
        return this.schemaHandler.enterCurrentMember();
    }

    public void leave(SchemaContext.State state) {
        this.schemaHandler.leave(state);
    }

    public Member getCurrentMember() {
        return this.schemaHandler.getCurrentMember();
    }

    public SchemaConstruct getCurrentSchemaConstruct() {
        return this.schemaHandler.getCurrentSchemaConstruct();
    }

    public Type getCurrentConstructSchemaType() {
        return this.schemaHandler.getCurrentConstructSchemaType();
    }

    public QName getCurrentConstructName() {
        return this.schemaHandler.getCurrentConstructName();
    }

    public SchemaConstruct.ConstructType getCurrentConstructType() {
        return this.schemaHandler.getCurrentConstructType();
    }

    public Member nextMember() {
        return this.schemaHandler.nextMember();
    }

    public SchemaConstruct nextSchemaConstruct() {
        return this.schemaHandler.nextSchemaConstruct();
    }

    public SchemaConstruct nextSchemaConstruct(String namespaceURI, String localPart) {
        return this.schemaHandler.nextSchemaConstruct(namespaceURI, localPart);
    }

    public void replaceTopMember(QName name, Type type) {
        this.schemaHandler.replaceTopMember(name, type);
    }

    public Type replaceTopMemberType(Type newType) {
        return this.schemaHandler.replaceTopMemberType(newType);
    }

    public boolean typeOfCurrentConstructReplaced() {
        return this.schemaHandler.typeOfCurrentConstructReplaced();
    }

    public Type getOriginalType() {
        return this.schemaHandler.getOriginalType();
    }

    public boolean isCurrentConstructArray() {
        return this.schemaHandler.isCurrentConstructArray();
    }

    public void registerPostDeserializationHandler(PostDeserializationHandler handler) {
        if (this.handlers == null) {
            this.handlers = new ArrayList();
        }
        this.handlers.add(handler);
    }

    public void unregisterPostDeserializationHandler(PostDeserializationHandler handler) {
        if (this.handlers == null) {
            return;
        }
        ((AbstractCollection)this.handlers).remove(handler);
    }

    public Iterator getPostDeserializationHandlers() {
        if (this.handlers == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return ((AbstractList)this.handlers).iterator();
    }

    public void replaceTopSchemaConstruct(SchemaConstruct referencedConstruct) {
        this.schemaHandler.replaceTopSchemaConstruct(referencedConstruct);
    }

    public String toString(boolean verbose) {
        StringBuffer ret = new StringBuffer();
        ret.append("WSDLDeserializationContext[\n");
        ret.append(this.schemaHandler.toString(verbose));
        ret.append("]");
        return ret.toString();
    }

    public String toString() {
        return this.toString(true);
    }

    public String getAttachmentMimeType(String className) {
        return this.serializationRepository.getAttachmentMimeType(className, this.serializationID, this.encodingURI);
    }

    public String getAttachmentClassName(String mimeType) {
        return this.serializationRepository.getAttachmentClassName(mimeType, this.serializationID, this.encodingURI);
    }

    private static class Entry
    implements Map.Entry {
        String key;
        Holder value;

        Entry(String key, Holder value) {
            this.key = key;
            this.value = value;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (!(o instanceof Entry)) {
                return false;
            }
            Entry e = (Entry)o;
            return this.key.equals(e.key);
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public int hashCode() {
            return this.key.hashCode();
        }

        public Object setValue(Object value) {
            Holder prev = this.value;
            this.value = (Holder)value;
            return prev;
        }
    }
}

