/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.serialization.attachments;

import com.idoox.debug.Category;
import com.idoox.util.HierarchicalMap;
import com.systinet.wasp.webservice.CallContextImpl;
import com.systinet.wasp.webservice.CurrentImpl;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import org.idoox.transport.OutputMessage;
import org.idoox.wasp.Context;
import org.idoox.wasp.types.MessageAttachment;
import org.systinet.wasp.webservice.Current;

public class MessageAttachmentSender
implements Runnable {
    ArrayList attachmentsToSend = new ArrayList();
    OutputMessage outmsg;
    Exception exception;
    CallContextImpl cContext;
    private static final Category cat = Category.getCategory("com.idoox.wasp.serialization.attachments.MessageAttachmentSender");

    public MessageAttachmentSender(OutputMessage out) {
        this.outmsg = out;
        Map old = Current.getCallContext().getContextData();
        Map newcc = null;
        Map map = old;
        synchronized (map) {
            newcc = (Map)((HierarchicalMap)old).clone();
        }
        this.cContext = Current.getProcessingType() == 1 ? new CallContextImpl(Current.getServiceClientContext().getContextData()) : new CallContextImpl(Current.getServiceEndpointContext().getContextData());
        this.cContext.setContextData(newcc);
    }

    public void addAttachment(MessageAttachment attachment) throws IOException {
        this.attachmentsToSend.add(attachment.getData());
        this.attachmentsToSend.add(attachment.getContentType());
        this.attachmentsToSend.add(attachment.getContentId());
        this.attachmentsToSend.add(attachment.getContentLocation());
    }

    public void addAttachments(MessageAttachment[] attachments) throws IOException {
        int i = 0;
        while (i < attachments.length) {
            this.addAttachment(attachments[i]);
            ++i;
        }
    }

    public void run() {
        CurrentImpl current = (CurrentImpl)Context.getInstance("org.systinet.wasp.webservice.ICurrent");
        current.setCallContext(this.cContext);
        try {
            int i = 0;
            while (i < this.attachmentsToSend.size()) {
                InputStream data = (InputStream)this.attachmentsToSend.get(i);
                String contentType = (String)this.attachmentsToSend.get(i + 1);
                String contentId = (String)this.attachmentsToSend.get(i + 2);
                String contentLocation = (String)this.attachmentsToSend.get(i + 3);
                this.outmsg.nextPart();
                if (data == null) {
                    this.outmsg.setContentType("application/octet-stream");
                    if (contentLocation != null) {
                        this.outmsg.setStringHeader("Content-Location", contentLocation);
                    }
                    if (contentId != null) {
                        this.outmsg.setStringHeader("Content-Id", contentId);
                    }
                } else {
                    if (contentType != null) {
                        this.outmsg.setContentType(contentType);
                    } else {
                        this.outmsg.setContentType("application/octet-stream");
                    }
                    if (contentLocation != null) {
                        this.outmsg.setStringHeader("Content-Location", contentLocation);
                    }
                    if (contentId != null) {
                        this.outmsg.setStringHeader("Content-Id", contentId);
                    }
                    MessageAttachmentSender.copyData(this.outmsg, data);
                }
                i += 4;
            }
            this.outmsg.close();
        }
        catch (Exception e) {
            this.exception = e;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void copyData(OutputMessage omsg, InputStream str) throws IOException {
        byte[] buf = new byte[4096];
        int wrt = 0;
        if (str != null) {
            int cnt;
            while ((cnt = str.read(buf)) > 0) {
                void var3_4;
                omsg.write(buf, 0, (int)var3_4);
                wrt += var3_4;
            }
        }
        str.close();
        omsg.flush();
    }
}

