/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.serialization;

import com.idoox.util.ElementHelper;
import com.idoox.wasp.Constants;
import com.idoox.wasp.serialization.DeserializationChainImpl;
import com.idoox.wasp.serialization.DuplicateAccessException;
import com.idoox.wasp.serialization.HolderReference;
import com.idoox.wasp.serialization.JaxRPC;
import com.idoox.wasp.serialization.MessageAttachmentReference;
import com.idoox.wasp.serialization.SerializationHelper;
import com.idoox.wasp.serialization.attachments.MessageAttachmentSender;
import com.idoox.xml.TokenPool;
import com.systinet.wasp.rpc.EncExceptionDeserializer;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.idoox.transport.OutputMessage;
import org.idoox.transport.client.Endpoint;
import org.idoox.util.RuntimeWrappedException;
import org.idoox.wasp.serialization.DeserializationChain;
import org.idoox.wasp.serialization.DeserializationContext;
import org.idoox.wasp.serialization.Deserializer;
import org.idoox.wasp.serialization.SchemaContext;
import org.idoox.wasp.serialization.SerializationContext;
import org.idoox.wasp.types.MessageAttachment;
import org.idoox.wasp.wsdl.SOAPMethodInfo;
import org.idoox.xml.Token;
import org.idoox.xml.TokenWriter;
import org.idoox.xml.Tokenizer;
import org.idoox.xml.TokenizerException;
import org.idoox.xml.schema.Member;
import org.idoox.xml.schema.SchemaConstruct;
import org.idoox.xml.schema.SchemaException;
import org.idoox.xml.schema.Type;
import org.idoox.xmlrpc.MessageCreatingException;
import org.idoox.xmlrpc.MessageProcessingException;
import org.idoox.xmlrpc.encoding.EncodingTokenWriter;
import org.idoox.xmlrpc.encoding.EncodingTokenizer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WaspSerializationHelper {
    private static final EncExceptionDeserializer xmlExceptionDeserializer = new EncExceptionDeserializer();
    private static Map classProperties = new HashMap();
    private static Map classDeclaredProperties = new HashMap();
    static boolean serializePrivateFields = false;
    static Map forbiddenIdentifiers = new HashMap();
    static /* synthetic */ Class class$java$lang$Object;

    public static void writeParam(TokenWriter writer, Object val, SOAPMethodInfo.PartInfo part, SerializationContext ctx, QName typeQName, QName targetName, boolean in) throws MessageCreatingException {
        try {
            if (JaxRPC.isHolder(val)) {
                Object holder = val;
                val = JaxRPC.getHolderValue(val);
                if (part.partType == 3) {
                    JaxRPC.setHolderValue(holder, null);
                }
            }
            SchemaContext.State state = WaspSerializationHelper.init(ctx, part, targetName, in);
            SerializationHelper.serialize(writer, val, ctx);
            ctx.leave(state);
        }
        catch (MessageProcessingException e) {
            throw new MessageCreatingException(e);
        }
        catch (IllegalAccessException e) {
            throw new MessageCreatingException(e);
        }
    }

    public static void writeObject(TokenWriter writer, Object val, SerializationContext ctx, Member member, Type type, QName targetName) throws MessageCreatingException {
        try {
            SchemaContext.State state = member != null ? ctx.putSchemaConstruct(member) : ctx.putSchemaConstruct(new Member(targetName, type, true));
            SerializationHelper.serialize(writer, val, ctx);
            ctx.leave(state);
        }
        catch (MessageProcessingException e) {
            throw new MessageCreatingException(e);
        }
    }

    public static void grabReferences(Object val, SerializationContext ctx, Member member, Type type, QName targetName) throws MessageCreatingException {
        try {
            SchemaContext.State state = member != null ? ctx.putSchemaConstruct(member) : ctx.putSchemaConstruct(new Member(targetName, type));
            SerializationHelper.grabReferences(val, ctx);
            ctx.leave(state);
        }
        catch (MessageProcessingException e) {
            throw new MessageCreatingException(e);
        }
    }

    public static void writeParam(EncodingTokenWriter writer, Object val, SOAPMethodInfo.PartInfo part, SerializationContext ctx, QName typeQName, QName targetName, boolean in) throws MessageCreatingException {
        try {
            if (JaxRPC.isHolder(val)) {
                Object holder = val;
                val = JaxRPC.getHolderValue(val);
                if (part.partType == 3) {
                    JaxRPC.setHolderValue(holder, null);
                }
            }
            SchemaContext.State state = WaspSerializationHelper.init(ctx, part, targetName, in);
            SerializationHelper.serialize(writer, val, null, ctx);
            ctx.leave(state);
        }
        catch (MessageProcessingException e) {
            throw new MessageCreatingException(e);
        }
        catch (IllegalAccessException e) {
            throw new MessageCreatingException(e);
        }
    }

    public static void writeObject(EncodingTokenWriter writer, Object val, SerializationContext ctx, Member member, Type type, QName targetName) throws MessageCreatingException {
        try {
            SchemaContext.State state1 = member != null ? ctx.putSchemaConstruct(member) : ctx.putSchemaConstruct(new Member(targetName, type, true));
            SchemaContext.State state = state1;
            SerializationHelper.serialize(writer, val, null, ctx);
            ctx.leave(state);
        }
        catch (MessageProcessingException e) {
            throw new MessageCreatingException(e);
        }
    }

    public static Object deserialize(Tokenizer tokenizer, Class deserializedClass, DeserializationContext dectx, Type type, Member element) throws MessageProcessingException, TokenizerException, IOException {
        Token currentToken = TokenPool.getToken();
        tokenizer.readToken(currentToken);
        String id = SerializationHelper.getId(currentToken);
        SchemaContext.State state = element != null ? dectx.putSchemaConstruct(element) : dectx.putSchemaConstruct(new Member(new QName(tokenizer.getNamespace(), tokenizer.getLocalName()), type));
        Object ret = SerializationHelper.deserializeElement(tokenizer, currentToken, deserializedClass, dectx);
        dectx.leave(state);
        if (id != null) {
            dectx.setReferencedValue(id, ret);
        }
        TokenPool.releaseToken(currentToken);
        return ret;
    }

    public static Object deserialize(EncodingTokenizer tokenizer, Class deserializedClass, DeserializationContext dectx, Type type, Member element) throws MessageProcessingException {
        String id = tokenizer.getID();
        SchemaContext.State state = element != null ? dectx.putSchemaConstruct(element) : dectx.putSchemaConstruct(new Member(new QName(tokenizer.getTokenNamespaceURI(), tokenizer.getTokenName()), type));
        DeserializationChain chain = dectx.getDeserializationChain(deserializedClass);
        Deserializer deserializer = (Deserializer)chain.getNextDeserializerAs(Deserializer.MECHANISM_TYPE);
        Object ret = deserializer.deserialize(tokenizer, deserializedClass, dectx, chain);
        dectx.releaseDeserializationChain(chain);
        dectx.leave(state);
        if (id != null) {
            dectx.setReferencedValue(id, ret);
        }
        return ret;
    }

    public static Object deserializeFault(EncodingTokenizer tokenizer, Class deserializedClass, DeserializationContext dectx, Type type, Member element) throws MessageProcessingException {
        String id = tokenizer.getID();
        SchemaContext.State state = element != null ? dectx.putSchemaConstruct(element) : dectx.putSchemaConstruct(new Member(new QName(tokenizer.getTokenNamespaceURI(), tokenizer.getTokenName()), type));
        DeserializationChain chain = dectx.getDeserializationChain(deserializedClass);
        chain = WaspSerializationHelper.getFaulChain(chain);
        Deserializer deserializer = (Deserializer)chain.getNextDeserializerAs(Deserializer.MECHANISM_TYPE);
        Object ret = deserializer.deserialize(tokenizer, deserializedClass, dectx, chain);
        dectx.releaseDeserializationChain(chain);
        dectx.leave(state);
        if (id != null) {
            dectx.setReferencedValue(id, ret);
        }
        return ret;
    }

    private static DeserializationChain getFaulChain(DeserializationChain chain) {
        ((DeserializationChainImpl)chain).replaceLast(xmlExceptionDeserializer);
        return chain;
    }

    public static void deserializeHolder(Tokenizer tokenizer, Object holder, DeserializationContext dectx, Type type, Member element) throws MessageProcessingException, TokenizerException, IOException {
        Token currentToken = TokenPool.getToken();
        tokenizer.readToken(currentToken);
        try {
            block6: {
                try {
                    Class deserializedClass = JaxRPC.getHolderValueClass(holder);
                    String reference = SerializationHelper.getReference(currentToken);
                    if (reference != null) {
                        dectx.addReference(reference, new HolderReference(holder, type));
                        if (tokenizer.next() != 3) {
                            throw new MessageProcessingException("There should be no content in reference");
                        }
                        break block6;
                    }
                    JaxRPC.setHolderValue(holder, WaspSerializationHelper.deserialize(tokenizer, deserializedClass, dectx, type, element));
                }
                catch (IllegalAccessException e) {
                    throw new MessageProcessingException(e);
                }
            }
            Object var9_9 = null;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            TokenPool.releaseToken(currentToken);
            throw throwable;
        }
        TokenPool.releaseToken(currentToken);
    }

    public static void deserializeHolder(EncodingTokenizer tokenizer, Object holder, DeserializationContext dectx, Type type, Member element) throws MessageProcessingException {
        try {
            Class deserializedClass = JaxRPC.getHolderValueClass(holder);
            if (tokenizer.getCurrentToken() == 5) {
                String reference = tokenizer.getReference();
                dectx.addReference(reference, new HolderReference(holder, type));
            } else {
                JaxRPC.setHolderValue(holder, WaspSerializationHelper.deserialize(tokenizer, deserializedClass, dectx, type, element));
            }
        }
        catch (IllegalAccessException e) {
            throw new MessageProcessingException(e);
        }
    }

    public static void deserializeMessageAttachment(Tokenizer tokenizer, MessageAttachment attachment, DeserializationContext dectx) throws MessageProcessingException, TokenizerException, IOException {
        Token currentToken = TokenPool.getToken();
        tokenizer.readToken(currentToken);
        if (SerializationHelper.isNil(currentToken)) {
            attachment.setData(null);
        } else {
            String reference = SerializationHelper.getReference(currentToken);
            if (reference == null) {
                reference = SerializationHelper.getDimeReference(currentToken);
            }
            if (reference != null) {
                try {
                    dectx.addReference(reference, new MessageAttachmentReference(attachment, dectx.getSchemaType(new QName("http://www.w3.org/2001/XMLSchema", "base64Binary"))));
                }
                catch (SchemaException e) {
                    throw new MessageProcessingException(e);
                }
            } else {
                throw new MessageProcessingException("MessageAttachment can be deserialized only from a reference");
            }
        }
        if (tokenizer.next() != 3) {
            throw new MessageProcessingException("There should be no content in reference");
        }
        TokenPool.releaseToken(currentToken);
    }

    public static void deserializeMessageAttachment(EncodingTokenizer tokenizer, MessageAttachment attachment, DeserializationContext dectx) throws MessageProcessingException, TokenizerException, IOException {
        int token = tokenizer.getCurrentToken();
        if (token == 6) {
            attachment.setData(null);
        } else if (token == 5) {
            String reference = tokenizer.getReference();
            try {
                dectx.addReference(reference, new MessageAttachmentReference(attachment, dectx.getSchemaType(new QName("http://www.w3.org/2001/XMLSchema", "base64Binary"))));
            }
            catch (SchemaException e) {
                throw new MessageProcessingException(e);
            }
        } else {
            throw new MessageProcessingException("MessageAttachment can be deserialized only from a reference");
        }
    }

    public static final boolean serializePrivateFields() {
        return serializePrivateFields;
    }

    public static Map getProperties(Class cls) throws IntrospectionException, DuplicateAccessException {
        return WaspSerializationHelper.getProperties(cls, true);
    }

    public static Map getProperties(Class cls, boolean inherit) throws IntrospectionException, DuplicateAccessException {
        if (inherit) {
            Map map = classProperties;
            synchronized (map) {
                HashMap props = (HashMap)classProperties.get(cls);
                if (props != null) {
                    HashMap hashMap = props;
                    return hashMap;
                }
                props = new HashMap(47, 0.75f);
                WaspSerializationHelper.setProperties(cls, props, true);
                classProperties.put(cls, props);
                HashMap hashMap = props;
                return hashMap;
            }
        }
        Map map = classDeclaredProperties;
        synchronized (map) {
            HashMap props = (HashMap)classDeclaredProperties.get(cls);
            if (props != null) {
                HashMap hashMap = props;
                return hashMap;
            }
            props = new HashMap(47, 0.75f);
            WaspSerializationHelper.setProperties(cls, props, false);
            classDeclaredProperties.put(cls, props);
            HashMap hashMap = props;
            return hashMap;
        }
    }

    static void setProperties(Class cls, Map props, boolean inherit) throws IntrospectionException, DuplicateAccessException {
        int i;
        PropertyDescriptor[] properties;
        if (serializePrivateFields) {
            properties = new PropertyDescriptor[]{};
        } else if (cls.isInterface()) {
            properties = Introspector.getBeanInfo(cls, null).getPropertyDescriptors();
        } else {
            if (cls == (class$java$lang$Object == null ? (class$java$lang$Object = WaspSerializationHelper.class$("java.lang.Object")) : class$java$lang$Object)) {
                throw new IntrospectionException("Due to undefined mapping between java.lang.Object.class and XML Schema WASP can not send instance of java.lang.Object.");
            }
            properties = Introspector.getBeanInfo(cls, class$java$lang$Object == null ? (class$java$lang$Object = WaspSerializationHelper.class$("java.lang.Object")) : class$java$lang$Object).getPropertyDescriptors();
        }
        if (inherit) {
            Class superC = cls.getSuperclass();
            Class<?>[] ifaces = cls.getInterfaces();
            if (superC != null && superC != (class$java$lang$Object == null ? (class$java$lang$Object = WaspSerializationHelper.class$("java.lang.Object")) : class$java$lang$Object)) {
                WaspSerializationHelper.setProperties(superC, props, inherit);
            }
            if (ifaces != null) {
                i = 0;
                while (i < ifaces.length) {
                    WaspSerializationHelper.setProperties(ifaces[i], props, inherit);
                    ++i;
                }
            }
        }
        Field[] fields = cls.getDeclaredFields();
        int length = properties.length;
        i = 0;
        while (i < length) {
            boolean skip = true;
            Method method = properties[i].getWriteMethod();
            if (method != null && Modifier.isPublic(method.getModifiers()) && !Modifier.isStatic(method.getModifiers())) {
                skip = false;
            }
            if ((method = properties[i].getReadMethod()) != null && Modifier.isPublic(method.getModifiers()) && !Modifier.isStatic(method.getModifiers())) {
                skip = false;
            }
            if (!skip) {
                String propName = properties[i].getName();
                props.put(propName, properties[i]);
            }
            ++i;
        }
        length = fields.length;
        int i2 = 0;
        while (i2 < length) {
            int modifiers = fields[i2].getModifiers();
            if (!(!serializePrivateFields && !Modifier.isPublic(modifiers) || Modifier.isTransient(modifiers) || Modifier.isStatic(modifiers) || Modifier.isFinal(modifiers))) {
                String shortName = fields[i2].getName();
                int p = shortName.lastIndexOf(46);
                if (p >= 0) {
                    shortName = shortName.substring(p);
                }
                if (!props.containsKey(shortName)) {
                    props.put(shortName, fields[i2]);
                }
            }
            ++i2;
        }
    }

    public static void clearProperties() {
        Map map = classProperties;
        synchronized (map) {
            classProperties.clear();
        }
        Map map2 = classDeclaredProperties;
        synchronized (map2) {
            classDeclaredProperties.clear();
        }
    }

    public static SchemaContext.State init(SerializationContext ctx, SOAPMethodInfo.PartInfo pi, QName elementName, boolean in) throws MessageCreatingException {
        SchemaContext.State state = in ? (pi.inSchemaElement != null ? ctx.putMember(pi.inSchemaElement) : ctx.putMember(new Member(elementName, pi.inSchemaType, true))) : (pi.outSchemaElement != null ? ctx.putMember(pi.outSchemaElement) : ctx.putMember(new Member(elementName, pi.outSchemaType, true)));
        return state;
    }

    public static MessageAttachmentSender writeAttachments(Iterator attachments, OutputMessage outmsg) throws IOException {
        MessageAttachmentSender sender = new MessageAttachmentSender(outmsg);
        while (attachments.hasNext()) {
            MessageAttachment att = (MessageAttachment)attachments.next();
            sender.addAttachment(att);
            att.setContentType(null);
            att.setData(null);
        }
        new Thread(sender).start();
        return sender;
    }

    public static String mapElementName(String schemaOrMessageName) {
        String ret;
        int length = schemaOrMessageName.length();
        char[] nameChars = schemaOrMessageName.toCharArray();
        boolean changed = false;
        boolean changedFirst = false;
        if (!Character.isJavaIdentifierStart(nameChars[0])) {
            changed = true;
            changedFirst = true;
            if (!Character.isJavaIdentifierPart(nameChars[0])) {
                nameChars[0] = 95;
            }
        }
        int i = 1;
        while (i < length) {
            if (!Character.isJavaIdentifierPart(nameChars[i])) {
                nameChars[i] = 95;
                changed = true;
            }
            ++i;
        }
        if (changed) {
            schemaOrMessageName = new String(nameChars);
            if (changedFirst) {
                schemaOrMessageName = "val".concat(schemaOrMessageName);
            }
        }
        if ((ret = (String)forbiddenIdentifiers.get(schemaOrMessageName)) != null) {
            return ret;
        }
        return schemaOrMessageName;
    }

    public static String getConstructJavaMemberName(SchemaConstruct construct) {
        if (construct != null) {
            if (construct.getJavaName() != null) {
                return construct.getJavaName();
            }
            SchemaConstruct.ConstructType constructType = construct.getConstructType();
            if (constructType != SchemaConstruct.ConstructType.TYPE && construct.getName() != null) {
                return construct.getName().getLocalPart();
            }
            if (constructType == SchemaConstruct.ConstructType.TYPE && ((Type)construct).getKind() == 39) {
                return "any";
            }
        }
        return null;
    }

    public static Object getField(Object data, Field field) throws IllegalAccessException {
        Object memberObject;
        if (WaspSerializationHelper.serializePrivateFields()) {
            boolean accessible = field.isAccessible();
            ((AccessibleObject)field).setAccessible(true);
            memberObject = field.get(data);
            ((AccessibleObject)field).setAccessible(accessible);
        } else {
            memberObject = field.get(data);
        }
        return memberObject;
    }

    public static Element getMappingFile(Class cls) {
        Document doc;
        URL resourceURL;
        if (cls == null || cls == (class$java$lang$Object == null ? (class$java$lang$Object = WaspSerializationHelper.class$("java.lang.Object")) : class$java$lang$Object)) {
            return null;
        }
        String name = cls.getName();
        int p = name.lastIndexOf(".");
        if (p >= 0) {
            name = name.substring(p + 1);
        }
        if ((resourceURL = cls.getResource(name = name + "." + Constants.MAPPING_FILE_SUFFIX)) == null) {
            Element ret = WaspSerializationHelper.getMappingFile(cls.getSuperclass());
            if (ret != null) {
                return ret;
            }
            Class<?>[] ifaces = cls.getInterfaces();
            if (ifaces != null) {
                int i = 0;
                while (i < ifaces.length) {
                    ret = WaspSerializationHelper.getMappingFile(ifaces[i]);
                    if (ret != null) {
                        return ret;
                    }
                    ++i;
                }
            }
            return null;
        }
        String url = resourceURL.toExternalForm();
        if (url == null) {
            return null;
        }
        try {
            doc = ElementHelper.loadDocument(new Endpoint(url));
        }
        catch (Exception e) {
            throw new RuntimeWrappedException("Exception getting mapping file for " + cls, e);
        }
        return doc.getDocumentElement();
    }

    public static String decapitalizeName(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(Character.toLowerCase(name.charAt(0)));
        buffer.append(name.substring(1));
        return buffer.toString();
    }

    public static Exception deserializeFault(Tokenizer tokenizer, Class deserializedClass, DeserializationContext dectx, Type type, Member element) throws MessageProcessingException, IOException, TokenizerException {
        Token currentToken = TokenPool.getToken();
        tokenizer.readToken(currentToken);
        String id = SerializationHelper.getId(currentToken);
        SchemaContext.State state = element != null ? dectx.putSchemaConstruct(element) : dectx.putSchemaConstruct(new Member(new QName(tokenizer.getNamespace(), tokenizer.getLocalName()), type));
        Exception ret = SerializationHelper.deserializeFaultElement(tokenizer, currentToken, deserializedClass, dectx);
        dectx.leave(state);
        if (id != null) {
            dectx.setReferencedValue(id, ret);
        }
        TokenPool.releaseToken(currentToken);
        return ret;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        forbiddenIdentifiers.put("default", "_default_");
        forbiddenIdentifiers.put("void", "_void_");
        forbiddenIdentifiers.put("byte", "_byte_");
        forbiddenIdentifiers.put("short", "_short_");
        forbiddenIdentifiers.put("char", "_char_");
        forbiddenIdentifiers.put("int", "_int_");
        forbiddenIdentifiers.put("long", "_long_");
        forbiddenIdentifiers.put("float", "_float_");
        forbiddenIdentifiers.put("double", "_double_");
        forbiddenIdentifiers.put("boolean", "_boolean_");
        forbiddenIdentifiers.put("if", "_if_");
        forbiddenIdentifiers.put("for", "_for_");
        forbiddenIdentifiers.put("while", "_while_");
        forbiddenIdentifiers.put("do", "_do_");
        forbiddenIdentifiers.put("switch", "_switch_");
        forbiddenIdentifiers.put("synchronized", "_synchronized_");
        forbiddenIdentifiers.put("return", "_return_");
        forbiddenIdentifiers.put("throw", "_throw_");
        forbiddenIdentifiers.put("break", "_break_");
        forbiddenIdentifiers.put("continue", "_continue_");
        forbiddenIdentifiers.put("catch", "_catch_");
        forbiddenIdentifiers.put("case", "_case_");
        forbiddenIdentifiers.put("public", "_public_");
        forbiddenIdentifiers.put("protected", "_protected_");
        forbiddenIdentifiers.put("private", "_private_");
        forbiddenIdentifiers.put("static", "_static_");
        forbiddenIdentifiers.put("abstract", "_abstract_");
        forbiddenIdentifiers.put("final", "_final_");
        forbiddenIdentifiers.put("native", "_native_");
        forbiddenIdentifiers.put("synchronized", "_synchronized_");
        forbiddenIdentifiers.put("transient", "_transient_");
        forbiddenIdentifiers.put("volatile", "_volatile_");
        forbiddenIdentifiers.put("strictfp", "_strictfp_");
        forbiddenIdentifiers.put("class", "_class_");
        forbiddenIdentifiers.put("interface", "_interface_");
        forbiddenIdentifiers.put("try", "_try_");
        forbiddenIdentifiers.put("finally", "_finally_");
        forbiddenIdentifiers.put("throws", "_throws_");
        forbiddenIdentifiers.put("new", "_new_");
        forbiddenIdentifiers.put("package", "_package_");
        forbiddenIdentifiers.put("import", "_import_");
        forbiddenIdentifiers.put("implements", "_implements_");
        forbiddenIdentifiers.put("extends", "_extends_");
        forbiddenIdentifiers.put("true", "_true_");
        forbiddenIdentifiers.put("false", "_false_");
    }
}

