/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.serialization;

import com.idoox.wasp.serialization.SerializationRepositoryImpl;
import java.util.Map;
import javax.xml.namespace.QName;
import org.idoox.xml.schema.Schema;
import org.idoox.xml.schema.SchemaException;
import org.idoox.xml.schema.Type;

public class TypeSerializationHelper {
    protected String serializationID;
    protected String targetLanguage;
    protected SerializationRepositoryImpl repository;
    protected Map typeToProgLangMapping;
    protected Map nullTypeToProgLangMapping;
    protected Map progLangToTypeMapping;
    protected Map nullProgLangToTypeMapping;
    protected Map typeToProgLangMappingSID;
    protected Map progLangToTypeMappingSID;
    private Schema schema;
    private boolean useSchemaTypeMapping;
    private String encodingURI;

    public void init(String serializationID, String targetLanguage, SerializationRepositoryImpl repository, String encodingURI) {
        this.serializationID = serializationID;
        this.targetLanguage = targetLanguage;
        this.repository = repository;
        this.encodingURI = encodingURI;
        this.fillServiceMappingTables();
    }

    public String getType(Type type) {
        String ret = null;
        if (this.useSchemaTypeMapping) {
            try {
                Type schemaType;
                QName name = type.getName();
                if (name != null && (schemaType = this.schema.getSchemaType(name)) != null && (ret = schemaType.getJavaTypeName()) != null) {
                    return ret;
                }
            }
            catch (SchemaException e) {
                // empty catch block
            }
            ret = type.getJavaTypeName();
            if (ret != null) {
                return ret;
            }
        }
        QName typeName = type.getName();
        if (this.typeToProgLangMappingSID != null && (ret = (String)this.typeToProgLangMappingSID.get(typeName)) != null) {
            return ret;
        }
        if (this.typeToProgLangMapping != null && (ret = (String)this.typeToProgLangMapping.get(typeName)) != null) {
            return ret;
        }
        if (this.nullTypeToProgLangMapping != null) {
            ret = (String)this.nullTypeToProgLangMapping.get(typeName);
        }
        return ret;
    }

    public QName getSchemaType(String progLangType) throws SchemaException {
        Type t;
        QName ret = null;
        if (this.schema != null && this.useSchemaTypeMapping && (t = this.schema.getSchemaType(progLangType)) != null) {
            return t.getName();
        }
        if (this.progLangToTypeMappingSID != null && (ret = (QName)this.progLangToTypeMappingSID.get(progLangType)) != null) {
            return ret;
        }
        if (this.progLangToTypeMapping != null && (ret = (QName)this.progLangToTypeMapping.get(progLangType)) != null) {
            return ret;
        }
        if (this.nullProgLangToTypeMapping != null) {
            ret = (QName)this.nullProgLangToTypeMapping.get(progLangType);
        }
        return ret;
    }

    private void fillServiceMappingTables() {
        if (this.serializationID == null) {
            this.serializationID = this.repository.getEncodingDefaultSerializationId(this.encodingURI);
        }
        this.progLangToTypeMapping = this.repository.getProgLangToSchemaMappingTable(this.repository.getEncodingDefaultSerializationId(this.encodingURI), this.targetLanguage);
        this.nullProgLangToTypeMapping = this.repository.getProgLangToSchemaMappingTable(null, this.targetLanguage);
        this.progLangToTypeMappingSID = this.repository.getProgLangToSchemaMappingTable(this.serializationID, this.targetLanguage);
        this.typeToProgLangMapping = this.repository.getSchemaToProgLangMappingTable(this.repository.getEncodingDefaultSerializationId(this.encodingURI), this.targetLanguage);
        this.nullTypeToProgLangMapping = this.repository.getSchemaToProgLangMappingTable(null, this.targetLanguage);
        this.typeToProgLangMappingSID = this.repository.getSchemaToProgLangMappingTable(this.serializationID, this.targetLanguage);
    }

    public void setSchema(Schema schema, boolean useSchemaTypeMapping) {
        this.schema = schema;
        this.useSchemaTypeMapping = useSchemaTypeMapping;
    }
}

