/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.serialization;

import com.idoox.debug.Category;
import com.idoox.util.CopyOnWriteHelper;
import com.idoox.util.ObjectPool;
import com.idoox.util.Pool;
import com.idoox.util.config.SchemaConfig;
import com.idoox.util.config.SchemaMappingConfig;
import com.idoox.util.config.SchemaRepositoryConfig;
import com.idoox.util.config.TypeMappingConfig;
import com.idoox.wasp.ClassSpace;
import com.idoox.wasp.ClassSpaceHelper;
import com.idoox.wasp.InitialReferencesRegistrar;
import com.idoox.wasp.config.FaultSerializationConfig;
import com.idoox.wasp.config.SerializationConfig;
import com.idoox.wasp.config.SerializationRepositoryConfig;
import com.idoox.wasp.serialization.DeserializationChainImpl;
import com.idoox.wasp.serialization.DeserializationChainImplPool;
import com.idoox.wasp.serialization.PrimitiveTypeAccessor;
import com.idoox.wasp.serialization.SerializationChainImpl;
import com.idoox.wasp.serialization.SerializationChainImplPool;
import com.idoox.wasp.serialization.TypeMappingContextImpl;
import com.idoox.wasp.serialization.WaspSerializationHelper;
import com.idoox.wasp.serialization.wsdl.WSDLDeserializationContext;
import com.idoox.wasp.serialization.wsdl.WSDLSerializationContext;
import com.systinet.wasp.soap.util.SAAJUtils;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.xml.namespace.QName;
import javax.xml.rpc.encoding.Deserializer;
import javax.xml.rpc.encoding.Serializer;
import javax.xml.soap.Detail;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPFault;
import org.idoox.config.Configurable;
import org.idoox.config.Configurator;
import org.idoox.transport.client.Endpoint;
import org.idoox.util.RuntimeWrappedException;
import org.idoox.wasp.Context;
import org.idoox.wasp.Module;
import org.idoox.wasp.serialization.DeserializationChain;
import org.idoox.wasp.serialization.DeserializationContext;
import org.idoox.wasp.serialization.FaultDeserializer;
import org.idoox.wasp.serialization.FaultSerializer;
import org.idoox.wasp.serialization.SerializationChain;
import org.idoox.wasp.serialization.SerializationContext;
import org.idoox.wasp.serialization.SerializationRepository;
import org.idoox.wasp.serialization.TypeMappingContext;
import org.idoox.wasp.serialization.XMLDeserializer;
import org.idoox.wasp.serialization.XMLSerializer;
import org.idoox.xml.Tokenizer;
import org.idoox.xml.schema.Type;
import org.idoox.xmlrpc.Fault;

public class SerializationRepositoryImpl
implements SerializationRepository,
Module {
    private static final Category cat = Category.getCategory("com.idoox.wasp.serialization.SerializationRepositoryImpl");
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    Map faultMap;
    Map serializationMap;
    FaultSerializer defaultFaultSerializer;
    FaultDeserializer defaultFaultDeserializer;
    Map progLangToSIDToTypeToProgLangMapping;
    Map progLangToSIDToProgLangToTypeMapping;
    Map sidToNamespaceURIToLocation;
    Map sidToMimeTypeToClassName;
    Map sidToClassNameToMimeType;
    Map encodingToDefaultSerializationMap;
    String defaultFaultSerializationId;
    String defaultXmlSerialization;
    String defaultSoapEncSerialization;
    Pool deserializationContextPool;
    Pool serializationContextPool;
    private int version = 0;
    String previousSerializationID = "---";
    SerializationCache previousSerializationCache = null;
    private Map nameToInstanceMap = new HashMap();
    private Map instanceToNameMap = new HashMap();
    private Map nameToFaultInstanceMap = new HashMap();
    private Map faultInstanceToNameMap = new HashMap();
    private long instanceCount = 0L;
    private final String INSTANCE_NAME_PREFIX = "$i";
    private long serCount = 0L;
    private final String SER_NAME_PREFIX = "$s";
    private final CopyOnWriteHelper COW = new CopyOnWriteHelper(new SerializationCOWCopyHander(this), "$");
    private final CopyOnWriteHelper FCOW = new CopyOnWriteHelper(new FaultSerializationCOWCopyHander(this), "$f");
    static /* synthetic */ Class class$com$idoox$wasp$config$SerializationRepositoryConfig;
    static /* synthetic */ Class class$com$idoox$wasp$config$SerializationConfig;
    static /* synthetic */ Class class$org$idoox$wasp$serialization$FaultSerializer;
    static /* synthetic */ Class class$org$idoox$wasp$serialization$FaultDeserializer;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$com$idoox$wasp$config$FaultSerializationConfig;
    static /* synthetic */ Class class$java$lang$Throwable;
    static /* synthetic */ Class class$com$idoox$util$config$SchemaRepositoryConfig;

    public SerializationRepositoryImpl() {
        this.deserializationContextPool = new ObjectPool();
        this.deserializationContextPool.init(new WSDLDeserializationContextFactory(), 5);
        this.serializationContextPool = new ObjectPool();
        this.serializationContextPool.init(new WSDLSerializationContextFactory(), 5);
    }

    public final int getVersion() {
        return this.version;
    }

    public DeserializationContext createDeserializationContext(String serializationID, String encodingURI) {
        WSDLDeserializationContext ctx = (WSDLDeserializationContext)this.deserializationContextPool.get();
        ctx.init(this, serializationID, encodingURI);
        return ctx;
    }

    public void releaseDeserializationContext(DeserializationContext ctx) {
        WSDLDeserializationContext deserializationContext = (WSDLDeserializationContext)ctx;
        deserializationContext.clear();
        this.deserializationContextPool.release(ctx);
    }

    public SerializationContext createSerializationContext(String serializationID, String encodingURI) {
        WSDLSerializationContext ctx = (WSDLSerializationContext)this.serializationContextPool.get();
        ctx.init(this, serializationID, encodingURI);
        return ctx;
    }

    public void releaseSerializationContext(SerializationContext ctx) {
        WSDLSerializationContext serializationContext = (WSDLSerializationContext)ctx;
        serializationContext.clear();
        this.serializationContextPool.release(ctx);
    }

    public TypeMappingContext createTypeMappingContext(String serializationID, String encodingURI, String language) {
        TypeMappingContextImpl ret = new TypeMappingContextImpl();
        ret.init(this, serializationID, encodingURI, language);
        return ret;
    }

    public void releaseTypeMappingContext(TypeMappingContext ctx) {
    }

    public FaultInstance getFaultSerializerInstance(String serializationID, Throwable exception) {
        FaultInstance[] faults = (FaultInstance[])this.faultMap.get(serializationID = this.FCOW.resolveID(serializationID, false));
        if (faults == null) {
            if (this.defaultFaultSerializationId != null && !this.defaultFaultSerializationId.equals(serializationID)) {
                return this.getFaultSerializerInstance(this.defaultFaultSerializationId, exception);
            }
            return null;
        }
        int i = 0;
        while (i < faults.length) {
            Class[] throwables = faults[i].throwables;
            if (throwables != null) {
                int j = 0;
                while (j < throwables.length) {
                    if (throwables[j].isInstance(exception)) {
                        return faults[i];
                    }
                    ++j;
                }
            }
            ++i;
        }
        if (this.defaultFaultSerializationId != null && !this.defaultFaultSerializationId.equals(serializationID)) {
            return this.getFaultSerializerInstance(this.defaultFaultSerializationId, exception);
        }
        return null;
    }

    public FaultSerializer getFaultSerializer(String serializationID, Throwable exception) {
        FaultInstance faultInstance = this.getFaultSerializerInstance(serializationID, exception);
        if (faultInstance == null) {
            return this.defaultFaultSerializer;
        }
        FaultSerializer serializer = faultInstance.serializer;
        if (serializer == null) {
            return this.defaultFaultSerializer;
        }
        return serializer;
    }

    public FaultInstance getFaultDeserializerInstance(String serializationID, SOAPFault fault) {
        FaultInstance[] faults = (FaultInstance[])this.faultMap.get(serializationID = this.FCOW.resolveID(serializationID, false));
        if (faults == null) {
            return null;
        }
        String faultCodeString = fault.getFaultCode();
        Iterator childElements = fault.getChildElements();
        SOAPElement faultCodeEl = null;
        while (childElements.hasNext()) {
            Object o = childElements.next();
            if (!(o instanceof SOAPElement)) continue;
            faultCodeEl = (SOAPElement)o;
            break;
        }
        if (faultCodeEl == null) {
            throw new RuntimeException("Unable to find faultCode!");
        }
        ArrayList<QName> subcodes = new ArrayList<QName>(1);
        subcodes.add(SAAJUtils.stringToQName(faultCodeEl, faultCodeString));
        Detail detail = fault.getDetail();
        childElements = detail.getChildElements();
        QName firstDetail = null;
        while (childElements.hasNext()) {
            Object o = childElements.next();
            if (!(o instanceof SOAPElement)) continue;
            SOAPElement el = (SOAPElement)o;
            Name elementName = el.getElementName();
            firstDetail = new QName(elementName.getURI(), elementName.getLocalName());
            break;
        }
        int codeIndex = 0;
        while (codeIndex < subcodes.size()) {
            int i = 0;
            while (i < faults.length) {
                FaultConfig[] faultcfgs = faults[i].faults;
                if (faultcfgs != null) {
                    int j = 0;
                    while (j < faultcfgs.length) {
                        if (this.testFaultCode(faultcfgs[j].faultCode, (QName)subcodes.get(codeIndex)) && this.testFaultActor(faultcfgs[j].faultActor, fault.getFaultActor()) && this.testFirstDetailElement(faultcfgs[j].firstDetailElement, firstDetail)) {
                            return faults[i];
                        }
                        ++j;
                    }
                }
                ++i;
            }
            ++codeIndex;
        }
        return null;
    }

    public FaultDeserializer getFaultDeserializer(String serializationID, Fault fault) {
        try {
            serializationID = this.FCOW.resolveID(serializationID, false);
            FaultInstance[] faults = (FaultInstance[])this.faultMap.get(serializationID);
            if (faults == null) {
                if (this.defaultFaultSerializationId != null && this.defaultFaultSerializationId.equals(serializationID)) {
                    return this.getFaultDeserializer(this.defaultFaultSerializationId, fault);
                }
                return this.defaultFaultDeserializer;
            }
            ArrayList<QName> subcodes = new ArrayList<QName>(fault.getFaultSubcodes().size() + 1);
            subcodes.add(fault.getFaultCode());
            subcodes.addAll(fault.getFaultSubcodes());
            QName firstDetail = null;
            Tokenizer detail = fault.getDetailTokenizer();
            if (detail != null && detail.currentState() == 2) {
                firstDetail = new QName(detail.getNamespace(), detail.getLocalName());
            }
            int codeIndex = 0;
            while (codeIndex < subcodes.size()) {
                int i = 0;
                while (i < faults.length) {
                    FaultConfig[] faultcfgs = faults[i].faults;
                    if (faultcfgs != null) {
                        int j = 0;
                        while (j < faultcfgs.length) {
                            if (this.testFaultCode(faultcfgs[j].faultCode, (QName)subcodes.get(codeIndex)) && this.testFaultActor(faultcfgs[j].faultActor, fault.getFaultActor()) && this.testFirstDetailElement(faultcfgs[j].firstDetailElement, firstDetail)) {
                                return faults[i].deserializer;
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
                ++codeIndex;
            }
        }
        catch (Exception e) {
            cat.error("Exception during getting fault deserializer : ", e);
        }
        if (this.defaultFaultSerializationId != null && this.defaultFaultSerializationId.equals(serializationID)) {
            return this.getFaultDeserializer(this.defaultFaultSerializationId, fault);
        }
        return this.defaultFaultDeserializer;
    }

    public DeserializationChain getDeserializationChain(String serializationID, String encodingURI, Type type, Class serializedClass) {
        DeserializationChainImpl chain = DeserializationChainImplPool.getDeserializationChain();
        chain.clear();
        if (serializationID != null) {
            this.fillDeserializationChain(serializationID, type, serializedClass, chain);
        }
        this.fillDeserializationChain(this.getEncodingDefaultSerializationId(encodingURI), type, serializedClass, chain);
        return chain;
    }

    public void fillDeserializationChain(String serializationID, Type type, Class serializedClass, DeserializationChainImpl chain) {
        SerializationCache cache;
        serializationID = this.COW.resolveID(serializationID, false);
        SerializationRepositoryImpl serializationRepositoryImpl = this;
        synchronized (serializationRepositoryImpl) {
            if (serializationID == this.previousSerializationID) {
                cache = this.previousSerializationCache;
            } else {
                cache = (SerializationCache)this.serializationMap.get(serializationID);
                this.previousSerializationID = serializationID;
                this.previousSerializationCache = cache;
            }
        }
        if (cache != null) {
            SerializationCache serializationCache = cache;
            synchronized (serializationCache) {
                Deserializer[] deserializers;
                Map typeToClassToDeserializers = cache.typeToClassToDeserializers();
                HashMap<Class, Deserializer[]> classToDeserializers = (HashMap<Class, Deserializer[]>)typeToClassToDeserializers.get(type.getName());
                if (classToDeserializers == null) {
                    classToDeserializers = new HashMap<Class, Deserializer[]>(5, 0.75f);
                    typeToClassToDeserializers.put(type.getName(), classToDeserializers);
                }
                if ((deserializers = (Deserializer[])classToDeserializers.get(serializedClass)) == null) {
                    ArrayList<Deserializer> ds = new ArrayList<Deserializer>();
                    SerializationInstance[] serializations = cache.getSerializations();
                    int i = 0;
                    while (i < serializations.length) {
                        if (this.compareSerialization(serializations[i], type, serializedClass, false)) {
                            ds.add(serializations[i].getDeserializer());
                        }
                        ++i;
                    }
                    deserializers = ds.toArray(new Deserializer[ds.size()]);
                    classToDeserializers.put(serializedClass, deserializers);
                }
                int i = 0;
                while (i < deserializers.length) {
                    chain.add(deserializers[i]);
                    ++i;
                }
            }
        }
    }

    public void releaseDeserializationChain(DeserializationChain chain) {
        DeserializationChainImpl chainImpl = (DeserializationChainImpl)chain;
        chainImpl.clear();
        DeserializationChainImplPool.releaseDeserializationChain(chainImpl);
    }

    private boolean compareSerialization(SerializationInstance serializationInstance, Type type, Class serializedClass, boolean getSerializer) {
        Class[] cls;
        if (getSerializer ? serializationInstance.serClassName == null : serializationInstance.deserClassName == null) {
            return false;
        }
        QName[] typeQNames = serializationInstance.typeQNames;
        if (typeQNames.length > 0) {
            int tqn = 0;
            while (tqn < typeQNames.length) {
                if (typeQNames[tqn] != null && SerializationRepositoryImpl.isExtendedFrom(type, typeQNames[tqn])) break;
                ++tqn;
            }
            if (tqn == typeQNames.length) {
                return false;
            }
        }
        if ((cls = serializationInstance.serializedClasses).length > 0) {
            int sc = 0;
            while (sc < cls.length) {
                if (serializedClass == null) {
                    if (cls[sc] == null) break;
                } else if (cls[sc].isAssignableFrom(serializedClass)) break;
                ++sc;
            }
            if (sc == cls.length) {
                return false;
            }
        }
        return true;
    }

    private static boolean isExtendedFrom(Type type, QName name) {
        do {
            if (!name.equals(type.getName())) continue;
            return true;
        } while ((type = type.getBaseType()) != null);
        return false;
    }

    private void fillSerializationChain(SerializationChainImpl chain, Type type, Class serializedClass, String serializationID) {
        SerializationCache cache;
        serializationID = this.COW.resolveID(serializationID, false);
        SerializationRepositoryImpl serializationRepositoryImpl = this;
        synchronized (serializationRepositoryImpl) {
            if (serializationID == this.previousSerializationID) {
                cache = this.previousSerializationCache;
            } else {
                cache = (SerializationCache)this.serializationMap.get(serializationID);
                this.previousSerializationID = serializationID;
                this.previousSerializationCache = cache;
            }
        }
        if (cache != null) {
            SerializationCache serializationCache = cache;
            synchronized (serializationCache) {
                Serializer[] serializers;
                Map typeToClassToSerializers = cache.typeToClassToSerializers();
                HashMap<Class, Serializer[]> classToSerializers = (HashMap<Class, Serializer[]>)typeToClassToSerializers.get(type.getName());
                if (classToSerializers == null) {
                    classToSerializers = new HashMap<Class, Serializer[]>(5, 0.75f);
                    typeToClassToSerializers.put(type.getName(), classToSerializers);
                }
                if ((serializers = (Serializer[])classToSerializers.get(serializedClass)) == null) {
                    ArrayList<Serializer> ds = new ArrayList<Serializer>();
                    SerializationInstance[] serializations = cache.getSerializations();
                    int i = 0;
                    while (i < serializations.length) {
                        if (this.compareSerialization(serializations[i], type, serializedClass, true)) {
                            ds.add(serializations[i].getSerializer());
                        }
                        ++i;
                    }
                    serializers = ds.toArray(new Serializer[ds.size()]);
                    classToSerializers.put(serializedClass, serializers);
                }
                int i = 0;
                while (i < serializers.length) {
                    chain.add(serializers[i]);
                    ++i;
                }
            }
        }
    }

    public SerializationChain getSerializationChain(String serializationID, String encodingURI, Class serializedClass, Type type) {
        SerializationChainImpl chain = SerializationChainImplPool.getSerializationChain();
        chain.clear();
        if (serializationID != null) {
            this.fillSerializationChain(chain, type, serializedClass, serializationID);
        }
        this.fillSerializationChain(chain, type, serializedClass, this.getEncodingDefaultSerializationId(encodingURI));
        return chain;
    }

    public void releaseSerializationChain(SerializationChain chain) {
        SerializationChainImpl chainImpl = (SerializationChainImpl)chain;
        chainImpl.clear();
        SerializationChainImplPool.releaseSerializationChain(chainImpl);
    }

    public void load(Configurable c) {
        ++this.version;
        InitialReferencesRegistrar.addInitialReference("org.idoox.wasp.serialization.SerializationRepository", this);
        SerializationRepositoryConfig cfg = (SerializationRepositoryConfig)c.narrow(class$com$idoox$wasp$config$SerializationRepositoryConfig == null ? (class$com$idoox$wasp$config$SerializationRepositoryConfig = SerializationRepositoryImpl.class$("com.idoox.wasp.config.SerializationRepositoryConfig")) : class$com$idoox$wasp$config$SerializationRepositoryConfig);
        Boolean serializePrivateFields = cfg.getSerializePrivateFields();
        if (serializePrivateFields != null && serializePrivateFields.booleanValue()) {
            cat.info("Serialization of private field is on");
            WaspSerializationHelper.serializePrivateFields = true;
        }
        this.initializeMappingTables();
        this.defaultFaultSerializationId = cfg.getDefaultFaultSerialization();
        this.loadDefaultFaultSerializers(c, cfg);
        this.loadDefaultSerialization(c, cfg);
        this.loadFaultSerializers(c, cfg);
        this.loadSerializers(c, cfg);
    }

    public void init() {
    }

    public void destroy() {
    }

    public void addSerialization(Configurable c) {
        ++this.version;
        SerializationConfig cfg = (SerializationConfig)c.narrow(class$com$idoox$wasp$config$SerializationConfig == null ? (class$com$idoox$wasp$config$SerializationConfig = SerializationRepositoryImpl.class$("com.idoox.wasp.config.SerializationConfig")) : class$com$idoox$wasp$config$SerializationConfig);
        this.loadSerializers(cfg);
    }

    public void removeSerialization(String name) {
        ++this.version;
        this.COW.removeID(name);
        this.serializationMap.remove(name);
    }

    public void addFaultSerialization(Configurable c) {
        ++this.version;
        SerializationRepositoryConfig cfg = (SerializationRepositoryConfig)c.narrow(class$com$idoox$wasp$config$SerializationRepositoryConfig == null ? (class$com$idoox$wasp$config$SerializationRepositoryConfig = SerializationRepositoryImpl.class$("com.idoox.wasp.config.SerializationRepositoryConfig")) : class$com$idoox$wasp$config$SerializationRepositoryConfig);
        this.loadFaultSerializers(c, cfg);
    }

    public void removeFaultSerialization(String name) {
        ++this.version;
        this.FCOW.removeID(name);
        this.faultMap.remove(name);
    }

    private void loadDefaultFaultSerializers(Configurable c, SerializationRepositoryConfig cfg) {
        SerializationRepositoryConfig.SerializerConfig serializerConfig = cfg.getDefaultFaultSerializer();
        if (serializerConfig == null) {
            cat.error("Do not have default fault serializer");
            return;
        }
        try {
            ClassSpace defaultFaultSerializerCS = ClassSpaceHelper.getClassSpace(serializerConfig.getClassSpace(), c.getReferenceLocation());
            this.defaultFaultSerializer = (FaultSerializer)defaultFaultSerializerCS.createInstance(class$org$idoox$wasp$serialization$FaultSerializer == null ? (class$org$idoox$wasp$serialization$FaultSerializer = SerializationRepositoryImpl.class$("org.idoox.wasp.serialization.FaultSerializer")) : class$org$idoox$wasp$serialization$FaultSerializer, serializerConfig.getClassName());
        }
        catch (Exception e) {
            cat.error("Can not create default fault serializer", e);
        }
        SerializationRepositoryConfig.DeserializerConfig deserializerConfig = cfg.getDefaultFaultDeserializer();
        if (deserializerConfig == null) {
            cat.error("Do not have default fault deserializer");
            return;
        }
        try {
            ClassSpace defaultFaultDeserializerCS = ClassSpaceHelper.getClassSpace(deserializerConfig.getClassSpace(), c.getReferenceLocation());
            this.defaultFaultDeserializer = (FaultDeserializer)defaultFaultDeserializerCS.createInstance(class$org$idoox$wasp$serialization$FaultDeserializer == null ? (class$org$idoox$wasp$serialization$FaultDeserializer = SerializationRepositoryImpl.class$("org.idoox.wasp.serialization.FaultDeserializer")) : class$org$idoox$wasp$serialization$FaultDeserializer, deserializerConfig.getClassName());
        }
        catch (Exception e) {
            cat.error("Can not create default fault deserializer", e);
        }
    }

    private void loadDefaultSerialization(Configurable c, SerializationRepositoryConfig cfg) {
        SerializationRepositoryConfig.DefaultSerialization[] defs = cfg.getDefaultSerializations();
        if (defs != null) {
            int i = 0;
            while (i < defs.length) {
                this.setDefaultEncoding(defs[i].getEncodingURI(), defs[i].getSerializationId());
                ++i;
            }
        }
        this.defaultXmlSerialization = (String)this.encodingToDefaultSerializationMap.get(null);
        this.defaultSoapEncSerialization = (String)this.encodingToDefaultSerializationMap.get("http://schemas.xmlsoap.org/soap/encoding/");
    }

    public void setDefaultEncoding(String encodingURI, String serializationID) {
        if (this.encodingToDefaultSerializationMap == null) {
            this.encodingToDefaultSerializationMap = new HashMap();
        }
        this.encodingToDefaultSerializationMap.put(encodingURI, serializationID);
    }

    private void loadFaultSerializers(Configurable c, SerializationRepositoryConfig cfg) {
        Configurator configurator = (Configurator)Context.getInstance("org.idoox.config.Configurator");
        Configurable[] faultSerializations = Configurator.getTopEntries("faultSerialization");
        this.faultMap = new HashMap(11);
        if (faultSerializations != null) {
            int faultConfigIndex = 0;
            while (faultConfigIndex < faultSerializations.length) {
                try {
                    List l = this.processFaultConfig(faultSerializations[faultConfigIndex], faultSerializations);
                    this.faultMap.put(faultSerializations[faultConfigIndex].getName(), l.toArray(new FaultInstance[0]));
                }
                catch (Exception e) {
                    cat.error("Unable to initialize fault serialization " + faultSerializations[faultConfigIndex].getName(), e);
                }
                ++faultConfigIndex;
            }
        }
    }

    private void loadSerializers(SerializationConfig cfg) {
        try {
            Configurator configurator = (Configurator)Context.getInstance("org.idoox.config.Configurator");
            Configurable[] serializations = Configurator.getTopEntries("serialization");
            List serializationConfig = this.processSerializationConfig(Configurator.getConfigurable(cfg), serializations, configurator, cfg.getName());
            SerializationInstance[] instances = serializationConfig.toArray(new SerializationInstance[0]);
            this.serializationMap.put(cfg.getName(), new SerializationCache(instances));
        }
        catch (Exception e) {
            cat.error("Unable to initialize serialization " + cfg.getName(), e);
        }
    }

    private void loadSerializers(Configurable c, SerializationRepositoryConfig cfg) {
        Configurator configurator = (Configurator)Context.getInstance("org.idoox.config.Configurator");
        Configurable[] serializations = Configurator.getTopEntries("serialization");
        this.serializationMap = new HashMap(11);
        if (serializations != null) {
            int configIndex = 0;
            while (configIndex < serializations.length) {
                try {
                    List serializationConfig = this.processSerializationConfig(serializations[configIndex], serializations, configurator, serializations[configIndex].getName());
                    SerializationInstance[] instances = serializationConfig.toArray(new SerializationInstance[0]);
                    this.serializationMap.put(serializations[configIndex].getName(), new SerializationCache(instances));
                }
                catch (Exception e) {
                    cat.error("Unable to initialize serialization " + serializations[configIndex].getName(), e);
                }
                ++configIndex;
            }
        }
    }

    private List processSerializationConfig(Configurable cfg, Configurable[] allConfigs, Configurator configurator, String sid) throws MalformedURLException, IllegalAccessException, InstantiationException, ClassNotFoundException {
        SerializationConfig config = (SerializationConfig)cfg.narrow(class$com$idoox$wasp$config$SerializationConfig == null ? (class$com$idoox$wasp$config$SerializationConfig = SerializationRepositoryImpl.class$("com.idoox.wasp.config.SerializationConfig")) : class$com$idoox$wasp$config$SerializationConfig);
        return this.processSerializationConfig(config, cfg, allConfigs, configurator, sid);
    }

    private List processSerializationConfig(String name, Configurable[] allConfigs, Configurator configurator, String sid) throws MalformedURLException, IllegalAccessException, InstantiationException, ClassNotFoundException {
        int i = 0;
        while (i < allConfigs.length) {
            if (name.equals(allConfigs[i].getName())) {
                return this.processSerializationConfig(allConfigs[i], allConfigs, configurator, sid);
            }
            ++i;
        }
        throw new RuntimeException("Undefined reference to serialization '" + name + "'");
    }

    private List processSerializationConfig(SerializationConfig cfg, Configurable plainConfigurable, Configurable[] allFaultConfigs, Configurator configurator, String sid) throws MalformedURLException, IllegalAccessException, InstantiationException, ClassNotFoundException {
        SerializationConfig.InstanceConfig[] instances;
        ArrayList<SerializationInstance> ret = new ArrayList<SerializationInstance>();
        SerializationConfig.ImportConfig[] imports = cfg.getImports();
        if (imports != null) {
            int i = 0;
            while (i < imports.length) {
                ret.addAll(this.processSerializationConfig(imports[i].getRef(), allFaultConfigs, configurator, sid));
                ++i;
            }
        }
        if ((instances = cfg.getInstances()) != null) {
            int i = 0;
            while (i < instances.length) {
                try {
                    ret.add(this.processSerializationInstance(instances[i], plainConfigurable, configurator, sid));
                }
                catch (Exception e) {
                    cat.error("Exception during instantiating serializer " + cfg.getName(), e);
                }
                ++i;
            }
        }
        SchemaConfig[] schemas = cfg.getSchemas();
        int i = 0;
        while (i < schemas.length) {
            this.processSchemaConfig(schemas[i], sid, true, configurator);
            ++i;
        }
        return ret;
    }

    private SerializationInstance processSerializationInstance(SerializationConfig.InstanceConfig cfg, Configurable configurable, Configurator configurator, String sid) throws MalformedURLException, IllegalAccessException, InstantiationException, ClassNotFoundException {
        SerializationConfig.SerializedClassConfig[] serializedClassCfg;
        SerializationConfig.DeserializerConfig deserializerCfg;
        SerializationInstance inst = new SerializationInstance();
        SerializationConfig.SerializerConfig serializerCfg = cfg.getSerializer();
        if (serializerCfg != null) {
            ClassSpace serializerCS = ClassSpaceHelper.getClassSpace(serializerCfg.getClassSpace(), configurable.getReferenceLocation());
            inst.serCfg = Configurator.getConfigurable(serializerCfg).getParent();
            inst.serClassSpace = serializerCS;
            inst.serClassName = serializerCfg.getClassName();
        }
        if ((deserializerCfg = cfg.getDeserializer()) != null) {
            ClassSpace deserializerCS = ClassSpaceHelper.getClassSpace(deserializerCfg.getClassSpace(), configurable.getReferenceLocation());
            inst.deserCfg = Configurator.getConfigurable(deserializerCfg).getParent();
            inst.deserClassSpace = deserializerCS;
            inst.deserClassName = deserializerCfg.getClassName();
        }
        if ((serializedClassCfg = cfg.getSerializedClasses()) == null) {
            inst.serializedClasses = new Class[0];
        } else {
            inst.serializedClasses = new Class[serializedClassCfg.length];
            int i = 0;
            while (i < serializedClassCfg.length) {
                ClassSpace serializedClassCS = ClassSpaceHelper.getClassSpace(serializedClassCfg[i].getClassSpace(), configurable.getReferenceLocation());
                if (serializedClassCS == null) {
                    throw new RuntimeException("Class space " + serializedClassCfg[i].getClassSpace() + " not found");
                }
                inst.serializedClasses[i] = serializedClassCS.getClass(class$java$lang$Object == null ? SerializationRepositoryImpl.class$("java.lang.Object") : class$java$lang$Object, serializedClassCfg[i].getClassName());
                ++i;
            }
        }
        SerializationConfig.SchemaPathConfig[] schemaPaths = cfg.getSchemaPaths();
        if (schemaPaths != null) {
            inst.typeQNames = new QName[schemaPaths.length];
            int i = 0;
            while (i < schemaPaths.length) {
                SerializationConfig.ElementConfig[] elements = schemaPaths[i].getElements();
                if (elements != null && elements.length > 0) {
                    if (elements.length > 1) {
                        throw new RuntimeException("Paths longer than 1 element are not supported now");
                    }
                    inst.typeQNames[i] = elements[0].getType();
                }
                ++i;
            }
        } else {
            inst.typeQNames = new QName[0];
        }
        String mimeType = cfg.getMimeType();
        if (mimeType != null) {
            SerializationConfig.SerializedClassConfig[] classCfg;
            HashMap<String, String> mimeTypeToClassName = (HashMap<String, String>)this.sidToMimeTypeToClassName.get(sid);
            HashMap<String, String> classNameToMimeType = (HashMap<String, String>)this.sidToClassNameToMimeType.get(sid);
            if (mimeTypeToClassName == null) {
                mimeTypeToClassName = new HashMap<String, String>();
                this.sidToMimeTypeToClassName.put(sid, mimeTypeToClassName);
            }
            if (classNameToMimeType == null) {
                classNameToMimeType = new HashMap<String, String>();
                this.sidToClassNameToMimeType.put(sid, classNameToMimeType);
            }
            if ((classCfg = cfg.getSerializedClasses()) != null) {
                int i = 0;
                while (i < classCfg.length) {
                    String className = classCfg[i].getClassName();
                    mimeTypeToClassName.put(mimeType, className);
                    classNameToMimeType.put(className, mimeType);
                    ++i;
                }
            }
        }
        this.registerSerializationInstance(inst);
        return inst;
    }

    private List processFaultConfig(String name, Configurable[] faultConfigs) throws MalformedURLException, IllegalAccessException, InstantiationException, ClassNotFoundException {
        int i = 0;
        while (i < faultConfigs.length) {
            if (name.equals(faultConfigs[i].getName())) {
                return this.processFaultConfig(faultConfigs[i], faultConfigs);
            }
            ++i;
        }
        throw new RuntimeException("Undefined reference to faults '" + name + "'");
    }

    private List processFaultConfig(Configurable cfg, Configurable[] allFaultConfigs) throws MalformedURLException, IllegalAccessException, InstantiationException, ClassNotFoundException {
        FaultSerializationConfig config = (FaultSerializationConfig)cfg.narrow(class$com$idoox$wasp$config$FaultSerializationConfig == null ? (class$com$idoox$wasp$config$FaultSerializationConfig = SerializationRepositoryImpl.class$("com.idoox.wasp.config.FaultSerializationConfig")) : class$com$idoox$wasp$config$FaultSerializationConfig);
        return this.processFaultConfig(config, cfg, allFaultConfigs);
    }

    private List processFaultConfig(FaultSerializationConfig cfg, Configurable plainConfigurable, Configurable[] allFaultConfigs) throws MalformedURLException, IllegalAccessException, InstantiationException, ClassNotFoundException {
        FaultSerializationConfig.ImportConfig[] imports;
        ArrayList<FaultInstance> ret = new ArrayList<FaultInstance>();
        FaultSerializationConfig.InstanceConfig[] instances = cfg.getInstances();
        if (instances != null) {
            int i = 0;
            while (i < instances.length) {
                ret.add(this.processFaultInstance(instances[i], plainConfigurable));
                ++i;
            }
        }
        if ((imports = cfg.getImports()) != null) {
            int i = 0;
            while (i < imports.length) {
                ret.addAll(this.processFaultConfig(imports[i].getRef(), allFaultConfigs));
                ++i;
            }
        }
        return ret;
    }

    private FaultInstance processFaultInstance(FaultSerializationConfig.InstanceConfig cfg, Configurable configurable) throws MalformedURLException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        int i;
        FaultSerializationConfig.SerializerConfig serializerCfg = cfg.getSerializer();
        FaultSerializationConfig.DeserializerConfig deserializerCfg = cfg.getDeserializer();
        FaultInstance inst = new FaultInstance();
        if (serializerCfg != null) {
            ClassSpace serializerCS = ClassSpaceHelper.getClassSpace(serializerCfg.getClassSpace(), configurable.getReferenceLocation());
            inst.serializer = (FaultSerializer)serializerCS.createInstance(class$org$idoox$wasp$serialization$FaultSerializer == null ? (class$org$idoox$wasp$serialization$FaultSerializer = SerializationRepositoryImpl.class$("org.idoox.wasp.serialization.FaultSerializer")) : class$org$idoox$wasp$serialization$FaultSerializer, serializerCfg.getClassName());
            FaultSerializationConfig.ExceptionConfig[] exceptions = serializerCfg.getExceptions();
            if (exceptions != null) {
                inst.throwables = new Class[exceptions.length];
                i = 0;
                while (i < exceptions.length) {
                    ClassSpace ecs = ClassSpaceHelper.getClassSpace(exceptions[i].getClassSpace(), configurable.getReferenceLocation());
                    inst.throwables[i] = ecs.getClass(class$java$lang$Throwable == null ? SerializationRepositoryImpl.class$("java.lang.Throwable") : class$java$lang$Throwable, exceptions[i].getClassName());
                    ++i;
                }
            }
        }
        if (deserializerCfg != null) {
            ClassSpace deserializerCS = ClassSpaceHelper.getClassSpace(deserializerCfg.getClassSpace(), configurable.getReferenceLocation());
            inst.deserializer = (FaultDeserializer)deserializerCS.createInstance(class$org$idoox$wasp$serialization$FaultDeserializer == null ? (class$org$idoox$wasp$serialization$FaultDeserializer = SerializationRepositoryImpl.class$("org.idoox.wasp.serialization.FaultDeserializer")) : class$org$idoox$wasp$serialization$FaultDeserializer, deserializerCfg.getClassName());
            FaultSerializationConfig.FaultConfig[] flts = deserializerCfg.getFaults();
            if (flts != null) {
                inst.faults = new FaultConfig[flts.length];
                i = 0;
                while (i < flts.length) {
                    inst.faults[i] = new FaultConfig(flts[i]);
                    ++i;
                }
            }
        }
        return inst;
    }

    private boolean testAsterixString(String pattern, String value) {
        return !(pattern.endsWith("*") ? !pattern.regionMatches(0, value, 0, pattern.length() - 1) : !pattern.equals(value));
    }

    private boolean testFaultCode(QName confFaultCode, QName messageFaultCode) {
        if (confFaultCode == null) {
            return true;
        }
        String nsUri = confFaultCode.getNamespaceURI();
        if (nsUri != null) {
            if (!this.testAsterixString(nsUri, messageFaultCode.getNamespaceURI())) {
                return false;
            }
            String localPart = confFaultCode.getLocalPart();
            if (localPart != null && !this.testAsterixString(localPart, messageFaultCode.getLocalPart())) {
                return false;
            }
        }
        return true;
    }

    private boolean testFaultActor(String confFaultActor, String messageFaultActor) {
        if (confFaultActor != null) {
            if (messageFaultActor != null) {
                return confFaultActor.equals(messageFaultActor);
            }
            return false;
        }
        return true;
    }

    private boolean testFirstDetailElement(QName confFirstDetailElement, QName firtDetail) {
        if (confFirstDetailElement == null) {
            return true;
        }
        if (firtDetail == null) {
            return false;
        }
        String localName = firtDetail.getLocalPart();
        String namespace = firtDetail.getNamespaceURI();
        if (confFirstDetailElement.getNamespaceURI() != null) {
            if (!this.testAsterixString(confFirstDetailElement.getNamespaceURI(), namespace)) {
                return false;
            }
            if (confFirstDetailElement.getLocalPart() != null && !this.testAsterixString(confFirstDetailElement.getLocalPart(), localName)) {
                return false;
            }
        }
        return true;
    }

    private void initializeMappingTables() {
        this.progLangToSIDToTypeToProgLangMapping = new HashMap();
        this.progLangToSIDToProgLangToTypeMapping = new HashMap();
        this.sidToNamespaceURIToLocation = new HashMap();
        this.sidToMimeTypeToClassName = new HashMap();
        this.sidToClassNameToMimeType = new HashMap();
        Configurator configurator = (Configurator)Context.getInstance("org.idoox.config.Configurator");
        Configurable[] knownSchemas = Configurator.getTopEntries("schemaRepository");
        if (knownSchemas == null || knownSchemas.length == 0) {
            return;
        }
        int schemaRepositoryIndex = 0;
        while (schemaRepositoryIndex < knownSchemas.length) {
            this.processSchemaRepositoryConfig(knownSchemas[schemaRepositoryIndex], true, configurator);
            ++schemaRepositoryIndex;
        }
    }

    public void addSchemaRepository(Configurable configurable) {
        this.processSchemaRepositoryConfig(configurable, true, (Configurator)Context.getInstance("org.idoox.config.Configurator"));
    }

    public void removeSchemaRepository(String name) {
        Configurator configurator = (Configurator)Context.getInstance("org.idoox.config.Configurator");
        Configurable configurable = Configurator.getConfigurable("schemaRepository", name);
        this.processSchemaRepositoryConfig(configurable, false, configurator);
    }

    private void processSchemaRepositoryConfig(Configurable configurable, boolean adding, Configurator configurator) {
        SchemaRepositoryConfig schemaRepositoryConfig = (SchemaRepositoryConfig)configurable.narrow(class$com$idoox$util$config$SchemaRepositoryConfig == null ? (class$com$idoox$util$config$SchemaRepositoryConfig = SerializationRepositoryImpl.class$("com.idoox.util.config.SchemaRepositoryConfig")) : class$com$idoox$util$config$SchemaRepositoryConfig);
        SchemaConfig[] schemas = schemaRepositoryConfig.getSchemas();
        int i = 0;
        while (i < schemas.length) {
            this.processSchemaConfig(schemas[i], null, adding, configurator);
            ++i;
        }
    }

    private void processSchemaConfig(SchemaConfig schema, String sid, boolean adding, Configurator configurator) {
        SchemaMappingConfig[] languageMappings;
        String locationURL;
        String namespaceURI = schema.getNamespaceURI();
        try {
            locationURL = schema.getLocationURL();
            String configurableLocation = Configurator.getConfigurable(schema).getReferenceLocation() + "/";
            if (locationURL != null) {
                locationURL = new Endpoint(new Endpoint(configurableLocation), locationURL).toExternalForm();
            }
        }
        catch (MalformedURLException e) {
            throw new RuntimeWrappedException(e);
        }
        if (locationURL != null) {
            HashMap<String, String> namespaceURIToLocation = (HashMap<String, String>)this.sidToNamespaceURIToLocation.get(sid);
            if (namespaceURIToLocation == null) {
                namespaceURIToLocation = new HashMap<String, String>();
                this.sidToNamespaceURIToLocation.put(sid, namespaceURIToLocation);
            }
            namespaceURIToLocation.put(namespaceURI, locationURL);
        }
        if ((languageMappings = schema.getMappings()) != null) {
            int languageIndex = 0;
            while (languageIndex < languageMappings.length) {
                TypeMappingConfig[] typeMappings;
                HashMap sidToTypeToProgLang;
                String language = languageMappings[languageIndex].getLanguage();
                HashMap sidToProgLangToType = (HashMap)this.progLangToSIDToProgLangToTypeMapping.get(language);
                if (sidToProgLangToType == null) {
                    sidToProgLangToType = new HashMap(5);
                    this.progLangToSIDToProgLangToTypeMapping.put(language, sidToProgLangToType);
                }
                if ((sidToTypeToProgLang = (HashMap)this.progLangToSIDToTypeToProgLangMapping.get(language)) == null) {
                    sidToTypeToProgLang = new HashMap(5);
                    this.progLangToSIDToTypeToProgLangMapping.put(language, sidToTypeToProgLang);
                }
                if ((typeMappings = languageMappings[languageIndex].getTypeMappings()).length > 0) {
                    HashMap<QName, String> typeToProgLang;
                    HashMap<String, QName> progLangToType = (HashMap<String, QName>)sidToProgLangToType.get(sid);
                    if (progLangToType == null && adding) {
                        progLangToType = new HashMap<String, QName>(11);
                        sidToProgLangToType.put(sid, progLangToType);
                    }
                    if ((typeToProgLang = (HashMap<QName, String>)sidToTypeToProgLang.get(sid)) == null && adding) {
                        typeToProgLang = new HashMap<QName, String>(11);
                        sidToTypeToProgLang.put(sid, typeToProgLang);
                    }
                    int typeIndex = 0;
                    while (typeIndex < typeMappings.length) {
                        String name = typeMappings[typeIndex].getName();
                        String mapsTo = typeMappings[typeIndex].getMapsTo();
                        QName typeqname = new QName(namespaceURI, name);
                        if (adding) {
                            if (!progLangToType.containsKey(mapsTo)) {
                                progLangToType.put(mapsTo, typeqname);
                            }
                        } else {
                            progLangToType.remove(mapsTo);
                        }
                        if (adding) {
                            if (!typeToProgLang.containsKey(typeqname)) {
                                typeToProgLang.put(typeqname, mapsTo);
                            }
                        } else {
                            progLangToType.remove(typeqname);
                        }
                        ++typeIndex;
                    }
                }
                ++languageIndex;
            }
        }
    }

    public synchronized void setSchemaLocation(String serializationID, String nsURI, String schemaLocationURL) {
        HashMap<String, String> nsURIToLocMap = (HashMap<String, String>)this.sidToNamespaceURIToLocation.get(serializationID = this.COW.resolveID(serializationID, true));
        if (nsURIToLocMap == null) {
            nsURIToLocMap = new HashMap<String, String>();
            this.sidToNamespaceURIToLocation.put(serializationID, nsURIToLocMap);
        }
        nsURIToLocMap.put(nsURI, schemaLocationURL);
    }

    public synchronized void setTypeMapping(String serializationID, String language, QName schemaTypeName, String progLangTypeName) {
        HashMap<QName, String> typeToProgLangMapping;
        HashMap sidToTypeToProgLangMapping;
        HashMap<String, QName> progLangToTypeMapping;
        serializationID = this.COW.resolveID(serializationID, true);
        HashMap sidToProgLangToTypeMapping = (HashMap)this.progLangToSIDToProgLangToTypeMapping.get(language);
        if (sidToProgLangToTypeMapping == null) {
            sidToProgLangToTypeMapping = new HashMap();
            this.progLangToSIDToProgLangToTypeMapping.put(language, sidToProgLangToTypeMapping);
        }
        if ((progLangToTypeMapping = (HashMap<String, QName>)sidToProgLangToTypeMapping.get(serializationID)) == null) {
            progLangToTypeMapping = new HashMap<String, QName>();
            sidToProgLangToTypeMapping.put(serializationID, progLangToTypeMapping);
        }
        if ((sidToTypeToProgLangMapping = (HashMap)this.progLangToSIDToTypeToProgLangMapping.get(language)) == null) {
            sidToTypeToProgLangMapping = new HashMap();
            this.progLangToSIDToTypeToProgLangMapping.put(language, sidToTypeToProgLangMapping);
        }
        if ((typeToProgLangMapping = (HashMap<QName, String>)sidToTypeToProgLangMapping.get(serializationID)) == null) {
            typeToProgLangMapping = new HashMap<QName, String>();
            sidToTypeToProgLangMapping.put(serializationID, typeToProgLangMapping);
        }
        progLangToTypeMapping.put(progLangTypeName, schemaTypeName);
        typeToProgLangMapping.put(schemaTypeName, progLangTypeName);
    }

    public synchronized Map getProgLangToSchemaMappingTable(String serializationID, String language) {
        serializationID = this.COW.resolveID(serializationID, false);
        Map sidToProgLangToTypeMapping = (Map)this.progLangToSIDToProgLangToTypeMapping.get(language);
        if (sidToProgLangToTypeMapping == null) {
            return null;
        }
        return (Map)sidToProgLangToTypeMapping.get(serializationID);
    }

    public synchronized Map getSchemaToProgLangMappingTable(String serializationID, String language) {
        serializationID = this.COW.resolveID(serializationID, false);
        Map sidToTypeToProgLangMapping = (Map)this.progLangToSIDToTypeToProgLangMapping.get(language);
        if (sidToTypeToProgLangMapping == null) {
            return null;
        }
        return (Map)sidToTypeToProgLangMapping.get(serializationID);
    }

    public String registerSerializer(Serializer instance, QName type) {
        SerializationInstance inst = new SerializationInstance();
        inst.serializer = instance;
        inst.serClassName = instance.getClass().getName();
        inst.typeQNames = new QName[]{type};
        return this.registerSerializationInstance(inst);
    }

    public String registerSerializer(Serializer instance, Class javaType) {
        SerializationInstance inst = new SerializationInstance();
        inst.serializer = instance;
        inst.serClassName = instance.getClass().getName();
        inst.serializedClasses = new Class[]{javaType};
        return this.registerSerializationInstance(inst);
    }

    public void unregisterSerializer(String name) {
        this.unregisterSerializationInstance(name);
    }

    public String registerDeserializer(Deserializer instance, QName type) {
        SerializationInstance inst = new SerializationInstance();
        inst.deserializer = instance;
        inst.deserClassName = instance.getClass().getName();
        inst.typeQNames = new QName[]{type};
        return this.registerSerializationInstance(inst);
    }

    public void unregisterDeserializer(String name) {
        this.unregisterSerializationInstance(name);
    }

    private String registerSerializationInstance(SerializationInstance inst) {
        String name;
        String string = "$i";
        synchronized (string) {
            name = "$i" + this.instanceCount++;
        }
        this.nameToInstanceMap.put(name, inst);
        this.instanceToNameMap.put(inst, name);
        return name;
    }

    private void unregisterSerializationInstance(String name) {
        Object oldInst = this.nameToInstanceMap.remove(name);
        this.instanceToNameMap.remove(oldInst);
    }

    public String registerFaultSerializer(Serializer instance, Class[] exceptions) {
        FaultInstance inst = new FaultInstance();
        inst.serializer = (FaultSerializer)((Object)instance);
        inst.throwables = exceptions;
        return this.registerFaultInstance(inst);
    }

    public void unregisterFaultSerializer(String name) {
        this.unregisterFaultInstance(name);
    }

    public String registerFaultDeserializer(Deserializer instance, QName faultCode, String faultActor, QName firstDetailElement) {
        FaultInstance inst = new FaultInstance();
        inst.deserializer = (FaultDeserializer)((Object)instance);
        inst.faults = new FaultConfig[]{new FaultConfig(faultCode, faultActor, firstDetailElement)};
        return this.registerFaultInstance(inst);
    }

    public void unregisterFaultDeserializer(String name) {
        this.unregisterFaultInstance(name);
    }

    private String registerFaultInstance(FaultInstance inst) {
        String name;
        String string = "$i";
        synchronized (string) {
            name = "$i" + this.instanceCount++;
        }
        this.nameToFaultInstanceMap.put(name, inst);
        this.faultInstanceToNameMap.put(inst, name);
        return name;
    }

    private void unregisterFaultInstance(String name) {
        Object oldInst = this.nameToFaultInstanceMap.remove(name);
        this.faultInstanceToNameMap.remove(oldInst);
    }

    public synchronized void addSerializer(String serID, String name) {
        SerializationCache cache = (SerializationCache)this.serializationMap.get(serID = this.COW.resolveID(serID, true));
        if (cache == null) {
            throw new IllegalArgumentException("No such serialization");
        }
        SerializationCache serializationCache = cache;
        synchronized (serializationCache) {
            SerializationInstance[] serializations = cache.getSerializations();
            SerializationInstance added = (SerializationInstance)this.nameToInstanceMap.get(name);
            if (added == null) {
                throw new IllegalArgumentException("No such serializer");
            }
            SerializationInstance[] newSers = new SerializationInstance[serializations.length + 1];
            System.arraycopy(serializations, 0, newSers, 0, serializations.length);
            newSers[serializations.length] = added;
            cache.setSerializations(newSers);
        }
    }

    public synchronized void addSerializer(String serID, String name, int position) {
        SerializationCache cache = (SerializationCache)this.serializationMap.get(serID = this.COW.resolveID(serID, true));
        if (cache == null) {
            throw new IllegalArgumentException("No such serialization");
        }
        SerializationCache serializationCache = cache;
        synchronized (serializationCache) {
            SerializationInstance[] serializations = cache.getSerializations();
            int i = 0;
            while (i < serializations.length && i <= position) {
                if (serializations[i].serClassName == null) {
                    ++position;
                }
                ++i;
            }
            if (position < 0 || position > serializations.length) {
                throw new IllegalArgumentException("Position out of bounds");
            }
            SerializationInstance added = (SerializationInstance)this.nameToInstanceMap.get(name);
            if (added == null) {
                throw new IllegalArgumentException("No such serializer");
            }
            SerializationInstance[] newSers = new SerializationInstance[serializations.length + 1];
            if (position > 0) {
                System.arraycopy(serializations, 0, newSers, 0, position);
            }
            if (position < serializations.length) {
                System.arraycopy(serializations, position, newSers, position + 1, serializations.length - position);
            }
            newSers[position] = added;
            cache.setSerializations(newSers);
        }
    }

    public synchronized void removeSerializer(String serID, String name) {
        SerializationCache cache = (SerializationCache)this.serializationMap.get(serID = this.COW.resolveID(serID, true));
        if (cache == null) {
            throw new IllegalArgumentException("No such serialization");
        }
        SerializationCache serializationCache = cache;
        synchronized (serializationCache) {
            SerializationInstance[] serializations = cache.getSerializations();
            SerializationInstance removed = (SerializationInstance)this.nameToInstanceMap.get(name);
            if (removed == null) {
                throw new IllegalArgumentException("No such serializer");
            }
            int position = 0;
            while (position < serializations.length) {
                if (serializations[position] == removed) break;
                ++position;
            }
            if (position == serializations.length) {
                throw new IllegalArgumentException("No such serializer in the serialization");
            }
            SerializationInstance[] newSers = new SerializationInstance[serializations.length - 1];
            if (position > 0) {
                System.arraycopy(serializations, 0, newSers, 0, position);
            }
            if (position < serializations.length - 1) {
                System.arraycopy(serializations, position + 1, newSers, position, serializations.length - position - 1);
            }
            cache.setSerializations(newSers);
        }
    }

    public String[] getSerializers(String serID) {
        String[] retval;
        SerializationCache cache = (SerializationCache)this.serializationMap.get(serID = this.COW.resolveID(serID, false));
        if (cache == null) {
            throw new IllegalArgumentException("No such serialization");
        }
        SerializationCache serializationCache = cache;
        synchronized (serializationCache) {
            SerializationInstance[] serializations = cache.getSerializations();
            int len = 0;
            int i = 0;
            while (i < serializations.length) {
                if (serializations[i].serClassName != null) {
                    ++len;
                }
                ++i;
            }
            retval = new String[len];
            int pos = 0;
            int i2 = 0;
            while (pos < len) {
                if (serializations[i2].serClassName != null) {
                    retval[pos++] = (String)this.instanceToNameMap.get(serializations[i2]);
                }
                ++i2;
            }
        }
        return retval;
    }

    public Serializer[] getSerializerInstances(String serID) {
        Serializer[] retval;
        SerializationCache cache = (SerializationCache)this.serializationMap.get(serID = this.COW.resolveID(serID, false));
        if (cache == null) {
            return new Serializer[0];
        }
        SerializationCache serializationCache = cache;
        synchronized (serializationCache) {
            SerializationInstance[] serializations = cache.getSerializations();
            int len = 0;
            int i = 0;
            while (i < serializations.length) {
                if (serializations[i].serClassName != null) {
                    ++len;
                }
                ++i;
            }
            retval = new Serializer[len];
            int pos = 0;
            int i2 = 0;
            while (pos < len) {
                if (serializations[i2].serClassName != null) {
                    retval[pos++] = serializations[i2].getSerializer();
                }
                ++i2;
            }
        }
        return retval;
    }

    public synchronized void addDeserializer(String serID, String name) {
        SerializationCache cache = (SerializationCache)this.serializationMap.get(serID = this.COW.resolveID(serID, true));
        if (cache == null) {
            throw new IllegalArgumentException("No such serialization");
        }
        SerializationCache serializationCache = cache;
        synchronized (serializationCache) {
            SerializationInstance[] serializations = cache.getSerializations();
            SerializationInstance added = (SerializationInstance)this.nameToInstanceMap.get(name);
            if (added == null) {
                throw new IllegalArgumentException("No such deserializer");
            }
            SerializationInstance[] newSers = new SerializationInstance[serializations.length + 1];
            System.arraycopy(serializations, 0, newSers, 0, serializations.length);
            newSers[serializations.length] = added;
            cache.setSerializations(newSers);
        }
    }

    public synchronized void addDeserializer(String serID, String name, int position) {
        SerializationCache cache = (SerializationCache)this.serializationMap.get(serID = this.COW.resolveID(serID, true));
        if (cache == null) {
            throw new IllegalArgumentException("No such serialization");
        }
        SerializationCache serializationCache = cache;
        synchronized (serializationCache) {
            SerializationInstance[] serializations = cache.getSerializations();
            int i = 0;
            while (i < serializations.length && i <= position) {
                if (serializations[i].deserClassName == null) {
                    ++position;
                }
                ++i;
            }
            if (position < 0 || position > serializations.length) {
                throw new IllegalArgumentException("Position out of bounds");
            }
            SerializationInstance added = (SerializationInstance)this.nameToInstanceMap.get(name);
            if (added == null) {
                throw new IllegalArgumentException("No such deserializer");
            }
            SerializationInstance[] newSers = new SerializationInstance[serializations.length + 1];
            if (position > 0) {
                System.arraycopy(serializations, 0, newSers, 0, position);
            }
            if (position < serializations.length) {
                System.arraycopy(serializations, position, newSers, position + 1, serializations.length - position);
            }
            newSers[position] = added;
            cache.setSerializations(newSers);
        }
    }

    public synchronized void removeDeserializer(String serID, String name) {
        SerializationCache cache = (SerializationCache)this.serializationMap.get(serID = this.COW.resolveID(serID, true));
        if (cache == null) {
            throw new IllegalArgumentException("No such serialization");
        }
        SerializationCache serializationCache = cache;
        synchronized (serializationCache) {
            SerializationInstance[] serializations = cache.getSerializations();
            SerializationInstance removed = (SerializationInstance)this.nameToInstanceMap.get(name);
            if (removed == null) {
                throw new IllegalArgumentException("No such deserializer");
            }
            int position = 0;
            while (position < serializations.length) {
                if (serializations[position] == removed) break;
                ++position;
            }
            if (position == serializations.length) {
                throw new IllegalArgumentException("No such deserializer in the serialization");
            }
            SerializationInstance[] newSers = new SerializationInstance[serializations.length - 1];
            if (position > 0) {
                System.arraycopy(serializations, 0, newSers, 0, position);
            }
            if (position < serializations.length - 1) {
                System.arraycopy(serializations, position + 1, newSers, position, serializations.length - position - 1);
            }
            cache.setSerializations(newSers);
        }
    }

    public String[] getDeserializers(String serID) {
        String[] retval;
        SerializationCache cache = (SerializationCache)this.serializationMap.get(serID = this.COW.resolveID(serID, false));
        if (cache == null) {
            throw new IllegalArgumentException("No such serialization");
        }
        SerializationCache serializationCache = cache;
        synchronized (serializationCache) {
            SerializationInstance[] serializations = cache.getSerializations();
            int len = 0;
            int i = 0;
            while (i < serializations.length) {
                if (serializations[i].deserClassName != null) {
                    ++len;
                }
                ++i;
            }
            retval = new String[len];
            int pos = 0;
            int i2 = 0;
            while (pos < len) {
                if (serializations[i2].deserClassName != null) {
                    retval[pos++] = (String)this.instanceToNameMap.get(serializations[i2]);
                }
                ++i2;
            }
        }
        return retval;
    }

    public synchronized void addFaultSerializer(String fserID, String name) {
        FaultInstance[] serializations = (FaultInstance[])this.faultMap.get(fserID = this.FCOW.resolveID(fserID, true));
        if (serializations == null) {
            throw new IllegalArgumentException("No such fault serialization");
        }
        FaultInstance added = (FaultInstance)this.nameToFaultInstanceMap.get(name);
        if (added == null) {
            throw new IllegalArgumentException("No such fault serializer");
        }
        FaultInstance[] newSers = new FaultInstance[serializations.length + 1];
        System.arraycopy(serializations, 0, newSers, 0, serializations.length);
        newSers[serializations.length] = added;
        this.faultMap.put(fserID, newSers);
    }

    public synchronized void addFaultSerializer(String fserID, String name, int position) {
        FaultInstance[] serializations = (FaultInstance[])this.faultMap.get(fserID = this.FCOW.resolveID(fserID, true));
        if (serializations == null) {
            throw new IllegalArgumentException("No such fault serialization");
        }
        int i = 0;
        while (i < serializations.length && i <= position) {
            if (serializations[i].serializer == null) {
                ++position;
            }
            ++i;
        }
        if (position < 0 || position > serializations.length) {
            throw new IllegalArgumentException("Position out of bounds");
        }
        FaultInstance added = (FaultInstance)this.nameToFaultInstanceMap.get(name);
        if (added == null) {
            throw new IllegalArgumentException("No such fault serializer");
        }
        FaultInstance[] newSers = new FaultInstance[serializations.length + 1];
        if (position > 0) {
            System.arraycopy(serializations, 0, newSers, 0, position);
        }
        if (position < serializations.length) {
            System.arraycopy(serializations, position, newSers, position + 1, serializations.length - position);
        }
        newSers[position] = added;
        this.faultMap.put(fserID, newSers);
    }

    public synchronized void removeFaultSerializer(String fserID, String name) {
        FaultInstance[] serializations = (FaultInstance[])this.faultMap.get(fserID = this.FCOW.resolveID(fserID, true));
        if (serializations == null) {
            throw new IllegalArgumentException("No such fault serialization");
        }
        FaultInstance removed = (FaultInstance)this.nameToFaultInstanceMap.get(name);
        if (removed == null) {
            throw new IllegalArgumentException("No such fault serializer");
        }
        int position = 0;
        while (position < serializations.length) {
            if (serializations[position] == removed) break;
            ++position;
        }
        if (position == serializations.length) {
            throw new IllegalArgumentException("No such fault serializer in the fault serialization");
        }
        FaultInstance[] newSers = new FaultInstance[serializations.length - 1];
        if (position > 0) {
            System.arraycopy(serializations, 0, newSers, 0, position);
        }
        if (position < serializations.length - 1) {
            System.arraycopy(serializations, position + 1, newSers, position, serializations.length - position - 1);
        }
        this.faultMap.put(fserID, newSers);
    }

    public String[] getFaultSerializers(String fserID) {
        FaultInstance[] serializations = (FaultInstance[])this.faultMap.get(fserID = this.FCOW.resolveID(fserID, false));
        if (serializations == null) {
            return EMPTY_STRING_ARRAY;
        }
        int len = 0;
        int i = 0;
        while (i < serializations.length) {
            if (serializations[i].serializer != null) {
                ++len;
            }
            ++i;
        }
        String[] retval = new String[len];
        int pos = 0;
        int i2 = 0;
        while (pos < len) {
            if (serializations[i2].serializer != null) {
                retval[pos++] = (String)this.faultInstanceToNameMap.get(serializations[i2]);
            }
            ++i2;
        }
        return retval;
    }

    public synchronized void addFaultDeserializer(String fserID, String name) {
        FaultInstance[] serializations = (FaultInstance[])this.faultMap.get(fserID = this.FCOW.resolveID(fserID, true));
        if (serializations == null) {
            throw new IllegalArgumentException("No such fault serialization");
        }
        FaultInstance added = (FaultInstance)this.nameToFaultInstanceMap.get(name);
        if (added == null) {
            throw new IllegalArgumentException("No such fault deserializer");
        }
        FaultInstance[] newSers = new FaultInstance[serializations.length + 1];
        System.arraycopy(serializations, 0, newSers, 0, serializations.length);
        newSers[serializations.length] = added;
        this.faultMap.put(fserID, newSers);
    }

    public synchronized void addFaultDeserializer(String fserID, String name, int position) {
        FaultInstance[] serializations = (FaultInstance[])this.faultMap.get(fserID = this.FCOW.resolveID(fserID, true));
        if (serializations == null) {
            throw new IllegalArgumentException("No such fault serialization");
        }
        int i = 0;
        while (i < serializations.length && i <= position) {
            if (serializations[i].deserializer == null) {
                ++position;
            }
            ++i;
        }
        if (position < 0 || position > serializations.length) {
            throw new IllegalArgumentException("Position out of bounds");
        }
        FaultInstance added = (FaultInstance)this.nameToFaultInstanceMap.get(name);
        if (added == null) {
            throw new IllegalArgumentException("No such fault deserializer");
        }
        FaultInstance[] newSers = new FaultInstance[serializations.length + 1];
        if (position > 0) {
            System.arraycopy(serializations, 0, newSers, 0, position);
        }
        if (position < serializations.length) {
            System.arraycopy(serializations, position, newSers, position + 1, serializations.length - position);
        }
        newSers[position] = added;
        this.faultMap.put(fserID, newSers);
    }

    public synchronized void removeFaultDeserializer(String fserID, String name) {
        FaultInstance[] serializations = (FaultInstance[])this.faultMap.get(fserID = this.FCOW.resolveID(fserID, true));
        if (serializations == null) {
            throw new IllegalArgumentException("No such fault serialization");
        }
        FaultInstance removed = (FaultInstance)this.nameToFaultInstanceMap.get(name);
        if (removed == null) {
            throw new IllegalArgumentException("No such fault deserializer");
        }
        int position = 0;
        while (position < serializations.length) {
            if (serializations[position] == removed) break;
            ++position;
        }
        if (position == serializations.length) {
            throw new IllegalArgumentException("No such fault deserializer in the fault serialization");
        }
        FaultInstance[] newSers = new FaultInstance[serializations.length - 1];
        if (position > 0) {
            System.arraycopy(serializations, 0, newSers, 0, position);
        }
        if (position < serializations.length - 1) {
            System.arraycopy(serializations, position + 1, newSers, position, serializations.length - position - 1);
        }
        this.faultMap.put(fserID, newSers);
    }

    public String[] getFaultDeserializers(String fserID) {
        FaultInstance[] serializations = (FaultInstance[])this.faultMap.get(fserID = this.FCOW.resolveID(fserID, false));
        if (serializations == null) {
            return EMPTY_STRING_ARRAY;
        }
        int len = 0;
        int i = 0;
        while (i < serializations.length) {
            if (serializations[i].deserializer != null) {
                ++len;
            }
            ++i;
        }
        String[] retval = new String[len];
        int pos = 0;
        int i2 = 0;
        while (pos < len) {
            if (serializations[i2].deserializer != null) {
                retval[pos++] = (String)this.faultInstanceToNameMap.get(serializations[i2]);
            }
            ++i2;
        }
        return retval;
    }

    public String createSerialization() {
        String name;
        String string = "$s";
        synchronized (string) {
            name = "$s" + this.serCount++;
        }
        this.createSerialization(name);
        return name;
    }

    private void createSerialization(String name) {
        this.serializationMap.put(name, new SerializationCache(new SerializationInstance[0]));
    }

    public String createFaultSerialization() {
        String name;
        String string = "$s";
        synchronized (string) {
            name = "$s" + this.serCount++;
        }
        this.createFaultSerialization(name);
        return name;
    }

    private void createFaultSerialization(String name) {
        this.faultMap.put(name, new FaultInstance[0]);
    }

    public synchronized Map getNamespaceLocationMap(String serializationID, String encodingURI) {
        serializationID = this.COW.resolveID(serializationID, false);
        HashMap ret = new HashMap();
        Map m1 = (Map)this.sidToNamespaceURIToLocation.get(null);
        if (m1 != null) {
            ret.putAll(m1);
        }
        String encodingDefaultSerializationID = this.getEncodingDefaultSerializationId(encodingURI);
        m1 = (Map)this.sidToNamespaceURIToLocation.get(encodingDefaultSerializationID = this.COW.resolveID(encodingDefaultSerializationID, false));
        if (m1 != null) {
            ret.putAll(m1);
        }
        if ((m1 = (Map)this.sidToNamespaceURIToLocation.get(serializationID)) != null) {
            ret.putAll(m1);
        }
        return ret;
    }

    public String getAttachmentMimeType(Class clazz, String sid, String encodingURI) {
        String mimeType = this.searchForMimeType((Map)this.sidToClassNameToMimeType.get(sid = this.COW.resolveID(sid, false)), clazz);
        if (mimeType != null) {
            return mimeType;
        }
        return this.searchForMimeType((Map)this.sidToClassNameToMimeType.get(this.getEncodingDefaultSerializationId(encodingURI)), clazz);
    }

    public String searchForMimeType(Map classToMime, Class clazz) {
        if (classToMime == null) {
            return null;
        }
        String mimeType = null;
        Stack stack = new Stack();
        stack.push(clazz);
        while (!stack.isEmpty()) {
            Class<?>[] ifaces;
            Class actualClass = (Class)stack.pop();
            mimeType = (String)classToMime.get(actualClass.getName());
            if (mimeType != null) {
                return mimeType;
            }
            if (actualClass.getSuperclass() != null) {
                stack.push(actualClass.getSuperclass());
            }
            if ((ifaces = actualClass.getInterfaces()) == null) continue;
            int i = 0;
            while (i < ifaces.length) {
                stack.push(ifaces[i]);
                ++i;
            }
        }
        return null;
    }

    public String getAttachmentMimeType(String className, String sid, String encodingURI) {
        sid = this.COW.resolveID(sid, false);
        String mimeType = null;
        Map classNameToMimeType = (Map)this.sidToClassNameToMimeType.get(sid);
        if (classNameToMimeType != null && (mimeType = (String)classNameToMimeType.get(className)) != null) {
            return mimeType;
        }
        classNameToMimeType = (Map)this.sidToClassNameToMimeType.get(this.getEncodingDefaultSerializationId(encodingURI));
        if (classNameToMimeType != null && (mimeType = (String)classNameToMimeType.get(className)) != null) {
            return mimeType;
        }
        try {
            Class<?> javaClass = PrimitiveTypeAccessor.convertPrimitiveToJavaClass(className);
            if (javaClass == null) {
                javaClass = Class.forName(className);
            }
            return this.getAttachmentMimeType(javaClass, sid, encodingURI);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public String getAttachmentClassName(String mimeType, String sid, String encodingURI) {
        String className;
        Map mimeTypeToClassName = (Map)this.sidToMimeTypeToClassName.get(sid = this.COW.resolveID(sid, false));
        if (mimeTypeToClassName != null && (className = (String)mimeTypeToClassName.get(mimeType)) != null) {
            return className;
        }
        mimeTypeToClassName = (Map)this.sidToMimeTypeToClassName.get(this.encodingToDefaultSerializationMap.get(encodingURI));
        if (mimeTypeToClassName != null) {
            return (String)mimeTypeToClassName.get(mimeType);
        }
        return null;
    }

    public String cloneSerializationID(String serID) {
        return this.COW.cloneID(serID);
    }

    public String cloneFaultSerializationID(String fserID) {
        return this.FCOW.cloneID(fserID);
    }

    public String getEncodingDefaultSerializationId(String encodingURI) {
        if (encodingURI == null) {
            return this.defaultXmlSerialization;
        }
        if (encodingURI == "http://schemas.xmlsoap.org/soap/encoding/") {
            return this.defaultSoapEncSerialization;
        }
        return (String)this.encodingToDefaultSerializationMap.get(encodingURI);
    }

    public boolean hasCustomFaultSerializers(String fsId, Throwable e) {
        FaultInstance faultInstance = this.getFaultSerializerInstance(fsId, e);
        if (faultInstance == null || faultInstance.serializer == null) {
            return false;
        }
        String instanceName = (String)this.faultInstanceToNameMap.get(faultInstance);
        String[] faultSerializers = this.getFaultSerializers(null);
        if (faultSerializers == null) {
            return true;
        }
        int i = 0;
        while (i < faultSerializers.length) {
            String id = faultSerializers[i];
            if (id.equals(instanceName)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean hasCustomFaultDeserializers(String fsID, SOAPFault fault) {
        FaultInstance faultInstance = this.getFaultDeserializerInstance(fsID, fault);
        if (faultInstance == null || faultInstance.deserializer == null) {
            return false;
        }
        String instanceName = (String)this.faultInstanceToNameMap.get(faultInstance);
        String[] faultDeserializers = this.getFaultDeserializers(null);
        if (faultDeserializers == null) {
            return true;
        }
        int i = 0;
        while (i < faultDeserializers.length) {
            String id = faultDeserializers[i];
            if (id.equals(instanceName)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class SerializationCache {
        private SerializationInstance[] instances;
        private Map typeToClassToDeserializers = new HashMap(19, 0.75f);
        private Map typeToClassToSerializers = new HashMap(19, 0.75f);

        SerializationCache(SerializationInstance[] instances) {
            this.instances = instances;
        }

        SerializationInstance[] getSerializations() {
            return this.instances;
        }

        void setSerializations(SerializationInstance[] instances) {
            this.typeToClassToSerializers.clear();
            this.typeToClassToDeserializers.clear();
            this.instances = instances;
        }

        Map typeToClassToSerializers() {
            return this.typeToClassToSerializers;
        }

        Map typeToClassToDeserializers() {
            return this.typeToClassToDeserializers;
        }
    }

    private class FaultSerializationCOWCopyHander
    implements CopyOnWriteHelper.CopyingHandler {
        Object syncLock;

        FaultSerializationCOWCopyHander(Object syncLock) {
            this.syncLock = syncLock;
        }

        public void doCopy(String origID, String id) {
            Object object = this.syncLock;
            synchronized (object) {
                if (origID == null) {
                    SerializationRepositoryImpl.this.createFaultSerialization(id);
                    return;
                }
                FaultInstance[] faultInsts = (FaultInstance[])SerializationRepositoryImpl.this.faultMap.get(origID);
                if (faultInsts != null) {
                    SerializationRepositoryImpl.this.faultMap.put(id, faultInsts.clone());
                } else {
                    cat.warn("doCopy called with nonexistent fault serialization ID: '" + origID + "'");
                }
            }
        }
    }

    private class SerializationCOWCopyHander
    implements CopyOnWriteHelper.CopyingHandler {
        Object syncLock;

        SerializationCOWCopyHander(Object syncLock) {
            this.syncLock = syncLock;
        }

        public void doCopy(String origID, String id) {
            Object object = this.syncLock;
            synchronized (object) {
                if (origID == null) {
                    SerializationRepositoryImpl.this.createSerialization(id);
                    return;
                }
                SerializationCache cache = (SerializationCache)SerializationRepositoryImpl.this.serializationMap.get(origID);
                if (cache == null) {
                    throw new IllegalArgumentException("No such serialization");
                }
                SerializationCache serializationCache = cache;
                synchronized (serializationCache) {
                    SerializationInstance[] insts = cache.getSerializations();
                    SerializationRepositoryImpl.this.serializationMap.put(id, new SerializationCache((SerializationInstance[])insts.clone()));
                    HashMap ns2location = (HashMap)SerializationRepositoryImpl.this.sidToNamespaceURIToLocation.get(origID);
                    if (ns2location != null) {
                        SerializationRepositoryImpl.this.sidToNamespaceURIToLocation.put(id, ns2location.clone());
                    }
                    Iterator it = SerializationRepositoryImpl.this.progLangToSIDToProgLangToTypeMapping.entrySet().iterator();
                    while (it.hasNext()) {
                        Map.Entry entry = it.next();
                        Map sidToProgLangToTypeMapping = (Map)entry.getValue();
                        HashMap pl2type = (HashMap)sidToProgLangToTypeMapping.get(origID);
                        if (pl2type == null) continue;
                        sidToProgLangToTypeMapping.put(id, pl2type.clone());
                    }
                    Iterator it2 = SerializationRepositoryImpl.this.progLangToSIDToTypeToProgLangMapping.entrySet().iterator();
                    while (it2.hasNext()) {
                        Map.Entry entry = it2.next();
                        Map sidToTypeToProgLangMapping = (Map)entry.getValue();
                        HashMap type2pl = (HashMap)sidToTypeToProgLangMapping.get(origID);
                        if (type2pl == null) continue;
                        sidToTypeToProgLangMapping.put(id, type2pl.clone());
                    }
                }
            }
        }
    }

    private static class SerializationInstance {
        Serializer serializer;
        Deserializer deserializer;
        ClassSpace serClassSpace;
        String serClassName;
        Configurable serCfg;
        ClassSpace deserClassSpace;
        String deserClassName;
        Configurable deserCfg;
        QName[] typeQNames;
        Class[] serializedClasses;
        static /* synthetic */ Class class$javax$xml$rpc$encoding$Serializer;
        static /* synthetic */ Class class$javax$xml$rpc$encoding$Deserializer;

        private SerializationInstance() {
        }

        public String toString() {
            return "type : " + this.arrayToString(this.typeQNames) + " serialized class " + this.arrayToString(this.serializedClasses);
        }

        public String arrayToString(Object[] array) {
            StringBuffer b = new StringBuffer("[");
            int i = 0;
            while (i < array.length) {
                if (i > 0) {
                    b.append(", ");
                }
                b.append(array[i]);
                ++i;
            }
            b.append("]");
            return b.toString();
        }

        public Serializer getSerializer() {
            if (this.serializer != null) {
                return this.serializer;
            }
            try {
                Class serClass = this.serClassSpace.getClass(class$javax$xml$rpc$encoding$Serializer == null ? (class$javax$xml$rpc$encoding$Serializer = SerializationInstance.class$("javax.xml.rpc.encoding.Serializer")) : class$javax$xml$rpc$encoding$Serializer, this.serClassName);
                this.serializer = (Serializer)serClass.newInstance();
                if (this.serializer instanceof org.idoox.wasp.serialization.Serializer) {
                    ((org.idoox.wasp.serialization.Serializer)this.serializer).init(this.serCfg);
                } else if (this.serializer instanceof XMLSerializer) {
                    ((XMLSerializer)this.serializer).init(this.serCfg);
                }
                return this.serializer;
            }
            catch (Exception e) {
                throw new RuntimeWrappedException(e);
            }
        }

        public Deserializer getDeserializer() {
            if (this.deserializer != null) {
                return this.deserializer;
            }
            try {
                Class deserClass = this.deserClassSpace.getClass(class$javax$xml$rpc$encoding$Deserializer == null ? (class$javax$xml$rpc$encoding$Deserializer = SerializationInstance.class$("javax.xml.rpc.encoding.Deserializer")) : class$javax$xml$rpc$encoding$Deserializer, this.deserClassName);
                this.deserializer = (Deserializer)deserClass.newInstance();
                if (this.deserializer instanceof org.idoox.wasp.serialization.Deserializer) {
                    ((org.idoox.wasp.serialization.Deserializer)this.deserializer).init(this.deserCfg);
                } else if (this.deserializer instanceof XMLDeserializer) {
                    ((XMLDeserializer)this.deserializer).init(this.deserCfg);
                }
                return this.deserializer;
            }
            catch (Exception e) {
                throw new RuntimeWrappedException(e);
            }
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    private static class FaultConfig {
        QName faultCode;
        String faultActor;
        QName firstDetailElement;

        FaultConfig(FaultSerializationConfig.FaultConfig cfg) {
            this.faultCode = cfg.getFaultCode();
            this.faultActor = cfg.getFaultActor();
            this.firstDetailElement = cfg.getFirstDetailElement();
        }

        FaultConfig(QName fc, String fa, QName fde) {
            this.faultCode = fc;
            this.faultActor = fa;
            this.firstDetailElement = fde;
        }
    }

    private static class FaultInstance {
        FaultSerializer serializer;
        FaultDeserializer deserializer;
        Class[] throwables;
        FaultConfig[] faults;

        private FaultInstance() {
        }
    }

    static class WSDLSerializationContextFactory
    implements Pool.Factory {
        WSDLSerializationContextFactory() {
        }

        public Object getNewInstance() {
            return new WSDLSerializationContext();
        }
    }

    static class WSDLDeserializationContextFactory
    implements Pool.Factory {
        WSDLDeserializationContextFactory() {
        }

        public Object getNewInstance() {
            return new WSDLDeserializationContext();
        }
    }
}

