/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.serialization;

import com.idoox.debug.Category;
import com.idoox.debug.IndentCategory;
import com.idoox.wasp.serialization.DeserializationChainImpl;
import com.systinet.wasp.rpc.XMLExceptionDeserializer;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.idoox.wasp.serialization.DeserializationChain;
import org.idoox.wasp.serialization.DeserializationContext;
import org.idoox.wasp.serialization.Deserializer;
import org.idoox.wasp.serialization.SchemaContext;
import org.idoox.wasp.serialization.SerializationChain;
import org.idoox.wasp.serialization.SerializationContext;
import org.idoox.wasp.serialization.Serializer;
import org.idoox.wasp.serialization.XMLDeserializer;
import org.idoox.wasp.serialization.XMLSerializer;
import org.idoox.xml.Token;
import org.idoox.xml.TokenWriter;
import org.idoox.xml.Tokenizer;
import org.idoox.xml.TokenizerException;
import org.idoox.xml.schema.Member;
import org.idoox.xml.schema.SchemaConstruct;
import org.idoox.xml.schema.Type;
import org.idoox.xmlrpc.MessageCreatingException;
import org.idoox.xmlrpc.MessageProcessingException;
import org.idoox.xmlrpc.encoding.EncodingTokenWriter;
import org.idoox.xmlrpc.encoding.EncodingTokenizer;
import org.systinet.wasp.webservice.Current;
import org.systinet.xml.schema.validation.ValidationConfig;
import org.systinet.xml.schema.validation.ValidationException;

public class SerializationHelper {
    public static IndentCategory dcat = new IndentCategory(Category.getCategory("wasp.serialization"));
    static Map classToSchemaMapping = new HashMap();
    private static final XMLExceptionDeserializer xmlExceptionDeserializer = new XMLExceptionDeserializer();
    static /* synthetic */ Class class$java$lang$Object;

    private SerializationHelper() {
    }

    public static Object deserialize(EncodingTokenizer dataTokenizer, Class targetClass, DeserializationContext ctx, Object context) throws MessageProcessingException {
        return SerializationHelper.deserialize(dataTokenizer, targetClass, ctx, context, false);
    }

    public static Object deserialize(EncodingTokenizer dataTokenizer, Class targetClass, DeserializationContext ctx, Object context, boolean arrayItem) throws MessageProcessingException {
        ctx.pushDeserializedObject(context);
        Object ret = SerializationHelper.deserialize(dataTokenizer, targetClass, ctx, arrayItem);
        ctx.popDeserializedObject();
        return ret;
    }

    public static Object deserialize(Tokenizer dataTokenizer, Token currentToken, Class targetClass, DeserializationContext ctx, Object context) throws MessageProcessingException {
        ctx.pushDeserializedObject(context);
        Object ret = SerializationHelper.deserialize(dataTokenizer, currentToken, targetClass, ctx);
        ctx.popDeserializedObject();
        return ret;
    }

    public static Object deserialize(Tokenizer dataTokenizer, Token currentToken, Class targetClass, DeserializationContext ctx) throws MessageProcessingException {
        if (dcat.isDebugEnabled()) {
            dcat.enter("deserializing to " + targetClass);
        }
        try {
            try {
                dataTokenizer.readToken(currentToken);
                if (ctx.nextSchemaConstruct(dataTokenizer.getNamespace(), dataTokenizer.getLocalName()) == null) {
                    throw new MessageProcessingException("Unexpected element {" + dataTokenizer.getNamespace() + "}" + dataTokenizer.getLocalName());
                }
                DeserializationChain chain = ctx.getDeserializationChain(targetClass);
                XMLDeserializer deserializer = (XMLDeserializer)chain.getNextDeserializerAs("systinet:xmlser/1.0");
                Object ret = deserializer.deserialize(dataTokenizer, currentToken, targetClass, ctx, chain);
                ctx.releaseDeserializationChain(chain);
                Object object = ret;
                Object var9_10 = null;
                if (dcat.isDebugEnabled()) {
                    dcat.leave();
                }
                return object;
            }
            catch (MessageProcessingException e) {
                throw e;
            }
            catch (Exception e) {
                throw new MessageProcessingException("Exception during deserialization : ", e);
            }
        }
        catch (Throwable throwable) {
            block8: {
                Object var9_11 = null;
                if (!dcat.isDebugEnabled()) break block8;
                dcat.leave();
            }
            throw throwable;
        }
    }

    public static Object deserializeCurrent(Tokenizer dataTokenizer, Token currentToken, Class targetClass, DeserializationContext ctx) throws MessageProcessingException {
        if (dcat.isDebugEnabled()) {
            dcat.enter("deserializing to " + targetClass);
        }
        try {
            try {
                dataTokenizer.readToken(currentToken);
                DeserializationChain chain = ctx.getDeserializationChain(targetClass);
                XMLDeserializer deserializer = (XMLDeserializer)chain.getNextDeserializerAs("systinet:xmlser/1.0");
                Object ret = deserializer.deserialize(dataTokenizer, currentToken, targetClass, ctx, chain);
                ctx.releaseDeserializationChain(chain);
                Object object = ret;
                Object var9_10 = null;
                if (dcat.isDebugEnabled()) {
                    dcat.leave();
                }
                return object;
            }
            catch (MessageProcessingException e) {
                throw e;
            }
            catch (Exception e) {
                throw new MessageProcessingException("Exception during deserialization : ", e);
            }
        }
        catch (Throwable throwable) {
            block7: {
                Object var9_11 = null;
                if (!dcat.isDebugEnabled()) break block7;
                dcat.leave();
            }
            throw throwable;
        }
    }

    public static Object deserialize(EncodingTokenizer dataTokenizer, Class targetClass, DeserializationContext ctx) throws MessageProcessingException {
        return SerializationHelper.deserialize(dataTokenizer, targetClass, ctx, false);
    }

    public static Object deserialize(EncodingTokenizer dataTokenizer, Class targetClass, DeserializationContext ctx, boolean arrayItem) throws MessageProcessingException {
        if (dcat.isDebugEnabled()) {
            dcat.enter("deserializing to " + targetClass);
        }
        try {
            try {
                if (arrayItem) {
                    if (ctx.nextSchemaConstruct(null, "item") == null) {
                        throw new MessageProcessingException("Schema validation error : unexpected soap message element {}item in " + ctx.toString());
                    }
                } else if (ctx.nextSchemaConstruct(dataTokenizer.getTokenNamespaceURI(), dataTokenizer.getTokenName()) == null) {
                    throw new MessageProcessingException("Schema validation error : unexpected soap message element {" + dataTokenizer.getTokenNamespaceURI() + "}" + dataTokenizer.getTokenName() + " in " + ctx.toString());
                }
                DeserializationChain chain = ctx.getDeserializationChain(targetClass);
                Deserializer deserializer = (Deserializer)chain.getNextDeserializerAs(Deserializer.MECHANISM_TYPE);
                Object ret = deserializer.deserialize(dataTokenizer, targetClass, ctx, chain);
                ctx.releaseDeserializationChain(chain);
                Object object = ret;
                Object var9_10 = null;
                if (dcat.isDebugEnabled()) {
                    dcat.leave();
                }
                return object;
            }
            catch (MessageProcessingException e) {
                throw e;
            }
            catch (Exception e) {
                throw new MessageProcessingException("Exception during deserialization : ", e);
            }
        }
        catch (Throwable throwable) {
            block11: {
                Object var9_11 = null;
                if (!dcat.isDebugEnabled()) break block11;
                dcat.leave();
            }
            throw throwable;
        }
    }

    public static Object deserializeElement(EncodingTokenizer dataTokenizer, Class targetClass, DeserializationContext ctx, boolean arrayItem) throws MessageProcessingException {
        if (dcat.isDebugEnabled()) {
            dcat.enter("deserializing to " + targetClass);
        }
        try {
            try {
                DeserializationChain chain = ctx.getDeserializationChain(targetClass);
                Deserializer deserializer = (Deserializer)chain.getNextDeserializerAs(Deserializer.MECHANISM_TYPE);
                Object ret = deserializer.deserialize(dataTokenizer, targetClass, ctx, chain);
                ctx.releaseDeserializationChain(chain);
                Object object = ret;
                Object var9_10 = null;
                if (dcat.isDebugEnabled()) {
                    dcat.leave();
                }
                return object;
            }
            catch (MessageProcessingException e) {
                throw e;
            }
            catch (Exception e) {
                throw new MessageProcessingException("Exception during deserialization : ", e);
            }
        }
        catch (Throwable throwable) {
            block7: {
                Object var9_11 = null;
                if (!dcat.isDebugEnabled()) break block7;
                dcat.leave();
            }
            throw throwable;
        }
    }

    public static Object deserializeElement(Tokenizer dataTokenizer, Token currentToken, Class targetClass, DeserializationContext ctx) throws MessageProcessingException {
        if (dcat.isDebugEnabled()) {
            dcat.enter("deserializing to " + targetClass);
        }
        try {
            try {
                DeserializationChain chain = ctx.getDeserializationChain(targetClass);
                XMLDeserializer deserializer = (XMLDeserializer)chain.getNextDeserializerAs("systinet:xmlser/1.0");
                Object ret = deserializer.deserialize(dataTokenizer, currentToken, targetClass, ctx, chain);
                ctx.releaseDeserializationChain(chain);
                Object object = ret;
                Object var9_10 = null;
                if (dcat.isDebugEnabled()) {
                    dcat.leave();
                }
                return object;
            }
            catch (MessageProcessingException e) {
                throw e;
            }
            catch (Exception e) {
                throw new MessageProcessingException("Exception during deserialization : ", e);
            }
        }
        catch (Throwable throwable) {
            block7: {
                Object var9_11 = null;
                if (!dcat.isDebugEnabled()) break block7;
                dcat.leave();
            }
            throw throwable;
        }
    }

    public static Exception deserializeFaultElement(Tokenizer dataTokenizer, Token currentToken, Class targetClass, DeserializationContext ctx) throws MessageProcessingException {
        if (dcat.isDebugEnabled()) {
            dcat.enter("deserializing to " + targetClass);
        }
        try {
            try {
                DeserializationChain chain = ctx.getDeserializationChain(targetClass);
                chain = SerializationHelper.getFaulChain(chain);
                XMLDeserializer deserializer = (XMLDeserializer)chain.getNextDeserializerAs("systinet:xmlser/1.0");
                Exception ret = (Exception)deserializer.deserialize(dataTokenizer, currentToken, targetClass, ctx, chain);
                ctx.releaseDeserializationChain(chain);
                Exception exception = ret;
                Object var9_10 = null;
                if (dcat.isDebugEnabled()) {
                    dcat.leave();
                }
                return exception;
            }
            catch (MessageProcessingException e) {
                throw e;
            }
            catch (Exception e) {
                throw new MessageProcessingException("Exception during deserialization : ", e);
            }
        }
        catch (Throwable throwable) {
            block7: {
                Object var9_11 = null;
                if (!dcat.isDebugEnabled()) break block7;
                dcat.leave();
            }
            throw throwable;
        }
    }

    private static DeserializationChain getFaulChain(DeserializationChain chain) {
        ((DeserializationChainImpl)chain).replaceLast(xmlExceptionDeserializer);
        return chain;
    }

    public static void serialize(TokenWriter dataTokenWriter, Object data, SerializationContext context) throws MessageCreatingException {
        if (dcat.isDebugEnabled()) {
            dcat.enter("serializing " + (data != null ? data.getClass().getName() + '#' + System.identityHashCode(data) : null));
        }
        try {
            try {
                Class clazz = data == null ? (class$java$lang$Object == null ? (class$java$lang$Object = SerializationHelper.class$("java.lang.Object")) : class$java$lang$Object) : data.getClass();
                SerializationChain chain = context.getSerializationChain(clazz);
                XMLSerializer s = (XMLSerializer)chain.getNextSerializerAs("systinet:xmlser/1.0");
                s.serialize(dataTokenWriter, data, context, chain);
                context.releaseSerializationChain(chain);
                context.nextSchemaConstruct();
            }
            catch (MessageCreatingException e) {
                throw e;
            }
            catch (Exception e) {
                throw new MessageCreatingException(e);
            }
            Object var6_7 = null;
            if (dcat.isDebugEnabled()) {
                dcat.leave();
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            if (dcat.isDebugEnabled()) {
                dcat.leave();
            }
            throw throwable;
        }
    }

    public static Member serialize(EncodingTokenWriter dataTokenWriter, Object data, int[] arrayPos, SerializationContext context) throws MessageCreatingException {
        if (dcat.isDebugEnabled()) {
            dcat.enter("serializing " + (data != null ? data.getClass().getName() + '#' + System.identityHashCode(data) : null));
        }
        try {
            try {
                Class clazz = data == null ? (class$java$lang$Object == null ? (class$java$lang$Object = SerializationHelper.class$("java.lang.Object")) : class$java$lang$Object) : data.getClass();
                SerializationChain chain = context.getSerializationChain(clazz);
                Serializer s = (Serializer)chain.getNextSerializerAs(Serializer.MECHANISM_TYPE);
                s.serialize(dataTokenWriter, data, arrayPos, context, chain);
                context.releaseSerializationChain(chain);
                Member member = (Member)context.nextSchemaConstruct();
                Object var8_9 = null;
                if (dcat.isDebugEnabled()) {
                    dcat.leave();
                }
                return member;
            }
            catch (MessageCreatingException e) {
                throw e;
            }
            catch (Exception e) {
                throw new MessageCreatingException(e);
            }
        }
        catch (Throwable throwable) {
            block7: {
                Object var8_10 = null;
                if (!dcat.isDebugEnabled()) break block7;
                dcat.leave();
            }
            throw throwable;
        }
    }

    public static void grabReferences(Object value, SerializationContext context) throws MessageCreatingException {
        if (dcat.isDebugEnabled()) {
            dcat.enter("getting reference count for " + (value != null ? value.getClass().getName() + '#' + System.identityHashCode(value) : null));
        }
        try {
            try {
                if (value != null) {
                    SerializationChain chain = context.getSerializationChain(value.getClass());
                    XMLSerializer s = (XMLSerializer)chain.getNextSerializerAs("systinet:xmlser/1.0");
                    s.grabReferences(value, context, chain);
                    context.releaseSerializationChain(chain);
                }
                context.nextSchemaConstruct();
            }
            catch (MessageCreatingException e) {
                throw e;
            }
            catch (Exception e) {
                throw new MessageCreatingException(e);
            }
            Object var5_6 = null;
            if (dcat.isDebugEnabled()) {
                dcat.leave();
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            if (dcat.isDebugEnabled()) {
                dcat.leave();
            }
            throw throwable;
        }
    }

    public static void writeReference(TokenWriter dataTokenWriter, QName name, String ref) throws IOException {
        dataTokenWriter.enter(name.getNamespaceURI(), name.getLocalPart());
        dataTokenWriter.writeAttribute(null, "href", ref);
        dataTokenWriter.leave();
    }

    public static void writeDimeReference(TokenWriter dataTokenWriter, QName name, String ref) throws IOException {
        dataTokenWriter.enter(name.getNamespaceURI(), name.getLocalPart());
        dataTokenWriter.writeAttribute("http://schemas.xmlsoap.org/ws/2002/04/reference/", "location", ref);
        dataTokenWriter.leave();
    }

    public static void writeXsiType(TokenWriter tokenWriter, QName type) throws IOException {
        String xsiType = type.getNamespaceURI() == null ? type.getLocalPart() : tokenWriter.getPrefixForNamespace(type.getNamespaceURI()) + ":" + type.getLocalPart();
        tokenWriter.writeAttribute("http://www.w3.org/2001/XMLSchema-instance", "type", xsiType);
    }

    public static void writeNil(TokenWriter dataTokenWriter, QName name) throws IOException {
        dataTokenWriter.enter(name.getNamespaceURI(), name.getLocalPart());
        dataTokenWriter.writeAttribute("http://www.w3.org/2001/XMLSchema-instance", "nil", "true");
        dataTokenWriter.leave();
    }

    public static void writeID(TokenWriter dataTokenWriter, String id) throws IOException {
        if (id != null) {
            dataTokenWriter.writeAttribute(null, "id", id);
        }
    }

    public static String getId(Token token) {
        return token.getAttributeValue(null, "id");
    }

    public static String getReference(Token token) {
        return token.getAttributeValue(null, "href");
    }

    public static String getDimeReference(Token token) {
        return token.getAttributeValue("http://schemas.xmlsoap.org/ws/2002/04/reference/", "location");
    }

    public static QName getXsiType(Tokenizer tokenizer, Token token) {
        String typeString = token.getAttributeValue("http://www.w3.org/2001/XMLSchema-instance", "type");
        if (typeString == null) {
            return null;
        }
        return tokenizer.parseQName(typeString);
    }

    public static void assertCanBeNil(SchemaConstruct currentSchemaConstruct, Token token) {
        Member currentMember;
        if (currentSchemaConstruct == null) {
            return;
        }
        if (currentSchemaConstruct.getConstructType() == SchemaConstruct.ConstructType.MEMBER && !(currentMember = (Member)currentSchemaConstruct).isNillable() && SerializationHelper.shouldValidateNillableIn()) {
            String tokenName = token != null ? "\"{" + token.getNamespace() + "}" + token.getLocalName() + "\"" : "";
            throw new ValidationException("Message contains element " + tokenName + " with attribute xsi:nil='true' but definition of element " + currentMember.getName() + " prohibites it!");
        }
    }

    private static boolean shouldValidateNillableIn() {
        ValidationConfig conf = (ValidationConfig)Current.getCallContext().getContextData().get("validation.config.key");
        return conf != null && (conf.getDirection() & 1) > 0 && (conf.getValidationType() & 2) > 0;
    }

    public static boolean isNil(Token token) {
        String nil2001 = token.getAttributeValue("http://www.w3.org/2001/XMLSchema-instance", "nil");
        String null2001 = token.getAttributeValue("http://www.w3.org/2001/XMLSchema-instance", "null");
        String null2000 = token.getAttributeValue("http://www.w3.org/2000/10/XMLSchema-instance", "null");
        String null1999 = token.getAttributeValue("http://www.w3.org/1999/XMLSchema-instance", "null");
        return nil2001 != null && ("1".equals(nil2001) || "true".equals(nil2001)) || null2001 != null && ("1".equals(null2001) || "true".equals(null2001)) || null2000 != null && ("1".equals(null2000) || "true".equals(null2000)) || null1999 != null && ("1".equals(null1999) || "true".equals(null1999));
    }

    public static byte nextNonWhitespace(Tokenizer tokenizer) throws MessageProcessingException, IOException, TokenizerException {
        byte state;
        while ((state = tokenizer.next()) == 4) {
            if (tokenizer.whitespaceContent()) continue;
            throw new MessageProcessingException("Unexpected non-whitespace chars " + SerializationHelper.formatHex(tokenizer.readContent()));
        }
        return state;
    }

    private static String formatHex(String source) {
        StringBuffer o = new StringBuffer();
        int i = 0;
        while (i < source.length()) {
            int c = source.charAt(i) & 0xFFFF;
            o.append(Integer.toHexString(c));
            o.append('(');
            o.append(source.charAt(i));
            o.append(") ");
            ++i;
        }
        return o.toString();
    }

    public static String readTextContent(Tokenizer tokenizer) throws IOException, TokenizerException {
        String ret = null;
        while (tokenizer.next() == 4) {
            ret = ret == null ? tokenizer.readContent() : ret + tokenizer.readContent();
        }
        return ret;
    }

    public static boolean isAnyComplexType(SchemaContext context) {
        try {
            SchemaConstruct construct;
            SchemaConstruct[] constructs;
            Type currentType = context.getCurrentConstructSchemaType();
            if ((currentType.getKind() | 0x20) != 0 && (constructs = currentType.getSubconstructs()) != null && constructs.length == 1 && (construct = constructs[0]).getConstructType() == SchemaConstruct.ConstructType.TYPE && ((Type)construct).getKind() == 39) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

