/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.serialization;

import com.idoox.soap.MustUnderstandException;
import com.idoox.soap.VersionMismatchException;
import com.idoox.wasp.serialization.DefaultFaultSerializer;
import javax.xml.namespace.QName;
import org.idoox.wasp.serialization.FaultSerializer;
import org.idoox.xmlrpc.Constants;
import org.idoox.xmlrpc.Fault;

public class SOAPSpecFaultsSerializer
implements FaultSerializer {
    public void serializeFault(Fault fault, Throwable throwable) {
        String faultString;
        QName faultCode;
        if (throwable instanceof MustUnderstandException) {
            faultCode = Constants.MUST_UNDERSTAND_FAULT_CODE;
            StringBuffer tmp = new StringBuffer("do not understand headers: ");
            QName[] headers = ((MustUnderstandException)throwable).getCauseHeaders();
            int i = 0;
            while (headers != null && i < headers.length) {
                tmp.append(headers[i].toString());
                if (i < headers.length - 1) {
                    tmp.append(", ");
                }
                ++i;
            }
            faultString = tmp.toString();
        } else if (throwable instanceof VersionMismatchException) {
            faultCode = Constants.VERSION_MISMATCH_FAULT_CODE;
            faultString = "received something that is not a SOAP Envelope";
        } else {
            new DefaultFaultSerializer().serializeFault(fault, throwable);
            return;
        }
        fault.setFaultCode(faultCode);
        fault.setFaultString(faultString);
    }
}

