/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.serialization;

import com.idoox.wasp.serialization.DeserializationException;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.HashSet;
import javax.xml.namespace.QName;
import org.idoox.util.Base64;
import org.idoox.util.RuntimeWrappedException;
import org.idoox.wasp.serialization.xsdbuiltin.DateTime;
import org.idoox.wasp.serialization.xsdbuiltin.Duration;
import org.idoox.wasp.serialization.xsdbuiltin.GDay;
import org.idoox.wasp.serialization.xsdbuiltin.GMonth;
import org.idoox.wasp.serialization.xsdbuiltin.GMonthDay;
import org.idoox.wasp.serialization.xsdbuiltin.GYear;
import org.idoox.wasp.serialization.xsdbuiltin.GYearMonth;
import org.idoox.wasp.serialization.xsdbuiltin.HexBinary;
import org.idoox.wasp.serialization.xsdbuiltin.NormalizedString;
import org.idoox.wasp.serialization.xsdbuiltin.Time;
import org.idoox.wasp.serialization.xsdbuiltin.Token;
import org.idoox.xmlrpc.MessageProcessingException;
import org.idoox.xmlrpc.encoding.EncodingTokenizer;

public class PrimitiveTypeAccessor {
    static HashMap xsdSimpleTypeMap = new HashMap(113, 0.75f);
    static HashMap xsdSimpleTypePrimMap = new HashMap(113, 0.75f);
    static HashSet javaSimpleTypeSet = new HashSet(17, 0.75f);
    static HashSet javaLiteralTypeSet = new HashSet(17, 0.75f);
    static HashMap javaPrimitiveTypeMap = new HashMap(17, 0.75f);
    static QName STRING_EXPANDED_NAME = new QName("http://www.w3.org/2001/XMLSchema", "string");
    static QName BOOLEAN_EXPANDED_NAME = new QName("http://www.w3.org/2001/XMLSchema", "boolean");
    static QName CHARACTER_EXPANDED_NAME = new QName("http://www.w3.org/2001/XMLSchema", "string");
    static QName BYTE_EXPANDED_NAME = new QName("http://www.w3.org/2001/XMLSchema", "byte");
    static QName SHORT_EXPANDED_NAME = new QName("http://www.w3.org/2001/XMLSchema", "short");
    static QName LONG_EXPANDED_NAME = new QName("http://www.w3.org/2001/XMLSchema", "unsignedInt");
    static QName INTEGER_EXPANDED_NAME = new QName("http://www.w3.org/2001/XMLSchema", "int");
    static QName FLOAT_EXPANDED_NAME = new QName("http://www.w3.org/2001/XMLSchema", "float");
    static QName DOUBLE_EXPANDED_NAME = new QName("http://www.w3.org/2001/XMLSchema", "double");
    static QName BIGINTEGER_EXPANDED_NAME = new QName("http://www.w3.org/2001/XMLSchema", "integer");
    static QName BIGDECIMAL_EXPANDED_NAME = new QName("http://www.w3.org/2001/XMLSchema", "decimal");
    static QName DATE_EXPANDED_NAME = new QName("http://www.w3.org/2001/XMLSchema", "date");
    static QName TIME_EXPANDED_NAME = new QName("http://www.w3.org/2001/XMLSchema", "time");
    static QName DATETIME_EXPANDED_NAME = new QName("http://www.w3.org/2001/XMLSchema", "dateTime");
    static QName DURATION_EXPANDED_NAME = new QName("http://www.w3.org/2001/XMLSchema", "duration");
    static QName GMONTH_EXPANDED_NAME = new QName("http://www.w3.org/2001/XMLSchema", "gMonth");
    static QName GYEAR_EXPANDED_NAME = new QName("http://www.w3.org/2001/XMLSchema", "gYear");
    static QName GYEARMONTH_EXPANDED_NAME = new QName("http://www.w3.org/2001/XMLSchema", "gYearMonth");
    static QName GDAY_EXPANDED_NAME = new QName("http://www.w3.org/2001/XMLSchema", "gDay");
    static QName GMONTHDAY_EXPANDED_NAME = new QName("http://www.w3.org/2001/XMLSchema", "gMonthDay");
    static QName HEXBINARY_EXPANDED_NAME = new QName("http://www.w3.org/2001/XMLSchema", "hexBinary");
    static QName NORMALIZEDSTRING_EXPANDED_NAME = new QName("http://www.w3.org/2001/XMLSchema", "normalizedString");
    static QName TOKEN_EXPANDED_NAME = new QName("http://www.w3.org/2001/XMLSchema", "token");
    static QName BASE64BINARY_EXPANDED_NAME = new QName("http://www.w3.org/2001/XMLSchema", "base64Binary");
    static QName QNAME_EXPANDED_NAME = new QName("http://www.w3.org/2001/XMLSchema", "QName");
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class class$javax$xml$namespace$QName;
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$org$idoox$wasp$serialization$xsdbuiltin$Date;
    static /* synthetic */ Class class$org$idoox$wasp$serialization$xsdbuiltin$Time;
    static /* synthetic */ Class class$org$idoox$wasp$serialization$xsdbuiltin$DateTime;
    static /* synthetic */ Class class$org$idoox$wasp$serialization$xsdbuiltin$Duration;
    static /* synthetic */ Class class$org$idoox$wasp$serialization$xsdbuiltin$GMonth;
    static /* synthetic */ Class class$org$idoox$wasp$serialization$xsdbuiltin$GYear;
    static /* synthetic */ Class class$org$idoox$wasp$serialization$xsdbuiltin$GYearMonth;
    static /* synthetic */ Class class$org$idoox$wasp$serialization$xsdbuiltin$GDay;
    static /* synthetic */ Class class$org$idoox$wasp$serialization$xsdbuiltin$GMonthDay;
    static /* synthetic */ Class class$org$idoox$wasp$serialization$xsdbuiltin$HexBinary;
    static /* synthetic */ Class class$org$idoox$wasp$serialization$xsdbuiltin$NormalizedString;
    static /* synthetic */ Class class$org$idoox$wasp$serialization$xsdbuiltin$Token;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$sql$Date;
    static /* synthetic */ Class class$java$sql$Time;
    static /* synthetic */ Class class$java$sql$Timestamp;

    public static boolean isJavaLiteralType(Class cls) {
        return javaLiteralTypeSet.contains(cls);
    }

    public static Class getPrimitiveClass(String typeNS, String type) {
        if (typeNS == null) {
            return null;
        }
        if ("http://www.w3.org/2001/XMLSchema".equals(typeNS) || "http://www.w3.org/2000/10/XMLSchema".equals(typeNS) || "http://www.w3.org/1999/XMLSchema".equals(typeNS) || "http://www.w3.org/1999/XMLSchema-instance".equals(typeNS) || "http://schemas.xmlsoap.org/soap/encoding/".equals(typeNS)) {
            return (Class)xsdSimpleTypeMap.get(type);
        }
        return null;
    }

    public static Class getPrimitiveArrayClass(String type, String typeNS) {
        if ("http://www.w3.org/2001/XMLSchema".equals(typeNS) || "http://www.w3.org/2000/10/XMLSchema".equals(typeNS) || "http://www.w3.org/1999/XMLSchema".equals(typeNS)) {
            Class aClass = (Class)xsdSimpleTypePrimMap.get(type);
            return aClass;
        }
        return null;
    }

    public static Object getPrimitiveObject(Class c, EncodingTokenizer tokenizer) throws MessageProcessingException, DeserializationException {
        String value = tokenizer.getPrimitiveTokenValue();
        if (c == (class$java$lang$Object == null ? (class$java$lang$Object = PrimitiveTypeAccessor.class$("java.lang.Object")) : class$java$lang$Object) && (c = PrimitiveTypeAccessor.getPrimitiveClass(tokenizer.getTokenTypeNamespaceURI(), tokenizer.getTokenTypeName())) == null) {
            if (tokenizer.getTokenTypeNamespaceURI() != null || tokenizer.getTokenTypeName() != null) {
                throw new DeserializationException("XML type was recognized as primitive but no mapping to any Java type was found : {" + tokenizer.getTokenTypeNamespaceURI() + "}" + tokenizer.getTokenTypeName());
            }
            throw new DeserializationException("XML type was recognized as primitive but no mapping to any Java type was found : [ no xsd:type defined ]");
        }
        if (c == (class$javax$xml$namespace$QName == null ? (class$javax$xml$namespace$QName = PrimitiveTypeAccessor.class$("javax.xml.namespace.QName")) : class$javax$xml$namespace$QName)) {
            return tokenizer.convertToQName(value);
        }
        return PrimitiveTypeAccessor.getPrimitiveObject(c, value);
    }

    public static Object getPrimitiveObject(Class c, String value) throws MessageProcessingException, DeserializationException {
        if (value == null) {
            return null;
        }
        if (c == (class$java$lang$String == null ? (class$java$lang$String = PrimitiveTypeAccessor.class$("java.lang.String")) : class$java$lang$String)) {
            return value;
        }
        if (c == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = PrimitiveTypeAccessor.class$("java.lang.Boolean")) : class$java$lang$Boolean) || c == Boolean.TYPE) {
            if ("true".equals(value) || "1".equals(value)) {
                return Boolean.TRUE;
            }
            if ("false".equals(value) || "0".equals(value)) {
                return Boolean.FALSE;
            }
            throw new DeserializationException("Unexpected boolean value : " + value);
        }
        if (c == (class$java$lang$Character == null ? (class$java$lang$Character = PrimitiveTypeAccessor.class$("java.lang.Character")) : class$java$lang$Character) || c == Character.TYPE) {
            return new Character(value.charAt(0));
        }
        if (c == (class$java$lang$Byte == null ? (class$java$lang$Byte = PrimitiveTypeAccessor.class$("java.lang.Byte")) : class$java$lang$Byte) || c == Byte.TYPE) {
            return Byte.valueOf(value);
        }
        if (c == (class$java$lang$Short == null ? (class$java$lang$Short = PrimitiveTypeAccessor.class$("java.lang.Short")) : class$java$lang$Short) || c == Short.TYPE) {
            return Short.valueOf(value);
        }
        if (c == (class$java$lang$Integer == null ? (class$java$lang$Integer = PrimitiveTypeAccessor.class$("java.lang.Integer")) : class$java$lang$Integer) || c == Integer.TYPE) {
            return Integer.valueOf(value);
        }
        if (c == (class$java$lang$Long == null ? (class$java$lang$Long = PrimitiveTypeAccessor.class$("java.lang.Long")) : class$java$lang$Long) || c == Long.TYPE) {
            return Long.valueOf(value);
        }
        if (c == (class$java$lang$Float == null ? (class$java$lang$Float = PrimitiveTypeAccessor.class$("java.lang.Float")) : class$java$lang$Float) || c == Float.TYPE) {
            if (value.equals("INF")) {
                return new Float(Float.POSITIVE_INFINITY);
            }
            if (value.equals("-INF")) {
                return new Float(Float.NEGATIVE_INFINITY);
            }
            if (value.equals("NaN")) {
                return new Float(Float.NaN);
            }
            try {
                return Float.valueOf(value);
            }
            catch (NumberFormatException e) {
                throw new DeserializationException("Unexpected float value : " + value, e);
            }
        }
        if (c == (class$java$lang$Double == null ? (class$java$lang$Double = PrimitiveTypeAccessor.class$("java.lang.Double")) : class$java$lang$Double) || c == Double.TYPE) {
            if (value.equals("INF")) {
                return new Double(Double.POSITIVE_INFINITY);
            }
            if (value.equals("-INF")) {
                return new Double(Double.NEGATIVE_INFINITY);
            }
            if (value.equals("NaN")) {
                return new Double(Double.NaN);
            }
            try {
                return Double.valueOf(value);
            }
            catch (NumberFormatException e) {
                throw new DeserializationException("Unexpected double value : " + value, e);
            }
        }
        if (c == (class$java$math$BigInteger == null ? (class$java$math$BigInteger = PrimitiveTypeAccessor.class$("java.math.BigInteger")) : class$java$math$BigInteger)) {
            return new BigInteger(value);
        }
        if (c == (class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = PrimitiveTypeAccessor.class$("java.math.BigDecimal")) : class$java$math$BigDecimal)) {
            return new BigDecimal(value);
        }
        if (c == (array$B == null ? (array$B = PrimitiveTypeAccessor.class$("[B")) : array$B)) {
            try {
                byte[] encoded = value.getBytes("US-ASCII");
                return Base64.decode(encoded);
            }
            catch (UnsupportedEncodingException e) {
                throw new DeserializationException(e);
            }
        }
        try {
            if (c == (class$java$util$Date == null ? (class$java$util$Date = PrimitiveTypeAccessor.class$("java.util.Date")) : class$java$util$Date)) {
                return new DateTime(value).toJavaUtilDate();
            }
            if (c == (class$java$sql$Date == null ? (class$java$sql$Date = PrimitiveTypeAccessor.class$("java.sql.Date")) : class$java$sql$Date)) {
                return new Date(new DateTime(value).toJavaUtilDate().getTime());
            }
            if (c == (class$java$sql$Time == null ? (class$java$sql$Time = PrimitiveTypeAccessor.class$("java.sql.Time")) : class$java$sql$Time)) {
                return new java.sql.Time(new DateTime(value).toJavaUtilDate().getTime());
            }
            if (c == (class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = PrimitiveTypeAccessor.class$("java.sql.Timestamp")) : class$java$sql$Timestamp)) {
                return new Timestamp(new DateTime(value).toJavaUtilDate().getTime());
            }
            if (c == (class$org$idoox$wasp$serialization$xsdbuiltin$Date == null ? (class$org$idoox$wasp$serialization$xsdbuiltin$Date = PrimitiveTypeAccessor.class$("org.idoox.wasp.serialization.xsdbuiltin.Date")) : class$org$idoox$wasp$serialization$xsdbuiltin$Date)) {
                return new org.idoox.wasp.serialization.xsdbuiltin.Date(value);
            }
            if (c == (class$org$idoox$wasp$serialization$xsdbuiltin$Time == null ? (class$org$idoox$wasp$serialization$xsdbuiltin$Time = PrimitiveTypeAccessor.class$("org.idoox.wasp.serialization.xsdbuiltin.Time")) : class$org$idoox$wasp$serialization$xsdbuiltin$Time)) {
                return new Time(value);
            }
            if (c == (class$org$idoox$wasp$serialization$xsdbuiltin$DateTime == null ? (class$org$idoox$wasp$serialization$xsdbuiltin$DateTime = PrimitiveTypeAccessor.class$("org.idoox.wasp.serialization.xsdbuiltin.DateTime")) : class$org$idoox$wasp$serialization$xsdbuiltin$DateTime)) {
                return new DateTime(value);
            }
            if (c == (class$org$idoox$wasp$serialization$xsdbuiltin$Duration == null ? (class$org$idoox$wasp$serialization$xsdbuiltin$Duration = PrimitiveTypeAccessor.class$("org.idoox.wasp.serialization.xsdbuiltin.Duration")) : class$org$idoox$wasp$serialization$xsdbuiltin$Duration)) {
                return new Duration(value);
            }
            if (c == (class$org$idoox$wasp$serialization$xsdbuiltin$GMonth == null ? (class$org$idoox$wasp$serialization$xsdbuiltin$GMonth = PrimitiveTypeAccessor.class$("org.idoox.wasp.serialization.xsdbuiltin.GMonth")) : class$org$idoox$wasp$serialization$xsdbuiltin$GMonth)) {
                return new GMonth(value);
            }
            if (c == (class$org$idoox$wasp$serialization$xsdbuiltin$GYear == null ? (class$org$idoox$wasp$serialization$xsdbuiltin$GYear = PrimitiveTypeAccessor.class$("org.idoox.wasp.serialization.xsdbuiltin.GYear")) : class$org$idoox$wasp$serialization$xsdbuiltin$GYear)) {
                return new GYear(value);
            }
            if (c == (class$org$idoox$wasp$serialization$xsdbuiltin$GYearMonth == null ? (class$org$idoox$wasp$serialization$xsdbuiltin$GYearMonth = PrimitiveTypeAccessor.class$("org.idoox.wasp.serialization.xsdbuiltin.GYearMonth")) : class$org$idoox$wasp$serialization$xsdbuiltin$GYearMonth)) {
                return new GYearMonth(value);
            }
            if (c == (class$org$idoox$wasp$serialization$xsdbuiltin$GDay == null ? (class$org$idoox$wasp$serialization$xsdbuiltin$GDay = PrimitiveTypeAccessor.class$("org.idoox.wasp.serialization.xsdbuiltin.GDay")) : class$org$idoox$wasp$serialization$xsdbuiltin$GDay)) {
                return new GDay(value);
            }
            if (c == (class$org$idoox$wasp$serialization$xsdbuiltin$GMonthDay == null ? (class$org$idoox$wasp$serialization$xsdbuiltin$GMonthDay = PrimitiveTypeAccessor.class$("org.idoox.wasp.serialization.xsdbuiltin.GMonthDay")) : class$org$idoox$wasp$serialization$xsdbuiltin$GMonthDay)) {
                return new GMonthDay(value);
            }
        }
        catch (Exception e) {
            throw new DeserializationException(e);
        }
        if (c == (class$org$idoox$wasp$serialization$xsdbuiltin$HexBinary == null ? (class$org$idoox$wasp$serialization$xsdbuiltin$HexBinary = PrimitiveTypeAccessor.class$("org.idoox.wasp.serialization.xsdbuiltin.HexBinary")) : class$org$idoox$wasp$serialization$xsdbuiltin$HexBinary)) {
            try {
                return new HexBinary(value);
            }
            catch (Exception e) {
                throw new DeserializationException(e);
            }
        }
        if (c == (class$org$idoox$wasp$serialization$xsdbuiltin$NormalizedString == null ? (class$org$idoox$wasp$serialization$xsdbuiltin$NormalizedString = PrimitiveTypeAccessor.class$("org.idoox.wasp.serialization.xsdbuiltin.NormalizedString")) : class$org$idoox$wasp$serialization$xsdbuiltin$NormalizedString)) {
            try {
                return new NormalizedString(value);
            }
            catch (Exception e) {
                throw new DeserializationException(e);
            }
        }
        if (c == (class$org$idoox$wasp$serialization$xsdbuiltin$Token == null ? (class$org$idoox$wasp$serialization$xsdbuiltin$Token = PrimitiveTypeAccessor.class$("org.idoox.wasp.serialization.xsdbuiltin.Token")) : class$org$idoox$wasp$serialization$xsdbuiltin$Token)) {
            try {
                return new Token(value);
            }
            catch (Exception e) {
                throw new DeserializationException(e);
            }
        }
        throw new DeserializationException("Internal exception: " + c + ": not a primitive type or not supported");
    }

    public static String writePrimitiveObject(Object o) {
        Class<?> aClass = o.getClass();
        if (aClass == (array$B == null ? (array$B = PrimitiveTypeAccessor.class$("[B")) : array$B)) {
            try {
                return new String(Base64.encode((byte[])o, false), "US-ASCII");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeWrappedException(e);
            }
        }
        if (aClass == (class$java$lang$Float == null ? (class$java$lang$Float = PrimitiveTypeAccessor.class$("java.lang.Float")) : class$java$lang$Float)) {
            float f = ((Float)o).floatValue();
            if (f == Float.NEGATIVE_INFINITY) {
                return "-INF";
            }
            if (f == Float.POSITIVE_INFINITY) {
                return "INF";
            }
            if (Float.isNaN(f)) {
                return "NaN";
            }
        } else if (aClass == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = PrimitiveTypeAccessor.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            if (((Boolean)o).booleanValue()) {
                return "1";
            }
            return "0";
        }
        return o.toString();
    }

    public static QName getPrimitiveType(Class c) {
        if (c == (class$java$lang$String == null ? (class$java$lang$String = PrimitiveTypeAccessor.class$("java.lang.String")) : class$java$lang$String)) {
            return STRING_EXPANDED_NAME;
        }
        if (c == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = PrimitiveTypeAccessor.class$("java.lang.Boolean")) : class$java$lang$Boolean) || c == Boolean.TYPE) {
            return BOOLEAN_EXPANDED_NAME;
        }
        if (c == (class$java$lang$Character == null ? (class$java$lang$Character = PrimitiveTypeAccessor.class$("java.lang.Character")) : class$java$lang$Character) || c == Character.TYPE) {
            return CHARACTER_EXPANDED_NAME;
        }
        if (c == (class$java$lang$Byte == null ? (class$java$lang$Byte = PrimitiveTypeAccessor.class$("java.lang.Byte")) : class$java$lang$Byte) || c == Byte.TYPE) {
            return BYTE_EXPANDED_NAME;
        }
        if (c == (class$java$lang$Short == null ? (class$java$lang$Short = PrimitiveTypeAccessor.class$("java.lang.Short")) : class$java$lang$Short) || c == Short.TYPE) {
            return SHORT_EXPANDED_NAME;
        }
        if (c == (class$java$lang$Integer == null ? (class$java$lang$Integer = PrimitiveTypeAccessor.class$("java.lang.Integer")) : class$java$lang$Integer) || c == Integer.TYPE) {
            return INTEGER_EXPANDED_NAME;
        }
        if (c == (class$java$lang$Long == null ? (class$java$lang$Long = PrimitiveTypeAccessor.class$("java.lang.Long")) : class$java$lang$Long) || c == Long.TYPE) {
            return LONG_EXPANDED_NAME;
        }
        if (c == (class$java$lang$Float == null ? (class$java$lang$Float = PrimitiveTypeAccessor.class$("java.lang.Float")) : class$java$lang$Float) || c == Float.TYPE) {
            return FLOAT_EXPANDED_NAME;
        }
        if (c == (class$java$lang$Double == null ? (class$java$lang$Double = PrimitiveTypeAccessor.class$("java.lang.Double")) : class$java$lang$Double) || c == Double.TYPE) {
            return DOUBLE_EXPANDED_NAME;
        }
        if (c == (class$java$math$BigInteger == null ? (class$java$math$BigInteger = PrimitiveTypeAccessor.class$("java.math.BigInteger")) : class$java$math$BigInteger)) {
            return BIGINTEGER_EXPANDED_NAME;
        }
        if (c == (class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = PrimitiveTypeAccessor.class$("java.math.BigDecimal")) : class$java$math$BigDecimal)) {
            return BIGDECIMAL_EXPANDED_NAME;
        }
        if (c == (class$java$util$Date == null ? (class$java$util$Date = PrimitiveTypeAccessor.class$("java.util.Date")) : class$java$util$Date)) {
            return DATETIME_EXPANDED_NAME;
        }
        if (c == (class$java$sql$Date == null ? (class$java$sql$Date = PrimitiveTypeAccessor.class$("java.sql.Date")) : class$java$sql$Date)) {
            return DATETIME_EXPANDED_NAME;
        }
        if (c == (class$java$sql$Time == null ? (class$java$sql$Time = PrimitiveTypeAccessor.class$("java.sql.Time")) : class$java$sql$Time)) {
            return DATETIME_EXPANDED_NAME;
        }
        if (c == (class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = PrimitiveTypeAccessor.class$("java.sql.Timestamp")) : class$java$sql$Timestamp)) {
            return DATETIME_EXPANDED_NAME;
        }
        if (c == (class$org$idoox$wasp$serialization$xsdbuiltin$Date == null ? (class$org$idoox$wasp$serialization$xsdbuiltin$Date = PrimitiveTypeAccessor.class$("org.idoox.wasp.serialization.xsdbuiltin.Date")) : class$org$idoox$wasp$serialization$xsdbuiltin$Date)) {
            return DATE_EXPANDED_NAME;
        }
        if (c == (class$org$idoox$wasp$serialization$xsdbuiltin$Time == null ? (class$org$idoox$wasp$serialization$xsdbuiltin$Time = PrimitiveTypeAccessor.class$("org.idoox.wasp.serialization.xsdbuiltin.Time")) : class$org$idoox$wasp$serialization$xsdbuiltin$Time)) {
            return TIME_EXPANDED_NAME;
        }
        if (c == (class$org$idoox$wasp$serialization$xsdbuiltin$DateTime == null ? (class$org$idoox$wasp$serialization$xsdbuiltin$DateTime = PrimitiveTypeAccessor.class$("org.idoox.wasp.serialization.xsdbuiltin.DateTime")) : class$org$idoox$wasp$serialization$xsdbuiltin$DateTime)) {
            return DATETIME_EXPANDED_NAME;
        }
        if (c == (class$org$idoox$wasp$serialization$xsdbuiltin$Duration == null ? (class$org$idoox$wasp$serialization$xsdbuiltin$Duration = PrimitiveTypeAccessor.class$("org.idoox.wasp.serialization.xsdbuiltin.Duration")) : class$org$idoox$wasp$serialization$xsdbuiltin$Duration)) {
            return DURATION_EXPANDED_NAME;
        }
        if (c == (class$org$idoox$wasp$serialization$xsdbuiltin$GMonth == null ? (class$org$idoox$wasp$serialization$xsdbuiltin$GMonth = PrimitiveTypeAccessor.class$("org.idoox.wasp.serialization.xsdbuiltin.GMonth")) : class$org$idoox$wasp$serialization$xsdbuiltin$GMonth)) {
            return GMONTH_EXPANDED_NAME;
        }
        if (c == (class$org$idoox$wasp$serialization$xsdbuiltin$GYear == null ? (class$org$idoox$wasp$serialization$xsdbuiltin$GYear = PrimitiveTypeAccessor.class$("org.idoox.wasp.serialization.xsdbuiltin.GYear")) : class$org$idoox$wasp$serialization$xsdbuiltin$GYear)) {
            return GYEAR_EXPANDED_NAME;
        }
        if (c == (class$org$idoox$wasp$serialization$xsdbuiltin$GYearMonth == null ? (class$org$idoox$wasp$serialization$xsdbuiltin$GYearMonth = PrimitiveTypeAccessor.class$("org.idoox.wasp.serialization.xsdbuiltin.GYearMonth")) : class$org$idoox$wasp$serialization$xsdbuiltin$GYearMonth)) {
            return GYEARMONTH_EXPANDED_NAME;
        }
        if (c == (class$org$idoox$wasp$serialization$xsdbuiltin$GDay == null ? (class$org$idoox$wasp$serialization$xsdbuiltin$GDay = PrimitiveTypeAccessor.class$("org.idoox.wasp.serialization.xsdbuiltin.GDay")) : class$org$idoox$wasp$serialization$xsdbuiltin$GDay)) {
            return GDAY_EXPANDED_NAME;
        }
        if (c == (class$org$idoox$wasp$serialization$xsdbuiltin$GMonthDay == null ? (class$org$idoox$wasp$serialization$xsdbuiltin$GMonthDay = PrimitiveTypeAccessor.class$("org.idoox.wasp.serialization.xsdbuiltin.GMonthDay")) : class$org$idoox$wasp$serialization$xsdbuiltin$GMonthDay)) {
            return GMONTHDAY_EXPANDED_NAME;
        }
        if (c == (class$org$idoox$wasp$serialization$xsdbuiltin$HexBinary == null ? (class$org$idoox$wasp$serialization$xsdbuiltin$HexBinary = PrimitiveTypeAccessor.class$("org.idoox.wasp.serialization.xsdbuiltin.HexBinary")) : class$org$idoox$wasp$serialization$xsdbuiltin$HexBinary)) {
            return HEXBINARY_EXPANDED_NAME;
        }
        if (c == (class$org$idoox$wasp$serialization$xsdbuiltin$NormalizedString == null ? (class$org$idoox$wasp$serialization$xsdbuiltin$NormalizedString = PrimitiveTypeAccessor.class$("org.idoox.wasp.serialization.xsdbuiltin.NormalizedString")) : class$org$idoox$wasp$serialization$xsdbuiltin$NormalizedString)) {
            return NORMALIZEDSTRING_EXPANDED_NAME;
        }
        if (c == (class$org$idoox$wasp$serialization$xsdbuiltin$Token == null ? (class$org$idoox$wasp$serialization$xsdbuiltin$Token = PrimitiveTypeAccessor.class$("org.idoox.wasp.serialization.xsdbuiltin.Token")) : class$org$idoox$wasp$serialization$xsdbuiltin$Token)) {
            return TOKEN_EXPANDED_NAME;
        }
        if (c == (array$B == null ? (array$B = PrimitiveTypeAccessor.class$("[B")) : array$B)) {
            return BASE64BINARY_EXPANDED_NAME;
        }
        if (c == (class$javax$xml$namespace$QName == null ? (class$javax$xml$namespace$QName = PrimitiveTypeAccessor.class$("javax.xml.namespace.QName")) : class$javax$xml$namespace$QName)) {
            return QNAME_EXPANDED_NAME;
        }
        return null;
    }

    public static boolean isPrimitive(Class cls) {
        if (cls == (array$B == null ? (array$B = PrimitiveTypeAccessor.class$("[B")) : array$B)) {
            return true;
        }
        return PrimitiveTypeAccessor.isPrimitive(cls.getName());
    }

    public static boolean isPrimitive(String javaTypeName) {
        return javaSimpleTypeSet.contains(javaTypeName);
    }

    public static Class convertPrimitiveToJavaClass(String className) {
        return (Class)javaPrimitiveTypeMap.get(className);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        xsdSimpleTypeMap.put("string", class$java$lang$String == null ? (class$java$lang$String = PrimitiveTypeAccessor.class$("java.lang.String")) : class$java$lang$String);
        xsdSimpleTypeMap.put("boolean", class$java$lang$Boolean == null ? (class$java$lang$Boolean = PrimitiveTypeAccessor.class$("java.lang.Boolean")) : class$java$lang$Boolean);
        xsdSimpleTypeMap.put("float", class$java$lang$Float == null ? (class$java$lang$Float = PrimitiveTypeAccessor.class$("java.lang.Float")) : class$java$lang$Float);
        xsdSimpleTypeMap.put("double", class$java$lang$Double == null ? (class$java$lang$Double = PrimitiveTypeAccessor.class$("java.lang.Double")) : class$java$lang$Double);
        xsdSimpleTypeMap.put("decimal", class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = PrimitiveTypeAccessor.class$("java.math.BigDecimal")) : class$java$math$BigDecimal);
        xsdSimpleTypeMap.put("base64Binary", array$B == null ? (array$B = PrimitiveTypeAccessor.class$("[B")) : array$B);
        xsdSimpleTypeMap.put("binary", array$B == null ? (array$B = PrimitiveTypeAccessor.class$("[B")) : array$B);
        xsdSimpleTypeMap.put("uriReference", class$java$lang$String == null ? (class$java$lang$String = PrimitiveTypeAccessor.class$("java.lang.String")) : class$java$lang$String);
        xsdSimpleTypeMap.put("ID", class$java$lang$String == null ? (class$java$lang$String = PrimitiveTypeAccessor.class$("java.lang.String")) : class$java$lang$String);
        xsdSimpleTypeMap.put("IDREF", class$java$lang$String == null ? (class$java$lang$String = PrimitiveTypeAccessor.class$("java.lang.String")) : class$java$lang$String);
        xsdSimpleTypeMap.put("ENTITY", class$java$lang$String == null ? (class$java$lang$String = PrimitiveTypeAccessor.class$("java.lang.String")) : class$java$lang$String);
        xsdSimpleTypeMap.put("NOTATION", class$java$lang$String == null ? (class$java$lang$String = PrimitiveTypeAccessor.class$("java.lang.String")) : class$java$lang$String);
        xsdSimpleTypeMap.put("QName", class$javax$xml$namespace$QName == null ? (class$javax$xml$namespace$QName = PrimitiveTypeAccessor.class$("javax.xml.namespace.QName")) : class$javax$xml$namespace$QName);
        xsdSimpleTypeMap.put("language", class$java$lang$String == null ? (class$java$lang$String = PrimitiveTypeAccessor.class$("java.lang.String")) : class$java$lang$String);
        xsdSimpleTypeMap.put("IDREFS", class$java$lang$String == null ? (class$java$lang$String = PrimitiveTypeAccessor.class$("java.lang.String")) : class$java$lang$String);
        xsdSimpleTypeMap.put("ENTITIES", class$java$lang$String == null ? (class$java$lang$String = PrimitiveTypeAccessor.class$("java.lang.String")) : class$java$lang$String);
        xsdSimpleTypeMap.put("NMTOKEN", class$java$lang$String == null ? (class$java$lang$String = PrimitiveTypeAccessor.class$("java.lang.String")) : class$java$lang$String);
        xsdSimpleTypeMap.put("NMTOKENS", class$java$lang$String == null ? (class$java$lang$String = PrimitiveTypeAccessor.class$("java.lang.String")) : class$java$lang$String);
        xsdSimpleTypeMap.put("Name", class$java$lang$String == null ? (class$java$lang$String = PrimitiveTypeAccessor.class$("java.lang.String")) : class$java$lang$String);
        xsdSimpleTypeMap.put("NCName", class$java$lang$String == null ? (class$java$lang$String = PrimitiveTypeAccessor.class$("java.lang.String")) : class$java$lang$String);
        xsdSimpleTypeMap.put("integer", class$java$math$BigInteger == null ? (class$java$math$BigInteger = PrimitiveTypeAccessor.class$("java.math.BigInteger")) : class$java$math$BigInteger);
        xsdSimpleTypeMap.put("nonPositiveInteger", class$java$math$BigInteger == null ? (class$java$math$BigInteger = PrimitiveTypeAccessor.class$("java.math.BigInteger")) : class$java$math$BigInteger);
        xsdSimpleTypeMap.put("negativeInteger", class$java$math$BigInteger == null ? (class$java$math$BigInteger = PrimitiveTypeAccessor.class$("java.math.BigInteger")) : class$java$math$BigInteger);
        xsdSimpleTypeMap.put("long", class$java$lang$Long == null ? (class$java$lang$Long = PrimitiveTypeAccessor.class$("java.lang.Long")) : class$java$lang$Long);
        xsdSimpleTypeMap.put("int", class$java$lang$Integer == null ? (class$java$lang$Integer = PrimitiveTypeAccessor.class$("java.lang.Integer")) : class$java$lang$Integer);
        xsdSimpleTypeMap.put("short", class$java$lang$Short == null ? (class$java$lang$Short = PrimitiveTypeAccessor.class$("java.lang.Short")) : class$java$lang$Short);
        xsdSimpleTypeMap.put("byte", class$java$lang$Byte == null ? (class$java$lang$Byte = PrimitiveTypeAccessor.class$("java.lang.Byte")) : class$java$lang$Byte);
        xsdSimpleTypeMap.put("nonNegativeInteger", class$java$math$BigInteger == null ? (class$java$math$BigInteger = PrimitiveTypeAccessor.class$("java.math.BigInteger")) : class$java$math$BigInteger);
        xsdSimpleTypeMap.put("unsignedLong", class$java$math$BigInteger == null ? (class$java$math$BigInteger = PrimitiveTypeAccessor.class$("java.math.BigInteger")) : class$java$math$BigInteger);
        xsdSimpleTypeMap.put("unsignedInt", class$java$lang$Long == null ? (class$java$lang$Long = PrimitiveTypeAccessor.class$("java.lang.Long")) : class$java$lang$Long);
        xsdSimpleTypeMap.put("unsignedShort", class$java$lang$Integer == null ? (class$java$lang$Integer = PrimitiveTypeAccessor.class$("java.lang.Integer")) : class$java$lang$Integer);
        xsdSimpleTypeMap.put("unsignedByte", class$java$lang$Short == null ? (class$java$lang$Short = PrimitiveTypeAccessor.class$("java.lang.Short")) : class$java$lang$Short);
        xsdSimpleTypeMap.put("positiveInteger", class$java$math$BigInteger == null ? (class$java$math$BigInteger = PrimitiveTypeAccessor.class$("java.math.BigInteger")) : class$java$math$BigInteger);
        xsdSimpleTypeMap.put("date", class$org$idoox$wasp$serialization$xsdbuiltin$Date == null ? (class$org$idoox$wasp$serialization$xsdbuiltin$Date = PrimitiveTypeAccessor.class$("org.idoox.wasp.serialization.xsdbuiltin.Date")) : class$org$idoox$wasp$serialization$xsdbuiltin$Date);
        xsdSimpleTypeMap.put("time", class$org$idoox$wasp$serialization$xsdbuiltin$Time == null ? (class$org$idoox$wasp$serialization$xsdbuiltin$Time = PrimitiveTypeAccessor.class$("org.idoox.wasp.serialization.xsdbuiltin.Time")) : class$org$idoox$wasp$serialization$xsdbuiltin$Time);
        xsdSimpleTypeMap.put("dateTime", class$org$idoox$wasp$serialization$xsdbuiltin$DateTime == null ? (class$org$idoox$wasp$serialization$xsdbuiltin$DateTime = PrimitiveTypeAccessor.class$("org.idoox.wasp.serialization.xsdbuiltin.DateTime")) : class$org$idoox$wasp$serialization$xsdbuiltin$DateTime);
        xsdSimpleTypeMap.put("duration", class$org$idoox$wasp$serialization$xsdbuiltin$Duration == null ? (class$org$idoox$wasp$serialization$xsdbuiltin$Duration = PrimitiveTypeAccessor.class$("org.idoox.wasp.serialization.xsdbuiltin.Duration")) : class$org$idoox$wasp$serialization$xsdbuiltin$Duration);
        xsdSimpleTypeMap.put("gMonth", class$org$idoox$wasp$serialization$xsdbuiltin$GMonth == null ? (class$org$idoox$wasp$serialization$xsdbuiltin$GMonth = PrimitiveTypeAccessor.class$("org.idoox.wasp.serialization.xsdbuiltin.GMonth")) : class$org$idoox$wasp$serialization$xsdbuiltin$GMonth);
        xsdSimpleTypeMap.put("gYear", class$org$idoox$wasp$serialization$xsdbuiltin$GYear == null ? (class$org$idoox$wasp$serialization$xsdbuiltin$GYear = PrimitiveTypeAccessor.class$("org.idoox.wasp.serialization.xsdbuiltin.GYear")) : class$org$idoox$wasp$serialization$xsdbuiltin$GYear);
        xsdSimpleTypeMap.put("gYearMonth", class$org$idoox$wasp$serialization$xsdbuiltin$GYearMonth == null ? (class$org$idoox$wasp$serialization$xsdbuiltin$GYearMonth = PrimitiveTypeAccessor.class$("org.idoox.wasp.serialization.xsdbuiltin.GYearMonth")) : class$org$idoox$wasp$serialization$xsdbuiltin$GYearMonth);
        xsdSimpleTypeMap.put("gDay", class$org$idoox$wasp$serialization$xsdbuiltin$GDay == null ? (class$org$idoox$wasp$serialization$xsdbuiltin$GDay = PrimitiveTypeAccessor.class$("org.idoox.wasp.serialization.xsdbuiltin.GDay")) : class$org$idoox$wasp$serialization$xsdbuiltin$GDay);
        xsdSimpleTypeMap.put("gMonthDay", class$org$idoox$wasp$serialization$xsdbuiltin$GMonthDay == null ? (class$org$idoox$wasp$serialization$xsdbuiltin$GMonthDay = PrimitiveTypeAccessor.class$("org.idoox.wasp.serialization.xsdbuiltin.GMonthDay")) : class$org$idoox$wasp$serialization$xsdbuiltin$GMonthDay);
        xsdSimpleTypeMap.put("hexBinary", class$org$idoox$wasp$serialization$xsdbuiltin$HexBinary == null ? (class$org$idoox$wasp$serialization$xsdbuiltin$HexBinary = PrimitiveTypeAccessor.class$("org.idoox.wasp.serialization.xsdbuiltin.HexBinary")) : class$org$idoox$wasp$serialization$xsdbuiltin$HexBinary);
        xsdSimpleTypeMap.put("normalizedString", class$org$idoox$wasp$serialization$xsdbuiltin$NormalizedString == null ? (class$org$idoox$wasp$serialization$xsdbuiltin$NormalizedString = PrimitiveTypeAccessor.class$("org.idoox.wasp.serialization.xsdbuiltin.NormalizedString")) : class$org$idoox$wasp$serialization$xsdbuiltin$NormalizedString);
        xsdSimpleTypeMap.put("token", class$org$idoox$wasp$serialization$xsdbuiltin$Token == null ? (class$org$idoox$wasp$serialization$xsdbuiltin$Token = PrimitiveTypeAccessor.class$("org.idoox.wasp.serialization.xsdbuiltin.Token")) : class$org$idoox$wasp$serialization$xsdbuiltin$Token);
        xsdSimpleTypeMap.put("anyURI", class$java$lang$String == null ? (class$java$lang$String = PrimitiveTypeAccessor.class$("java.lang.String")) : class$java$lang$String);
        xsdSimpleTypeMap.put("timeInstant", class$java$lang$String == null ? (class$java$lang$String = PrimitiveTypeAccessor.class$("java.lang.String")) : class$java$lang$String);
        xsdSimpleTypeMap.put("timeDuration", class$org$idoox$wasp$serialization$xsdbuiltin$Duration == null ? (class$org$idoox$wasp$serialization$xsdbuiltin$Duration = PrimitiveTypeAccessor.class$("org.idoox.wasp.serialization.xsdbuiltin.Duration")) : class$org$idoox$wasp$serialization$xsdbuiltin$Duration);
        xsdSimpleTypeMap.put("CDATA", class$java$lang$String == null ? (class$java$lang$String = PrimitiveTypeAccessor.class$("java.lang.String")) : class$java$lang$String);
        xsdSimpleTypeMap.put("month", class$org$idoox$wasp$serialization$xsdbuiltin$GMonth == null ? (class$org$idoox$wasp$serialization$xsdbuiltin$GMonth = PrimitiveTypeAccessor.class$("org.idoox.wasp.serialization.xsdbuiltin.GMonth")) : class$org$idoox$wasp$serialization$xsdbuiltin$GMonth);
        xsdSimpleTypeMap.put("year", class$org$idoox$wasp$serialization$xsdbuiltin$GYear == null ? (class$org$idoox$wasp$serialization$xsdbuiltin$GYear = PrimitiveTypeAccessor.class$("org.idoox.wasp.serialization.xsdbuiltin.GYear")) : class$org$idoox$wasp$serialization$xsdbuiltin$GYear);
        xsdSimpleTypeMap.put("uri", class$java$lang$String == null ? (class$java$lang$String = PrimitiveTypeAccessor.class$("java.lang.String")) : class$java$lang$String);
        xsdSimpleTypeMap.put("non-negative-integer", class$java$math$BigInteger == null ? (class$java$math$BigInteger = PrimitiveTypeAccessor.class$("java.math.BigInteger")) : class$java$math$BigInteger);
        xsdSimpleTypeMap.put("positive-integer", class$java$math$BigInteger == null ? (class$java$math$BigInteger = PrimitiveTypeAccessor.class$("java.math.BigInteger")) : class$java$math$BigInteger);
        xsdSimpleTypeMap.put("non-positive-integer", class$java$math$BigInteger == null ? (class$java$math$BigInteger = PrimitiveTypeAccessor.class$("java.math.BigInteger")) : class$java$math$BigInteger);
        xsdSimpleTypeMap.put("negative-integer", class$java$math$BigInteger == null ? (class$java$math$BigInteger = PrimitiveTypeAccessor.class$("java.math.BigInteger")) : class$java$math$BigInteger);
        xsdSimpleTypeMap.put("base64", array$B == null ? (array$B = PrimitiveTypeAccessor.class$("[B")) : array$B);
        xsdSimpleTypePrimMap.put("string", class$java$lang$String == null ? (class$java$lang$String = PrimitiveTypeAccessor.class$("java.lang.String")) : class$java$lang$String);
        xsdSimpleTypePrimMap.put("boolean", Boolean.TYPE);
        xsdSimpleTypePrimMap.put("float", Float.TYPE);
        xsdSimpleTypePrimMap.put("double", Double.TYPE);
        xsdSimpleTypePrimMap.put("decimal", class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = PrimitiveTypeAccessor.class$("java.math.BigDecimal")) : class$java$math$BigDecimal);
        xsdSimpleTypePrimMap.put("base64Binary", array$B == null ? (array$B = PrimitiveTypeAccessor.class$("[B")) : array$B);
        xsdSimpleTypePrimMap.put("binary", array$B == null ? (array$B = PrimitiveTypeAccessor.class$("[B")) : array$B);
        xsdSimpleTypePrimMap.put("uriReference", class$java$lang$String == null ? (class$java$lang$String = PrimitiveTypeAccessor.class$("java.lang.String")) : class$java$lang$String);
        xsdSimpleTypePrimMap.put("ID", class$java$lang$String == null ? (class$java$lang$String = PrimitiveTypeAccessor.class$("java.lang.String")) : class$java$lang$String);
        xsdSimpleTypePrimMap.put("IDREF", class$java$lang$String == null ? (class$java$lang$String = PrimitiveTypeAccessor.class$("java.lang.String")) : class$java$lang$String);
        xsdSimpleTypePrimMap.put("ENTITY", class$java$lang$String == null ? (class$java$lang$String = PrimitiveTypeAccessor.class$("java.lang.String")) : class$java$lang$String);
        xsdSimpleTypePrimMap.put("NOTATION", class$java$lang$String == null ? (class$java$lang$String = PrimitiveTypeAccessor.class$("java.lang.String")) : class$java$lang$String);
        xsdSimpleTypePrimMap.put("QName", class$javax$xml$namespace$QName == null ? (class$javax$xml$namespace$QName = PrimitiveTypeAccessor.class$("javax.xml.namespace.QName")) : class$javax$xml$namespace$QName);
        xsdSimpleTypePrimMap.put("language", class$java$lang$String == null ? (class$java$lang$String = PrimitiveTypeAccessor.class$("java.lang.String")) : class$java$lang$String);
        xsdSimpleTypePrimMap.put("IDREFS", class$java$lang$String == null ? (class$java$lang$String = PrimitiveTypeAccessor.class$("java.lang.String")) : class$java$lang$String);
        xsdSimpleTypePrimMap.put("ENTITIES", class$java$lang$String == null ? (class$java$lang$String = PrimitiveTypeAccessor.class$("java.lang.String")) : class$java$lang$String);
        xsdSimpleTypePrimMap.put("NMTOKEN", class$java$lang$String == null ? (class$java$lang$String = PrimitiveTypeAccessor.class$("java.lang.String")) : class$java$lang$String);
        xsdSimpleTypePrimMap.put("NMTOKENS", class$java$lang$String == null ? (class$java$lang$String = PrimitiveTypeAccessor.class$("java.lang.String")) : class$java$lang$String);
        xsdSimpleTypePrimMap.put("Name", class$java$lang$String == null ? (class$java$lang$String = PrimitiveTypeAccessor.class$("java.lang.String")) : class$java$lang$String);
        xsdSimpleTypePrimMap.put("NCName", class$java$lang$String == null ? (class$java$lang$String = PrimitiveTypeAccessor.class$("java.lang.String")) : class$java$lang$String);
        xsdSimpleTypePrimMap.put("integer", class$java$math$BigInteger == null ? (class$java$math$BigInteger = PrimitiveTypeAccessor.class$("java.math.BigInteger")) : class$java$math$BigInteger);
        xsdSimpleTypePrimMap.put("nonPositiveInteger", class$java$math$BigInteger == null ? (class$java$math$BigInteger = PrimitiveTypeAccessor.class$("java.math.BigInteger")) : class$java$math$BigInteger);
        xsdSimpleTypePrimMap.put("negativeInteger", class$java$math$BigInteger == null ? (class$java$math$BigInteger = PrimitiveTypeAccessor.class$("java.math.BigInteger")) : class$java$math$BigInteger);
        xsdSimpleTypePrimMap.put("long", Long.TYPE);
        xsdSimpleTypePrimMap.put("int", Integer.TYPE);
        xsdSimpleTypePrimMap.put("short", Short.TYPE);
        xsdSimpleTypePrimMap.put("byte", Byte.TYPE);
        xsdSimpleTypePrimMap.put("nonNegativeInteger", class$java$math$BigInteger == null ? (class$java$math$BigInteger = PrimitiveTypeAccessor.class$("java.math.BigInteger")) : class$java$math$BigInteger);
        xsdSimpleTypePrimMap.put("unsignedLong", class$java$math$BigInteger == null ? (class$java$math$BigInteger = PrimitiveTypeAccessor.class$("java.math.BigInteger")) : class$java$math$BigInteger);
        xsdSimpleTypePrimMap.put("unsignedInt", Long.TYPE);
        xsdSimpleTypePrimMap.put("unsignedShort", Integer.TYPE);
        xsdSimpleTypePrimMap.put("unsignedByte", Short.TYPE);
        xsdSimpleTypePrimMap.put("positiveInteger", class$java$math$BigInteger == null ? (class$java$math$BigInteger = PrimitiveTypeAccessor.class$("java.math.BigInteger")) : class$java$math$BigInteger);
        xsdSimpleTypePrimMap.put("date", class$org$idoox$wasp$serialization$xsdbuiltin$Date == null ? (class$org$idoox$wasp$serialization$xsdbuiltin$Date = PrimitiveTypeAccessor.class$("org.idoox.wasp.serialization.xsdbuiltin.Date")) : class$org$idoox$wasp$serialization$xsdbuiltin$Date);
        xsdSimpleTypePrimMap.put("time", class$org$idoox$wasp$serialization$xsdbuiltin$Time == null ? (class$org$idoox$wasp$serialization$xsdbuiltin$Time = PrimitiveTypeAccessor.class$("org.idoox.wasp.serialization.xsdbuiltin.Time")) : class$org$idoox$wasp$serialization$xsdbuiltin$Time);
        xsdSimpleTypePrimMap.put("dateTime", class$org$idoox$wasp$serialization$xsdbuiltin$DateTime == null ? (class$org$idoox$wasp$serialization$xsdbuiltin$DateTime = PrimitiveTypeAccessor.class$("org.idoox.wasp.serialization.xsdbuiltin.DateTime")) : class$org$idoox$wasp$serialization$xsdbuiltin$DateTime);
        xsdSimpleTypePrimMap.put("duration", class$org$idoox$wasp$serialization$xsdbuiltin$Duration == null ? (class$org$idoox$wasp$serialization$xsdbuiltin$Duration = PrimitiveTypeAccessor.class$("org.idoox.wasp.serialization.xsdbuiltin.Duration")) : class$org$idoox$wasp$serialization$xsdbuiltin$Duration);
        xsdSimpleTypePrimMap.put("gMonth", class$org$idoox$wasp$serialization$xsdbuiltin$GMonth == null ? (class$org$idoox$wasp$serialization$xsdbuiltin$GMonth = PrimitiveTypeAccessor.class$("org.idoox.wasp.serialization.xsdbuiltin.GMonth")) : class$org$idoox$wasp$serialization$xsdbuiltin$GMonth);
        xsdSimpleTypePrimMap.put("gYear", class$org$idoox$wasp$serialization$xsdbuiltin$GYear == null ? (class$org$idoox$wasp$serialization$xsdbuiltin$GYear = PrimitiveTypeAccessor.class$("org.idoox.wasp.serialization.xsdbuiltin.GYear")) : class$org$idoox$wasp$serialization$xsdbuiltin$GYear);
        xsdSimpleTypePrimMap.put("gYearMonth", class$org$idoox$wasp$serialization$xsdbuiltin$GYearMonth == null ? (class$org$idoox$wasp$serialization$xsdbuiltin$GYearMonth = PrimitiveTypeAccessor.class$("org.idoox.wasp.serialization.xsdbuiltin.GYearMonth")) : class$org$idoox$wasp$serialization$xsdbuiltin$GYearMonth);
        xsdSimpleTypePrimMap.put("gDay", class$org$idoox$wasp$serialization$xsdbuiltin$GDay == null ? (class$org$idoox$wasp$serialization$xsdbuiltin$GDay = PrimitiveTypeAccessor.class$("org.idoox.wasp.serialization.xsdbuiltin.GDay")) : class$org$idoox$wasp$serialization$xsdbuiltin$GDay);
        xsdSimpleTypePrimMap.put("gMonthDay", class$org$idoox$wasp$serialization$xsdbuiltin$GMonthDay == null ? (class$org$idoox$wasp$serialization$xsdbuiltin$GMonthDay = PrimitiveTypeAccessor.class$("org.idoox.wasp.serialization.xsdbuiltin.GMonthDay")) : class$org$idoox$wasp$serialization$xsdbuiltin$GMonthDay);
        xsdSimpleTypePrimMap.put("hexBinary", class$org$idoox$wasp$serialization$xsdbuiltin$HexBinary == null ? (class$org$idoox$wasp$serialization$xsdbuiltin$HexBinary = PrimitiveTypeAccessor.class$("org.idoox.wasp.serialization.xsdbuiltin.HexBinary")) : class$org$idoox$wasp$serialization$xsdbuiltin$HexBinary);
        xsdSimpleTypePrimMap.put("normalizedString", class$org$idoox$wasp$serialization$xsdbuiltin$NormalizedString == null ? (class$org$idoox$wasp$serialization$xsdbuiltin$NormalizedString = PrimitiveTypeAccessor.class$("org.idoox.wasp.serialization.xsdbuiltin.NormalizedString")) : class$org$idoox$wasp$serialization$xsdbuiltin$NormalizedString);
        xsdSimpleTypePrimMap.put("token", class$org$idoox$wasp$serialization$xsdbuiltin$Token == null ? (class$org$idoox$wasp$serialization$xsdbuiltin$Token = PrimitiveTypeAccessor.class$("org.idoox.wasp.serialization.xsdbuiltin.Token")) : class$org$idoox$wasp$serialization$xsdbuiltin$Token);
        xsdSimpleTypePrimMap.put("anyURI", class$java$lang$String == null ? (class$java$lang$String = PrimitiveTypeAccessor.class$("java.lang.String")) : class$java$lang$String);
        xsdSimpleTypePrimMap.put("timeInstant", class$java$lang$String == null ? (class$java$lang$String = PrimitiveTypeAccessor.class$("java.lang.String")) : class$java$lang$String);
        xsdSimpleTypePrimMap.put("timeDuration", class$org$idoox$wasp$serialization$xsdbuiltin$Duration == null ? (class$org$idoox$wasp$serialization$xsdbuiltin$Duration = PrimitiveTypeAccessor.class$("org.idoox.wasp.serialization.xsdbuiltin.Duration")) : class$org$idoox$wasp$serialization$xsdbuiltin$Duration);
        xsdSimpleTypePrimMap.put("CDATA", class$java$lang$String == null ? (class$java$lang$String = PrimitiveTypeAccessor.class$("java.lang.String")) : class$java$lang$String);
        xsdSimpleTypePrimMap.put("month", class$org$idoox$wasp$serialization$xsdbuiltin$GMonth == null ? (class$org$idoox$wasp$serialization$xsdbuiltin$GMonth = PrimitiveTypeAccessor.class$("org.idoox.wasp.serialization.xsdbuiltin.GMonth")) : class$org$idoox$wasp$serialization$xsdbuiltin$GMonth);
        xsdSimpleTypePrimMap.put("year", class$org$idoox$wasp$serialization$xsdbuiltin$GYear == null ? (class$org$idoox$wasp$serialization$xsdbuiltin$GYear = PrimitiveTypeAccessor.class$("org.idoox.wasp.serialization.xsdbuiltin.GYear")) : class$org$idoox$wasp$serialization$xsdbuiltin$GYear);
        xsdSimpleTypePrimMap.put("uri", class$java$lang$String == null ? (class$java$lang$String = PrimitiveTypeAccessor.class$("java.lang.String")) : class$java$lang$String);
        xsdSimpleTypePrimMap.put("non-negative-integer", class$java$math$BigInteger == null ? (class$java$math$BigInteger = PrimitiveTypeAccessor.class$("java.math.BigInteger")) : class$java$math$BigInteger);
        xsdSimpleTypePrimMap.put("positive-integer", class$java$math$BigInteger == null ? (class$java$math$BigInteger = PrimitiveTypeAccessor.class$("java.math.BigInteger")) : class$java$math$BigInteger);
        xsdSimpleTypePrimMap.put("non-positive-integer", class$java$math$BigInteger == null ? (class$java$math$BigInteger = PrimitiveTypeAccessor.class$("java.math.BigInteger")) : class$java$math$BigInteger);
        xsdSimpleTypePrimMap.put("negative-integer", class$java$math$BigInteger == null ? (class$java$math$BigInteger = PrimitiveTypeAccessor.class$("java.math.BigInteger")) : class$java$math$BigInteger);
        xsdSimpleTypePrimMap.put("base64", array$B == null ? (array$B = PrimitiveTypeAccessor.class$("[B")) : array$B);
        javaSimpleTypeSet.add("java.lang.String");
        javaSimpleTypeSet.add("boolean");
        javaSimpleTypeSet.add("byte");
        javaSimpleTypeSet.add("char");
        javaSimpleTypeSet.add("short");
        javaSimpleTypeSet.add("int");
        javaSimpleTypeSet.add("long");
        javaSimpleTypeSet.add("float");
        javaSimpleTypeSet.add("double");
        javaSimpleTypeSet.add("byte[]");
        javaSimpleTypeSet.add("[B");
        javaLiteralTypeSet.add(Boolean.TYPE);
        javaLiteralTypeSet.add(Byte.TYPE);
        javaLiteralTypeSet.add(Character.TYPE);
        javaLiteralTypeSet.add(Double.TYPE);
        javaLiteralTypeSet.add(Float.TYPE);
        javaLiteralTypeSet.add(Integer.TYPE);
        javaLiteralTypeSet.add(Long.TYPE);
        javaLiteralTypeSet.add(Short.TYPE);
        javaPrimitiveTypeMap.put("byte", Byte.TYPE);
        javaPrimitiveTypeMap.put("char", Character.TYPE);
        javaPrimitiveTypeMap.put("double", Double.TYPE);
        javaPrimitiveTypeMap.put("float", Float.TYPE);
        javaPrimitiveTypeMap.put("int", Integer.TYPE);
        javaPrimitiveTypeMap.put("long", Long.TYPE);
        javaPrimitiveTypeMap.put("short", Short.TYPE);
        javaPrimitiveTypeMap.put("boolean", Boolean.TYPE);
    }
}

