/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.serialization;

import com.idoox.wasp.serialization.SerializationException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.idoox.xml.schema.Type;

public class MultirefHandler {
    private int referenceCount = 0;
    private Map references = new HashMap();
    private List referencesList = new ArrayList();
    private MultirefHolder holder = new MultirefHolder();
    boolean serializingMultirefs = false;
    boolean multirefsInline = false;

    public String registerReference(Object reference, Type schemaType) throws SerializationException {
        this.holder.value = reference;
        MultirefHolder id = (MultirefHolder)this.references.get(this.holder);
        this.holder.value = null;
        if (id == null) {
            id = new MultirefHolder(reference, schemaType, null);
            this.references.put(id, id);
        } else if (id.id == null) {
            id.id = Integer.toString(this.referenceCount++);
            id.ref = "#" + id.id;
            this.referencesList.add(id);
        }
        return id.id;
    }

    public String registerReference(Object reference, Type schemaType, String id, String ref) throws SerializationException {
        this.holder.value = reference;
        MultirefHolder _id = (MultirefHolder)this.references.get(this.holder);
        this.holder.value = null;
        if (_id == null) {
            _id = new MultirefHolder(reference, schemaType, id);
            _id.ref = ref;
            this.references.put(_id, _id);
            this.referencesList.add(_id);
        }
        return _id.id;
    }

    public Map getReferences() throws SerializationException {
        return this.references;
    }

    public Iterator getReferencesIterator() throws SerializationException {
        return new BackwardIterator(this.referencesList);
    }

    public String getMultirefId(Object reference) {
        this.holder.value = reference;
        MultirefHolder id = (MultirefHolder)this.references.get(this.holder);
        this.holder.value = null;
        if (id == null) {
            return null;
        }
        return id.id;
    }

    public String getMultirefRef(Object reference) {
        this.holder.value = reference;
        MultirefHolder id = (MultirefHolder)this.references.get(this.holder);
        this.holder.value = null;
        if (id == null) {
            return null;
        }
        return id.ref;
    }

    public Type getMultirefType(Object reference) {
        this.holder.value = reference;
        MultirefHolder id = (MultirefHolder)this.references.get(this.holder);
        this.holder.value = null;
        if (id == null) {
            return null;
        }
        return id.schemaType;
    }

    public void clearMultirefs() {
        this.serializingMultirefs = false;
        this.multirefsInline = false;
        this.referenceCount = 0;
        this.references.clear();
        this.referencesList.clear();
    }

    public String toString() {
        return this.references.toString();
    }

    public void setSerializingMultirefs(boolean doSerializeMultirefs) {
        this.serializingMultirefs = doSerializeMultirefs;
    }

    public boolean isSerializingMultirefs() {
        boolean r = this.serializingMultirefs;
        this.serializingMultirefs = false;
        return r;
    }

    public boolean isMultirefsInline() {
        return this.multirefsInline;
    }

    public void setMultirefsInline(boolean flag) {
        this.multirefsInline = flag;
    }

    public void setReferenceSerialized(Object reference) {
        this.holder.value = reference;
        MultirefHolder id = (MultirefHolder)this.references.get(this.holder);
        this.holder.value = null;
        if (id == null) {
            return;
        }
        id.isSerialized = true;
    }

    public boolean isReferenceSerialized(Object reference) {
        this.holder.value = reference;
        MultirefHolder id = (MultirefHolder)this.references.get(this.holder);
        this.holder.value = null;
        if (id == null) {
            return false;
        }
        return id.isSerialized;
    }

    private class BackwardIterator
    implements Iterator {
        List list;
        int pos;

        BackwardIterator(List list) {
            this.list = list;
            this.pos = list.size() - 1;
        }

        public boolean hasNext() {
            return this.pos >= 0;
        }

        public Object next() {
            return this.list.get(this.pos--);
        }

        public void remove() {
            throw new UnsupportedOperationException("Remove not allowed in this iterator !");
        }
    }

    public static class MultirefHolder {
        public Object value;
        public String id;
        public String ref;
        public Type schemaType;
        public boolean isSerialized;

        public MultirefHolder() {
        }

        public MultirefHolder(Object value) {
            this.value = value;
            this.id = null;
        }

        public MultirefHolder(Object value, String id) {
            this.value = value;
            this.id = id;
        }

        public MultirefHolder(Object value, Type schemaType, String id) {
            this.value = value;
            this.id = id;
            this.schemaType = schemaType;
        }

        public int hashCode() {
            return System.identityHashCode(this.value);
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (!(other instanceof MultirefHolder)) {
                return false;
            }
            return this.value == ((MultirefHolder)other).value;
        }

        public String toString() {
            return "MultirefHolder[id=" + this.id + ", object=" + this.value + "]";
        }
    }
}

