/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.serialization;

import com.idoox.wasp.serialization.DuplicateAccessException;
import com.idoox.wasp.serialization.PrimitiveTypeAccessor;
import com.idoox.wasp.serialization.WaspSerializationHelper;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Map;
import org.idoox.xml.schema.SimpleTypeEnumExtension;
import org.idoox.xml.schema.Type;
import org.idoox.xmlrpc.MessageProcessingException;

public class EnumHelper {
    public static String getEnumValue(Object data) throws IllegalAccessException, IntrospectionException, DuplicateAccessException, InvocationTargetException {
        Object memberObject;
        if (data == null) {
            return null;
        }
        Map props = WaspSerializationHelper.getProperties(data.getClass());
        Object fieldOrMethod = props.get("value");
        if (fieldOrMethod == null) {
            return null;
        }
        if (fieldOrMethod instanceof PropertyDescriptor) {
            PropertyDescriptor pd = (PropertyDescriptor)fieldOrMethod;
            Method readMethod = pd.getReadMethod();
            if (readMethod == null) {
                return null;
            }
            memberObject = readMethod.invoke(data, new Object[0]);
        } else {
            memberObject = ((Field)fieldOrMethod).get(data);
        }
        return PrimitiveTypeAccessor.writePrimitiveObject(memberObject);
    }

    public static String getEnumField(Object data) throws IllegalAccessException {
        if (data == null) {
            return null;
        }
        Field[] typeFields = data.getClass().getDeclaredFields();
        int i = 0;
        while (i < typeFields.length) {
            int modifiers = typeFields[i].getModifiers();
            if (Modifier.isPublic(modifiers) && Modifier.isStatic(modifiers) && Modifier.isFinal(modifiers) && data == WaspSerializationHelper.getField(null, typeFields[i])) {
                return typeFields[i].getName();
            }
            ++i;
        }
        return null;
    }

    public static Object deserializeEnumeration(Class targetClass, String value, Type schemaType) throws MessageProcessingException {
        try {
            if (value == null) {
                return null;
            }
            String elemName = null;
            SimpleTypeEnumExtension ext = (SimpleTypeEnumExtension)schemaType.getExtension("SimpleTypeEnumExtension");
            elemName = ext != null ? ext.getJavaValue(value) : WaspSerializationHelper.mapElementName(value);
            if (elemName == null) {
                throw new MessageProcessingException("Couldn't map a value '" + value + "' to a Java field in a class '" + targetClass.getName() + "'");
            }
            Field fld = targetClass.getDeclaredField(elemName = WaspSerializationHelper.mapElementName(elemName));
            if (fld == null) {
                throw new MessageProcessingException("Can not find field '" + elemName + "' within " + targetClass);
            }
            return fld.get(null);
        }
        catch (MessageProcessingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MessageProcessingException(e);
        }
    }
}

