/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.serialization;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import javax.xml.namespace.QName;
import org.idoox.util.RuntimeWrappedException;
import org.idoox.wasp.serialization.FaultSerializer;
import org.idoox.xml.TokenWriter;
import org.idoox.xmlrpc.Constants;
import org.idoox.xmlrpc.Fault;

public class DefaultFaultSerializer
implements FaultSerializer {
    public void serializeFault(Fault fault, Throwable throwable) {
        try {
            Throwable sub = throwable;
            if (sub instanceof InvocationTargetException) {
                sub = ((InvocationTargetException)sub).getTargetException();
            }
            fault.setFaultCode(this.getServerFaultCode());
            String faultString = sub.getMessage();
            if (faultString == null) {
                faultString = "An exception occurred: " + sub.getClass().getName();
            }
            fault.setFaultString(faultString);
            TokenWriter writer = fault.getDetailTokenWriter();
            writer.setPrefixForNamespace("ijm", "urn:idoox-java-mapping");
            writer.enter("urn:idoox-java-mapping", "idoox-java-mapping." + sub.getClass().getName());
            writer.enter("urn:idoox-java-mapping", "stack-trace");
            StringWriter swriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(swriter);
            throwable.printStackTrace(printWriter);
            printWriter.flush();
            String content = swriter.toString();
            printWriter.close();
            writer.writeContent(content);
            writer.leave();
            writer.leave();
        }
        catch (IOException e) {
            throw new RuntimeWrappedException(e);
        }
    }

    protected QName getServerFaultCode() {
        return Constants.SERVER_FAULT_CODE;
    }
}

