/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.interrefs;

import com.idoox.util.ClassCache;
import com.idoox.wasp.InterfaceIntrospector;
import com.idoox.wasp.PortTypeMappingRegistry;
import com.idoox.wasp.WSDLSchemas;
import com.idoox.wasp.WSDLServiceInfo;
import com.idoox.wasp.interrefs.ClientInterrefSerializer;
import com.idoox.wasp.interrefs.Interrefs;
import com.idoox.wasp.serialization.SerializationException;
import com.idoox.wasp.tools.common.util.ClassHelper;
import com.idoox.wasp.wsdl.WSDLRepositoryImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.Service;
import javax.xml.namespace.QName;
import org.idoox.transport.Connection;
import org.idoox.transport.URI;
import org.idoox.transport.client.Endpoint;
import org.idoox.wasp.Context;
import org.idoox.wasp.serialization.SchemaContext;
import org.idoox.wasp.serialization.SerializationChain;
import org.idoox.wasp.serialization.SerializationContext;
import org.idoox.wasp.serialization.Serializer;
import org.idoox.wasp.server.WSRegistry;
import org.idoox.wasp.wsdl.SOAPPortInfo;
import org.idoox.wasp.wsdl.SOAPServiceInfo;
import org.idoox.wasp.wsdl.WSDLRepository;
import org.idoox.webservice.client.WebService;
import org.idoox.webservice.client.WebServiceHelper;
import org.idoox.xml.schema.Member;
import org.idoox.xml.schema.SchemaConstruct;
import org.idoox.xml.schema.SchemaException;
import org.idoox.xmlrpc.MessageCreatingException;
import org.idoox.xmlrpc.encoding.EncodingTokenWriter;
import org.systinet.wasp.webservice.CallContext;
import org.systinet.wasp.webservice.Current;
import org.systinet.wasp.webservice.ServiceEndpoint;
import org.systinet.wasp.webservice.ServiceEndpointContext;

public class ServerInterrefSerializer
extends ClientInterrefSerializer {
    public String getMechanismType() {
        return Serializer.MECHANISM_TYPE;
    }

    public void grabReferences(Object data, SerializationContext serContext, SerializationChain chain) throws MessageCreatingException {
        serContext.registerReference(data, serContext.getCurrentMember().getType());
    }

    public void serialize(EncodingTokenWriter out, Object object, int[] arrayPos, SerializationContext serContext, SerializationChain chain) throws MessageCreatingException {
        String namespace = null;
        WebService ws = WebServiceHelper.getWebService(object);
        if (ws != null) {
            super.serialize(out, object, arrayPos, serContext, chain);
            return;
        }
        Member m = serContext.getCurrentMember();
        SchemaContext.State inStructure = serContext.enterCurrentMember();
        SchemaConstruct construct = serContext.nextSchemaConstruct();
        namespace = this.getUse() == 1 ? "http://idoox.com/interface" : null;
        CallContext context = Current.getCallContext();
        ServiceEndpointContext wsContext = Current.getServiceEndpointContext();
        Map wsContextData = wsContext.getContextData();
        PortTypeMappingRegistry ptMappingRegistry = (PortTypeMappingRegistry)Context.getInstance("com.idoox.wasp.PortTypeMappingRegistry");
        String ptMappingRegistryConfigName = this.getPortTypeMappingRegistryConfigName();
        Boolean noPTMPassingObject = (Boolean)context.getContextData().get("wasp.service.NoPTMappingPassing");
        boolean noPTMPassing = noPTMPassingObject != null && noPTMPassingObject != false;
        String address = null;
        String instID = null;
        QName serviceQName = ptMappingRegistry.getServiceForClass(ptMappingRegistryConfigName, object.getClass());
        ArrayList<QName> portTypeQNames = null;
        if (serviceQName != null) {
            SOAPPortInfo[] portInfos;
            WSDLRepository wsdlRepo = (WSDLRepository)Context.getInstance("org.idoox.wasp.wsdl.WSDLRepository");
            WSDLRepository.ServiceInfo repoService = wsdlRepo.findService(serviceQName);
            SOAPServiceInfo serviceInfo = null;
            if (repoService != null) {
                Definition wsdl = repoService.getDefinition();
                address = wsdl.getDocumentBaseURI();
                if (!noPTMPassing) {
                    Service wsdlService = repoService.getService();
                    try {
                        serviceInfo = new WSDLServiceInfo(wsdl, wsdlService, new WSDLSchemas(wsdl));
                    }
                    catch (SchemaException e) {
                        throw new SerializationException("Exception during creating wsdl service info", e);
                    }
                }
            } else {
                Connection connection = (Connection)context.getContextData().get("wasp.transport.connection");
                address = connection.getURI().toExternalForm();
                Map serviceInfoMap = (Map)wsContextData.get("wasp.service.info.map");
                serviceInfo = (SOAPServiceInfo)serviceInfoMap.get(null);
                if (!serviceQName.equals(serviceInfo.getServiceQName())) {
                    Definition wsdl;
                    try {
                        ServiceEndpoint serviceEndpoint = Current.getServiceEndpointContext().getServiceEndpoint();
                        wsdl = serviceEndpoint.getWSDL();
                    }
                    catch (Exception e) {
                        throw new SerializationException("couldn't load service wsdl", e);
                    }
                    Service service = wsdl.getService(serviceQName);
                    if (service == null) {
                        throw new SerializationException("No definition found for service " + serviceQName);
                    }
                    if (!noPTMPassing) {
                        try {
                            serviceInfo = new WSDLServiceInfo(wsdl, service, new WSDLSchemas(wsdl));
                        }
                        catch (SchemaException e) {
                            throw new SerializationException("Exception during creating wsdl service info", e);
                        }
                    }
                }
            }
            if (!noPTMPassing && serviceInfo != null && (portInfos = serviceInfo.getPortInfos()).length > 0) {
                portTypeQNames = new ArrayList<QName>(portInfos.length);
                int i = 0;
                while (i < portInfos.length) {
                    portTypeQNames.add(portInfos[i].getPortTypeQName());
                    ++i;
                }
            }
        } else {
            ServiceInfo si = ServerInterrefSerializer.processUnknownInterrefClass(ptMappingRegistryConfigName, object.getClass(), null);
            if (si == null) {
                throw new SerializationException("No service found for class " + object.getClass().getName());
            }
            serviceQName = si.getServiceQName();
            address = si.getWSDLUrl();
            portTypeQNames = si.getPortTypeQNames();
        }
        WSRegistry lc = (WSRegistry)wsContext.getContextData().get("core.ws_registry");
        instID = lc.getServiceInstanceId(object);
        if (instID == null) {
            instID = lc.registerService(object, false);
        }
        QName typeQName = m.getType() != null && m.getType().getName() != null ? m.getType().getName() : Interrefs.IREF_TYPE_QNAME;
        out.writeStructureStart(m.getName(), typeQName, arrayPos, null);
        out.writeQName(new QName(namespace, "service"), null, serviceQName, null, null);
        out.writePrimitive(new QName(namespace, "wsdl"), null, address, null, null);
        if (instID != null) {
            out.writePrimitive(new QName(namespace, "instanceID"), null, instID, null, null);
        }
        if (portTypeQNames != null) {
            this.serializePTMappingInformation(out, serContext, portTypeQNames, namespace);
        }
        out.writeStructureEnd();
        serContext.leave(inStructure);
    }

    protected String getPortTypeMappingRegistryConfigName() {
        ServiceEndpointContext wsc = Current.getServiceEndpointContext();
        if (wsc == null) {
            return null;
        }
        Map context = wsc.getContextData();
        return (String)context.get("wasp.JavaAdaptor.PortTypeMappingRegistryConfig");
    }

    public static ServiceInfo processUnknownInterrefClass(String ptmRepoConfig, Class clazz, URI sURI) throws MessageCreatingException {
        CallContext context = Current.getCallContext();
        if (sURI == null) {
            sURI = ((Connection)context.getContextData().get("wasp.transport.connection")).getURI();
        }
        String serviceURI = sURI.toExternalForm();
        String clazzName = clazz.getName();
        String clazzUID = ClassHelper.getClassUID(clazz);
        String convertedClazzUID = clazzUID.replace('$', '_');
        ServiceInfo ret = new ServiceInfo();
        if (clazz.isInterface()) {
            throw new MessageCreatingException("Unable to process interface classes!");
        }
        QName serviceQName = new QName(serviceURI, convertedClazzUID);
        ret.setServiceQName(serviceQName);
        Endpoint endpoint = new Endpoint(sURI);
        endpoint.setLocation("/internal/java/wsdlGenerator/");
        endpoint.setParameter("class", clazzName);
        endpoint.setParameter("serviceURI", serviceURI);
        String protocol = (String)context.getContextData().get("wasp.xml.protocol");
        if (protocol != null) {
            endpoint.setParameter("protocol", protocol);
        }
        ret.setWSDLUrl(endpoint.toExternalForm());
        ClassCache.setClassForName(serviceURI + ": " + clazzName, clazz);
        Class[] ifaceA = InterfaceIntrospector.getExportInterfaces(clazz);
        ArrayList<QName> portTypeQNames = new ArrayList<QName>(5);
        PortTypeMappingRegistry ptmr = (PortTypeMappingRegistry)Context.getInstance("com.idoox.wasp.PortTypeMappingRegistry");
        WSDLRepository wsdlR = (WSDLRepository)Context.getInstance("org.idoox.wasp.wsdl.WSDLRepository");
        if (!(wsdlR instanceof WSDLRepositoryImpl)) {
            throw new RuntimeException("Unknown WSDLRepository implementation!");
        }
        ((WSDLRepositoryImpl)wsdlR)._registerService(ret.getWSDLUrl(), serviceQName);
        ptmr.setImplementationMapping(ptmRepoConfig, clazz, ret.getServiceQName());
        int i = 0;
        while (i < ifaceA.length) {
            String cName = ifaceA[i].getName();
            ClassCache.setClassForName(serviceURI + ": " + cName, ifaceA[i]);
            String cUID = ClassHelper.getClassUID(ifaceA[i]);
            QName ptQName = new QName(serviceURI + "/" + cUID, cUID);
            portTypeQNames.add(ptQName);
            ((WSDLRepositoryImpl)wsdlR)._registerPort(ret.getWSDLUrl(), serviceQName, cUID, ptQName);
            ptmr.setInterfaceMapping(ptmRepoConfig, ptQName, ifaceA[i]);
            ++i;
        }
        ret.setPortTypeQNames(portTypeQNames);
        return ret;
    }

    public static class ServiceInfo {
        private QName serviceQName;
        private String wsdlUrl;
        private List portTypeQNames;

        public ServiceInfo() {
        }

        public ServiceInfo(QName serviceQName, String wsdlUrl, List portTypeQNames) {
            this.serviceQName = serviceQName;
            this.wsdlUrl = wsdlUrl;
            this.portTypeQNames = portTypeQNames;
        }

        public QName getServiceQName() {
            return this.serviceQName;
        }

        public void setServiceQName(QName serviceQName) {
            this.serviceQName = serviceQName;
        }

        public String getWSDLUrl() {
            return this.wsdlUrl;
        }

        public void setWSDLUrl(String wsdlUrl) {
            this.wsdlUrl = wsdlUrl;
        }

        public List getPortTypeQNames() {
            return this.portTypeQNames;
        }

        public void setPortTypeQNames(List portTypeQNames) {
            this.portTypeQNames = portTypeQNames;
        }
    }
}

