/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.interrefs;

import com.idoox.wasp.PortTypeMappingRegistry;
import com.idoox.wasp.interrefs.Interrefs;
import com.idoox.wasp.serialization.SerializationException;
import com.systinet.wasp.client.ClientProxy;
import com.systinet.wasp.client.MultipleInterfaceProxy;
import com.systinet.wasp.webservice.ServiceClientImpl;
import com.systinet.wasp.webservice.ServiceEndpointImpl;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.idoox.config.Configurable;
import org.idoox.wasp.Context;
import org.idoox.wasp.serialization.SchemaContext;
import org.idoox.wasp.serialization.SerializationChain;
import org.idoox.wasp.serialization.SerializationContext;
import org.idoox.wasp.serialization.Serializer;
import org.idoox.wasp.wsdl.SOAPPortInfo;
import org.idoox.wasp.wsdl.SOAPServiceInfo;
import org.idoox.webservice.CallContext;
import org.idoox.xml.schema.Member;
import org.idoox.xmlrpc.MessageCreatingException;
import org.idoox.xmlrpc.encoding.EncodingTokenWriter;
import org.systinet.wasp.webservice.Current;
import org.systinet.wasp.webservice.LookupException;
import org.systinet.wasp.webservice.ServiceClient;

public class ClientInterrefSerializer
implements Serializer {
    protected static final String INTERREF_NS = "http://idoox.com/interface";
    private static final QName PTMAPPINGS_TYPE_QNAME = new QName("http://idoox.com/interface", "interfaceMapping");

    public String getMechanismType() {
        return Serializer.MECHANISM_TYPE;
    }

    public void grabReferences(Object data, SerializationContext serContext, SerializationChain chain) throws MessageCreatingException {
        serContext.registerReference(data, serContext.getCurrentMember().getType());
    }

    public void serialize(EncodingTokenWriter out, Object data, int[] arrayPos, SerializationContext serContext, SerializationChain chain) throws MessageCreatingException {
        SOAPPortInfo[] portA;
        CallContext callContext;
        Boolean noPTMPassingObject;
        QName serviceQName;
        ServiceClient[] clients;
        String namespace = null;
        if (Current.getProcessingType() != 1) {
            throw new SerializationException("You are not in client processing");
        }
        InvocationHandler stubHandler = Proxy.getInvocationHandler(data);
        if (stubHandler == null) {
            throw new SerializationException("You are trying to serilize nonproxy object");
        }
        ServiceClient client = null;
        if (stubHandler instanceof ClientProxy) {
            client = ((ClientProxy)stubHandler).getServiceClient();
        } else if (stubHandler instanceof MultipleInterfaceProxy && (clients = ((MultipleInterfaceProxy)stubHandler).getClients()) != null && clients.length > 0) {
            client = clients[0];
        }
        if (client == null) {
            throw new SerializationException("Can't find stub configuration.");
        }
        Map context = client.getContext().getContextData();
        Member member = serContext.getCurrentMember();
        SchemaContext.State inStructure = serContext.enterCurrentMember();
        namespace = this.getUse() == 1 ? INTERREF_NS : null;
        QName typeQName = member.getType() != null && member.getType().getName() != null ? member.getType().getName() : Interrefs.IREF_TYPE_QNAME;
        out.writeStructureStart(member.getName(), typeQName, arrayPos, null);
        try {
            serviceQName = client.getWSDLServiceName();
        }
        catch (LookupException e) {
            throw new SerializationException(e);
        }
        if (serviceQName == null) {
            throw new SerializationException("Unknown service.");
        }
        out.writeQName(new QName(namespace, "service"), null, serviceQName, null, null);
        out.writePrimitive(new QName(namespace, "wsdl"), null, client.getWSDLLocation(), null, null);
        String instID = (String)context.get(CallContext.INSTANCE_ID_KEY);
        if (instID != null) {
            out.writePrimitive(new QName(namespace, "instanceID"), null, instID, null, null);
        }
        boolean noPTMPassing = (noPTMPassingObject = (Boolean)(callContext = CallContext.getInstance()).get("wasp.service.NoPTMappingPassing")) != null && noPTMPassingObject != false;
        SOAPServiceInfo service = ((ServiceClientImpl)client).getPortInfo().getServiceInfo();
        if (!noPTMPassing && service != null && (portA = service.getPortInfos()) != null && portA.length != 0) {
            ArrayList<QName> portTypeQNames = new ArrayList<QName>(portA.length);
            int ii = 0;
            while (ii < portA.length) {
                portTypeQNames.add(portA[ii].getPortTypeQName());
                ++ii;
            }
            this.serializePTMappingInformation(out, serContext, portTypeQNames, namespace);
        }
        out.writeStructureEnd();
        serContext.leave(inStructure);
    }

    public void init(Configurable config) {
    }

    void serializePTMappingInformation(EncodingTokenWriter out, SerializationContext serContext, List portTypeQNames, String namespace) throws MessageCreatingException {
        Member member;
        if (portTypeQNames == null || portTypeQNames.size() == 0) {
            return;
        }
        ArrayList<InterfaceMapping> mappingsList = new ArrayList<InterfaceMapping>(portTypeQNames.size());
        PortTypeMappingRegistry reg = (PortTypeMappingRegistry)Context.getInstance("com.idoox.wasp.PortTypeMappingRegistry");
        String regKey = this.getPortTypeMappingRegistryConfigName();
        Iterator it = portTypeQNames.iterator();
        while (it.hasNext()) {
            QName portType = (QName)it.next();
            Class iface = reg.getInterfaceOfPortType(regKey, portType);
            if (iface == null) continue;
            InterfaceMapping mapping = new InterfaceMapping();
            mapping.className = iface.getName();
            mapping.portType = portType;
            mappingsList.add(mapping);
        }
        if (mappingsList.size() == 0) {
            return;
        }
        InterfaceMapping[] mappings = mappingsList.toArray(new InterfaceMapping[0]);
        while (!((member = serContext.nextMember()) == null || member.getName() != null && "portTypeMappings".equals(member.getName().getLocalPart()))) {
        }
        if (member == null) {
            throw new MessageCreatingException("no portType mappings to be serialized!");
        }
        out.writeArrayStart(new QName(namespace, "portTypeMappings"), PTMAPPINGS_TYPE_QNAME, new int[]{mappings.length}, null, null);
        int i = 0;
        while (i < mappings.length) {
            out.writeStructureStart(new QName(namespace, "item"), null, null, null);
            out.writeQName(new QName(namespace, "portType"), null, mappings[i].portType, null, null);
            out.writePrimitive(new QName(namespace, "className"), null, mappings[i].className, null, null);
            out.writeStructureEnd();
            ++i;
        }
        out.writeArrayEnd();
    }

    protected String getPortTypeMappingRegistryConfigName() {
        return null;
    }

    protected int getUse() {
        if (Current.getProcessingType() == 1) {
            org.systinet.wasp.webservice.CallContext cc = Current.getCallContext();
            String encodingURI = (String)cc.getContextData().get("wasp.encodingURI");
            if (encodingURI == null) {
                return 1;
            }
            return 0;
        }
        return ((ServiceEndpointImpl)Current.getServiceEndpointContext().getServiceEndpoint()).getUse();
    }

    public static class InterfaceMapping {
        public String className;
        public QName portType;
    }
}

