/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.interceptor;

import com.idoox.wasp.config.InterceptorConfig;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.idoox.config.Configurable;
import org.idoox.transport.Connection;
import org.idoox.transport.server.ServerConnection;
import org.idoox.wasp.WaspInternalException;
import org.idoox.wasp.interceptor.InterceptorChain;
import org.idoox.wasp.interceptor.TransportInterceptor;
import org.systinet.wasp.webservice.Current;

public class IPFilterInterceptor
implements TransportInterceptor {
    private long[] addresses;
    private long[] netmasks;
    private boolean[] allows;
    private int rangeNumber = 0;
    private boolean allowedByDefault = false;
    static /* synthetic */ Class class$com$idoox$wasp$interceptor$IPFilterInterceptor$Config;
    static /* synthetic */ Class class$com$idoox$wasp$interceptor$IPFilterInterceptor$Cfg;

    public IPFilterInterceptor() {
    }

    public IPFilterInterceptor(boolean allowByDefault) {
        this.allowedByDefault = allowByDefault;
    }

    public IPFilterInterceptor(boolean allowByDefault, Rule[] rules) {
        this.allowedByDefault = allowByDefault;
        this.setRules(rules);
    }

    public synchronized boolean getAllowedByDefault() {
        return this.allowedByDefault;
    }

    public synchronized void setAllowedByDefault(boolean allowedByDefault) {
        this.allowedByDefault = allowedByDefault;
    }

    public synchronized void addRule(String address, String netmask, boolean allow) {
        if (this.addresses == null) {
            this.addresses = new long[10];
            this.netmasks = new long[10];
            this.allows = new boolean[10];
        } else if (this.addresses.length == this.rangeNumber) {
            this.reallocate(this.addresses.length + 10);
        }
        try {
            this.addresses[this.rangeNumber] = IPFilterInterceptor.parseIP(address);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("malformed IP address: " + address + " (should be four numbers from 0 to 255 delimited by dots)");
        }
        try {
            this.netmasks[this.rangeNumber] = IPFilterInterceptor.parseIP(netmask);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("malformed netmask: " + netmask + " (should be four numbers from 0 to 255 delimited by dots)");
        }
        this.addresses[this.rangeNumber] = this.addresses[this.rangeNumber] & this.netmasks[this.rangeNumber];
        this.allows[this.rangeNumber] = allow;
        ++this.rangeNumber;
    }

    public synchronized void removeRule(String address, String netmask) {
        int i;
        if (this.addresses == null) {
            return;
        }
        try {
            long addressL = IPFilterInterceptor.parseIP(address);
            long netmaskL = IPFilterInterceptor.parseIP(netmask);
            i = 0;
            while (i < this.rangeNumber) {
                if (this.addresses[i] != (addressL & netmaskL) || this.netmasks[i] != netmaskL) {
                    ++i;
                    continue;
                }
                break;
            }
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("problem parsing address '" + address + "' or netmask '" + netmask + "'");
        }
        if (i == this.rangeNumber) {
            return;
        }
        --this.rangeNumber;
        System.arraycopy(this.addresses, i + 1, this.addresses, i, this.rangeNumber - i);
        System.arraycopy(this.netmasks, i + 1, this.netmasks, i, this.rangeNumber - i);
        System.arraycopy(this.allows, i + 1, this.allows, i, this.rangeNumber - i);
    }

    public synchronized Rule[] getRules() {
        if (this.addresses == null) {
            return new Rule[0];
        }
        Rule[] result = new Rule[this.rangeNumber];
        int i = 0;
        while (i < this.rangeNumber) {
            result[i] = new Rule(this.addresses[i], this.netmasks[i], this.allows[i]);
            ++i;
        }
        return result;
    }

    public synchronized void setRules(Rule[] rules) {
        this.addresses = null;
        this.netmasks = null;
        this.allows = null;
        this.rangeNumber = 0;
        if (rules != null) {
            int i = 0;
            while (i < rules.length) {
                if (rules[i] != null) {
                    this.addRule(rules[i].address, rules[i].netmask, rules[i].allow);
                }
                ++i;
            }
        }
    }

    public synchronized void intercept(Connection connection, InterceptorChain chain, int position) {
        long ip;
        ServerConnection con;
        try {
            con = (ServerConnection)connection;
        }
        catch (ClassCastException e) {
            System.err.println("IPFilterInterceptor not running on server - connection is not ServerConnection");
            chain.remove(position);
            return;
        }
        String addr = con.getClientAddress();
        try {
            ip = IPFilterInterceptor.parseIP(addr);
        }
        catch (UnknownHostException e) {
            Current.getServiceInstanceContext().getServiceInstance().log("client address invalid: " + addr);
            if (this.allowedByDefault) {
                return;
            }
            throw new RuntimeException("client request from " + addr + " blocked by IPFilterInterceptor");
        }
        int i = 0;
        while (i < this.rangeNumber) {
            if ((ip & this.netmasks[i]) == this.addresses[i]) {
                if (this.allows[i]) {
                    return;
                }
                throw new RuntimeException("client request from " + addr + " blocked by IPFilterInterceptor");
            }
            ++i;
        }
        if (this.allowedByDefault) {
            return;
        }
        throw new RuntimeException("client request from " + addr + " blocked by IPFilterInterceptor");
    }

    public void load(Configurable configurable) throws WaspInternalException {
        Config config = (Config)configurable.narrow(class$com$idoox$wasp$interceptor$IPFilterInterceptor$Config == null ? (class$com$idoox$wasp$interceptor$IPFilterInterceptor$Config = IPFilterInterceptor.class$("com.idoox.wasp.interceptor.IPFilterInterceptor$Config")) : class$com$idoox$wasp$interceptor$IPFilterInterceptor$Config);
        Range[] ranges = config.getRange();
        this.rangeNumber = 0;
        this.addresses = new long[ranges.length];
        this.netmasks = new long[ranges.length];
        this.allows = new boolean[ranges.length];
        int i = 0;
        while (i < ranges.length) {
            block6: {
                String addr = ranges[i].getAddress();
                String nmask = ranges[i].getNetmask();
                Boolean allowB = ranges[i].getAllowed();
                boolean allow = allowB != null ? allowB : false;
                try {
                    this.addRule(addr, nmask, allow);
                }
                catch (IllegalArgumentException e) {
                    Current.getServiceInstanceContext().getServiceInstance().log(e.getMessage());
                    break block6;
                }
                if (allow) {
                    Current.getServiceInstanceContext().getServiceInstance().log("will allow " + addr + "/" + nmask);
                } else {
                    Current.getServiceInstanceContext().getServiceInstance().log("will block " + addr + "/" + nmask);
                }
            }
            ++i;
        }
        Boolean tmp = config.isAllowedByDefault();
        if (tmp != null) {
            this.allowedByDefault = tmp;
        }
    }

    public void destroy() {
        this.addresses = null;
        this.netmasks = null;
        this.allows = null;
    }

    public synchronized void store(Configurable configurable, String interceptorName, String classSpace) throws WaspInternalException {
        try {
            int i;
            Cfg config = (Cfg)configurable.narrow(class$com$idoox$wasp$interceptor$IPFilterInterceptor$Cfg == null ? (class$com$idoox$wasp$interceptor$IPFilterInterceptor$Cfg = IPFilterInterceptor.class$("com.idoox.wasp.interceptor.IPFilterInterceptor$Cfg")) : class$com$idoox$wasp$interceptor$IPFilterInterceptor$Cfg);
            Cfg.Interceptor interceptor = config.newInterceptor();
            Cfg.Interceptor[] interceptors = config.getInterceptor();
            boolean stretch = true;
            if (interceptors == null) {
                interceptors = new Cfg.Interceptor[]{interceptor};
            } else {
                Cfg.Interceptor[] interceptorsAux = new Cfg.Interceptor[interceptors.length + 1];
                i = 0;
                while (i < interceptors.length) {
                    if (interceptors[i] != null && interceptorName != null && interceptorName.equals(interceptors[i].getName())) {
                        interceptors[i].setName(null);
                        interceptors[i] = interceptor;
                        stretch = false;
                        break;
                    }
                    interceptorsAux[i] = interceptors[i];
                    ++i;
                }
                if (stretch) {
                    interceptorsAux[interceptors.length] = interceptor;
                    interceptors = interceptorsAux;
                }
                config.setInterceptor(interceptors);
            }
            interceptor.setName(interceptorName);
            interceptor.setClassName("com.idoox.wasp.interceptor.IPFilterInterceptor");
            interceptor.setClassSpaceName(classSpace);
            interceptor.setAllowedByDefault(new Boolean(this.allowedByDefault));
            if (this.addresses != null) {
                Cfg.Interceptor.Range[] ranges = new Cfg.Interceptor.Range[this.rangeNumber];
                i = 0;
                while (i < this.rangeNumber) {
                    ranges[i] = interceptor.newRange();
                    ranges[i].setAddress(IPFilterInterceptor.parselongIp(this.addresses[i]));
                    ranges[i].setNetmask(IPFilterInterceptor.parselongIp(this.netmasks[i]));
                    ranges[i].setAllowed(new Boolean(this.allows[i]));
                    ++i;
                }
                interceptor.setRange(ranges);
            }
        }
        catch (NullPointerException e) {
            // empty catch block
        }
    }

    private void reallocate(int x) {
        long[] tmp = new long[x];
        System.arraycopy(this.addresses, 0, tmp, 0, this.rangeNumber);
        this.addresses = tmp;
        tmp = new long[x];
        System.arraycopy(this.netmasks, 0, tmp, 0, this.rangeNumber);
        this.netmasks = tmp;
        boolean[] tmpb = new boolean[x];
        System.arraycopy(this.allows, 0, tmpb, 0, this.rangeNumber);
        this.allows = tmpb;
    }

    private static long parseIP(String ip) throws UnknownHostException {
        InetAddress addr = InetAddress.getByName(ip);
        long retval = 0L;
        byte[] bytes = addr.getAddress();
        int i = 0;
        while (i < bytes.length) {
            retval = (retval << 8) + (bytes[i] >= 0 ? (long)bytes[i] : (long)bytes[i] + 256L);
            ++i;
        }
        return retval;
    }

    private static String parselongIp(long longIp) {
        if (longIp > 0L) {
            return String.valueOf(longIp >> 24 & 0xFFL) + "." + String.valueOf(longIp >> 16 & 0xFFL) + "." + String.valueOf(longIp >> 8 & 0xFFL) + "." + String.valueOf(longIp & 0xFFL);
        }
        return "0.0.0.0";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static interface Cfg {
        public Interceptor newInterceptor();

        public void setInterceptor(Interceptor[] var1);

        public Interceptor[] getInterceptor();

        public static interface Interceptor
        extends InterceptorConfig {
            public Range newRange();

            public Range[] getRange();

            public void setRange(Range[] var1);

            public Boolean getAllowedByDefault();

            public void setAllowedByDefault(Boolean var1);

            public static interface Range {
                public String getAddress();

                public void setAddress(String var1);

                public String getNetmask();

                public void setNetmask(String var1);

                public Boolean getAllowed();

                public void setAllowed(Boolean var1);
            }
        }
    }

    public static interface Range {
        public String getAddress();

        public String getNetmask();

        public Boolean getAllowed();
    }

    public static interface Config {
        public Range[] getRange();

        public Boolean isAllowedByDefault();
    }

    public static class Rule {
        public String address;
        public String netmask;
        public boolean allow;

        public Rule(String address, String netmask, boolean allow) {
            this.address = address;
            this.netmask = netmask;
            this.allow = allow;
        }

        public Rule(long address, long netmask, boolean allow) {
            this.address = IPFilterInterceptor.parselongIp(address);
            this.netmask = IPFilterInterceptor.parselongIp(netmask);
            this.allow = allow;
        }
    }
}

