/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.interceptor;

import com.idoox.debug.Category;
import com.idoox.transport.util.Headers;
import com.idoox.transport.util.WriteLine;
import com.idoox.wasp.Constants;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DateFormat;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.idoox.config.Configurable;
import org.idoox.config.Configurator;
import org.idoox.transport.Connection;
import org.idoox.transport.InputMessage;
import org.idoox.transport.InputMessageWrapper;
import org.idoox.transport.OutputMessage;
import org.idoox.transport.OutputMessageWrapper;
import org.idoox.transport.URI;
import org.idoox.wasp.Context;
import org.idoox.wasp.interceptor.InterceptorChain;
import org.idoox.wasp.interceptor.TransportInterceptor;
import org.systinet.wasp.Wasp;
import org.systinet.wasp.webservice.CallContext;
import org.systinet.wasp.webservice.Current;
import org.systinet.wasp.webservice.Registry;
import org.systinet.wasp.webservice.ServiceEndpoint;
import org.systinet.wasp.webservice.ServiceEndpointContext;
import org.systinet.wasp.webservice.ServiceInstanceContext;

public class DebugInterceptor
implements TransportInterceptor {
    private static final String className = "com.idoox.wasp.interceptor.DebugInterceptor";
    private static final Category log = Category.getCategory("com.idoox.wasp.interceptor.DebugInterceptor");
    private FileOutputStream debugFile;
    private File debugDescriptor;
    private String dirPath = null;
    private int state;
    private static final int lineLength = 80;

    public DebugInterceptor() {
    }

    public DebugInterceptor(String dirPath) {
        this.dirPath = dirPath;
    }

    public void load(Configurable config) {
    }

    public void destroy() {
        this.debugFile = null;
        this.state = 0;
    }

    public String getFileUrl(String serviceEndpointPath) {
        String path = null;
        File file = this.getDebugDescriptor(serviceEndpointPath);
        if (file != null) {
            try {
                path = file.toURL().getFile();
            }
            catch (MalformedURLException e) {
                log.error("Debug file can't be found", e);
            }
        }
        return path;
    }

    public synchronized void intercept(Connection connection, InterceptorChain chain, int position) {
        ServiceEndpointContext endpointCtx = Current.getServiceEndpointContext();
        if (endpointCtx != null) {
            Map contextMap = endpointCtx.getContextData();
            FileOutputStream debugFile = (FileOutputStream)contextMap.get("com.idoox.wasp.interceptor.DebugInterceptor.debugFile");
            if (debugFile == null) {
                File debugDescriptor;
                ServiceInstanceContext instanceCtx = Current.getServiceInstanceContext();
                String filePath = instanceCtx.getServiceInstance().getResource("/");
                if (filePath == null) {
                    String endpointPath = endpointCtx.getServiceEndpoint().getPath();
                    if (this.dirPath != null) {
                        try {
                            filePath = new File(this.dirPath).toURL().toExternalForm() + "/debug" + endpointPath.replace('/', '_') + ".txt";
                        }
                        catch (MalformedURLException e) {
                            log.error("Debug file can't be created", e);
                            chain.remove(position);
                            return;
                        }
                    } else {
                        filePath = Wasp.getWaspLocation() + "/debug" + endpointPath.replace('/', '_') + ".txt";
                    }
                } else {
                    filePath = filePath + "/debug.txt";
                }
                try {
                    URL url = new URL(filePath);
                    filePath = url.getFile();
                }
                catch (MalformedURLException e) {
                    log.error("Debug file can't be created", e);
                    chain.remove(position);
                    return;
                }
                try {
                    debugDescriptor = new File(filePath);
                    debugFile = new FileOutputStream(filePath, true);
                }
                catch (FileNotFoundException e) {
                    log.error("Debug file can't be created", e);
                    chain.remove(position);
                    return;
                }
                contextMap.put("com.idoox.wasp.interceptor.DebugInterceptor.debugFile", debugFile);
                contextMap.put("com.idoox.wasp.interceptor.DebugInterceptor.debugDescriptor", debugDescriptor);
                contextMap.put("com.idoox.wasp.interceptor.DebugInterceptor.state", new Integer(0));
            }
        } else if (this.debugFile == null) {
            String filePath = "debug.txt";
            Configurator configurator = (Configurator)Context.getInstance("org.idoox.config.Configurator");
            String waspLocation = Configurator.getWaspLocation();
            if (waspLocation != null) {
                try {
                    filePath = waspLocation + '/' + filePath;
                    filePath = new URL(filePath).getFile();
                }
                catch (MalformedURLException e) {
                    log.error("Debug file can't be created", e);
                    chain.remove(position);
                    return;
                }
            }
            try {
                this.debugDescriptor = new File(filePath);
                this.debugFile = new FileOutputStream(filePath, true);
            }
            catch (FileNotFoundException e) {
                log.error("Debug file can't be created", e);
                chain.remove(position);
                return;
            }
            this.state = 0;
        }
        Current.getCallContext().getContextData().put("com.idoox.wasp.interceptor.DebugInterceptor.state", new Integer(0));
        if (connection.getInputMessage() != null) {
            connection.setInputMessage(new DebugInputMessage(connection.getInputMessage(), connection.getURI()));
        }
        if (connection.getOutputMessage() != null) {
            connection.setOutputMessage(new DebugOutputMessage(connection.getOutputMessage(), connection.getURI()));
        }
    }

    public synchronized void cleanFile(String uri) throws IOException {
        FileOutputStream debugFile = this.getDebugFile(uri);
        File debugDescriptor = this.getDebugDescriptor(uri);
        if (debugFile != null) {
            debugFile.close();
            debugFile = new FileOutputStream(debugDescriptor);
            this.setDebugFile(uri, debugFile);
        } else {
            String fileLocation;
            ServiceEndpointContext context = null;
            ServiceEndpoint endpoint = Registry.getServiceEndpoint(uri);
            if (uri != null && endpoint != null) {
                context = endpoint.getContext();
            }
            if (context != null) {
                fileLocation = context.getServiceEndpoint().getServiceInstance().getResource("/") + "/debug.txt";
            } else {
                Configurator configurator = (Configurator)Context.getInstance("org.idoox.config.Configurator");
                fileLocation = Configurator.getWaspLocation() + "/debug.txt";
            }
            String filePath = new URL(fileLocation).getFile();
            new File(filePath).delete();
        }
    }

    private File getDebugDescriptor(String uri) {
        ServiceEndpointContext context = null;
        ServiceEndpoint endpoint = Registry.getServiceEndpoint(uri);
        if (uri != null && endpoint != null) {
            context = endpoint.getContext();
        }
        if (context != null) {
            Map contextMap = context.getContextData();
            return (File)contextMap.get("com.idoox.wasp.interceptor.DebugInterceptor.debugDescriptor");
        }
        return this.debugDescriptor;
    }

    private FileOutputStream getDebugFile(String uri) {
        ServiceEndpoint endpoint = Registry.getServiceEndpoint(uri);
        ServiceEndpointContext context = Current.getServiceEndpointContext();
        if (uri != null && endpoint != null) {
            context = endpoint.getContext();
        }
        if (context != null) {
            Map contextMap = context.getContextData();
            return (FileOutputStream)contextMap.get("com.idoox.wasp.interceptor.DebugInterceptor.debugFile");
        }
        return this.debugFile;
    }

    private void setDebugFile(String uri, FileOutputStream file) {
        ServiceEndpointContext context = Current.getServiceEndpointContext();
        if (uri != null) {
            context = Registry.getServiceEndpoint(uri).getContext();
        }
        if (context != null) {
            Map contextMap = context.getContextData();
            contextMap.put("com.idoox.wasp.interceptor.DebugInterceptor.debugFile", file);
        } else {
            this.debugFile = file;
        }
    }

    private int getDebugFileState() {
        ServiceEndpointContext context = Current.getServiceEndpointContext();
        if (context != null) {
            Map contextMap = context.getContextData();
            return (Integer)contextMap.get("com.idoox.wasp.interceptor.DebugInterceptor.state");
        }
        return this.state;
    }

    private void setStates(int state) {
        ServiceEndpointContext context = Current.getServiceEndpointContext();
        if (context != null) {
            Map contextMap = context.getContextData();
            contextMap.put("com.idoox.wasp.interceptor.DebugInterceptor.state", new Integer(state));
        } else {
            this.state = state;
        }
        CallContext callContext = Current.getCallContext();
        if (callContext != null) {
            callContext.getContextData().put("com.idoox.wasp.interceptor.DebugInterceptor.state", new Integer(state));
        }
    }

    private void dumpLine(FileOutputStream debugFile, String line, boolean startEnter) throws IOException {
        int length = 82;
        if (startEnter) {
            length += 2;
        }
        StringBuffer buffer = new StringBuffer(length);
        if (startEnter) {
            buffer.append("\r\n");
        }
        buffer.append("==== ");
        buffer.append(line);
        int buffLength = buffer.length();
        if (buffLength < length - 3) {
            buffer.append(" ");
            ++buffLength;
        }
        int i = 0;
        while (i < length - 2 - buffLength) {
            buffer.append('=');
            ++i;
        }
        buffer.append("\r\n");
        debugFile.write(new String(buffer).getBytes(Constants.UTF_8));
    }

    private synchronized void dumpInput(byte[] b, int off, int len, Map headers, URI uri) throws IOException {
        FileOutputStream debugFile = this.getDebugFile(null);
        int debugFileState = this.getDebugFileState();
        if (debugFileState != 1) {
            this.setStates(1);
            String time = " ==== " + DateFormat.getInstance().format(new GregorianCalendar().getTime()) + " ";
            this.dumpLine(debugFile, "INPUT ==== " + uri.toExternalForm() + time, true);
        }
        if (headers != null) {
            new Headers(headers).write(new WriteLine(debugFile));
        }
        if (b == null) {
            this.dumpLine(debugFile, "FIRST PART", false);
        } else {
            debugFile.write(b, off, len);
        }
    }

    private synchronized void dumpOutput(byte[] b, int off, int len, Map headers, URI uri) throws IOException {
        FileOutputStream debugFile = this.getDebugFile(null);
        int debugFileState = this.getDebugFileState();
        if (debugFileState != 2) {
            this.setStates(2);
            this.dumpLine(debugFile, "OUTPUT ==== " + uri.toExternalForm(), true);
        }
        if (headers != null) {
            new Headers(headers).write(new WriteLine(debugFile));
        }
        if (b == null) {
            this.dumpLine(debugFile, "FIRST PART", false);
        } else {
            debugFile.write(b, off, len);
        }
    }

    private synchronized void dumpPart(Map headers) throws IOException {
        FileOutputStream debugFile = this.getDebugFile(null);
        if (headers != null) {
            new Headers(headers).write(new WriteLine(debugFile));
        }
        this.dumpLine(debugFile, "NEXT PART", true);
    }

    private synchronized void dumpClose(Map headers) throws IOException {
        FileOutputStream debugFile = this.getDebugFile(null);
        if (headers != null) {
            new Headers(headers).write(new WriteLine(debugFile));
        }
        this.dumpLine(debugFile, "CLOSE", true);
        this.setStates(0);
    }

    class DebugOutputMessage
    extends OutputMessageWrapper {
        private URI uri;
        private Map headers;

        public DebugOutputMessage(OutputMessage message, URI uri) {
            super(message);
            this.uri = uri;
        }

        public void write(byte[] b) throws IOException {
            DebugInterceptor.this.dumpOutput(b, 0, b.length, this.headers, this.uri);
            this.headers = null;
            super.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            DebugInterceptor.this.dumpOutput(b, off, len, this.headers, this.uri);
            this.headers = null;
            super.write(b, off, len);
        }

        public void write(int b) throws IOException {
            DebugInterceptor.this.dumpOutput(new byte[]{(byte)b}, 0, 1, this.headers, this.uri);
            this.headers = null;
            super.write(b);
        }

        public void nextPart() throws IOException {
            DebugInterceptor.this.dumpPart(this.headers);
            this.headers = null;
            super.nextPart();
        }

        public void close() throws IOException {
            DebugInterceptor.this.dumpClose(this.headers);
            this.headers = null;
            super.close();
        }

        public void setContentType(String type) {
            if (this.headers == null) {
                this.headers = new HashMap(13);
            }
            this.headers.put("content-type", type);
            super.setContentType(type);
        }

        public void setStringHeader(String name, String value) {
            if (this.headers == null) {
                this.headers = new HashMap(13);
            }
            this.headers.put(name.toLowerCase(), value);
            super.setStringHeader(name, value);
        }

        public void setIntHeader(String name, int value) {
            if (this.headers == null) {
                this.headers = new HashMap(13);
            }
            this.headers.put(name.toLowerCase(), String.valueOf(value));
            super.setIntHeader(name, value);
        }

        public void setDateHeader(String name, long value) {
            if (this.headers == null) {
                this.headers = new HashMap(13);
            }
            this.headers.put(name.toLowerCase(), Headers.createDate(value));
            super.setDateHeader(name, value);
        }

        public void setMultipartType(String type) throws IOException {
            if (type != null) {
                if (this.headers == null) {
                    this.headers = new HashMap(13);
                }
                this.headers.put("content-type", type);
                DebugInterceptor.this.dumpOutput(null, 0, 0, this.headers, this.uri);
                this.headers = null;
            }
            super.setMultipartType(type);
        }
    }

    class DebugInputMessage
    extends InputMessageWrapper {
        private URI uri;
        private Map headers;
        private boolean firstPart = true;

        public DebugInputMessage(InputMessage message, URI uri) {
            super(message);
            this.uri = uri;
        }

        public int read(byte[] b) throws IOException {
            int n = super.read(b);
            if (n >= 0) {
                DebugInterceptor.this.dumpInput(b, 0, n, this.headers, this.uri);
                this.headers = null;
            }
            return n;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            int n = super.read(b, off, len);
            if (n >= 0) {
                DebugInterceptor.this.dumpInput(b, off, n, this.headers, this.uri);
                this.headers = null;
            }
            return n;
        }

        public int read() throws IOException {
            int n = super.read();
            if (n >= 0) {
                DebugInterceptor.this.dumpInput(new byte[]{(byte)n}, 0, 1, this.headers, this.uri);
                this.headers = null;
            }
            return n;
        }

        public boolean nextPart() throws IOException {
            if (this.firstPart) {
                this.firstPart = false;
                return super.nextPart();
            }
            DebugInterceptor.this.dumpPart(this.headers);
            this.headers = null;
            boolean nextPart = super.nextPart();
            if (nextPart) {
                this.headers = this.readHeaders();
            }
            return nextPart;
        }

        public void close() throws IOException {
            DebugInterceptor.this.dumpClose(this.headers);
            this.headers = null;
            super.close();
        }

        public String getMultipartType() throws IOException {
            this.headers = this.readHeaders();
            String mpType = super.getMultipartType();
            if (mpType != null) {
                DebugInterceptor.this.dumpInput(null, 0, 0, this.headers, this.uri);
                this.headers = this.readHeaders();
            }
            return mpType;
        }

        public long skip(long len) throws IOException {
            byte[] b = new byte[(int)len];
            int n = super.read(b);
            if (n >= 0) {
                DebugInterceptor.this.dumpInput(b, 0, n, this.headers, this.uri);
                this.headers = null;
            }
            return n;
        }

        private Map readHeaders() throws IOException {
            Set keys = this.getHeaderNames();
            if (keys == null) {
                return null;
            }
            HashMap<String, String> headers = new HashMap<String, String>(keys.size());
            Iterator i = keys.iterator();
            while (i.hasNext()) {
                String tmp = (String)i.next();
                headers.put(tmp, this.getStringHeader(tmp));
            }
            return headers;
        }
    }
}

