/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.client;

import com.idoox.wasp.SOAPServiceInfoCache;
import java.util.HashMap;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.xml.namespace.QName;
import org.idoox.wasp.wsdl.SOAPPortInfo;
import org.idoox.wasp.wsdl.SOAPServiceInfo;
import org.idoox.webservice.client.WebServiceLookupException;
import org.idoox.xml.schema.SchemaException;

public class WebServiceMetaData {
    private String wsdlURL;
    private SOAPServiceInfo[] services;
    private Class iface;
    private SOAPServiceInfo defaultService;
    private SOAPPortInfo defaultPort;
    private String endpointURI;
    private boolean hasMultipleInterfaceMappings = false;
    private Map ifaceMap;
    private Map portMap;

    public WebServiceMetaData() {
    }

    public WebServiceMetaData(SOAPServiceInfo[] services, SOAPServiceInfo defaultService, SOAPPortInfo defaultPort, Class iface, String endpointURI, String wsdlURL) {
        this.services = services;
        this.defaultService = defaultService;
        this.defaultPort = defaultPort;
        this.iface = iface;
        this.endpointURI = endpointURI;
        this.wsdlURL = wsdlURL;
    }

    public WebServiceMetaData(Definition definition, Service service, Port port, Class iface, String endpointURI) throws WebServiceLookupException {
        try {
            SOAPServiceInfo[] services = SOAPServiceInfoCache.getServices(definition);
            SOAPServiceInfo defaultService = null;
            QName serviceQName = service.getQName();
            int i = 0;
            while (i < services.length) {
                if (serviceQName.equals(services[i].getServiceQName())) {
                    defaultService = services[i];
                    break;
                }
                ++i;
            }
            if (defaultService == null) {
                throw new RuntimeException("Can not find service within this wsdl");
            }
            SOAPPortInfo defaultPort = defaultService.getPortInfo(port.getName());
            if (defaultPort == null) {
                throw new RuntimeException("Can not find port within service");
            }
            if (endpointURI == null) {
                endpointURI = defaultPort.getEndpointURI();
            }
            this.wsdlURL = definition.getDocumentBaseURI();
            this.services = services;
            this.defaultService = defaultService;
            this.defaultPort = defaultPort;
            this.iface = iface;
            this.endpointURI = endpointURI;
        }
        catch (SchemaException e) {
            throw new WebServiceLookupException(e);
        }
    }

    public WebServiceMetaData(Definition definition, Service service) throws WebServiceLookupException {
        try {
            SOAPServiceInfo[] services = SOAPServiceInfoCache.getServices(definition);
            SOAPServiceInfo defaultService = null;
            QName serviceQName = service.getQName();
            int i = 0;
            while (i < services.length) {
                if (serviceQName.equals(services[i].getServiceQName())) {
                    defaultService = services[i];
                    break;
                }
                ++i;
            }
            if (defaultService == null) {
                throw new RuntimeException("Can not find service within this wsdl");
            }
            this.wsdlURL = definition.getDocumentBaseURI();
            this.services = services;
            this.defaultService = defaultService;
        }
        catch (SchemaException e) {
            throw new WebServiceLookupException(e);
        }
    }

    public WebServiceMetaData(Definition definition, Class iface, String endpointURI, QName requestedBindingQName) throws WebServiceLookupException {
        try {
            SOAPPortInfo defaultPort;
            SOAPServiceInfo defaultService;
            SOAPServiceInfo[] services;
            block18: {
                services = SOAPServiceInfoCache.getServices(definition);
                defaultService = null;
                defaultPort = null;
                if (services.length == 1) {
                    defaultService = services[0];
                    SOAPPortInfo[] portInfos = defaultService.getPortInfos();
                    if (portInfos.length == 1) {
                        defaultPort = portInfos[0];
                    } else {
                        int i = 0;
                        while (i < portInfos.length) {
                            String pie = portInfos[i].getEndpointURI();
                            if (pie != null && pie.equals(endpointURI)) {
                                if (defaultPort == null) {
                                    defaultPort = portInfos[i];
                                    if (requestedBindingQName == null) break;
                                }
                                if (portInfos[i].getBindingExtensibilityElementQName().equals(requestedBindingQName)) {
                                    defaultPort = portInfos[i];
                                    break;
                                }
                            }
                            ++i;
                        }
                    }
                } else {
                    int j = 0;
                    while (j < services.length) {
                        SOAPPortInfo[] portInfos = services[j].getPortInfos();
                        int i = 0;
                        while (i < portInfos.length) {
                            String pie = portInfos[i].getEndpointURI();
                            if (pie != null && pie.equals(endpointURI)) {
                                if (defaultPort == null) {
                                    defaultService = services[j];
                                    defaultPort = portInfos[i];
                                    if (requestedBindingQName == null) break block18;
                                }
                                if (portInfos[i].getBindingExtensibilityElementQName().equals(requestedBindingQName)) {
                                    defaultService = services[j];
                                    defaultPort = portInfos[i];
                                    break block18;
                                }
                            }
                            ++i;
                        }
                        ++j;
                    }
                }
            }
            if (defaultService == null) {
                throw new RuntimeException("Can not find service within this wsdl");
            }
            if (defaultPort == null) {
                throw new RuntimeException("Can not find port within service");
            }
            if (endpointURI == null) {
                endpointURI = defaultPort.getEndpointURI();
            }
            this.wsdlURL = definition.getDocumentBaseURI();
            this.services = services;
            this.defaultService = defaultService;
            this.defaultPort = defaultPort;
            this.iface = iface;
            this.endpointURI = endpointURI;
        }
        catch (SchemaException e) {
            throw new WebServiceLookupException(e);
        }
    }

    public WebServiceMetaData(Definition definition, Class iface, QName requestedBindingQName) throws WebServiceLookupException {
        try {
            SOAPServiceInfo[] services = SOAPServiceInfoCache.getServices(definition);
            SOAPServiceInfo defaultService = null;
            SOAPPortInfo defaultPort = null;
            SOAPPortInfo defaultPreferredPort = null;
            int portInfoCount = 0;
            int j = 0;
            while (j < services.length) {
                SOAPPortInfo[] portInfos = services[j].getPortInfos();
                int i = 0;
                while (i < portInfos.length) {
                    if (portInfos[i].getBindingExtensibilityElementQName().equals(requestedBindingQName)) {
                        if (defaultPreferredPort == null) {
                            defaultService = services[j];
                            defaultPreferredPort = portInfos[i];
                        } else {
                            throw new WebServiceLookupException("Multiple SOAP ports found in services " + defaultService.getServiceQName() + ", " + services[j].getServiceQName());
                        }
                    }
                    if (defaultPort == null) {
                        defaultService = services[j];
                        defaultPort = portInfos[i];
                    }
                    ++portInfoCount;
                    ++i;
                }
                if (defaultPreferredPort != null) {
                    defaultPort = defaultPreferredPort;
                } else if (portInfoCount > 1) {
                    throw new WebServiceLookupException("Multiple SOAP ports found in services " + defaultService.getServiceQName() + ", " + services[j].getServiceQName());
                }
                ++j;
            }
            if (defaultService == null) {
                throw new RuntimeException("Can not find SOAP service within this wsdl");
            }
            if (defaultPort == null) {
                throw new RuntimeException("Can not find SOAP port within service");
            }
            this.wsdlURL = definition.getDocumentBaseURI();
            this.services = services;
            this.defaultService = defaultService;
            this.defaultPort = defaultPort;
            this.iface = iface;
            this.endpointURI = this.defaultPort.getEndpointURI();
        }
        catch (SchemaException e) {
            throw new WebServiceLookupException(e);
        }
    }

    public String toString() {
        StringBuffer sbRet = new StringBuffer();
        sbRet.append("WebServiceMetaData:");
        if (this.hasMultipleInterfaceMappings()) {
            Class[] ifaceA = this.getMappedInterfaces();
            if (ifaceA != null && ifaceA.length > 0) {
                int i = 0;
                while (i < ifaceA.length) {
                    sbRet.append(" [ Interface=" + ifaceA[i].getName() + " " + this.getInterfaceMapping(ifaceA[i]).toString() + " ]");
                    ++i;
                }
            }
        } else {
            if (this.defaultService != null && this.defaultService.getServiceQName() != null) {
                sbRet.append(" Service=" + this.defaultService.getServiceQName());
            }
            if (this.defaultPort != null && this.defaultPort.getPortName() != null) {
                sbRet.append(" Port=" + this.defaultPort.getPortName());
            }
            if (this.iface != null) {
                sbRet.append(" Interface=" + this.iface.getName());
            }
        }
        if (this.endpointURI != null) {
            sbRet.append(" EndpointURI=" + this.endpointURI);
        }
        return sbRet.toString();
    }

    public String getWSDLUrl() {
        return this.wsdlURL;
    }

    public void setWSDLUrl(String wsdlURL) {
        this.wsdlURL = wsdlURL;
    }

    public SOAPServiceInfo[] getServices() {
        return this.services;
    }

    public void setServices(SOAPServiceInfo[] services) {
        this.services = services;
    }

    public Class getInterface() {
        return this.iface;
    }

    public void setInterface(Class iface) {
        this.iface = iface;
    }

    public SOAPServiceInfo getService() {
        return this.defaultService;
    }

    public void setService(SOAPServiceInfo service) {
        this.defaultService = service;
    }

    public SOAPPortInfo getPort() {
        return this.defaultPort;
    }

    public void setPort(SOAPPortInfo port) {
        this.defaultPort = port;
    }

    public String getEndpointURI() {
        return this.endpointURI;
    }

    public void setEndpointURI(String endpointURI) {
        this.endpointURI = endpointURI;
    }

    public boolean hasMultipleInterfaceMappings() {
        return this.hasMultipleInterfaceMappings;
    }

    public void setInterfaceMapping(Class iface, PortInfo portInfo) {
        if (!this.hasMultipleInterfaceMappings) {
            this.hasMultipleInterfaceMappings = true;
            this.ifaceMap = new HashMap(2);
            this.portMap = new HashMap(2);
            if (this.iface != null && this.defaultPort != null && this.defaultService != null) {
                this.setInterfaceMapping(this.iface, new PortInfo(this.defaultPort, this.defaultService));
            }
        }
        this.ifaceMap.put(iface, portInfo);
        this.portMap.put(portInfo, iface);
    }

    public PortInfo getInterfaceMapping(Class iface) {
        return (PortInfo)this.ifaceMap.get(iface);
    }

    public Class getPortMapping(PortInfo portInfo) {
        return (Class)this.ifaceMap.get(portInfo);
    }

    public Class[] getMappedInterfaces() {
        return this.ifaceMap.keySet().toArray(new Class[0]);
    }

    public PortInfo[] getMappedPortInfos() {
        return this.portMap.keySet().toArray(new PortInfo[0]);
    }

    public static class PortInfo {
        private SOAPPortInfo port;
        private SOAPServiceInfo service;
        private Definition definition;
        private int hC = -1;

        public PortInfo() {
        }

        public PortInfo(SOAPPortInfo port, SOAPServiceInfo service) {
            this.port = port;
            this.service = service;
        }

        public PortInfo(SOAPPortInfo port, SOAPServiceInfo service, Definition definition) {
            this.port = port;
            this.service = service;
            this.definition = definition;
        }

        public Definition getDefinition() {
            return this.definition;
        }

        public void setDefinition(Definition definition) {
            this.definition = definition;
        }

        public SOAPPortInfo getPort() {
            return this.port;
        }

        public void setPort(SOAPPortInfo port) {
            this.port = port;
        }

        public SOAPServiceInfo getService() {
            return this.service;
        }

        public void setService(SOAPServiceInfo service) {
            this.service = service;
        }

        public int hashCode() {
            if (this.hC == -1) {
                this.hC = this.port.getPortName().hashCode() ^ this.service.getServiceQName().hashCode();
            }
            return this.hC;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof PortInfo)) {
                return false;
            }
            PortInfo toCmp = (PortInfo)obj;
            return this.port.getPortName().equals(toCmp.getPort().getPortName()) && this.service.getServiceQName().equals(toCmp.getService().getServiceQName());
        }

        public String toString() {
            StringBuffer sbRet = new StringBuffer();
            sbRet.append("PortInfo:");
            if (this.service != null) {
                sbRet.append(" Service=");
                sbRet.append(this.service.getServiceQName().toString());
            }
            if (this.port != null) {
                sbRet.append(" Port=");
                sbRet.append(this.port.getPortName());
            }
            return sbRet.toString();
        }
    }
}

