/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.classloader;

import com.idoox.wasp.classloader.ClassHolder;
import com.idoox.wasp.classloader.ClassPath;
import com.idoox.wasp.classloader.Resource;
import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.SocketPermission;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.SecureClassLoader;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public class WaspClassLoader
extends SecureClassLoader {
    private AccessControlContext acc;
    private ClassPath classPath;
    private ClassLoader[] parents = null;

    public WaspClassLoader(URL[] urls) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkCreateClassLoader();
        }
        this.acc = AccessController.getContext();
        this.classPath = new ClassPath(urls);
    }

    public WaspClassLoader(URL[] urls, ClassLoader parent) {
        super(parent);
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkCreateClassLoader();
        }
        this.acc = AccessController.getContext();
        this.classPath = new ClassPath(urls);
    }

    public WaspClassLoader(URL[] urls, ClassLoader[] parents) {
        this.parents = parents;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkCreateClassLoader();
        }
        this.acc = AccessController.getContext();
        this.classPath = new ClassPath(urls);
    }

    protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> c = this.findLoadedClass(name);
        if (c == null) {
            if (this.parents != null) {
                int i = 0;
                while (i < this.parents.length) {
                    try {
                        c = this.parents[i].loadClass(name);
                        break;
                    }
                    catch (ClassNotFoundException e) {
                        ++i;
                    }
                }
            } else {
                return super.loadClass(name, resolve);
            }
            if (c == null) {
                c = this.findClass(name);
            }
        }
        if (resolve) {
            this.resolveClass(c);
        }
        return c;
    }

    public URL getResource(String name) {
        URL url = null;
        if (this.parents != null) {
            int i = 0;
            while (i < this.parents.length) {
                url = this.parents[i].getResource(name);
                if (url == null) {
                    ++i;
                    continue;
                }
                break;
            }
        } else {
            url = super.getResource(name);
        }
        if (url == null) {
            url = this.findResource(name);
        }
        return url;
    }

    public InputStream getResourceAsStream(String name) {
        URL url = this.getResource(name);
        try {
            return url != null ? url.openStream() : null;
        }
        catch (IOException e) {
            return null;
        }
    }

    protected Class findClass(final String name) throws ClassNotFoundException {
        try {
            return (Class)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws ClassNotFoundException {
                    String path = name.replace('.', '/').concat(".class");
                    ClassHolder classHolder = WaspClassLoader.this.classPath.getClassHolder(path);
                    if (classHolder != null) {
                        return WaspClassLoader.this.defineClass(name, classHolder);
                    }
                    throw new ClassNotFoundException(name);
                }
            }, this.acc);
        }
        catch (PrivilegedActionException e) {
            throw (ClassNotFoundException)e.getException();
        }
    }

    private Class defineClass(String name, ClassHolder classHolder) throws ClassNotFoundException {
        try {
            Resource res = null;
            res = classHolder.getClassResource();
            if (res != null) {
                URL url = new URL(res.getUrl(), name.replace('.', '/').concat(".class"));
                int i = name.lastIndexOf(46);
                if (i != -1) {
                    String pkgname = name.substring(0, i);
                    Package pkg = this.getPackage(pkgname);
                    Manifest man = res.getManifest();
                    if (pkg != null) {
                        boolean ok;
                        if (pkg.isSealed()) {
                            ok = pkg.isSealed();
                        } else {
                            boolean bl = ok = man == null || !this.isSealed(pkgname, man);
                        }
                        if (!ok) {
                            throw new SecurityException("sealing violation");
                        }
                    } else if (man != null) {
                        this.definePackage(pkgname, man, url);
                    } else {
                        this.definePackage(pkgname, null, null, null, null, null, null, null);
                    }
                }
                Certificate[] certificates = res.getCertificates(name);
                CodeSource codeSource = new CodeSource(url, certificates);
                byte[] bytes = null;
                bytes = classHolder.getClassBytes();
                if (bytes != null) {
                    return this.defineClass(name, bytes, 0, bytes.length, codeSource);
                }
            }
        }
        catch (MalformedURLException e) {
            throw new ClassNotFoundException(name, e);
        }
        catch (IOException e) {
            throw new ClassNotFoundException(name, e);
        }
        throw new ClassNotFoundException(name);
    }

    protected Package definePackage(String name, Manifest man, URL url) throws IllegalArgumentException {
        String path = name.replace('.', '/').concat("/");
        String specTitle = null;
        String specVersion = null;
        String specVendor = null;
        String implTitle = null;
        String implVersion = null;
        String implVendor = null;
        String sealed = null;
        URL sealBase = null;
        Attributes attr = man.getAttributes(path);
        if (attr != null) {
            specTitle = attr.getValue(Attributes.Name.SPECIFICATION_TITLE);
            specVersion = attr.getValue(Attributes.Name.SPECIFICATION_VERSION);
            specVendor = attr.getValue(Attributes.Name.SPECIFICATION_VENDOR);
            implTitle = attr.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
            implVersion = attr.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            implVendor = attr.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
            sealed = attr.getValue(Attributes.Name.SEALED);
        }
        if ((attr = man.getMainAttributes()) != null) {
            if (specTitle == null) {
                specTitle = attr.getValue(Attributes.Name.SPECIFICATION_TITLE);
            }
            if (specVersion == null) {
                specVersion = attr.getValue(Attributes.Name.SPECIFICATION_VERSION);
            }
            if (specVendor == null) {
                specVendor = attr.getValue(Attributes.Name.SPECIFICATION_VENDOR);
            }
            if (implTitle == null) {
                implTitle = attr.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
            }
            if (implVersion == null) {
                implVersion = attr.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            }
            if (implVendor == null) {
                implVendor = attr.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
            }
            if (sealed == null) {
                sealed = attr.getValue(Attributes.Name.SEALED);
            }
        }
        if ("true".equalsIgnoreCase(sealed)) {
            sealBase = url;
        }
        return this.definePackage(name, specTitle, specVersion, specVendor, implTitle, implVersion, implVendor, sealBase);
    }

    private boolean isSealed(String name, Manifest man) {
        String path = name.replace('.', '/').concat("/");
        Attributes attr = man.getAttributes(path);
        String sealed = null;
        if (attr != null) {
            sealed = attr.getValue(Attributes.Name.SEALED);
        }
        if (sealed == null && (attr = man.getMainAttributes()) != null) {
            sealed = attr.getValue(Attributes.Name.SEALED);
        }
        return "true".equalsIgnoreCase(sealed);
    }

    protected URL findResource(final String name) {
        try {
            return (URL)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() {
                    try {
                        Resource res;
                        ClassHolder classHolder = WaspClassLoader.this.classPath.getClassHolder(name);
                        if (classHolder != null && (res = classHolder.getClassResource()) != null) {
                            URL url = new URL(res.getUrl(), name);
                            return url;
                        }
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                    return null;
                }
            }, this.acc);
        }
        catch (PrivilegedActionException e) {
            return null;
        }
    }

    protected Enumeration findResources(final String name) throws IOException {
        final Enumeration en = this.classPath.getResources(name);
        return new Enumeration(){
            private Resource resource;

            public Object nextElement() {
                try {
                    if (this.resource == null) {
                        throw new NoSuchElementException();
                    }
                    Resource res = this.resource;
                    this.resource = null;
                    URL url = new URL(res.getUrl(), name);
                    return url;
                }
                catch (MalformedURLException e) {
                    throw new NoSuchElementException();
                }
            }

            public boolean hasMoreElements() {
                try {
                    Resource res;
                    if (this.resource != null) {
                        return true;
                    }
                    while ((res = (Resource)AccessController.doPrivileged(new PrivilegedExceptionAction(this){
                        private final /* synthetic */ 3 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public Object run() {
                            if (!3.access$200(this.this$1).hasMoreElements()) {
                                return null;
                            }
                            return 3.access$200(this.this$1).nextElement();
                        }
                    }, WaspClassLoader.this.acc)) != null) {
                        this.resource = res;
                        if (this.resource == null) continue;
                    }
                    return this.resource != null;
                }
                catch (PrivilegedActionException e) {
                    return false;
                }
            }

            static /* synthetic */ Enumeration access$200(3 x0) {
                return x0.en;
            }
        };
    }

    protected PermissionCollection getPermissions(CodeSource codesource) {
        String path;
        Permission p;
        PermissionCollection perms = super.getPermissions(codesource);
        URL url = codesource.getLocation();
        try {
            p = url.openConnection().getPermission();
        }
        catch (IOException ioe) {
            p = null;
        }
        if (p instanceof FilePermission) {
            path = p.getName();
            if (path.endsWith(File.separator)) {
                path = path + "-";
                p = new FilePermission(path, "read");
            }
        } else if (p == null && url.getProtocol().equals("file")) {
            path = url.getFile().replace('/', File.separatorChar);
            if (path.endsWith(File.separator)) {
                path = path + "-";
            }
            p = new FilePermission(path, "read");
        } else {
            String host = url.getHost();
            if (host == null) {
                host = "localhost";
            }
            p = new SocketPermission(host, "connect, accept");
        }
        if (p != null) {
            final SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                final Permission fp = p;
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() throws SecurityException {
                        sm.checkPermission(fp);
                        return null;
                    }
                }, this.acc);
            }
            perms.add(p);
        }
        return perms;
    }

    public void releaseResource(URL url) throws IOException {
        this.classPath.relaeseResource(url);
    }

    public void releaseAllResources() throws IOException {
        this.classPath.releaseAllResources();
    }
}

