/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp;

import com.idoox.util.xml.DOMWriter;
import com.idoox.wasp.WSDLPortInfo;
import com.idoox.wasp.WSDLSchemas;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.xml.namespace.QName;
import org.idoox.util.RuntimeWrappedException;
import org.idoox.wasp.wsdl.SOAPPortInfo;
import org.idoox.wasp.wsdl.SOAPServiceInfo;
import org.idoox.xml.schema.SchemaException;

public class WSDLServiceInfo
implements SOAPServiceInfo {
    private Definition definition;
    private Service service;
    private String documentation;
    private Map portNameToPortInfo = new HashMap();
    private Map portTypeNameToPortInfoNames = new HashMap();
    private SOAPPortInfo[] portInfos;
    private WSDLSchemas wsdlSchemas;

    public WSDLServiceInfo(Definition definition, Service service, WSDLSchemas wsdlSchemas) throws SchemaException {
        this.definition = definition;
        this.service = service;
        this.documentation = DOMWriter.serializeContent(service.getDocumentationElement(), true);
        this.wsdlSchemas = wsdlSchemas;
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public QName getServiceQName() {
        return this.service.getQName();
    }

    public synchronized SOAPPortInfo[] getPortInfos(QName portTypeName) {
        if (portTypeName == null) {
            return null;
        }
        String[] names = (String[])this.portTypeNameToPortInfoNames.get(portTypeName);
        if (names == null) {
            Map servicePorts = this.service.getPorts();
            ArrayList<String> retArrayList = new ArrayList<String>();
            Iterator it = servicePorts.keySet().iterator();
            while (it.hasNext()) {
                String currPortName = (String)it.next();
                Port port = (Port)servicePorts.get(currPortName);
                Binding binding = port.getBinding();
                PortType portType = binding.getPortType();
                if (!portTypeName.equals(portType.getQName())) continue;
                retArrayList.add(port.getName());
            }
            names = new String[retArrayList.size()];
            names = retArrayList.toArray(names);
            this.portTypeNameToPortInfoNames.put(portTypeName, names);
        }
        SOAPPortInfo[] ret = new SOAPPortInfo[names.length];
        int i = 0;
        while (i < names.length) {
            ret[i] = this.getPortInfo(names[i]);
            ++i;
        }
        return ret;
    }

    public synchronized SOAPPortInfo[] getPortInfos() {
        if (this.portInfos != null) {
            return this.portInfos;
        }
        try {
            Map ports = this.service.getPorts();
            if (ports.size() == 0) {
                this.portInfos = new SOAPPortInfo[0];
                return this.portInfos;
            }
            this.portInfos = new SOAPPortInfo[ports.size()];
            int i = 0;
            Iterator it = ports.values().iterator();
            while (it.hasNext()) {
                Port port = (Port)it.next();
                Binding binding = port.getBinding();
                WSDLPortInfo ret = new WSDLPortInfo(this, this.definition, this.service, port, binding, binding.getPortType(), this.wsdlSchemas);
                this.portNameToPortInfo.put(port.getName(), ret);
                this.portInfos[i++] = ret;
            }
            return this.portInfos;
        }
        catch (SchemaException e) {
            throw new RuntimeWrappedException(e);
        }
    }

    public synchronized SOAPPortInfo getPortInfo(String portName) {
        if (portName == null) {
            return null;
        }
        try {
            SOAPPortInfo ret = (SOAPPortInfo)this.portNameToPortInfo.get(portName);
            if (ret != null) {
                return ret;
            }
            Port port = this.service.getPort(portName);
            if (port == null) {
                return null;
            }
            Binding binding = port.getBinding();
            ret = new WSDLPortInfo(this, this.definition, this.service, port, binding, binding.getPortType(), this.wsdlSchemas);
            this.portNameToPortInfo.put(portName, ret);
            return ret;
        }
        catch (SchemaException e) {
            throw new RuntimeWrappedException(e);
        }
    }

    public synchronized WSDLSchemas getWSDLSchemas() {
        return this.wsdlSchemas;
    }

    public synchronized Definition getDefinition() {
        return this.definition;
    }
}

