/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp;

import com.idoox.debug.Category;
import com.idoox.wasp.ClassSpace;
import com.idoox.wasp.ClassSpaceHelper;
import com.idoox.wasp.InitialReferencesRegistrar;
import com.idoox.wasp.config.ProtocolConfig;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPException;
import org.idoox.config.Configurable;
import org.idoox.config.Configurator;
import org.idoox.wasp.Context;
import org.idoox.wasp.Module;
import org.idoox.wasp.ProtocolHandler;
import org.idoox.wasp.ProtocolRepository;
import org.idoox.wasp.UnknownProtocolException;
import org.systinet.wasp.IWasp;

public class ProtocolRepositoryImpl
implements ProtocolRepository,
Module {
    private static final Category cat = Category.getCategory("com.idoox.wasp.ProtocolRepositoryImpl");
    Map protocolHandlers;
    Map protocolHandlerNames;
    private String defaultProtocol;
    static /* synthetic */ Class class$com$idoox$wasp$config$ProtocolConfig;
    static /* synthetic */ Class class$org$idoox$wasp$ProtocolHandler;

    public ProtocolHandler getProtocolHandler(String protocol) throws UnknownProtocolException {
        try {
            return (ProtocolHandler)((Object)this.createMessageFactory(protocol));
        }
        catch (SOAPException e) {
            throw new UnknownProtocolException(e);
        }
    }

    public MessageFactory createMessageFactory(String protocol) throws SOAPException {
        Class ret = protocol == null ? (Class)this.protocolHandlers.get(this.defaultProtocol) : (Class)this.protocolHandlers.get(protocol);
        if (ret == null) {
            throw new SOAPException("Protocol " + protocol + " has not been found");
        }
        try {
            return (MessageFactory)ret.newInstance();
        }
        catch (Exception e) {
            throw new SOAPException(e);
        }
    }

    public Set getProtocolNames() {
        return this.protocolHandlers.keySet();
    }

    public void load(Configurable moduleConfig) {
        this.protocolHandlers = new HashMap();
        this.protocolHandlerNames = new HashMap();
        Configurator configurator = (Configurator)Context.getInstance("org.idoox.config.Configurator");
        Configurable[] protocols = Configurator.getTopEntries("protocol");
        int i = 0;
        while (i < protocols.length) {
            ProtocolConfig config = (ProtocolConfig)protocols[i].narrow(class$com$idoox$wasp$config$ProtocolConfig == null ? ProtocolRepositoryImpl.class$("com.idoox.wasp.config.ProtocolConfig") : class$com$idoox$wasp$config$ProtocolConfig);
            String configName = config.getName();
            String protocolHandlerClassName = config.getHandler();
            String protocolHandlerClassSpaceName = config.getClassSpace();
            if (protocolHandlerClassSpaceName == null) {
                throw new RuntimeException("Config file does not contain class space for protocolHandler " + configName);
            }
            ClassSpace protocolHandlerClassSpace = ClassSpaceHelper.getClassSpace(protocolHandlerClassSpaceName);
            if (protocolHandlerClassSpace == null) {
                throw new RuntimeException("Could not find class space '" + protocolHandlerClassSpaceName + "' for protocolHandler " + configName);
            }
            try {
                ProtocolHandler m = (ProtocolHandler)protocolHandlerClassSpace.createInstance(class$org$idoox$wasp$ProtocolHandler == null ? ProtocolRepositoryImpl.class$("org.idoox.wasp.ProtocolHandler") : class$org$idoox$wasp$ProtocolHandler, protocolHandlerClassName);
                if (m == null) {
                    cat.error("Could not access protocolHandler " + protocolHandlerClassName + " in class space " + protocolHandlerClassSpaceName);
                } else {
                    Class protocolHandlerClass = protocolHandlerClassSpace.getClass(class$org$idoox$wasp$ProtocolHandler == null ? ProtocolRepositoryImpl.class$("org.idoox.wasp.ProtocolHandler") : class$org$idoox$wasp$ProtocolHandler, protocolHandlerClassName);
                    this.protocolHandlers.put(configName, protocolHandlerClass);
                    this.protocolHandlerNames.put(protocolHandlerClass, configName);
                }
            }
            catch (Exception e) {
                cat.error("Exception in protocolHandler " + configName + ", protocolHandler " + protocolHandlerClassName + ", class space " + protocolHandlerClassSpaceName + " : ", e);
            }
            ++i;
        }
        try {
            IWasp iWasp = (IWasp)Context.getInstance("org.systinet.wasp.Wasp");
            this.defaultProtocol = iWasp.getDefaultXMLProtocols()[0];
        }
        catch (Exception e) {
            cat.error("Cannot gen value for 'defaultProtocol' from configuration! Using 'soap11' as the default value!");
            this.defaultProtocol = "soap11";
        }
        if (!this.protocolHandlers.containsKey(this.defaultProtocol)) {
            cat.info("Invalid default protocol specified");
        }
        InitialReferencesRegistrar.addInitialReference("org.idoox.wasp.ProtocolRepository", this);
    }

    public void init() {
    }

    public void destroy() {
    }

    public String registerProtocol(String name, Class protoHandlerClass) {
        if (this.protocolHandlers.containsKey(name)) {
            throw new IllegalArgumentException("protocol already registered: " + name);
        }
        this.protocolHandlers.put(name, protoHandlerClass);
        return name;
    }

    public void unregisterProtocol(String name) {
        if (!this.protocolHandlers.containsKey(name)) {
            throw new IllegalArgumentException("protocol not registered: " + name);
        }
        Object removed = this.protocolHandlers.remove(name);
        this.protocolHandlerNames.remove(removed);
    }

    public void setDefaultProtocol(String name) {
        if (!this.protocolHandlers.containsKey(name)) {
            throw new IllegalArgumentException("protocol not registered: " + name);
        }
        this.defaultProtocol = name;
    }

    public String getDefaultProtocol() {
        return this.defaultProtocol;
    }

    public String getProtocolHandlerName(ProtocolHandler handler) {
        String name = (String)this.protocolHandlerNames.get(handler.getClass());
        if (name == null) {
            throw new IllegalArgumentException("protocol name not found for: " + handler.getClass());
        }
        return name;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

