/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp;

import com.idoox.debug.Category;
import com.idoox.wasp.HProcessor;
import com.systinet.wasp.webservice.ServiceEndpointImpl;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.idoox.webservice.CallContext;
import org.idoox.xml.DeclaredPrefixesStack;
import org.idoox.xml.Token;
import org.idoox.xml.Tokenizer;
import org.idoox.xml.TokenizerException;
import org.idoox.xmlrpc.Constants;
import org.idoox.xmlrpc.Message;
import org.idoox.xmlrpc.MultipleHeadersException;
import org.idoox.xmlrpc.header.HeaderProcessingException;
import org.systinet.wasp.webservice.Current;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class InstanceIDHeaderProcessor
implements HProcessor {
    private static final Category log = Category.getCategory("com.idoox.wasp.InstanceIDHeaderProcessor");
    static final String INCOMMING_ID = "com.idoox.wasp.InstanceIDHeaderProcessor.incommingID";
    public static final String INSTID_HEADER_NS = "http://idoox.com/interface";
    static final String INSTID_HEADER_NAME = "instance";
    public static final QName INSTID_QNAME = new QName("http://idoox.com/interface", "instance");
    private QName INSTID_HEADER_ID_NAME;
    private QName INSTID_HEADER_SETID_NAME;
    private QName INSTID_HEADER_NOTFOUND_NAME;
    private boolean headerCreated;
    private int processingType = -1;

    public boolean wasHeaderCreated() {
        return this.headerCreated;
    }

    private int getProcessingType() {
        if (this.processingType == -1) {
            this.processingType = Current.getProcessingType();
        }
        return this.processingType;
    }

    public void processOutput(Message message) throws HeaderProcessingException {
        this.headerCreated = false;
        if (this.getProcessingType() == 2) {
            Object incommingID;
            Map callContext = Current.getCallContext().getContextData();
            Object id = callContext.get("wasp.service.instance.id");
            if (id != null && !id.equals(incommingID = callContext.get(INCOMMING_ID))) {
                this.processServerOutput(message, id);
            }
            return;
        }
        Map context = Current.getServiceClientContext().getContextData();
        Object id = context.get("wasp.service.instance.id");
        if (id != null) {
            this.processClientOutput(message, id);
        }
    }

    public void processOutputFault(Message message) throws HeaderProcessingException {
        this.headerCreated = false;
        Map context = Current.getCallContext().getContextData();
        if (context.containsKey(CallContext.INVALID_INSTANCE_ID_KEY)) {
            this.initQNames();
            InstanceIDCreatingTokenizer header = new InstanceIDCreatingTokenizer(this.INSTID_HEADER_NOTFOUND_NAME, context.get(CallContext.INVALID_INSTANCE_ID_KEY).toString());
            HashMap properties = new HashMap();
            try {
                message.addHeader(INSTID_QNAME, properties, header);
                this.headerCreated = true;
            }
            catch (IOException e) {
                log.error("an IOException occurred when adding the instanceID header", e);
                throw new HeaderProcessingException("IOException when adding the instanceID header.");
            }
        }
    }

    public void processInputFault(Message message) throws HeaderProcessingException {
    }

    public void processInput(Message message) throws HeaderProcessingException {
        Tokenizer header;
        this.initQNames();
        if (message == null) {
            return;
        }
        try {
            header = message.getHeader(INSTID_QNAME);
            if (header != null) {
                message.removeHeader(INSTID_QNAME);
            }
        }
        catch (MultipleHeadersException e) {
            log.error("Too many instanceIDs headers present in one message.");
            throw new HeaderProcessingException("Multiple instanceID headers present in one message.");
        }
        if (header == null) {
            return;
        }
        try {
            byte state = header.next();
            while (state == 2 || state == 4) {
                if (state == 4) {
                    state = header.next();
                    continue;
                }
                if (this.INSTID_HEADER_ID_NAME.getLocalPart().equals(header.getLocalName()) || this.INSTID_HEADER_SETID_NAME.getLocalPart().equals(header.getLocalName())) break;
                int depth = 1;
                do {
                    state = header.next();
                    switch (state) {
                        case 2: {
                            ++depth;
                            break;
                        }
                        case 3: {
                            --depth;
                            break;
                        }
                        case 1: {
                            log.error("Unexpected tokenizer end of document in instanceID header.");
                            throw new HeaderProcessingException("Unexpected tokenizer end of document in instanceID header.");
                        }
                    }
                } while (depth > 0);
                state = header.next();
            }
            if (state != 2) {
                log.error("no unqualified <id> or <setId> element in the instanceID header");
                throw new HeaderProcessingException("No unqualified <id> or <setId> element in the instanceID header.");
            }
            boolean isSetId = false;
            if (this.INSTID_HEADER_SETID_NAME.getLocalPart().equals(header.getLocalName())) {
                isSetId = true;
            }
            if ((state = header.next()) == 3) {
                log.error("empty <id> or <setId> element - the header shouldn't have been there at all");
                throw new HeaderProcessingException("empty <id> or <setId> element - the header shouldn't have been there at all");
            }
            if (state == 2) {
                log.error("<id> or <setId> element is invalid for it has children");
                throw new HeaderProcessingException("<id> or <setId> element is invalid for it has children");
            }
            if (state != 4) {
                log.error("malformed <id> or <setId> element");
                throw new HeaderProcessingException("malformed <id> or <setId> element");
            }
            String key = header.readContent();
            Map context = Current.getCallContext().getContextData();
            if (isSetId) {
                if (this.getProcessingType() != 1) {
                    log.warn("setID on something that is not a stub");
                    return;
                }
                Current.getServiceClientContext().getContextData().put(CallContext.INSTANCE_ID_KEY, key);
            } else {
                context.put("wasp.service.instance.id", key);
                context.put(INCOMMING_ID, key);
            }
            state = header.next();
            if (state != 3) {
                log.error("malformed <id> or <setId> element");
                throw new HeaderProcessingException("malformed <id> or <setId> element");
            }
        }
        catch (IOException e) {
            log.error("an IOException occurred when reading the instanceID header", e);
            throw new HeaderProcessingException("IOException when trying to parse the instanceID header.");
        }
        catch (TokenizerException e) {
            log.error("a tokenizer exception occurred when reading the instanceID header", e);
            throw new HeaderProcessingException("Tokenizer exception when trying to parse the instanceID header.");
        }
    }

    private int getUse() {
        if (this.getProcessingType() == 2) {
            return ((ServiceEndpointImpl)Current.getServiceEndpointContext().getServiceEndpoint()).getUse();
        }
        String encodingURI = (String)Current.getCallContext().getContextData().get("wasp.encodingURI");
        if (encodingURI == null) {
            return 1;
        }
        return 0;
    }

    private void initQNames() {
        this.INSTID_HEADER_ID_NAME = new QName(this.getUse() == 0 ? null : INSTID_HEADER_NS, "id");
        this.INSTID_HEADER_SETID_NAME = new QName(this.getUse() == 0 ? null : INSTID_HEADER_NS, "setId");
        this.INSTID_HEADER_NOTFOUND_NAME = new QName(this.getUse() == 0 ? null : INSTID_HEADER_NS, "notFound");
    }

    public void processClientOutput(Message message, Object id) throws HeaderProcessingException {
        this.initQNames();
        InstanceIDCreatingTokenizer header = new InstanceIDCreatingTokenizer(this.INSTID_HEADER_ID_NAME, id.toString());
        HashMap<QName, String> properties = new HashMap<QName, String>();
        properties.put(Constants.MUST_UNDERSTAND_PROPERTY, "1");
        try {
            message.addHeader(INSTID_QNAME, properties, header);
            this.headerCreated = true;
        }
        catch (IOException e) {
            log.error("an IOException occurred when adding the instanceID header", e);
            throw new HeaderProcessingException("IOException when adding the instanceID header.");
        }
    }

    public void processServerOutput(Message message, Object key) throws HeaderProcessingException {
        this.initQNames();
        InstanceIDCreatingTokenizer header = new InstanceIDCreatingTokenizer(this.INSTID_HEADER_SETID_NAME, key.toString());
        HashMap<QName, String> properties = new HashMap<QName, String>();
        properties.put(Constants.MUST_UNDERSTAND_PROPERTY, "1");
        try {
            message.addHeader(INSTID_QNAME, properties, header);
            this.headerCreated = true;
        }
        catch (IOException e) {
            log.error("an IOException occurred when adding the instanceID header", e);
            throw new HeaderProcessingException("IOException when adding the instanceID header.");
        }
    }

    class InstanceIDCreatingTokenizer
    implements Tokenizer {
        private String theID;
        private QName memberName;
        private int count = 0;
        private QName name = null;
        private byte state = 0;
        private String content = null;

        InstanceIDCreatingTokenizer(QName memberName, String id) {
            this.theID = id;
            this.memberName = memberName;
            try {
                this.next();
            }
            catch (TokenizerException e) {
                // empty catch block
            }
        }

        public byte next() throws TokenizerException {
            switch (this.count) {
                case 0: {
                    this.name = this.memberName;
                    this.state = (byte)2;
                    ++this.count;
                    break;
                }
                case 1: {
                    this.name = null;
                    this.state = (byte)4;
                    this.content = this.theID;
                    ++this.count;
                    break;
                }
                case 2: {
                    this.name = this.memberName;
                    this.state = (byte)3;
                    this.content = null;
                    ++this.count;
                    break;
                }
                case 3: {
                    this.state = 1;
                    ++this.count;
                    break;
                }
                default: {
                    throw new TokenizerException("next() after the end of the document!");
                }
            }
            return this.state;
        }

        public String getLocalName() throws TokenizerException {
            if (this.state == 0) {
                throw new TokenizerException("Invalid state.");
            }
            return this.name.getLocalPart();
        }

        public String getNamespace() throws TokenizerException {
            if (this.state == 0) {
                throw new TokenizerException("Invalid state.");
            }
            return this.name.getNamespaceURI();
        }

        public String getNamespaceForPrefix(String prefix) {
            return null;
        }

        public QName parseQName(String qName) {
            return null;
        }

        public byte currentState() {
            return this.state;
        }

        public String readContent() throws TokenizerException {
            if (this.state != 4) {
                throw new TokenizerException("Invalid state.");
            }
            return this.content;
        }

        public void readToken(Token stoken) throws TokenizerException {
            if (stoken == null) {
                throw new TokenizerException("Null token to fill.");
            }
            stoken.clear();
            stoken.type = this.state;
            stoken.uri = this.name.getNamespaceURI();
            stoken.localName = this.name.getLocalPart();
        }

        public boolean whitespaceContent() throws TokenizerException {
            if (this.state != 4) {
                throw new TokenizerException("Invalid state.");
            }
            return false;
        }

        public Map getCurrentPrefixMap() {
            return null;
        }

        public int pushNewlyDeclaredPrefixes(DeclaredPrefixesStack prefixes) {
            return 0;
        }

        public Element getDOMRepresentation(Document doc) throws TokenizerException {
            throw new UnsupportedOperationException("not supported");
        }
    }
}

