/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp;

import com.idoox.debug.Category;
import com.idoox.util.Pool;
import com.idoox.wasp.ClassSpace;
import com.idoox.wasp.ClassSpaceHelper;
import com.idoox.wasp.InitialReferencesRegistrar;
import com.idoox.wasp.config.ClassHolderConfig;
import com.idoox.wasp.config.EncodingConfig;
import com.idoox.wasp.config.EncodingRepositoryConfig;
import com.idoox.wasp.serialization.SerializationRepositoryImpl;
import java.util.HashMap;
import java.util.Map;
import org.idoox.config.Configurable;
import org.idoox.config.Configurator;
import org.idoox.util.RuntimeWrappedException;
import org.idoox.wasp.Context;
import org.idoox.wasp.Module;
import org.idoox.xmlrpc.encoding.EncodingTokenWriter;
import org.idoox.xmlrpc.encoding.EncodingTokenizer;
import org.idoox.xmlrpc.encoding.NoSuchEncodingException;

public class EncodingRepository
implements com.idoox.xmlrpc.encoding.EncodingRepository,
Module {
    private static final Category cat = Category.getCategory("com.idoox.wasp.EncodingRepository");
    Configurator configurator;
    private HashMap encodingIdToEncodingMap = new HashMap(47, 0.75f);
    private Map defaultEncodingMap;
    private EncodingRecord defaultEncodingRecord;
    private String defaultEncodingId;
    private String defaultEncoding;
    static /* synthetic */ Class class$com$idoox$wasp$config$EncodingConfig;
    static /* synthetic */ Class class$com$idoox$wasp$config$EncodingRepositoryConfig;
    static /* synthetic */ Class class$org$idoox$xmlrpc$encoding$EncodingTokenizer;
    static /* synthetic */ Class class$org$idoox$xmlrpc$encoding$EncodingTokenWriter;

    public EncodingRepository() {
        this.configurator = (Configurator)Context.getInstance("org.idoox.config.Configurator");
    }

    private EncodingRecord getEncodingRecord(String encodingId, String encodingURI) throws NoSuchEncodingException {
        try {
            Map encodingMap;
            if (encodingURI == null) {
                encodingURI = this.defaultEncoding;
            }
            EncodingRecord r = null;
            if (encodingId != null) {
                encodingMap = (Map)this.encodingIdToEncodingMap.get(encodingId);
                if (encodingMap == null) {
                    throw new NoSuchEncodingException("Encoding with id " + encodingId + " has not been found");
                }
            } else {
                if (this.defaultEncodingMap == null) {
                    this.defaultEncodingMap = (Map)this.encodingIdToEncodingMap.get(this.defaultEncodingId);
                }
                if ((encodingMap = this.defaultEncodingMap) == null) {
                    throw new NoSuchEncodingException("Default encoding with id " + this.defaultEncodingId + " has not been found");
                }
                if (encodingURI == "http://schemas.xmlsoap.org/soap/encoding/") {
                    if (this.defaultEncodingRecord == null) {
                        this.defaultEncodingRecord = (EncodingRecord)encodingMap.get(encodingURI);
                    }
                    r = this.defaultEncodingRecord;
                }
            }
            if (r == null) {
                r = (EncodingRecord)encodingMap.get(encodingURI);
            }
            if (r == null) {
                throw new NoSuchEncodingException("No encoding " + encodingId + " for encoding uri " + encodingURI);
            }
            return r;
        }
        catch (Exception e) {
            cat.error("No encoding handlers for [" + encodingId + ", " + encodingURI + "]");
            throw new NoSuchEncodingException("No encoding " + encodingId + " for encoding uri " + encodingURI);
        }
    }

    public EncodingTokenizer getEncodingTokenizer(String encodingId, String encodingURI) throws NoSuchEncodingException {
        EncodingRecord r = this.getEncodingRecord(encodingId, encodingURI);
        return (EncodingTokenizer)r.tokenizerPool.get();
    }

    public void releaseEncodingTokenizer(String encodingId, String encodingURI, EncodingTokenizer tokenizer) throws NoSuchEncodingException {
        EncodingRecord r = this.getEncodingRecord(encodingId, encodingURI);
        r.tokenizerPool.release(tokenizer);
    }

    public EncodingTokenWriter getEncodingTokenWriter(String encodingId, String encodingURI) throws NoSuchEncodingException {
        EncodingRecord r = this.getEncodingRecord(encodingId, encodingURI);
        return (EncodingTokenWriter)r.tokenWriterPool.get();
    }

    public void releaseEncodingTokenWriter(String encodingId, String encodingURI, EncodingTokenWriter tokenWriter) throws NoSuchEncodingException {
        EncodingRecord r = this.getEncodingRecord(encodingId, encodingURI);
        r.tokenWriterPool.release(tokenWriter);
    }

    public void load(Configurable c) {
        InitialReferencesRegistrar.addInitialReference("com.idoox.xmlrpc.encoding.EncodingRepository", this);
        Configurator configurator = (Configurator)Context.getInstance("org.idoox.config.Configurator");
        Configurable[] encodings = Configurator.getTopEntries("encoding");
        int i = 0;
        while (i < encodings.length) {
            EncodingConfig config = (EncodingConfig)encodings[i].narrow(class$com$idoox$wasp$config$EncodingConfig == null ? EncodingRepository.class$("com.idoox.wasp.config.EncodingConfig") : class$com$idoox$wasp$config$EncodingConfig);
            try {
                this.loadEncoding(config, encodings[i]);
            }
            catch (Exception e) {
                cat.error("Exception in encoding " + config.getName() + " : ", e);
            }
            ++i;
        }
        EncodingRepositoryConfig ec = (EncodingRepositoryConfig)c.narrow(class$com$idoox$wasp$config$EncodingRepositoryConfig == null ? (class$com$idoox$wasp$config$EncodingRepositoryConfig = EncodingRepository.class$("com.idoox.wasp.config.EncodingRepositoryConfig")) : class$com$idoox$wasp$config$EncodingRepositoryConfig);
        this.defaultEncoding = ec.getDefaultEncoding();
        this.defaultEncodingId = ec.getDefaultEncodingId();
    }

    private void loadEncoding(EncodingConfig config, Configurable rawConfig) throws Exception {
        HashMap<String, EncodingRecord> encodingMap = (HashMap<String, EncodingRecord>)this.encodingIdToEncodingMap.get(config.getName());
        if (encodingMap == null) {
            encodingMap = new HashMap<String, EncodingRecord>(11, 0.75f);
            this.encodingIdToEncodingMap.put(config.getName(), encodingMap);
        }
        EncodingConfig.EncodingInstanceConfig[] cfgs = config.getEncodingInstances();
        int instance = 0;
        while (instance < cfgs.length) {
            Integer poolSizeInteger;
            String poolClassName;
            Configurable tokenizerConfigurable = null;
            Configurable tokenWriterConfigurable = null;
            ClassHolderConfig h = cfgs[instance].getTokenizer();
            String tokenizerClassName = null;
            String tokenWriterClassName = null;
            if (h == null) {
                cat.warn("No encoding tokenizer for " + config.getName() + ", instance " + cfgs[instance].getName());
            } else {
                tokenizerConfigurable = Configurator.getConfigurable(h);
                tokenizerClassName = h.getClassName();
            }
            h = cfgs[instance].getWriter();
            if (h == null) {
                cat.warn("No encoding writer for " + config.getName() + ", instance " + cfgs[instance].getName());
            } else {
                tokenWriterConfigurable = Configurator.getConfigurable(h);
                tokenWriterClassName = h.getClassName();
            }
            String classSpaceName = cfgs[instance].getClassSpace();
            ClassSpace classSpace = ClassSpaceHelper.getClassSpace(classSpaceName, rawConfig.getReferenceLocation());
            if (classSpace == null) {
                throw new RuntimeException("Could not find class space '" + classSpaceName + "' for encoding " + config.getName() + ", instance " + cfgs[instance].getName());
            }
            EncodingTokenizer tokenizer = null;
            if (tokenizerClassName != null && (tokenizer = (EncodingTokenizer)classSpace.createInstance(class$org$idoox$xmlrpc$encoding$EncodingTokenizer == null ? EncodingRepository.class$("org.idoox.xmlrpc.encoding.EncodingTokenizer") : class$org$idoox$xmlrpc$encoding$EncodingTokenizer, tokenizerClassName)) == null) {
                cat.error("Could not access encoding tokenizer " + tokenizerClassName + " in class space " + classSpaceName);
            }
            EncodingTokenWriter writer = null;
            if (tokenWriterClassName != null && (writer = (EncodingTokenWriter)classSpace.createInstance(class$org$idoox$xmlrpc$encoding$EncodingTokenWriter == null ? EncodingRepository.class$("org.idoox.xmlrpc.encoding.EncodingTokenWriter") : class$org$idoox$xmlrpc$encoding$EncodingTokenWriter, tokenWriterClassName)) == null) {
                cat.error("Could not access encoding token writer " + tokenWriterClassName + " in class space " + classSpaceName);
            }
            if ((poolClassName = cfgs[instance].getPoolClassName()) == null) {
                poolClassName = "com.idoox.util.ObjectPool";
            }
            int poolSize = (poolSizeInteger = cfgs[instance].getPoolSize()) == null ? 20 : poolSizeInteger;
            encodingMap.put(cfgs[instance].getName(), new EncodingRecord(tokenizerClassName, tokenWriterClassName, tokenizerConfigurable, tokenWriterConfigurable, classSpace, poolClassName, poolSize));
            String defaultSerialization = cfgs[instance].getDefaultSerializationID();
            if (defaultSerialization != null) {
                SerializationRepositoryImpl serializationRepository = (SerializationRepositoryImpl)Context.getInstance("org.idoox.wasp.serialization.SerializationRepository");
                serializationRepository.setDefaultEncoding(cfgs[instance].getName(), defaultSerialization);
            }
            ++instance;
        }
    }

    public void init() {
    }

    public void destroy() {
    }

    public void addEncoding(Configurable config) {
        try {
            EncodingConfig encodingConfig = (EncodingConfig)config.narrow(class$com$idoox$wasp$config$EncodingConfig == null ? (class$com$idoox$wasp$config$EncodingConfig = EncodingRepository.class$("com.idoox.wasp.config.EncodingConfig")) : class$com$idoox$wasp$config$EncodingConfig);
            this.loadEncoding(encodingConfig, config);
        }
        catch (Exception e) {
            throw new RuntimeWrappedException(e);
        }
    }

    public void removeEncoding(String name) {
        this.encodingIdToEncodingMap.remove(name);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class EncodingRecord {
        Configurable config;
        Pool tokenizerPool;
        Pool tokenWriterPool;
        static /* synthetic */ Class class$com$idoox$util$Pool;
        static /* synthetic */ Class class$org$idoox$xmlrpc$encoding$EncodingTokenizer;
        static /* synthetic */ Class class$org$idoox$xmlrpc$encoding$EncodingTokenWriter;

        EncodingRecord(String tokenizerClassName, String tokenWriterClassName, Configurable tokenizerConfigurable, Configurable tokenWriterConfigurable, ClassSpace classSpace, String poolClassName, int poolSize) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
            ClassSpace waspRoot = ClassSpaceHelper.getWaspClassSpace();
            Class poolClass = waspRoot.getClass(class$com$idoox$util$Pool == null ? (class$com$idoox$util$Pool = EncodingRecord.class$("com.idoox.util.Pool")) : class$com$idoox$util$Pool, poolClassName);
            Class clazz = classSpace.getClass(class$org$idoox$xmlrpc$encoding$EncodingTokenizer == null ? (class$org$idoox$xmlrpc$encoding$EncodingTokenizer = EncodingRecord.class$("org.idoox.xmlrpc.encoding.EncodingTokenizer")) : class$org$idoox$xmlrpc$encoding$EncodingTokenizer, tokenizerClassName);
            this.tokenizerPool = (Pool)poolClass.newInstance();
            this.tokenizerPool.init(new ClassInstantiator(clazz, tokenizerConfigurable), poolSize);
            clazz = classSpace.getClass(class$org$idoox$xmlrpc$encoding$EncodingTokenWriter == null ? (class$org$idoox$xmlrpc$encoding$EncodingTokenWriter = EncodingRecord.class$("org.idoox.xmlrpc.encoding.EncodingTokenWriter")) : class$org$idoox$xmlrpc$encoding$EncodingTokenWriter, tokenWriterClassName);
            this.tokenWriterPool = (Pool)poolClass.newInstance();
            this.tokenWriterPool.init(new ClassInstantiator(clazz, tokenWriterConfigurable), poolSize);
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }

        class ClassInstantiator
        implements Pool.Factory {
            Class clazz;
            Configurable config;

            public ClassInstantiator(Class clazz, Configurable config) {
                this.clazz = clazz;
                this.config = config;
            }

            public Object getNewInstance() {
                try {
                    Object ret = this.clazz.newInstance();
                    if (ret instanceof EncodingTokenizer) {
                        ((EncodingTokenizer)ret).init(this.config);
                    } else if (ret instanceof EncodingTokenWriter) {
                        ((EncodingTokenWriter)ret).init(this.config);
                    } else {
                        throw new RuntimeException("Do not know how to initialize class " + this.clazz);
                    }
                    return ret;
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeWrappedException(e);
                }
                catch (InstantiationException e) {
                    throw new RuntimeWrappedException(e);
                }
            }
        }
    }
}

