/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp;

import com.idoox.debug.Category;
import com.idoox.wasp.ClassSpace;
import com.idoox.wasp.ClassSpaceException;
import com.idoox.wasp.ClassSpaceNotFoundException;
import com.idoox.wasp.classloader.WaspClassLoader;
import com.idoox.wasp.config.ClassSpaceConfig;
import com.idoox.wasp.config.ClassSpaceHelperConfig;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.idoox.config.Configurable;
import org.idoox.config.Configurator;

public class ClassSpaceHelper {
    private static final Category log = Category.getCategory("com.idoox.wasp.ClassSpaceHelper");
    private static Map knownClassSpaces;
    private static Map refLocationToClassSpace;
    private static ClassSpaceHelperConfig classSpaceHelperConfig;
    static /* synthetic */ Class class$com$idoox$wasp$config$ClassSpaceHelperConfig;
    static /* synthetic */ Class class$com$idoox$wasp$config$ClassSpaceConfig;

    public static ClassSpace initializeClassSpaces(Configurator configurator, ClassLoader waspInterfaceClassLoader, ClassLoader waspImplementationClassLoader) throws ClassSpaceException, MalformedURLException {
        int i;
        boolean changed;
        knownClassSpaces = new HashMap(13);
        refLocationToClassSpace = new HashMap(13);
        Configurable mainConfig = Configurator.getConfigurable("config", "main");
        classSpaceHelperConfig = (ClassSpaceHelperConfig)mainConfig.narrow(class$com$idoox$wasp$config$ClassSpaceHelperConfig == null ? (class$com$idoox$wasp$config$ClassSpaceHelperConfig = ClassSpaceHelper.class$("com.idoox.wasp.config.ClassSpaceHelperConfig")) : class$com$idoox$wasp$config$ClassSpaceHelperConfig);
        String waspClassSpace = classSpaceHelperConfig.getWaspClassSpace();
        if (waspImplementationClassLoader != null && waspClassSpace == null) {
            throw new ClassSpaceException("WASP class space is not mentioned in the configuration file.Please insert <waspClassSpace>...</waspClassSpace> tag into the config file.");
        }
        String serviceClassSpace = classSpaceHelperConfig.getServiceDefaultParentClassSpace();
        if (waspImplementationClassLoader != null && serviceClassSpace == null) {
            throw new ClassSpaceException("Service default class space is not mentioned in the configuration file.Please insert <serviceDefaultParentClassSpace>...</serviceDefaultParentClassSpace> tag into the config file.");
        }
        Configurable[] classSpaces = Configurator.getTopEntries("classSpace");
        if (classSpaces == null || classSpaces.length == 0) {
            throw new ClassSpaceException("Must have at least one class space present");
        }
        Configurable rootConfigurable = null;
        int i2 = 0;
        while (i2 < classSpaces.length) {
            if (classSpaces[i2].getName().equals("root")) {
                rootConfigurable = classSpaces[i2];
                classSpaces[i2] = null;
                break;
            }
            ++i2;
        }
        if (rootConfigurable == null) {
            throw new ClassSpaceException("Could not find top-level class space");
        }
        ClassSpaceConfig rootClassSpaceConfig = (ClassSpaceConfig)rootConfigurable.narrow(class$com$idoox$wasp$config$ClassSpaceConfig == null ? (class$com$idoox$wasp$config$ClassSpaceConfig = ClassSpaceHelper.class$("com.idoox.wasp.config.ClassSpaceConfig")) : class$com$idoox$wasp$config$ClassSpaceConfig);
        if (rootClassSpaceConfig == null) {
            throw new ClassSpaceException("internal error: need config");
        }
        ClassSpace rootClassSpace = new ClassSpace(null, rootClassSpaceConfig);
        if (waspInterfaceClassLoader != null) {
            rootClassSpace.setClassLoader(waspInterfaceClassLoader);
        }
        rootClassSpace.init(null, knownClassSpaces, refLocationToClassSpace);
        if (waspImplementationClassLoader != null) {
            ClassSpace waspCS = (ClassSpace)knownClassSpaces.get(waspClassSpace);
            if (waspCS == null) {
                throw new ClassSpaceException("Unresolved reference to waspClassLoader");
            }
            waspCS.setClassLoader(waspImplementationClassLoader);
            ClassSpace serviceCS = (ClassSpace)knownClassSpaces.get(serviceClassSpace);
            if (serviceCS != null) {
                serviceCS.setClassLoader(waspImplementationClassLoader);
            } else {
                throw new ClassSpaceException("Unresolved reference to serviceDeafaultClassLoader");
            }
        }
        do {
            changed = false;
            i = 0;
            while (i < classSpaces.length) {
                if (classSpaces[i] != null) {
                    int j;
                    ClassSpaceConfig childConfig = (ClassSpaceConfig)classSpaces[i].narrow(class$com$idoox$wasp$config$ClassSpaceConfig == null ? ClassSpaceHelper.class$("com.idoox.wasp.config.ClassSpaceConfig") : class$com$idoox$wasp$config$ClassSpaceConfig);
                    String[] parents = childConfig.getParentClassSpaces();
                    ArrayList<ClassSpace> parentList = new ArrayList<ClassSpace>();
                    boolean unresolvedParents = false;
                    if (parents != null) {
                        j = 0;
                        while (j < parents.length) {
                            String parent = parents[j];
                            ClassSpace parentClassSpace = (ClassSpace)knownClassSpaces.get(parent);
                            if (parentClassSpace == null) {
                                unresolvedParents = true;
                                break;
                            }
                            parentList.add(parentClassSpace);
                            ++j;
                        }
                    }
                    if (parentList.size() != 0 && !unresolvedParents) {
                        if (!classSpaces[i].getReferenceLocation().equals(mainConfig.getReferenceLocation())) {
                            if (!knownClassSpaces.containsKey(childConfig.getName())) {
                                ClassSpace childClassSpace = new ClassSpace(parentList.toArray(new ClassSpace[0]), childConfig);
                                childClassSpace.init(null, knownClassSpaces, refLocationToClassSpace);
                                refLocationToClassSpace.put(classSpaces[i].getReferenceLocation(), childClassSpace.getCurrentPath());
                                int j2 = 0;
                                while (j2 < parentList.size()) {
                                    ClassSpace parent = (ClassSpace)parentList.get(j2);
                                    if (parent != null) {
                                        parent.addChildClassSpace(childClassSpace);
                                    }
                                    ++j2;
                                }
                                ClassSpaceHelper.setClassPath(childClassSpace, classSpaces[i].getReferenceLocation());
                            }
                        } else {
                            j = 0;
                            while (j < parentList.size()) {
                                ClassSpace parentClassSpace = (ClassSpace)parentList.get(j);
                                if (parentClassSpace != null && !knownClassSpaces.containsKey(parentClassSpace.getName() + "." + childConfig.getName())) {
                                    ClassSpace childClassSpace = new ClassSpace(parentList.toArray(new ClassSpace[0]), childConfig);
                                    childClassSpace.init(parentClassSpace.getCurrentPath(), knownClassSpaces, refLocationToClassSpace);
                                    parentClassSpace.addChildClassSpace(childClassSpace);
                                }
                                ++j;
                            }
                        }
                        classSpaces[i] = null;
                        changed = true;
                    }
                }
                ++i;
            }
        } while (changed);
        i = 0;
        while (i < classSpaces.length) {
            if (classSpaces[i] != null) {
                log.error("Unresolved parent of classspace " + classSpaces[i].getType() + ":" + classSpaces[i].getName());
                log.error("Known class spaces: ");
                Iterator j = knownClassSpaces.keySet().iterator();
                while (j.hasNext()) {
                    log.error("   " + j.next());
                }
                throw new ClassSpaceException("Error during initialization: unresolved class spaces");
            }
            ++i;
        }
        return rootClassSpace;
    }

    public static void destroy() {
        if (knownClassSpaces != null) {
            Collection classSpaces = knownClassSpaces.values();
            Iterator iterator = classSpaces.iterator();
            while (iterator.hasNext()) {
                ClassLoader classLoader;
                ClassSpace classSpace = (ClassSpace)iterator.next();
                if (classSpace == null || (classLoader = classSpace.getClassLoader()) == null || !(classLoader instanceof WaspClassLoader)) continue;
                try {
                    ((WaspClassLoader)classLoader).releaseAllResources();
                }
                catch (IOException e) {
                    log.error("Error when releasing classloader resourses", e);
                }
            }
        }
        knownClassSpaces = null;
        classSpaceHelperConfig = null;
    }

    public static ClassSpace getClassSpace(String classSpaceId) {
        ClassSpace cs = (ClassSpace)knownClassSpaces.get(classSpaceId);
        if (cs == null) {
            throw new ClassSpaceNotFoundException(classSpaceId);
        }
        return cs;
    }

    public static ClassSpace addClassSpace(Configurable config) throws ClassSpaceException, MalformedURLException {
        ClassSpaceConfig childConfig = (ClassSpaceConfig)config.narrow(class$com$idoox$wasp$config$ClassSpaceConfig == null ? (class$com$idoox$wasp$config$ClassSpaceConfig = ClassSpaceHelper.class$("com.idoox.wasp.config.ClassSpaceConfig")) : class$com$idoox$wasp$config$ClassSpaceConfig);
        String[] parents = childConfig.getParentClassSpaces();
        ArrayList<ClassSpace> parentList = new ArrayList<ClassSpace>();
        if (parents == null) {
            ClassSpace parentClassSpace = ClassSpaceHelper.getServiceDefaultParentClassSpace();
            if (parentClassSpace == null) {
                throw new ClassSpaceException("Default parent class space for service wasn't found");
            }
            parentList.add(parentClassSpace);
        } else {
            int i = 0;
            while (i < parents.length) {
                ClassSpace parentClassSpace = (ClassSpace)knownClassSpaces.get(parents[i]);
                if (parentClassSpace == null) {
                    throw new ClassSpaceException("Parent class space '" + parents[i] + "' for class space '" + childConfig.getName() + "' wasn't found");
                }
                parentList.add(parentClassSpace);
                ++i;
            }
        }
        ClassSpace childClassSpace = new ClassSpace(parentList.toArray(new ClassSpace[0]), childConfig);
        childClassSpace.init(null, knownClassSpaces, refLocationToClassSpace);
        refLocationToClassSpace.put(config.getReferenceLocation(), childClassSpace.getCurrentPath());
        int i = 0;
        while (i < parentList.size()) {
            ClassSpace parent = (ClassSpace)parentList.get(i);
            if (parent != null) {
                parent.addChildClassSpace(childClassSpace);
            }
            ++i;
        }
        ClassSpaceHelper.setClassPath(childClassSpace, config.getReferenceLocation());
        return childClassSpace;
    }

    public static ClassSpace removeClassSpace(String name) {
        ClassSpace classSpace = (ClassSpace)knownClassSpaces.get(name);
        if (classSpace == null) {
            return null;
        }
        knownClassSpaces.remove(name);
        refLocationToClassSpace.remove(classSpace.getReferenceLocation());
        classSpace.setClassPath(new URL[0]);
        ClassSpace[] parent = classSpace.getParentClassSpaces();
        if (parent != null) {
            int i = 0;
            while (i < parent.length) {
                ClassSpace parentClassSpace = parent[i];
                if (parentClassSpace != null) {
                    parentClassSpace.removeChildClassSpace(classSpace);
                }
                ++i;
            }
        }
        return classSpace;
    }

    public static ClassSpace getWaspClassSpace() {
        return ClassSpaceHelper.getClassSpace(classSpaceHelperConfig.getWaspClassSpace());
    }

    public static ClassSpace getServiceDefaultParentClassSpace() {
        return (ClassSpace)knownClassSpaces.get(classSpaceHelperConfig.getServiceDefaultParentClassSpace());
    }

    public static ClassSpace getClassSpace(String classSpaceName, String referenceLocation) throws MalformedURLException {
        if (classSpaceName == null) {
            String currentPath = (String)refLocationToClassSpace.get(referenceLocation);
            ClassSpace serviceClassSpace = null;
            if (currentPath != null && (serviceClassSpace = (ClassSpace)knownClassSpaces.get(currentPath)) != null) {
                return serviceClassSpace;
            }
            serviceClassSpace = ClassSpaceHelper.getServiceDefaultParentClassSpace().createChildClassSpace(referenceLocation);
            serviceClassSpace.init(null, knownClassSpaces, refLocationToClassSpace);
            refLocationToClassSpace.put(referenceLocation, serviceClassSpace.getCurrentPath());
            ClassSpaceHelper.setClassPath(serviceClassSpace, referenceLocation);
            return serviceClassSpace;
        }
        return ClassSpaceHelper.getClassSpace(classSpaceName);
    }

    private static void setClassPath(ClassSpace classSpace, String referenceLocation) throws MalformedURLException {
        File libsFile;
        File[] jars;
        URL classesURL = new URL(new URL(referenceLocation + "/"), "WASP-INF/classes/");
        classSpace.addClassPath(classesURL);
        if (referenceLocation.startsWith("file:") && (jars = (libsFile = new File(new URL(referenceLocation + "/").getFile(), "WASP-INF/lib")).listFiles(new LibFilenameFilter())) != null) {
            int i = 0;
            while (i < jars.length) {
                classSpace.addClassPath(jars[i].toURL());
                ++i;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    protected static class LibFilenameFilter
    implements FilenameFilter {
        protected LibFilenameFilter() {
        }

        public boolean accept(File dir, String name) {
            return name.endsWith(".jar") || name.endsWith(".zip");
        }
    }
}

