/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp;

import java.util.Iterator;
import java.util.LinkedList;
import javax.xml.namespace.QName;
import org.idoox.config.Configurable;
import org.idoox.xml.Tokenizer;
import org.idoox.xmlrpc.Message;
import org.idoox.xmlrpc.MessageProcessingException;
import org.idoox.xmlrpc.encoding.EncodingTokenizer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CachedEncodingTokenizer
implements EncodingTokenizer {
    Iterator tokenIterator;
    EncodingTokenizerState currentState;

    public void setInputMessage(Message message, String encodingId) throws MessageProcessingException {
        throw new UnsupportedOperationException("This method must not be called");
    }

    public void setInput(Tokenizer parser, String encodingId) throws MessageProcessingException {
        throw new UnsupportedOperationException("This method must not be called");
    }

    public int next() throws MessageProcessingException {
        return this.nextToken();
    }

    public int nextToken() throws MessageProcessingException {
        if (this.currentState == null) {
            return 0;
        }
        if (!this.tokenIterator.hasNext()) {
            this.currentState = null;
            return 0;
        }
        this.currentState = (EncodingTokenizerState)this.tokenIterator.next();
        return this.currentState.token;
    }

    public Element nextAsElement(Document doc) throws MessageProcessingException {
        throw new UnsupportedOperationException("Not supported");
    }

    public Element getElementTokenValue(Document doc) throws MessageProcessingException {
        throw new UnsupportedOperationException("Not supported");
    }

    public int getCurrentToken() throws MessageProcessingException {
        if (this.currentState == null) {
            return 0;
        }
        return this.currentState.token;
    }

    public String getTokenName() throws MessageProcessingException {
        if (this.currentState == null) {
            throw new IllegalStateException("Bad state");
        }
        return this.currentState.tokenName;
    }

    public String getTokenNamespaceURI() throws MessageProcessingException {
        if (this.currentState == null) {
            throw new IllegalStateException("Bad state");
        }
        return this.currentState.tokenNamespaceURI;
    }

    public String getTokenTypeName() throws MessageProcessingException {
        if (this.currentState == null) {
            throw new IllegalStateException("Bad state");
        }
        return this.currentState.tokenTypeName;
    }

    public String getTokenTypeNamespaceURI() throws MessageProcessingException {
        if (this.currentState == null) {
            throw new IllegalStateException("Bad state");
        }
        return this.currentState.tokenTypeNamespaceURI;
    }

    public int[] getArrayDimensions() throws MessageProcessingException {
        if (this.currentState == null) {
            throw new IllegalStateException("Bad state");
        }
        return this.currentState.dimensions;
    }

    public int[] getArrayOffset() throws MessageProcessingException {
        if (this.currentState == null) {
            throw new IllegalStateException("Bad state");
        }
        return this.currentState.arrayOffset;
    }

    public int[] getArrayPosition(int expectedDimensions) throws MessageProcessingException {
        if (this.currentState == null) {
            throw new IllegalStateException("Bad state");
        }
        return this.currentState.position;
    }

    public String getPrimitiveTokenValue() throws MessageProcessingException {
        if (this.currentState == null) {
            throw new IllegalStateException("Bad state");
        }
        return this.currentState.tokenValue;
    }

    public String getID() throws MessageProcessingException {
        if (this.currentState == null) {
            throw new IllegalStateException("Bad state");
        }
        return this.currentState.id;
    }

    public String getReference() throws MessageProcessingException {
        if (this.currentState == null) {
            throw new IllegalStateException("Bad state");
        }
        return this.currentState.reference;
    }

    public QName convertToQName(String qname) {
        throw new UnsupportedOperationException("Sorry, not implemented now");
    }

    public void fill(EncodingTokenizer tokenizer) throws MessageProcessingException {
        int token = tokenizer.getCurrentToken();
        int level = 0;
        LinkedList<EncodingTokenizerState> tokens = new LinkedList<EncodingTokenizerState>();
        int[] dims = new int[10];
        do {
            EncodingTokenizerState newState = new EncodingTokenizerState();
            newState.token = token;
            if (token == 1 || token == 3) {
                if (token == 3) {
                    newState.dimensions = tokenizer.getArrayDimensions();
                    newState.arrayOffset = tokenizer.getArrayOffset();
                    dims = this.addDims(dims, level, newState.dimensions.length);
                } else {
                    dims = this.addDims(dims, level, Integer.MIN_VALUE);
                }
                ++level;
            }
            if (token == 2) {
                --level;
            }
            if (token == 1 || token == 3 || token == 4 || token == 5 || token == 6) {
                newState.tokenNamespaceURI = tokenizer.getTokenNamespaceURI();
                newState.tokenName = tokenizer.getTokenName();
                newState.tokenTypeNamespaceURI = tokenizer.getTokenTypeNamespaceURI();
                newState.tokenTypeName = tokenizer.getTokenTypeName();
                newState.position = this.cloneIntArray(tokenizer.getArrayPosition(this.getArrayDims(dims, level)));
                newState.id = tokenizer.getID();
            }
            if (token == 5) {
                newState.reference = tokenizer.getReference();
            }
            if (token == 4) {
                newState.tokenValue = tokenizer.getPrimitiveTokenValue();
            }
            tokens.add(newState);
            token = tokenizer.nextToken();
        } while (level > 0);
        this.tokenIterator = tokens.iterator();
        this.currentState = (EncodingTokenizerState)this.tokenIterator.next();
    }

    private int[] cloneIntArray(int[] arr) {
        if (arr == null) {
            return null;
        }
        int l = arr.length;
        int[] newArr = new int[l];
        System.arraycopy(arr, 0, newArr, 0, l);
        return newArr;
    }

    private int[] addDims(int[] dims, int pos, int value) {
        int l = dims.length;
        if (l == pos) {
            int[] newDims = new int[l + 10];
            System.arraycopy(dims, 0, newDims, 0, l);
            dims = newDims;
        }
        dims[pos] = value;
        return dims;
    }

    private int getArrayDims(int[] dims, int size) {
        int i = size - 1;
        while (i >= 0) {
            if (dims[i] != Integer.MIN_VALUE) {
                return dims[i];
            }
            --i;
        }
        return 0;
    }

    public void init(Configurable conf) {
    }

    static class EncodingTokenizerState {
        int token;
        String tokenNamespaceURI;
        String tokenName;
        String tokenTypeNamespaceURI;
        String tokenTypeName;
        int[] dimensions;
        int[] position;
        String tokenValue;
        String id;
        String reference;
        int[] arrayOffset;

        EncodingTokenizerState() {
        }
    }
}

