/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.util.xml;

import com.idoox.util.xml.BaseMarkupSerializer;
import com.idoox.util.xml.ElementState;
import com.idoox.util.xml.OutputFormat;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Enumeration;
import java.util.HashSet;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.AttributeList;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class XMLSerializer
extends BaseMarkupSerializer {
    boolean _mustUnindent = false;
    boolean _hadOneAttribute = false;

    public XMLSerializer() {
        super(new OutputFormat("xml", null, false));
    }

    public XMLSerializer(OutputFormat format) {
        super(format != null ? format : new OutputFormat("xml", null, false));
        this._format.setMethod("xml");
    }

    public XMLSerializer(Writer writer, OutputFormat format) {
        super(format != null ? format : new OutputFormat("xml", null, false));
        this._format.setMethod("xml");
        this.setOutputCharStream(writer);
    }

    public XMLSerializer(OutputStream output, OutputFormat format) {
        super(format != null ? format : new OutputFormat("xml", null, false));
        this._format.setMethod("xml");
        this.setOutputByteStream(output);
    }

    protected void prepare() throws IOException {
        super.prepare();
        this._printer.setIndentationLevel(this._format.getIndentationLevel());
    }

    public void setOutputFormat(OutputFormat format) {
        super.setOutputFormat(format != null ? format : new OutputFormat("xml", null, false));
    }

    public void startElement(String namespaceURI, String localName, String rawName, Attributes attrs) throws SAXException {
        boolean addNSAttr = false;
        try {
            String value;
            String name;
            String prefix;
            if (this._printer == null) {
                throw new IllegalStateException("SER002 No writer supplied for serializer");
            }
            ElementState state = this.getElementState();
            if (this.isDocumentState()) {
                if (!this._started) {
                    this.startDocument(localName == null || localName.length() == 0 ? rawName : localName);
                }
            } else {
                if (state.empty) {
                    this._printer.printText('>');
                }
                if (state.inCData) {
                    this._printer.printText("]]>");
                    state.inCData = false;
                }
                if (this._indenting && !state.preserveSpace && (state.empty || state.afterElement || state.afterComment)) {
                    this._printer.breakLine();
                }
            }
            boolean preserveSpace = state.preserveSpace;
            attrs = this.extractNamespaces(attrs);
            if (rawName == null || rawName.length() == 0) {
                if (localName == null) {
                    throw new SAXException("No rawName and localName is null");
                }
                rawName = namespaceURI != null && !namespaceURI.equals("") ? ((prefix = this.getPrefix(namespaceURI)) != null && prefix.length() > 0 ? prefix + ":" + localName : localName) : localName;
                addNSAttr = true;
            }
            this._printer.printText('<');
            this._printer.printText(rawName);
            this._printer.indent();
            if (attrs != null) {
                int i = 0;
                while (i < attrs.getLength()) {
                    this._printer.printSpace();
                    name = attrs.getQName(i);
                    if (name != null && name.length() == 0) {
                        name = attrs.getLocalName(i);
                        String attrURI = attrs.getURI(i);
                        if (!(attrURI == null || attrURI.length() == 0 || namespaceURI != null && namespaceURI.length() != 0 && attrURI.equals(namespaceURI) || (prefix = this.getPrefix(attrURI)) == null || prefix.length() <= 0)) {
                            name = prefix + ":" + name;
                        }
                    }
                    if ((value = attrs.getValue(i)) == null) {
                        value = "";
                    }
                    this._printer.printText(name);
                    this._printer.printText("=\"");
                    this.printEscaped(value);
                    this._printer.printText('\"');
                    if (name.equals("xml:space")) {
                        preserveSpace = value.equals("preserve") ? true : this._format.getPreserveSpace();
                    }
                    ++i;
                }
            }
            if (this._prefixes != null) {
                Enumeration enumeration = this._prefixes.keys();
                while (enumeration.hasMoreElements()) {
                    this._printer.printSpace();
                    value = (String)enumeration.nextElement();
                    name = (String)this._prefixes.get(value);
                    if (name.length() == 0) {
                        this._printer.printText("xmlns=\"");
                        this.printEscaped(value);
                        this._printer.printText('\"');
                        continue;
                    }
                    this._printer.printText("xmlns:");
                    this._printer.printText(name);
                    this._printer.printText("=\"");
                    this.printEscaped(value);
                    this._printer.printText('\"');
                }
            }
            state = this.enterElementState(namespaceURI, localName, rawName, preserveSpace);
            name = localName == null || localName.length() == 0 ? rawName : namespaceURI + "^" + localName;
            state.doCData = this._format.isCDataElement(name);
            state.unescaped = this._format.isNonEscapingElement(name);
        }
        catch (IOException except) {
            throw new SAXException(except);
        }
    }

    public void endElement(String namespaceURI, String localName, String rawName) throws SAXException {
        try {
            this.endElementIO(namespaceURI, localName, rawName);
        }
        catch (IOException except) {
            throw new SAXException(except);
        }
    }

    public void endElementIO(String namespaceURI, String localName, String rawName) throws IOException {
        this._printer.unindent();
        if (this._mustUnindent) {
            this._printer.unindent();
            this._mustUnindent = false;
        }
        ElementState state = this.getElementState();
        if (state.empty) {
            this._printer.printText("/>");
        } else {
            if (state.inCData) {
                this._printer.printText("]]>");
            }
            if (this._indenting && !state.preserveSpace && (state.afterElement || state.afterComment)) {
                this._printer.breakLine();
            }
            this._printer.printText("</");
            this._printer.printText(state.rawName);
            this._printer.printText('>');
        }
        this._printer.printSpace();
        state = this.leaveElementState();
        state.afterElement = true;
        state.afterComment = false;
        state.empty = false;
        if (this.isDocumentState()) {
            this._printer.flush();
        }
    }

    public void startElement(String tagName, AttributeList attrs) throws SAXException {
        try {
            if (this._printer == null) {
                throw new IllegalStateException("SER002 No writer supplied for serializer");
            }
            ElementState state = this.getElementState();
            if (this.isDocumentState()) {
                if (!this._started) {
                    this.startDocument(tagName);
                }
            } else {
                if (state.empty) {
                    this._printer.printText('>');
                }
                if (state.inCData) {
                    this._printer.printText("]]>");
                    state.inCData = false;
                }
                if (this._indenting && !state.preserveSpace && (state.empty || state.afterElement || state.afterComment)) {
                    this._printer.breakLine();
                }
            }
            boolean preserveSpace = state.preserveSpace;
            this._printer.printText('<');
            this._printer.printText(tagName);
            this._printer.indent();
            if (attrs != null) {
                int i = 0;
                while (i < attrs.getLength()) {
                    this._printer.printSpace();
                    String name = attrs.getName(i);
                    String value = attrs.getValue(i);
                    if (value != null) {
                        this._printer.printText(name);
                        this._printer.printText("=\"");
                        this.printEscaped(value);
                        this._printer.printText('\"');
                    }
                    if (name.equals("xml:space")) {
                        preserveSpace = value.equals("preserve") ? true : this._format.getPreserveSpace();
                    }
                    ++i;
                }
            }
            state = this.enterElementState(null, null, tagName, preserveSpace);
            state.doCData = this._format.isCDataElement(tagName);
            state.unescaped = this._format.isNonEscapingElement(tagName);
        }
        catch (IOException except) {
            throw new SAXException(except);
        }
    }

    public void endElement(String tagName) throws SAXException {
        this.endElement(null, null, tagName);
    }

    protected void startDocument(String rootTagName) throws IOException {
        String dtd = this._printer.leaveDTD();
        if (!this._started) {
            if (!this._format.getOmitXMLDeclaration()) {
                StringBuffer buffer = new StringBuffer("<?xml version=\"");
                if (this._format.getVersion() != null) {
                    buffer.append(this._format.getVersion());
                } else {
                    buffer.append("1.0");
                }
                buffer.append('\"');
                if (this._format.getEncoding() != null) {
                    buffer.append(" encoding=\"");
                    buffer.append(this._format.getEncoding());
                    buffer.append('\"');
                }
                if (this._format.getStandalone() && this._docTypeSystemId == null && this._docTypePublicId == null) {
                    buffer.append(" standalone=\"yes\"");
                }
                buffer.append("?>");
                this._printer.printText(buffer);
                this._printer.breakLine();
            }
            if (!this._format.getOmitDocumentType()) {
                if (this._docTypeSystemId != null) {
                    this._printer.printText("<!DOCTYPE ");
                    this._printer.printText(rootTagName);
                    if (this._docTypePublicId != null) {
                        this._printer.printText(" PUBLIC ");
                        this.printDoctypeURL(this._docTypePublicId);
                        if (this._indenting) {
                            this._printer.breakLine();
                            int i = 0;
                            while (i < 18 + rootTagName.length()) {
                                this._printer.printText(" ");
                                ++i;
                            }
                        } else {
                            this._printer.printText(" ");
                        }
                        this.printDoctypeURL(this._docTypeSystemId);
                    } else {
                        this._printer.printText(" SYSTEM ");
                        this.printDoctypeURL(this._docTypeSystemId);
                    }
                    if (dtd != null && dtd.length() > 0) {
                        this._printer.printText(" [");
                        this.printText(dtd, true, true);
                        this._printer.printText(']');
                    }
                    this._printer.printText(">");
                    this._printer.breakLine();
                } else if (dtd != null && dtd.length() > 0) {
                    this._printer.printText("<!DOCTYPE ");
                    this._printer.printText(rootTagName);
                    this._printer.printText(" [");
                    this.printText(dtd, true, true);
                    this._printer.printText("]>");
                    this._printer.breakLine();
                }
            }
        }
        this._started = true;
        this.serializePreRoot();
    }

    protected void serializeElement(Element elem) throws IOException {
        String tagName = elem.getTagName();
        ElementState state = this.getElementState();
        if (this.isDocumentState()) {
            if (!this._started) {
                this.startDocument(tagName);
            }
        } else {
            if (state.empty) {
                this._printer.printText('>');
            }
            if (state.inCData) {
                this._printer.printText("]]>");
                state.inCData = false;
            }
            if (this._indenting && !state.preserveSpace && (state.empty || state.afterElement || state.afterComment)) {
                if (state.empty && !this._hadOneAttribute) {
                    this._printer.printSpace();
                }
                this._hadOneAttribute = false;
                this._printer.breakLine();
            }
        }
        boolean preserveSpace = state.preserveSpace;
        if (this._mustUnindent) {
            this._printer.unindent();
            this._mustUnindent = false;
        }
        this._printer.printText('<');
        this._printer.printText(tagName);
        this._printer.indent();
        NamedNodeMap attrMap = elem.getAttributes();
        if (attrMap != null) {
            this._hadOneAttribute = attrMap.getLength() == 1;
            int i = 0;
            while (i < attrMap.getLength()) {
                Attr attr = (Attr)attrMap.item(i);
                String name = attr.getName();
                String value = attr.getValue();
                if (value == null) {
                    value = "";
                }
                if (attr.getSpecified()) {
                    this._printer.printSpace();
                    this._printer.printText(name);
                    this._printer.printText("=\"");
                    this.printEscaped(value);
                    this._printer.printText('\"');
                }
                if (name.equals("xml:space")) {
                    preserveSpace = value.equals("preserve") ? true : this._format.getPreserveSpace();
                }
                ++i;
            }
        }
        if (this.writeParentNamespaces) {
            this.writeParentNamespaces = false;
            this.writeParentNamespaces(elem);
        }
        if (elem.hasChildNodes()) {
            state = this.enterElementState(null, null, tagName, preserveSpace);
            state.doCData = this._format.isCDataElement(tagName);
            state.unescaped = this._format.isNonEscapingElement(tagName);
            Node child = elem.getFirstChild();
            while (child != null) {
                this.serializeNode(child);
                child = child.getNextSibling();
            }
            this.endElementIO(null, null, tagName);
        } else {
            this._printer.unindent();
            this._printer.printText("/>");
            NamedNodeMap attrMap2 = elem.getAttributes();
            if (attrMap.getLength() > 1) {
                this._printer.indent();
                this._mustUnindent = true;
            }
            this._printer.printSpace();
            state.afterElement = true;
            state.afterComment = false;
            state.empty = false;
            if (this.isDocumentState()) {
                this._printer.flush();
            }
        }
    }

    private void writeParentNamespaces(Element element) throws IOException {
        HashSet<String> definedPrefixes = new HashSet<String>();
        NamedNodeMap attributes = element.getAttributes();
        int i = 0;
        while (i < attributes.getLength()) {
            Attr attr = (Attr)attributes.item(i);
            String name = attr.getName();
            if (name.startsWith("xmlns:") || name.equals("xmlns")) {
                definedPrefixes.add(name);
            }
            ++i;
        }
        Node node = element.getParentNode();
        while (node != null && node.getNodeType() == 1) {
            Element parentElement = (Element)node;
            attributes = parentElement.getAttributes();
            int i2 = 0;
            while (i2 < attributes.getLength()) {
                Attr attr = (Attr)attributes.item(i2);
                String name = attr.getName();
                String value = attr.getValue();
                if ((name.startsWith("xmlns:") || name.equals("xmlns")) && !definedPrefixes.contains(name)) {
                    definedPrefixes.add(name);
                    if (value == null) {
                        value = "";
                    }
                    if (attr.getSpecified()) {
                        this._printer.printSpace();
                        this._printer.printText(name);
                        this._printer.printText("=\"");
                        this.printEscaped(value);
                        this._printer.printText('\"');
                    }
                }
                ++i2;
            }
            node = parentElement.getParentNode();
        }
    }

    protected String getEntityRef(int ch) {
        switch (ch) {
            case 60: {
                return "lt";
            }
            case 62: {
                return "gt";
            }
            case 34: {
                return "quot";
            }
            case 39: {
                return "apos";
            }
            case 38: {
                return "amp";
            }
        }
        return null;
    }

    private Attributes extractNamespaces(Attributes attrs) throws SAXException {
        int length = attrs.getLength();
        AttributesImpl attrsOnly = new AttributesImpl(attrs);
        int i = length - 1;
        while (i >= 0) {
            String rawName = attrsOnly.getQName(i);
            if (rawName.startsWith("xmlns")) {
                int indexColon = rawName.indexOf(58);
                String prefix = indexColon != -1 && indexColon + 1 < rawName.length() ? rawName.substring(indexColon + 1) : "";
                this.startPrefixMapping(prefix, attrs.getValue(i));
                attrsOnly.removeAttribute(i);
            }
            --i;
        }
        return attrsOnly;
    }
}

