/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.util;

public class UUIDgen {
    private static int CLOCK_SEQ_LAST = 16383;
    private static long RAND_MASK = CLOCK_SEQ_LAST;
    private static String netaddress;
    private static Unsigned64T timeLast;
    private static int clockSeq;
    static long randM;
    static long randIa;
    static long randIb;
    static long randIrand;
    static int pid;
    static Object mutex;
    static int timeAdjust;

    private static String digits(long val, int digits) {
        long hi = 1L << digits * 4;
        return Long.toHexString(hi | val & hi - 1L).substring(1);
    }

    public void setNetAddress(String address) {
        netaddress = address;
    }

    public UUIDgen() {
        this.uuidInit();
    }

    public void add64bTo64b(Unsigned64T A, Unsigned64T B, Unsigned64T sum) {
        if ((A.lo & 0x80000000L ^ B.lo & 0x80000000L) == 0L) {
            if ((A.lo & 0x80000000L) != 0L) {
                sum.lo = A.lo + B.lo;
                sum.hi = A.hi + B.hi + 1L;
            } else {
                sum.lo = A.lo + B.lo;
                sum.hi = A.hi + B.hi;
            }
        } else {
            sum.lo = A.lo + B.lo;
            sum.hi = A.hi + B.hi;
            if ((sum.lo & 0x80000000L) == 0L) {
                ++sum.hi;
            }
        }
    }

    public void add16bTo64b(int A, Unsigned64T B, Unsigned64T sum) {
        sum.hi = B.hi;
        if ((B.lo & 0x80000000L) != 0L) {
            sum.lo = (long)A + B.lo;
            if ((sum.lo & 0x80000000L) == 0L) {
                ++sum.hi;
            }
        } else {
            sum.lo = (long)A + B.lo;
        }
    }

    void mult32(long u, long v, Unsigned64T result) {
        long uuid1 = u >> 16;
        long uuid2 = u & 0xFFFFL;
        long v1 = v >> 16;
        long v2 = v & 0xFFFFL;
        long temp = uuid2 * v2;
        result.lo = temp & 0xFFFFL;
        temp = uuid1 * v2 + (temp >> 16);
        result.hi = temp >> 16;
        temp = uuid2 * v1 + (temp & 0xFFFFL);
        result.lo += (temp & 0xFFFFL) << 16;
        result.hi += uuid1 * v1 + (temp >> 16);
    }

    void getSystemTime(Unsigned64T uuidTime) {
        Unsigned64T utc = new Unsigned64T();
        Unsigned64T usecs = new Unsigned64T();
        Unsigned64T osBaseTimeDiff = new Unsigned64T();
        long tp = System.currentTimeMillis();
        this.mult32(tp / 1000L, 10000000L, utc);
        this.mult32(tp % 1000L * 1000L, 10L, usecs);
        this.add64bTo64b(usecs, utc, utc);
        osBaseTimeDiff.lo = 327237632L;
        osBaseTimeDiff.hi = 28450258L;
        this.add64bTo64b(utc, osBaseTimeDiff, uuidTime);
    }

    void trueRandomInit() {
        Unsigned64T t = new Unsigned64T();
        randM = 971L;
        randIa = 11113L;
        randIb = 104322L;
        randIrand = 4181L;
        this.getSystemTime(t);
        int seed = (int)(t.lo & 0xFFFFL);
        seed ^= (int)(t.lo >> 16 & 0xFFFFL);
        seed ^= (int)(t.hi & 0xFFFFL);
        randIrand += (long)((seed ^= (int)(t.hi >> 16 & 0xFFFFL)) + pid);
    }

    static int trueRandom() {
        if ((randM += 7L) >= 9973L) {
            randM -= 9871L;
        }
        if ((randIa += 1907L) >= 99991L) {
            randIa -= 89989L;
        }
        if ((randIb += 73939L) >= 224729L) {
            randIb -= 96233L;
        }
        randIrand = randIrand * randM + randIa + randIb;
        return (int)(randIrand >> 16 ^ randIrand & RAND_MASK);
    }

    public void uuidInit() {
        this.trueRandomInit();
        this.getSystemTime(timeLast);
        clockSeq = UUIDgen.trueRandom();
        netaddress = this.getNetAddress();
    }

    int timeCmp(Unsigned64T time1, Unsigned64T time2) {
        if (time1.hi < time2.hi) {
            return -1;
        }
        if (time1.hi > time2.hi) {
            return 1;
        }
        if (time1.lo < time2.lo) {
            return -1;
        }
        if (time1.lo > time2.lo) {
            return 1;
        }
        return 0;
    }

    void newClockSeq() {
        if ((clockSeq = (clockSeq + 1) % (CLOCK_SEQ_LAST + 1)) == 0) {
            clockSeq = 1;
        }
    }

    public UUIDT uuidCreate() {
        Object object = mutex;
        synchronized (object) {
            UUIDT uuid = new UUIDT();
            Unsigned64T timeNow = new Unsigned64T();
            boolean gotNoTime = false;
            do {
                this.getSystemTime(timeNow);
                switch (this.timeCmp(timeNow, timeLast)) {
                    case -1: {
                        this.newClockSeq();
                        timeAdjust = 0;
                        break;
                    }
                    case 1: {
                        timeAdjust = 0;
                        break;
                    }
                    default: {
                        if (timeAdjust == Short.MAX_VALUE) {
                            gotNoTime = true;
                            break;
                        }
                        ++timeAdjust;
                    }
                }
            } while (gotNoTime);
            UUIDgen.timeLast.lo = timeNow.lo;
            UUIDgen.timeLast.hi = timeNow.hi;
            if (timeAdjust != 0) {
                this.add16bTo64b(timeAdjust, timeNow, timeNow);
            }
            uuid.timeLow = timeNow.lo;
            uuid.timeMid = (int)(timeNow.hi & 0xFFFFL);
            uuid.timeHiAndVersion = (int)((timeNow.hi & 0xFFF0000L) >> 16);
            uuid.timeHiAndVersion |= 0x1000;
            uuid.clockSeqLow = (char)(clockSeq & 0xFF);
            uuid.clockSeqHiAndReserved = (char)((clockSeq & 0x3F00) >> 8);
            uuid.clockSeqHiAndReserved = (char)(uuid.clockSeqHiAndReserved | 0x80);
            uuid.node = netaddress;
            UUIDT uUIDT = uuid;
            return uUIDT;
        }
    }

    public String uuidgen() {
        return this.uuidCreate().toString().toLowerCase();
    }

    public String getNetAddress() {
        return this.uuidCreate().getNetAddress();
    }

    static {
        timeLast = new Unsigned64T();
        pid = new Object().hashCode();
        mutex = new Object();
        timeAdjust = 0;
    }

    static class Unsigned64T {
        long lo;
        long hi;

        Unsigned64T() {
        }
    }

    static class UUIDT {
        long timeLow;
        int timeMid;
        int timeHiAndVersion;
        char clockSeqHiAndReserved;
        char clockSeqLow;
        String node;

        UUIDT() {
        }

        public String toString() {
            return UUIDgen.digits(this.timeLow, 8) + "-" + UUIDgen.digits(this.timeMid, 4) + "-" + UUIDgen.digits(this.timeHiAndVersion, 4) + "-" + UUIDgen.digits(this.clockSeqHiAndReserved, 2) + UUIDgen.digits(this.clockSeqLow, 2) + "-" + this.node;
        }

        public String getNetAddress() {
            return UUIDgen.digits(this.timeLow, 8) + UUIDgen.digits(this.clockSeqHiAndReserved, 2) + UUIDgen.digits(this.clockSeqLow, 2);
        }
    }
}

