/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.util;

import java.lang.reflect.Method;

public class SignatureHelper {
    private static final String ILLEGAL_TYPE = "<illegal type>";
    private static final byte T_BOOLEAN = 4;
    private static final byte T_CHAR = 5;
    private static final byte T_FLOAT = 6;
    private static final byte T_DOUBLE = 7;
    private static final byte T_BYTE = 8;
    private static final byte T_SHORT = 9;
    private static final byte T_INT = 10;
    private static final byte T_LONG = 11;
    private static final byte T_VOID = 12;
    private static final String[] TYPE_NAMES = new String[]{"<illegal type>", "<illegal type>", "<illegal type>", "<illegal type>", "boolean", "char", "float", "double", "byte", "short", "int", "long", "void", "array", "object", "unknown"};
    private static final String[] SHORT_TYPE_NAMES = new String[]{"<illegal type>", "<illegal type>", "<illegal type>", "<illegal type>", "Z", "C", "F", "D", "B", "S", "I", "J", "V", "<illegal type>", "<illegal type>", "<illegal type>"};

    public static String convertName(Class javaType) {
        String ret = "";
        while (javaType.isArray()) {
            ret = ret + "[]";
            javaType = javaType.getComponentType();
        }
        return javaType.getName() + ret;
    }

    public static String getSignature(Method method) {
        Class<?>[] params = method.getParameterTypes();
        String[] typeNames = new String[params.length];
        int i = 0;
        while (i < params.length) {
            typeNames[i] = SignatureHelper.convertName(params[i]);
            ++i;
        }
        return SignatureHelper.methodTypeToSignature(SignatureHelper.convertName(method.getReturnType()), typeNames);
    }

    public static String getSignature(Class[] params, Class returnType) {
        String[] typeNames = new String[params.length];
        int i = 0;
        while (i < params.length) {
            typeNames[i] = SignatureHelper.convertName(params[i]);
            ++i;
        }
        return SignatureHelper.methodTypeToSignature(SignatureHelper.convertName(returnType), typeNames);
    }

    public static String methodTypeToSignature(String[] argv) {
        StringBuffer buf = new StringBuffer("(");
        if (argv != null) {
            int i = 0;
            while (i < argv.length) {
                String param = SignatureHelper.removeMaliciousChars(argv[i]);
                String str = SignatureHelper.getSignature(param);
                if (str.endsWith("V")) {
                    throw new RuntimeException("Invalid type: " + argv[i]);
                }
                buf.append(str);
                ++i;
            }
        }
        buf.append(")");
        return buf.toString();
    }

    public static String methodTypeToSignature(String ret, String[] argv) {
        return SignatureHelper.methodTypeToSignature(argv) + SignatureHelper.getSignature(ret);
    }

    private static String removeMaliciousChars(String s) {
        if (s.startsWith(",")) {
            return s.substring(1);
        }
        return s;
    }

    public static String getSignature(String type) {
        StringBuffer buf = new StringBuffer();
        char[] chars = type.toCharArray();
        boolean char_found = false;
        boolean delim = false;
        int index = -1;
        int i = 0;
        block4: while (i < chars.length) {
            switch (chars[i]) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    if (!char_found) break;
                    delim = true;
                    break;
                }
                case '[': {
                    if (!char_found) {
                        throw new RuntimeException("Illegal type: " + type);
                    }
                    index = i;
                    break block4;
                }
                default: {
                    char_found = true;
                    if (delim) break;
                    buf.append(chars[i]);
                }
            }
            ++i;
        }
        int brackets = 0;
        if (index > 0) {
            brackets = SignatureHelper.countBrackets(type.substring(index));
        }
        type = buf.toString();
        buf.setLength(0);
        int i2 = 0;
        while (i2 < brackets) {
            buf.append('[');
            ++i2;
        }
        boolean found = false;
        int i3 = 4;
        while (i3 <= 12 && !found) {
            if (TYPE_NAMES[i3].equals(type)) {
                found = true;
                buf.append(SHORT_TYPE_NAMES[i3]);
            }
            ++i3;
        }
        if (!found) {
            buf.append('L' + type.replace('.', '/') + ';');
        }
        return buf.toString();
    }

    public static int countBrackets(String brackets) {
        char[] chars = brackets.toCharArray();
        int count = 0;
        boolean open = false;
        int i = 0;
        while (i < chars.length) {
            switch (chars[i]) {
                case '[': {
                    if (open) {
                        throw new RuntimeException("Illegally nested brackets:" + brackets);
                    }
                    open = true;
                    break;
                }
                case ']': {
                    if (!open) {
                        throw new RuntimeException("Illegally nested brackets:" + brackets);
                    }
                    open = false;
                    ++count;
                    break;
                }
            }
            ++i;
        }
        if (open) {
            throw new RuntimeException("Illegally nested brackets:" + brackets);
        }
        return count;
    }
}

