/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.util;

import com.idoox.util.Pool;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;

public class ObjectPool
implements Pool {
    private Object[] objects;
    private int top;
    private int size;
    private int minTop;
    private Pool.Factory factory;
    private static Shrinker shrinker = new Shrinker();

    public static void destroyPools() {
        shrinker.clear();
        shrinker = new Shrinker();
    }

    public ObjectPool() {
        shrinker.addPool(this);
    }

    public ObjectPool(Pool.Factory fact, int size) {
        this.init(fact, size);
        shrinker.addPool(this);
    }

    public void init(Pool.Factory fact, int size) {
        this.objects = new Object[size];
        this.top = -1;
        this.minTop = size;
        this.size = size;
        this.factory = fact;
    }

    public Object get() {
        ObjectPool objectPool = this;
        synchronized (objectPool) {
            if (this.top >= 0) {
                Object retval = this.objects[this.top];
                this.objects[this.top] = null;
                --this.top;
                if (this.top < this.minTop) {
                    this.minTop = this.top;
                }
                Object object = retval;
                return object;
            }
            this.minTop = -1;
        }
        return this.factory.getNewInstance();
    }

    public synchronized void release(Object obj) {
        if (obj == null) {
            throw new RuntimeException("Pool can not contain nulls");
        }
        if (this.top < this.size - 1) {
            ++this.top;
            this.objects[this.top] = obj;
        }
    }

    synchronized void shrink() {
        if (this.factory != null) {
            int shrinkBy;
            if (this.minTop == this.size) {
                this.minTop = this.top;
            }
            if ((shrinkBy = this.minTop + 1) > 0) {
                System.arraycopy(this.objects, shrinkBy, this.objects, 0, this.top + 1 - shrinkBy);
                int i = this.top + 1 - shrinkBy;
                while (i <= this.top) {
                    this.objects[i] = null;
                    ++i;
                }
                this.top -= shrinkBy;
            }
            this.minTop = this.size;
        }
    }

    private static class Shrinker
    extends TimerTask {
        List pools = new LinkedList();
        Timer timer = null;

        public synchronized void run() {
            Iterator iter = this.pools.iterator();
            while (iter.hasNext()) {
                ((ObjectPool)iter.next()).shrink();
            }
        }

        synchronized void clear() {
            if (this.timer != null) {
                this.timer.cancel();
                this.timer = null;
                this.pools.clear();
            }
        }

        synchronized void addPool(ObjectPool pool) {
            if (this.timer == null) {
                this.timer = new Timer(true);
                this.timer.schedule((TimerTask)this, 30000L, 30000L);
            }
            this.pools.add(pool);
        }

        Shrinker() {
        }
    }
}

