/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.util;

import com.idoox.util.ObjectPool;
import com.idoox.util.Pool;
import com.idoox.util.StreamReaderWriterPool;
import com.idoox.wasp.Constants;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.idoox.util.RuntimeWrappedException;
import sun.io.ByteToCharConverter;
import sun.io.CharToByteConverter;
import sun.io.ConversionBufferFullException;
import sun.io.MalformedInputException;

class IdooxImplementationStreamReaderWriterFactory
implements StreamReaderWriterPool.StreamReaderWriterFactory {
    Pool inputStreamPool = new ObjectPool();
    Pool outputStreamPool;

    IdooxImplementationStreamReaderWriterFactory() {
        this.inputStreamPool.init(new InputStreamReaderPoolFactory(), 10);
        this.outputStreamPool = new ObjectPool();
        this.outputStreamPool.init(new OutputStreamWriterPoolFactory(), 10);
    }

    public Reader getInputStreamUTFReader(InputStream is) throws UnsupportedEncodingException {
        IdooxInputStreamReader reader = (IdooxInputStreamReader)this.inputStreamPool.get();
        reader.setInputStream(is);
        return reader;
    }

    public void releaseInputStreamUTFReader(Reader reader) {
        if (reader instanceof IdooxInputStreamReader) {
            this.inputStreamPool.release(reader);
        }
    }

    public Writer getOutputStreamUTFWriter(OutputStream os) throws UnsupportedEncodingException {
        IdooxOutputStreamWriter writer = (IdooxOutputStreamWriter)this.outputStreamPool.get();
        writer.setOutputStream(os);
        return writer;
    }

    public void releaseOutputStreamUTFWriter(Writer writer) {
        if (writer instanceof IdooxOutputStreamWriter) {
            this.outputStreamPool.release(writer);
        }
    }

    static class IdooxOutputStreamWriter
    extends Writer {
        private CharToByteConverter ctb;
        private OutputStream out;
        private static final int defaultByteBufferSize = 8192;
        private byte[] bb;
        private int nextByte = 0;
        private int nBytes = 0;
        char[] bfr = new char[10];

        public IdooxOutputStreamWriter(String enc) throws UnsupportedEncodingException {
            this.ctb = enc.equals(Constants.UTF_8) ? new CharToByteUTF8() : CharToByteConverter.getConverter((String)enc);
            this.bb = new byte[8192];
            this.nBytes = 8192;
        }

        public IdooxOutputStreamWriter() {
            this(new CharToByteUTF8());
        }

        private IdooxOutputStreamWriter(CharToByteConverter ctb) {
            this.ctb = ctb;
            this.bb = new byte[8192];
            this.nBytes = 8192;
        }

        public void setOutputStream(OutputStream os) {
            this.out = os;
            this.lock = os;
            this.nextByte = 0;
        }

        public String getEncoding() {
            Object object = this.lock;
            synchronized (object) {
                if (this.ctb != null) {
                    String string = this.ctb.getCharacterEncoding();
                    return string;
                }
                String string = null;
                return string;
            }
        }

        private void ensureOpen() throws IOException {
            if (this.out == null) {
                throw new IOException("Stream closed");
            }
        }

        public void write(int c) throws IOException {
            this.bfr[0] = (char)c;
            this.write(this.bfr, 0, 1);
        }

        public void write(char[] cbuf, int off, int len) throws IOException {
            Object object = this.lock;
            synchronized (object) {
                this.ensureOpen();
                if (off < 0 || off > cbuf.length || len < 0 || off + len > cbuf.length || off + len < 0) {
                    throw new IndexOutOfBoundsException();
                }
                if (len == 0) {
                    return;
                }
                int ci = off;
                int end = off + len;
                boolean bufferFlushed = false;
                while (ci < end) {
                    boolean bufferFull = false;
                    try {
                        this.nextByte += this.ctb.convertAny(cbuf, ci, end, this.bb, this.nextByte, this.nBytes);
                        ci = end;
                    }
                    catch (ConversionBufferFullException x) {
                        int nci = this.ctb.nextCharIndex();
                        if (nci == ci && bufferFlushed) {
                            throw new CharConversionException("Output buffer too small");
                        }
                        ci = nci;
                        bufferFull = true;
                        this.nextByte = this.ctb.nextByteIndex();
                    }
                    if (this.nextByte < this.nBytes && !bufferFull) continue;
                    this.out.write(this.bb, 0, this.nextByte);
                    this.nextByte = 0;
                    bufferFlushed = true;
                }
            }
        }

        public void write(String str, int off, int len) throws IOException {
            if (len < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (this.bfr.length < len) {
                this.bfr = new char[len];
            }
            str.getChars(off, off + len, this.bfr, 0);
            this.write(this.bfr, 0, len);
        }

        void flushBuffer() throws IOException {
            Object object = this.lock;
            synchronized (object) {
                this.ensureOpen();
                while (true) {
                    try {
                        this.nextByte += this.ctb.flushAny(this.bb, this.nextByte, this.nBytes);
                    }
                    catch (ConversionBufferFullException x) {
                        this.nextByte = this.ctb.nextByteIndex();
                    }
                    if (this.nextByte == 0) break;
                    if (this.nextByte <= 0) continue;
                    this.out.write(this.bb, 0, this.nextByte);
                    this.nextByte = 0;
                }
            }
        }

        public void flush() throws IOException {
            Object object = this.lock;
            synchronized (object) {
                this.flushBuffer();
                this.out.flush();
            }
        }

        public void close() throws IOException {
            Object object = this.lock;
            synchronized (object) {
                if (this.out == null) {
                    return;
                }
                this.flush();
                this.out.close();
                this.out = null;
                this.bb = null;
                this.ctb = null;
            }
        }
    }

    private static class CharToByteUTF8
    extends CharToByteConverter {
        private byte[] abyte1 = new byte[6];
        private char highHalfZoneCode;

        public int flush(byte[] abyte0, int i, int j) throws MalformedInputException {
            if (this.highHalfZoneCode != '\u0000') {
                this.highHalfZoneCode = '\u0000';
                this.badInputLength = 0;
                throw new MalformedInputException();
            }
            this.charOff = 0;
            this.byteOff = 0;
            return 0;
        }

        /*
         * Handled impossible loop by adding 'first' condition
         * Enabled aggressive block sorting
         */
        public int convert(char[] ac, int i, int j, byte[] abyte0, int k, int l) throws ConversionBufferFullException, MalformedInputException {
            this.charOff = i;
            this.byteOff = k;
            boolean bl = true;
            do {
                int byte1;
                int byte0;
                char c1;
                if (bl && !(bl = false)) {
                    if (this.highHalfZoneCode == '\u0000') continue;
                    char c = this.highHalfZoneCode;
                    this.highHalfZoneCode = '\u0000';
                    if (ac[i] >= '\udc00' && ac[i] <= '\udfff') {
                        int i1 = (this.highHalfZoneCode - 55296) * 1024 + (ac[i] - 56320) + 65536;
                        abyte0[0] = (byte)(0xF0 | i1 >> 18 & 7);
                        abyte0[1] = (byte)(0x80 | i1 >> 12 & 0x3F);
                        abyte0[2] = (byte)(0x80 | i1 >> 6 & 0x3F);
                        abyte0[3] = (byte)(0x80 | i1 & 0x3F);
                        ++this.charOff;
                        this.highHalfZoneCode = '\u0000';
                        if (true) continue;
                    }
                    this.badInputLength = 0;
                    throw new MalformedInputException();
                }
                if ((c1 = ac[this.charOff]) < '\u0080') {
                    this.abyte1[0] = (byte)c1;
                    byte0 = 1;
                    byte1 = 1;
                } else if (c1 < '\u0800') {
                    this.abyte1[0] = (byte)(0xC0 | c1 >> 6 & 0x1F);
                    this.abyte1[1] = (byte)(0x80 | c1 & 0x3F);
                    byte0 = 1;
                    byte1 = 2;
                } else if (c1 >= '\ud800' && c1 <= '\udbff') {
                    if (this.charOff + 1 >= j) {
                        this.highHalfZoneCode = c1;
                        return this.byteOff - k;
                    }
                    char c2 = ac[this.charOff + 1];
                    if (c2 < '\udc00' || c2 > '\udfff') {
                        this.badInputLength = 1;
                        throw new MalformedInputException();
                    }
                    int k1 = (c1 - 55296) * 1024 + (c2 - 56320) + 65536;
                    this.abyte1[0] = (byte)(0xF0 | k1 >> 18 & 7);
                    this.abyte1[1] = (byte)(0x80 | k1 >> 12 & 0x3F);
                    this.abyte1[2] = (byte)(0x80 | k1 >> 6 & 0x3F);
                    this.abyte1[3] = (byte)(0x80 | k1 & 0x3F);
                    byte1 = 4;
                    byte0 = 2;
                } else {
                    this.abyte1[0] = (byte)(0xE0 | c1 >> 12 & 0xF);
                    this.abyte1[1] = (byte)(0x80 | c1 >> 6 & 0x3F);
                    this.abyte1[2] = (byte)(0x80 | c1 & 0x3F);
                    byte0 = 1;
                    byte1 = 3;
                }
                if (this.byteOff + byte1 > l) {
                    throw new ConversionBufferFullException();
                }
                int j1 = 0;
                while (j1 < byte1) {
                    abyte0[this.byteOff++] = this.abyte1[j1];
                    ++j1;
                }
                this.charOff += byte0;
            } while (this.charOff < j);
            return this.byteOff - k;
        }

        public boolean canConvert(char c) {
            return true;
        }

        public int getMaxBytesPerChar() {
            return 3;
        }

        public void reset() {
            this.charOff = 0;
            this.byteOff = 0;
            this.highHalfZoneCode = '\u0000';
        }

        public String getCharacterEncoding() {
            return "UTF8";
        }
    }

    static class IdooxInputStreamReader
    extends Reader {
        private ByteToCharConverter btc;
        private InputStream in;
        private static final int defaultByteBufferSize = 8192;
        private byte[] bb;
        private int nBytes = 0;
        private int nextByte = 0;

        public IdooxInputStreamReader() {
            this(ByteToCharConverter.getDefault());
        }

        public IdooxInputStreamReader(String enc) throws UnsupportedEncodingException {
            this(ByteToCharConverter.getConverter((String)enc));
        }

        private IdooxInputStreamReader(ByteToCharConverter btc) {
            this.btc = btc;
            this.bb = new byte[8192];
        }

        public void setInputStream(InputStream is) {
            this.in = is;
            this.lock = is;
            this.nBytes = 0;
            this.nextByte = 0;
        }

        public String getEncoding() {
            Object object = this.lock;
            synchronized (object) {
                if (this.btc != null) {
                    String string = this.btc.getCharacterEncoding();
                    return string;
                }
                String string = null;
                return string;
            }
        }

        private void malfunction() {
            throw new InternalError("Converter malfunction (" + this.btc.getCharacterEncoding() + ") -- please submit a bug report via " + System.getProperty("java.vendor.url.bug"));
        }

        private int convertInto(char[] cbuf, int off, int end) throws IOException {
            int nc = 0;
            if (this.nextByte < this.nBytes) {
                try {
                    nc = this.btc.convert(this.bb, this.nextByte, this.nBytes, cbuf, off, end);
                    this.nextByte = this.nBytes;
                    if (this.btc.nextByteIndex() != this.nextByte) {
                        this.malfunction();
                    }
                }
                catch (ConversionBufferFullException x) {
                    this.nextByte = this.btc.nextByteIndex();
                    nc = this.btc.nextCharIndex() - off;
                }
            }
            return nc;
        }

        private int flushInto(char[] cbuf, int off, int end) throws IOException {
            int nc = 0;
            try {
                nc = this.btc.flush(cbuf, off, end);
            }
            catch (ConversionBufferFullException x) {
                nc = this.btc.nextCharIndex() - off;
            }
            return nc;
        }

        private int fill(char[] cbuf, int off, int end) throws IOException {
            int nc = 0;
            if (this.nextByte < this.nBytes) {
                nc = this.convertInto(cbuf, off, end);
            }
            while (off + nc < end) {
                if (this.nBytes != -1) {
                    if (nc > 0 && !this.inReady()) break;
                    this.nBytes = this.in.read(this.bb);
                }
                if (this.nBytes == -1) {
                    this.nBytes = 0;
                    if ((nc += this.flushInto(cbuf, off + nc, end)) != 0) break;
                    return -1;
                }
                this.nextByte = 0;
                nc += this.convertInto(cbuf, off + nc, end);
            }
            return nc;
        }

        private boolean inReady() {
            try {
                return this.in.available() > 0;
            }
            catch (IOException x) {
                return false;
            }
        }

        private void ensureOpen() throws IOException {
            if (this.in == null) {
                throw new IOException("Stream closed");
            }
        }

        public int read() throws IOException {
            char[] cb = new char[1];
            if (this.read(cb, 0, 1) == -1) {
                return -1;
            }
            return cb[0];
        }

        public int read(char[] cbuf, int off, int len) throws IOException {
            Object object = this.lock;
            synchronized (object) {
                this.ensureOpen();
                if (off < 0 || off > cbuf.length || len < 0 || off + len > cbuf.length || off + len < 0) {
                    throw new IndexOutOfBoundsException();
                }
                if (len == 0) {
                    int n = 0;
                    return n;
                }
                int n = this.fill(cbuf, off, off + len);
                return n;
            }
        }

        public boolean ready() throws IOException {
            Object object = this.lock;
            synchronized (object) {
                this.ensureOpen();
                boolean bl = this.nextByte < this.nBytes || this.inReady();
                return bl;
            }
        }

        public void close() throws IOException {
            Object object = this.lock;
            synchronized (object) {
                if (this.in == null) {
                    return;
                }
                this.in.close();
                this.in = null;
            }
        }
    }

    static class OutputStreamWriterPoolFactory
    implements Pool.Factory {
        OutputStreamWriterPoolFactory() {
        }

        public Object getNewInstance() {
            try {
                return new IdooxOutputStreamWriter(Constants.UTF_8);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeWrappedException(e);
            }
        }
    }

    static class InputStreamReaderPoolFactory
    implements Pool.Factory {
        InputStreamReaderPoolFactory() {
        }

        public Object getNewInstance() {
            try {
                return new IdooxInputStreamReader(Constants.UTF_8);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeWrappedException(e);
            }
        }
    }
}

