/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.util;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class HierarchicalMap
implements Map {
    private HashMap ownMap;
    private Set invalidKeyOwnMap = new HashSet();
    private Map delegateMap;
    private Map temporaryRemoved = new HashMap();
    protected Set keySet;
    protected Set entrySet;
    protected Collection values;
    private Set tmpSet;

    public HierarchicalMap(Map delegateMap) {
        this.ownMap = new HashMap();
        this.delegateMap = delegateMap;
    }

    public HierarchicalMap(int initialCapacity, float loadFactor, Map delegateMap) {
        this.ownMap = new HashMap(initialCapacity, loadFactor);
        this.delegateMap = delegateMap;
    }

    public HierarchicalMap(int initialCapacity, Map delegateMap) {
        this.ownMap = new HashMap(initialCapacity);
        this.delegateMap = delegateMap;
    }

    public HierarchicalMap(Map m, Map delegateMap) {
        this.ownMap = new HashMap(m);
        this.delegateMap = delegateMap;
    }

    public HierarchicalMap(Map m, Map delegateMap, Set invalidKeyOwnMap) {
        this.ownMap = new HashMap(m);
        this.delegateMap = delegateMap;
        this.invalidKeyOwnMap = new HashSet(invalidKeyOwnMap);
    }

    public boolean isEmpty() {
        if (!this.ownMap.isEmpty()) {
            return false;
        }
        if (this.delegateMap != null) {
            return this.delegateMap.isEmpty();
        }
        return true;
    }

    public boolean containsKey(Object key) {
        if (this.ownMap.containsKey(key)) {
            return true;
        }
        if (this.delegateMap != null) {
            if (this.temporaryRemoved.containsKey(key)) {
                return false;
            }
            return this.delegateMap.containsKey(key);
        }
        return false;
    }

    private boolean containsValueInternal(Object value) {
        int tempCounter = 0;
        Collection tempRemoved = this.temporaryRemoved.values();
        Iterator iterator = tempRemoved.iterator();
        while (iterator.hasNext()) {
            Object o = iterator.next();
            if (!o.equals(value)) continue;
            ++tempCounter;
        }
        int counter = 0;
        if (this.delegateMap != null) {
            Collection delagete = this.delegateMap.values();
            Iterator iterator2 = delagete.iterator();
            while (iterator2.hasNext()) {
                Object o = iterator2.next();
                if (!o.equals(value)) continue;
                ++counter;
            }
        }
        return counter > tempCounter;
    }

    public boolean containsValue(Object value) {
        if (this.ownMap.containsValue(value)) {
            return true;
        }
        if (this.delegateMap != null) {
            return this.containsValueInternal(value);
        }
        return false;
    }

    public Object get(Object key) {
        Object o = this.ownMap.get(key);
        if (o != null || this.ownMap.containsKey(key)) {
            return o;
        }
        if (this.delegateMap != null) {
            if (this.temporaryRemoved.containsKey(key)) {
                return null;
            }
            return this.delegateMap.get(key);
        }
        return null;
    }

    public Object put(Object key, Object value) {
        this.invalidKeyOwnMap.remove(key);
        return this.ownMap.put(key, value);
    }

    public void putAll(Map t) {
        this.invalidKeyOwnMap.removeAll(t.keySet());
        this.ownMap.putAll(t);
    }

    public Object remove(Object key) {
        Object o = this.ownMap.remove(key);
        this.invalidKeyOwnMap.remove(key);
        Object odel = null;
        if (this.delegateMap != null) {
            odel = this.delegateMap.get(key);
        }
        if (odel != null) {
            this.temporaryRemoved.put(key, odel);
        }
        if (o != null) {
            return o;
        }
        return odel;
    }

    public void clear() {
        this.ownMap.clear();
        this.invalidKeyOwnMap.clear();
        if (this.delegateMap != null) {
            this.temporaryRemoved.putAll(this.delegateMap);
        }
    }

    public void removeInvalidOwnData() {
        if (this.ownMap.size() == this.invalidKeyOwnMap.size()) {
            this.ownMap.clear();
        } else {
            Iterator iterator = this.invalidKeyOwnMap.iterator();
            while (iterator.hasNext()) {
                Object key = iterator.next();
                this.ownMap.remove(key);
            }
        }
        this.invalidKeyOwnMap.clear();
        this.temporaryRemoved.clear();
    }

    public void setOwnDataAsInvalid() {
        this.invalidKeyOwnMap.addAll(this.ownMap.keySet());
    }

    public Map getOwnMap() {
        return this.ownMap;
    }

    public Map getDelegateMap() {
        return this.delegateMap;
    }

    public int size() {
        if (this.tmpSet == null) {
            this.tmpSet = new HashSet();
        } else {
            this.tmpSet.clear();
        }
        this.tmpSet.addAll(this.ownMap.keySet());
        if (this.delegateMap != null) {
            this.tmpSet.addAll(this.delegateMap.keySet());
            this.tmpSet.removeAll(this.temporaryRemoved.keySet());
        }
        return this.tmpSet.size();
    }

    public Set keySet() {
        Set ks = this.keySet;
        return ks != null ? ks : (this.keySet = new KeySet());
    }

    public Set entrySet() {
        Set es = this.entrySet;
        return es != null ? es : (this.entrySet = new EntrySet());
    }

    public Collection values() {
        Collection vs = this.values;
        return vs != null ? vs : (this.values = new Values());
    }

    public Object clone() {
        return new HierarchicalMap((HashMap)this.ownMap.clone(), this.delegateMap, this.invalidKeyOwnMap);
    }

    private Map.Entry getEntryInternal(Map map, Object key) {
        Set set = map.entrySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (!entry.getKey().equals(key)) continue;
            return entry;
        }
        return null;
    }

    Map.Entry getEntry(Object key) {
        Map.Entry entry = this.getEntryInternal(this.ownMap, key);
        if (entry != null) {
            return entry;
        }
        if (this.delegateMap != null) {
            if (this.temporaryRemoved.containsKey(key)) {
                return null;
            }
            return this.getEntryInternal(this.delegateMap, key);
        }
        return null;
    }

    Iterator newKeyIterator() {
        return new KeyIterator();
    }

    Iterator newEntryIterator() {
        return new EntryIterator();
    }

    Iterator newValueIterator() {
        return new ValueIterator();
    }

    private class ValueIterator
    implements Iterator {
        Set set;
        Iterator iterator;
        Object current;

        private ValueIterator() {
            this.set = HierarchicalMap.this.entrySet();
            this.iterator = this.set.iterator();
        }

        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public Object next() {
            this.current = this.iterator.next();
            return ((Map.Entry)this.current).getValue();
        }

        public void remove() {
            HierarchicalMap.this.remove(((Map.Entry)this.current).getKey());
            this.current = null;
        }
    }

    private class EntryIterator
    implements Iterator {
        Set set;
        Iterator iterator;
        Object current;

        private EntryIterator() {
            this.set = HierarchicalMap.this.keySet();
            this.iterator = this.set.iterator();
        }

        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public Object next() {
            Object key = this.iterator.next();
            this.current = HierarchicalMap.this.getEntry(key);
            return this.current;
        }

        public void remove() {
            HierarchicalMap.this.remove(((Map.Entry)this.current).getKey());
            this.current = null;
        }
    }

    private class KeyIterator
    implements Iterator {
        Set keySet = new HashSet();
        Iterator iterator;
        Object current;

        public KeyIterator() {
            this.keySet.addAll(HierarchicalMap.this.ownMap.keySet());
            if (HierarchicalMap.this.delegateMap != null) {
                this.keySet.addAll(HierarchicalMap.this.delegateMap.keySet());
                this.keySet.removeAll(HierarchicalMap.this.temporaryRemoved.keySet());
            }
            this.iterator = this.keySet.iterator();
        }

        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public Object next() {
            this.current = this.iterator.next();
            return this.current;
        }

        public void remove() {
            HierarchicalMap.this.remove(this.current);
            this.current = null;
        }
    }

    protected class Values
    extends AbstractCollection {
        protected Values() {
        }

        public Iterator iterator() {
            return HierarchicalMap.this.newValueIterator();
        }

        public int size() {
            return HierarchicalMap.this.size();
        }

        public boolean contains(Object o) {
            return HierarchicalMap.this.containsValue(o);
        }

        public void clear() {
            HierarchicalMap.this.clear();
        }
    }

    protected class EntrySet
    extends AbstractSet {
        protected EntrySet() {
        }

        public Iterator iterator() {
            return HierarchicalMap.this.newEntryIterator();
        }

        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Map.Entry candidate = HierarchicalMap.this.getEntry(e.getKey());
            return candidate != null && candidate.equals(e);
        }

        public boolean remove(Object o) {
            Object tmp;
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Map.Entry candidate = HierarchicalMap.this.getEntry(e.getKey());
            return candidate != null && candidate.equals(e) && (tmp = HierarchicalMap.this.remove(e.getKey())) != null;
        }

        public int size() {
            return HierarchicalMap.this.size();
        }

        public void clear() {
            HierarchicalMap.this.clear();
        }
    }

    protected class KeySet
    extends AbstractSet {
        protected KeySet() {
        }

        public Iterator iterator() {
            return HierarchicalMap.this.newKeyIterator();
        }

        public int size() {
            return HierarchicalMap.this.size();
        }

        public boolean contains(Object o) {
            return HierarchicalMap.this.containsKey(o);
        }

        public boolean remove(Object o) {
            return HierarchicalMap.this.remove(o) != null;
        }

        public void clear() {
            HierarchicalMap.this.clear();
        }
    }
}

