/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.util;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.idoox.transport.TransportMethod;
import org.idoox.transport.client.Endpoint;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class ElementHelper {
    private static DocumentBuilderFactory factory = null;

    public static String getAttribute(Element element, String attribute) {
        if (!element.hasAttribute(attribute)) {
            return null;
        }
        return element.getAttribute(attribute);
    }

    public static void setAttribute(Element element, String attribute, String value) {
        element.setAttribute(attribute, value);
    }

    public static String getAttributeNS(Element element, String attributeNS, String attribute) {
        if (attributeNS == null) {
            return ElementHelper.getAttribute(element, attribute);
        }
        NamedNodeMap attrs = element.getAttributes();
        Attr a = (Attr)attrs.getNamedItemNS(attributeNS, attribute);
        if (a == null) {
            return null;
        }
        return a.getValue();
    }

    public static Document createEmptyDocument() throws ParserConfigurationException {
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.newDocument();
    }

    public static Document loadDocument(Endpoint location) throws ParserConfigurationException, IOException, MalformedURLException, SAXException {
        return ElementHelper.loadDocument(location, null);
    }

    public static Document loadDocument(Endpoint location, Map transportProperties) throws ParserConfigurationException, IOException, MalformedURLException, SAXException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.parse(location.newConnection(TransportMethod.GET, transportProperties).getInputMessage(), location.toExternalForm());
    }

    public static Element[] getChildrenElementsByTagName(Element parent, String namespace, String name) {
        Object e;
        ArrayList<Object> els = new ArrayList<Object>();
        Node n = parent.getFirstChild();
        while (n != null) {
            if (n.getNodeType() == 1 && (e = (Element)n).getLocalName().equals(name)) {
                String nsURI = e.getNamespaceURI();
                if (namespace == null) {
                    if (nsURI == null || nsURI.length() == 0) {
                        els.add(e);
                    }
                } else if (namespace.equals(nsURI)) {
                    els.add(e);
                }
            }
            n = n.getNextSibling();
        }
        e = new Element[els.size()];
        return els.toArray((T[])e);
    }

    public static QName getTagName(Element el) {
        return new QName(el.getNamespaceURI(), el.getLocalName());
    }

    public static Element getChildElementByTagName(Element parent, String namespace, String name) throws IllegalStateException {
        Element returned = null;
        Node n = parent.getFirstChild();
        while (n != null) {
            Element e;
            if (n.getNodeType() == 1 && (e = (Element)n).getLocalName().equals(name)) {
                String nsURI = e.getNamespaceURI();
                if (namespace == null) {
                    if (nsURI == null || nsURI.length() == 0) {
                        if (returned != null) {
                            throw new IllegalStateException("Element " + namespace + ", " + name + " occured more than once in " + ElementHelper.getFullPath(parent));
                        }
                        returned = e;
                    }
                } else if (namespace.equals(nsURI)) {
                    if (returned != null) {
                        throw new IllegalStateException("Element " + namespace + ", " + name + "([@name=" + ElementHelper.getAttributeNS(e, null, "name") + "]) occured more than once in " + ElementHelper.getFullPath(parent));
                    }
                    returned = e;
                }
            }
            n = n.getNextSibling();
        }
        return returned;
    }

    public static String getTargetNamespace(Element element, String defaultTargetNamespace) {
        while (true) {
            String targetNamespace;
            if ((targetNamespace = ElementHelper.getAttributeNS(element, null, "targetNamespace")) != null) {
                return targetNamespace;
            }
            Node n = element.getParentNode();
            if (n == null || n.getNodeType() != 1) break;
            element = (Element)n;
        }
        return defaultTargetNamespace;
    }

    public static QName chameleonQName(QName qName, String chameleonNamespace) {
        String namespaceURI;
        if (chameleonNamespace != null && ((namespaceURI = qName.getNamespaceURI()) == null || namespaceURI.length() == 0)) {
            return new QName(chameleonNamespace, qName.getLocalPart());
        }
        return qName;
    }

    public static QName getQName(Element context, String qname) throws IllegalArgumentException {
        if (qname == null) {
            return null;
        }
        int p = qname.indexOf(58);
        if (p < 0) {
            return new QName(ElementHelper.getDefaultNamespace(context), qname);
        }
        String prefix = qname.substring(0, p);
        String localName = qname.substring(p + 1);
        String nsDecl = "xmlns:" + prefix;
        int pathLen = 0;
        Node n = context;
        while (n != null) {
            String ns;
            if (n.getNodeType() == 1 && (ns = ElementHelper.getAttribute(n, nsDecl)) != null) {
                if (pathLen > 1) {
                    // empty if block
                }
                return new QName(ns, localName);
            }
            ++pathLen;
            n = n.getParentNode();
        }
        if ("xml".equals(prefix)) {
            return new QName("http://www.w3.org/XML/1998/namespace", localName);
        }
        throw new IllegalArgumentException("Undefined namespace for " + qname);
    }

    public static String getNamespaceURI(Element element) {
        return element.getNamespaceURI();
    }

    public static String getDefaultNamespace(Element context) {
        Node n = context;
        while (n != null) {
            String ns;
            if (n.getNodeType() == 1 && (ns = ElementHelper.getAttribute(n, "xmlns")) != null) {
                return ns.length() > 0 ? ns : null;
            }
            n = n.getParentNode();
        }
        return null;
    }

    public static String getFullPath(Element e) {
        String targetNamespace;
        StringBuffer r = new StringBuffer();
        if (e.getParentNode() != null && e.getParentNode().getNodeType() == 1) {
            r.append(ElementHelper.getFullPath((Element)e.getParentNode()));
            r.append("/");
        }
        r.append(e.getTagName());
        r.append("[");
        String name = ElementHelper.getAttribute(e, "name");
        if (name != null) {
            r.append("name='");
            r.append(name);
            r.append("'");
        }
        if ((targetNamespace = ElementHelper.getAttribute(e, "targetNamespace")) != null) {
            r.append("targetNamespace='");
            r.append(targetNamespace);
            r.append("'");
        }
        r.append("]");
        if (e.getParentNode() != null) {
            if (e.getParentNode().getNodeType() != 1) {
                r.insert(0, "/");
            }
        } else {
            r.insert(0, ".../");
        }
        return r.toString();
    }

    public static String toString(Element e) {
        StringBuffer b = new StringBuffer();
        ElementHelper.toString(e, b);
        return b.toString();
    }

    private static void toString(Node n, StringBuffer b) {
        if (n instanceof CharacterData) {
            String val = ((CharacterData)n).getData();
            val = val.replace('\n', ' ');
            val = val.replace('\t', ' ');
            b.append(val);
        } else if (n instanceof Element) {
            Element e = (Element)n;
            n = e.getFirstChild();
            while (n != null) {
                ElementHelper.toString(n, b);
                n = n.getNextSibling();
            }
        }
    }

    public static Map getDeclaredNamespaces(Element element, Map ret) {
        NamedNodeMap attrs = element.getAttributes();
        int l = attrs.getLength();
        int i = 0;
        while (i < l) {
            Attr a = (Attr)attrs.item(i);
            if (a.getName().equals("xmlns")) {
                if (ret == null) {
                    ret = new HashMap<String, String>(11);
                }
                if (!ret.containsKey("")) {
                    ret.put("", a.getValue());
                }
            } else if (a.getName().startsWith("xmlns:")) {
                String n;
                if (ret == null) {
                    ret = new HashMap(11);
                }
                if (!ret.containsKey(n = a.getName().substring(6))) {
                    ret.put(n, a.getValue());
                }
            }
            ++i;
        }
        return ret;
    }

    public static Map getAllNamespaces(Element element, Map ret) {
        while (element != null) {
            ret = ElementHelper.getDeclaredNamespaces(element, ret);
            Node n = element.getParentNode();
            if (n == null || !(n instanceof Element)) break;
            element = (Element)n;
        }
        return ret;
    }

    public static Element cloneNode(Element element) {
        if (element == null) {
            return null;
        }
        return ElementHelper.cloneNode1(element, element.getOwnerDocument());
    }

    private static Element cloneNode1(Element element, Document document) {
        Element cloned = document.createElementNS(element.getNamespaceURI(), element.getNodeName());
        NamedNodeMap attrs = element.getAttributes();
        int i = 0;
        while (i < attrs.getLength()) {
            Attr attr = (Attr)attrs.item(i);
            if (attr.getNamespaceURI() != null) {
                cloned.setAttributeNS(attr.getNamespaceURI(), attr.getNodeName(), attr.getNodeValue());
            } else {
                cloned.setAttribute(attr.getNodeName(), attr.getNodeValue());
            }
            ++i;
        }
        Node child = element.getFirstChild();
        while (child != null) {
            switch (child.getNodeType()) {
                case 1: {
                    cloned.appendChild(ElementHelper.cloneNode1((Element)child, document));
                    break;
                }
                case 3: {
                    cloned.appendChild(document.createTextNode(child.getNodeValue()));
                    break;
                }
                case 4: {
                    cloned.appendChild(document.createTextNode(child.getNodeValue()));
                }
            }
            child = child.getNextSibling();
        }
        return cloned;
    }

    static {
        factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(false);
    }
}

