/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class CachedStream
extends InputStream {
    InputStream wrappedStream;
    UnderlyingStreamCloser closer;
    static final int BUFFER_RESIZE = 2048;
    static final int INITIAL_BUFFER_SIZE = 2048;

    public CachedStream(InputStream wrapped, UnderlyingStreamCloser closer) {
        this.wrappedStream = wrapped;
        this.closer = closer;
        closer.addReference(this.wrappedStream);
    }

    public CachedStream(InputStream wrapped) {
        this.wrappedStream = wrapped;
    }

    /*
     * WARNING - void declaration
     */
    public void fillCache() throws IOException {
        int length;
        byte[] buffer = new byte[2048];
        int off = 0;
        while ((length = this.wrappedStream.read(buffer, off, buffer.length - off)) >= 0) {
            void var2_3;
            if ((off += var2_3) < buffer.length) continue;
            byte[] newBuffer = new byte[buffer.length + 2048];
            System.arraycopy(buffer, 0, newBuffer, 0, buffer.length);
            buffer = newBuffer;
        }
        this.close();
        this.wrappedStream = new ByteArrayInputStream(buffer, 0, off);
    }

    public int available() throws IOException {
        return this.wrappedStream.available();
    }

    public void close() throws IOException {
        if (this.closer != null) {
            this.closer.removeReference(this.wrappedStream);
            this.closer = null;
        }
    }

    public void mark(int readlimit) {
        this.wrappedStream.mark(readlimit);
    }

    public boolean markSupported() {
        return this.wrappedStream.markSupported();
    }

    public int read() throws IOException {
        return this.wrappedStream.read();
    }

    public int read(byte[] b) throws IOException {
        return this.wrappedStream.read(b);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        return this.wrappedStream.read(b, off, len);
    }

    public void reset() throws IOException {
        this.wrappedStream.reset();
    }

    public long skip(long n) throws IOException {
        return this.wrappedStream.skip(n);
    }

    public static interface UnderlyingStreamCloser {
        public void addReference(InputStream var1);

        public void removeReference(InputStream var1) throws IOException;
    }
}

