/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.transport.util;

import java.io.UnsupportedEncodingException;
import java.util.BitSet;
import org.idoox.util.RuntimeWrappedException;

public class URLEncoder {
    static BitSet dontNeedEncoding = new BitSet(256);

    private URLEncoder() {
    }

    public static String encode(String s) {
        return URLEncoder.encodeJava(s);
    }

    public static String encodeSpaces(String s) {
        StringBuffer out = new StringBuffer();
        boolean wasChanged = false;
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c == ' ') {
                out.append("%20");
                wasChanged = true;
            } else {
                out.append(c);
            }
            ++i;
        }
        return wasChanged ? out.toString() : s;
    }

    private static String encodeJava(String s) {
        byte[] bytes;
        boolean wasChanged = false;
        try {
            bytes = s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeWrappedException(e);
        }
        StringBuffer out = new StringBuffer(2 * s.length());
        int i = 0;
        while (i < bytes.length) {
            byte c = bytes[i];
            if (dontNeedEncoding.get(c & 0xFF)) {
                out.append((char)c);
            } else {
                wasChanged = true;
                URLEncoder.escapeOctet(out, c);
            }
            ++i;
        }
        return wasChanged ? out.toString() : s;
    }

    private static String encodeFast(String s) {
        boolean wasChanged = false;
        StringBuffer out = new StringBuffer(2 * s.length());
        int i = 0;
        while (i < s.length()) {
            char surrL;
            int ucs4 = s.charAt(i);
            if (ucs4 >= 55296 && ucs4 < 56320 && i + 1 < s.length() && (surrL = s.charAt(i + 1)) >= '\udc00' && surrL < '\ue000') {
                wasChanged = true;
                ++i;
                ucs4 = ucs4 - 55232 << 10 | surrL - 56320;
                URLEncoder.escapeOctet(out, 0xF0 | ucs4 >> 18 & 7);
                URLEncoder.escapeOctet(out, 0x80 | ucs4 >> 12 & 0x3F);
                URLEncoder.escapeOctet(out, 0x80 | ucs4 >> 6 & 0x3F);
                URLEncoder.escapeOctet(out, 0x80 | ucs4 & 0x3F);
            } else if (ucs4 < 128 && dontNeedEncoding.get(ucs4 & 0xFF)) {
                out.append((char)ucs4);
            } else {
                wasChanged = true;
                if (ucs4 < 128) {
                    URLEncoder.escapeOctet(out, ucs4 & 0x7F);
                } else if (ucs4 < 4096) {
                    URLEncoder.escapeOctet(out, 0xC0 | ucs4 >> 6 & 0x1F);
                    URLEncoder.escapeOctet(out, 0x80 | ucs4 & 0x3F);
                } else {
                    URLEncoder.escapeOctet(out, 0xE0 | ucs4 >> 12 & 0xF);
                    URLEncoder.escapeOctet(out, 0x80 | ucs4 >> 6 & 0x3F);
                    URLEncoder.escapeOctet(out, 0x80 | ucs4 & 0x3F);
                }
            }
            ++i;
        }
        return wasChanged ? out.toString() : s;
    }

    private static final void escapeOctet(StringBuffer out, int octet) {
        out.append('%');
        int ch = octet >> 4 & 0xF;
        ch = ch < 10 ? ch + 48 : ch + 65 - 10;
        out.append((char)ch);
        ch = octet & 0xF;
        ch = ch < 10 ? ch + 48 : ch + 65 - 10;
        out.append((char)ch);
    }

    static {
        int i = 97;
        while (i <= 122) {
            dontNeedEncoding.set(i);
            ++i;
        }
        int i2 = 65;
        while (i2 <= 90) {
            dontNeedEncoding.set(i2);
            ++i2;
        }
        int i3 = 48;
        while (i3 <= 57) {
            dontNeedEncoding.set(i3);
            ++i3;
        }
        dontNeedEncoding.set(45);
        dontNeedEncoding.set(95);
        dontNeedEncoding.set(46);
        dontNeedEncoding.set(42);
    }
}

