/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.transport.util;

import com.idoox.debug.Category;
import com.idoox.transport.util.MyBufferedOutputStream;
import com.idoox.transport.util.SocketEx;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;

public class SocketPool {
    private static final Category log = Category.getCategory("com.idoox.transport.util.SocketPool");
    private Map pool;
    private Set trash;

    public SocketPool(int initialSize) {
        this.pool = new HashMap(initialSize);
        this.trash = new HashSet(initialSize);
    }

    public SocketEx get(String userinfo, String host, int port, int timeout, int updateInterval, Map properties) throws UnknownHostException, IOException {
        StringBuffer buffer;
        if (userinfo == null) {
            buffer = new StringBuffer(host.length() + 6);
        } else {
            buffer = new StringBuffer(userinfo.length() + 1 + host.length() + 6);
            buffer.append(userinfo);
            buffer.append('@');
        }
        buffer.append(host);
        buffer.append(':');
        buffer.append(port);
        String key = buffer.toString();
        SocketExImpl connection = null;
        SocketPool socketPool = this;
        synchronized (socketPool) {
            LinkedList sockets = (LinkedList)this.pool.get(key);
            if (sockets != null && !sockets.isEmpty()) {
                connection = (SocketExImpl)sockets.removeLast();
            }
        }
        if (connection == null) {
            connection = new SocketExImpl(this, userinfo, host, port, key, properties);
            connection.open(timeout);
        } else {
            connection.unrelease();
            try {
                connection.setTimeout(timeout);
                connection.setProperties(properties);
            }
            catch (IOException e) {
                connection = new SocketExImpl(this, userinfo, host, port, key, properties);
                connection.open(timeout);
            }
        }
        connection.setUpdateInterval(updateInterval);
        return connection;
    }

    public void clear() {
        Map tmpPool = null;
        Set tmpTrash = null;
        SocketPool socketPool = this;
        synchronized (socketPool) {
            tmpPool = (Map)((HashMap)this.pool).clone();
            tmpTrash = (Set)((HashSet)this.trash).clone();
            this.pool.clear();
            this.trash.clear();
        }
        Iterator i = tmpPool.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            LinkedList sockets = (LinkedList)entry.getValue();
            if (sockets == null) continue;
            Iterator k = sockets.iterator();
            while (k.hasNext()) {
                SocketExImpl socket = (SocketExImpl)k.next();
                try {
                    socket.close(false, true);
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }
        Iterator j = tmpTrash.iterator();
        while (j.hasNext()) {
            SocketExImpl socket = (SocketExImpl)j.next();
            try {
                socket.close(false, true);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    protected Socket newSocket(SocketEx socket, String server, int port, int timeout) throws IOException {
        Socket newSocket = new Socket(server, port);
        if (timeout >= 0) {
            newSocket.setSoTimeout(timeout);
        }
        return newSocket;
    }

    protected void hello(SocketEx socket, String userinfo, String host, int port) throws IOException {
    }

    protected void quit(SocketEx socket) throws IOException {
    }

    public class SocketExImpl
    extends SocketEx {
        private SocketPool socketPool;
        private Socket socket;
        private Map properties;
        private String userinfo;
        private String host;
        private int port;
        private String key;
        private int timeout = -1;
        private int updateInterval = -1;
        private Timer timer;
        private Updater updater;
        private boolean released = false;
        private boolean fresh = true;

        public SocketExImpl(SocketPool socketPool, String userinfo, String host, int port, String key, Map properties) {
            this.socketPool = socketPool;
            this.userinfo = userinfo;
            this.host = host;
            this.port = port;
            this.key = key;
            this.properties = properties;
        }

        public void release() {
            SocketExImpl socketExImpl = this;
            synchronized (socketExImpl) {
                this.released = true;
                this.notify();
            }
            SocketPool socketPool = this.socketPool;
            synchronized (socketPool) {
                SocketPool.this.trash.remove(this);
                this.fresh = false;
                LinkedList<SocketExImpl> sockets = (LinkedList<SocketExImpl>)SocketPool.this.pool.get(this.key);
                if (sockets == null) {
                    sockets = new LinkedList<SocketExImpl>();
                    SocketPool.this.pool.put(this.key, sockets);
                }
                sockets.addLast(this);
            }
        }

        void unrelease() {
            SocketExImpl socketExImpl = this;
            synchronized (socketExImpl) {
                this.released = false;
                this.notify();
            }
            SocketPool socketPool = this.socketPool;
            synchronized (socketPool) {
                SocketPool.this.trash.add(this);
            }
        }

        public void setProperties(Map properties) {
            this.properties = properties;
        }

        public Map getProperties() {
            return this.properties;
        }

        public void open() throws UnknownHostException, IOException {
            this.open(true, -1);
        }

        void open(int timeout) throws UnknownHostException, IOException {
            this.open(true, timeout);
        }

        void open(boolean addToTrash, int timeout) throws UnknownHostException, IOException {
            if (timeout < 0) {
                timeout = this.timeout;
                this.timeout = -1;
            }
            this.socket = SocketPool.this.newSocket(this, this.host, this.port, timeout);
            this.socket.setTcpNoDelay(true);
            this.input = new BufferedInputStream(this.socket.getInputStream(), 1468);
            this.output = new MyBufferedOutputStream(this.socket.getOutputStream(), 1468);
            if (addToTrash) {
                SocketPool socketPool = this.socketPool;
                synchronized (socketPool) {
                    SocketPool.this.trash.add(this);
                }
            }
            SocketPool.this.hello(this, this.userinfo, this.host, this.port);
        }

        public void close() throws IOException {
            this.close(true, true);
        }

        synchronized void close(boolean remove, boolean killTimer) throws IOException {
            if (killTimer && this.updater != null) {
                this.updater.cancel();
                this.updater = null;
                this.timer.cancel();
                this.timer = null;
            }
            if (remove) {
                SocketPool socketPool = this.socketPool;
                synchronized (socketPool) {
                    SocketPool.this.trash.remove(this);
                    LinkedList sockets = (LinkedList)SocketPool.this.pool.get(this.key);
                    if (sockets != null) {
                        sockets.remove(this);
                    }
                }
            }
            if (this.socket != null) {
                try {
                    SocketPool.this.quit(this);
                    this.output.flush();
                    try {
                        this.input.skip(this.input.available() - this.socket.getInputStream().available());
                    }
                    catch (IOException iOException) {
                    }
                    Object var7_7 = null;
                }
                catch (Throwable throwable) {
                    Object var7_8 = null;
                    this.socket.close();
                    this.socket = null;
                    throw throwable;
                }
                this.socket.close();
                this.socket = null;
                {
                }
            }
        }

        void update() throws IOException {
            try {
                SocketExImpl socketExImpl = this;
                synchronized (socketExImpl) {
                    while (!this.released && this.updater != null) {
                        this.wait(100L);
                    }
                    if (this.socket != null) {
                        this.close(false, false);
                        this.open(false, -1);
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public void setTimeout(int timeout) throws IOException {
            if (timeout == this.timeout) {
                return;
            }
            if (this.socket != null && timeout >= 0) {
                this.socket.setSoTimeout(timeout);
            }
            this.timeout = timeout;
        }

        public int getTimeout() {
            return this.timeout;
        }

        public void setUpdateInterval(int updateInterval) {
            if (updateInterval == this.updateInterval) {
                return;
            }
            if (this.updater != null) {
                this.updater.cancel();
                this.updater = null;
            }
            if (updateInterval > 0) {
                if (this.updater == null) {
                    this.updater = new Updater();
                }
                if (this.timer == null) {
                    this.timer = new Timer(true);
                }
                this.timer.schedule((TimerTask)this.updater, updateInterval, (long)updateInterval);
            }
            if (updateInterval > 0 && this.timeout > 0 && updateInterval > this.timeout) {
                log.warn("Timeout should be greater than update interval (" + this.host + ":" + this.port + ")");
            }
            this.updateInterval = updateInterval;
        }

        public int getUpdateInterval() {
            return this.updateInterval;
        }

        public boolean isFresh() {
            return this.fresh;
        }

        public int getPort() {
            return this.socket.getPort();
        }

        public String toString() {
            return this.key;
        }

        public class Updater
        extends TimerTask {
            public void run() {
                try {
                    SocketExImpl.this.update();
                }
                catch (IOException e) {
                    log.error("Error during updating " + SocketExImpl.this.key + " - " + e.getMessage());
                }
            }
        }
    }
}

