/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.transport.util;

import java.net.InetAddress;
import java.net.UnknownHostException;

public class Resolve {
    private static InetAddress localhost;
    private static InetAddress zerohost;

    public static boolean isLocal(String name) {
        try {
            InetAddress[] addresses = InetAddress.getAllByName(name);
            int i = 0;
            while (i < addresses.length) {
                if (Resolve.isLocal(addresses[i])) {
                    return true;
                }
                ++i;
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return false;
    }

    public static boolean isLocal(InetAddress address) {
        if (localhost != null && localhost.equals(address)) {
            return true;
        }
        if (zerohost != null && zerohost.equals(address)) {
            return true;
        }
        return address.getAddress()[0] == 127;
    }

    public static boolean equals(String host1, String host2) {
        try {
            InetAddress[] addresses1 = InetAddress.getAllByName(host1);
            InetAddress[] addresses2 = InetAddress.getAllByName(host2);
            int i = 0;
            while (i < addresses1.length) {
                int j = 0;
                while (j < addresses2.length) {
                    if (addresses1[i].equals(addresses2[j])) {
                        return true;
                    }
                    if (Resolve.isLocal(addresses1[i]) && Resolve.isLocal(addresses2[j])) {
                        return true;
                    }
                    ++j;
                }
                ++i;
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return false;
    }

    static {
        try {
            localhost = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            // empty catch block
        }
        try {
            zerohost = InetAddress.getByName("0.0.0.0");
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }
}

