/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.transport.smtp.client;

import com.idoox.transport.smtp.client.SmtpReadLine;
import com.idoox.transport.util.SocketEx;
import com.idoox.transport.util.SocketPool;
import com.idoox.transport.util.WriteLine;
import java.io.IOException;
import java.net.InetAddress;

public class SmtpPool
extends SocketPool {
    private static String HELLO = "EHLO";
    private static String QUIT = "QUIT";

    public SmtpPool(int initialSize) {
        super(initialSize);
    }

    protected void hello(SocketEx socket, String userinfo, String host, int port) throws IOException {
        SmtpReadLine readLine = new SmtpReadLine(socket.input);
        WriteLine writeLine = new WriteLine(socket.output);
        socket.ext = new SmtpSocketData(readLine, writeLine);
        try {
            while (!readLine.smtpRead()) {
            }
            writeLine.write(HELLO, true);
            socket.output.flush();
            while (!readLine.smtpRead()) {
            }
        }
        catch (IOException e) {
            try {
                socket.close();
            }
            catch (IOException _e) {
                // empty catch block
            }
            throw e;
        }
    }

    protected void quit(SocketEx socket) throws IOException {
        SmtpReadLine readLine = ((SmtpSocketData)socket.ext).readLine;
        WriteLine writeLine = ((SmtpSocketData)socket.ext).writeLine;
        if (readLine != null) {
            writeLine.write(QUIT, true);
            socket.output.flush();
            while (!readLine.smtpRead()) {
            }
        }
    }

    static {
        try {
            HELLO = HELLO + " " + InetAddress.getLocalHost().getHostName();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public class SmtpSocketData {
        public SmtpReadLine readLine;
        public WriteLine writeLine;

        public SmtpSocketData(SmtpReadLine readLine, WriteLine writeLine) {
            this.readLine = readLine;
            this.writeLine = writeLine;
        }
    }
}

