/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.transport.mime;

import com.idoox.transport.mime.MimeUtils;
import com.idoox.transport.util.Headers;
import com.idoox.transport.util.WriteLine;
import java.io.IOException;
import org.idoox.transport.OutputMessage;
import org.idoox.transport.OutputMessageWrapper;
import org.idoox.wasp.types.MessageAttachment;

public class MultipartOutputMessage
extends OutputMessageWrapper {
    private static final String HEADER_CONTENT_ID = "content-id";
    private static final String HEADER_CONTENT_TYPE = "content-type";
    protected byte[] boundary = null;
    protected Headers headers;
    private WriteLine line;
    private boolean dirtyHeaders = false;
    private boolean rootPart = true;
    private String mpType = null;
    private StringBuffer mpBuffer;

    public MultipartOutputMessage(OutputMessage message) {
        super(message);
    }

    public void setContentType(String type) {
        if (this.boundary == null) {
            super.setContentType(type);
        } else {
            this.headers.set(HEADER_CONTENT_TYPE, type);
            if (this.rootPart && this.mpType == null) {
                super.setContentType(type);
            }
        }
    }

    public void setIntHeader(String name, int value) {
        if (this.boundary == null) {
            super.setIntHeader(name, value);
        } else {
            this.headers.set(name, String.valueOf(value));
        }
    }

    public void setDateHeader(String name, long value) {
        if (this.boundary == null) {
            super.setDateHeader(name, value);
        } else {
            this.headers.setDate(name, value);
        }
    }

    public void setStringHeader(String name, String value) {
        if (this.boundary == null) {
            super.setStringHeader(name, value);
        } else if (HEADER_CONTENT_ID.equalsIgnoreCase(name)) {
            this.headers.set(name, "<" + value + ">");
        } else {
            this.headers.set(name, value);
        }
    }

    public void setMultipartType(String type) throws IOException {
        if (type != null && type.toLowerCase().startsWith("multipart/")) {
            String boundary = MimeUtils.generateMultipartBoundary();
            this.boundary = new byte[boundary.length()];
            boundary.getBytes(0, boundary.length(), this.boundary, 0);
            super.setStringHeader("MIME-version", "1.0");
            if (this.headers == null) {
                this.headers = new Headers(13);
            } else {
                this.headers.clear();
            }
            this.dirtyHeaders = true;
            this.mpType = type;
        } else {
            super.setMultipartType(type);
        }
    }

    public void nextPart() throws IOException {
        if (this.boundary != null) {
            if (this.dirtyHeaders) {
                this.flushPart();
            }
            this.dirtyHeaders = true;
            this.rootPart = false;
        }
        super.nextPart();
    }

    private void flushPart() throws IOException {
        if (this.rootPart) {
            String rootContentId = this.headers.get(HEADER_CONTENT_ID);
            if (rootContentId == null) {
                rootContentId = new MessageAttachment().getContentId();
                this.setStringHeader(HEADER_CONTENT_ID, rootContentId);
                rootContentId = this.headers.get(HEADER_CONTENT_ID);
            }
            this.mpBuffer = new StringBuffer(255);
            this.mpBuffer.append(this.mpType);
            this.mpBuffer.append("; boundary=");
            this.mpBuffer.append(new String(this.boundary, 0, 0, this.boundary.length));
            String type = this.headers.get(HEADER_CONTENT_TYPE);
            if (type != null) {
                this.mpBuffer.append("; type=\"");
                int semicolon = type.indexOf(59);
                if (semicolon != -1) {
                    type = type.substring(0, semicolon);
                }
                this.mpBuffer.append(type);
                this.mpBuffer.append('\"');
            }
            this.mpBuffer.append("; start=\"");
            this.mpBuffer.append(rootContentId);
            this.mpBuffer.append('\"');
            super.setContentType(this.mpBuffer.toString());
            this.mpBuffer = null;
        }
        super.write(13);
        super.write(10);
        super.write(45);
        super.write(45);
        super.write(this.boundary);
        super.write(13);
        super.write(10);
        if (this.line == null) {
            this.line = new WriteLine(this.getWrappedMessage());
        }
        this.headers.write(this.line);
        this.headers.clear();
        this.dirtyHeaders = false;
    }

    public void write(byte[] b) throws IOException {
        if (this.dirtyHeaders) {
            this.flushPart();
        }
        super.write(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (this.dirtyHeaders) {
            this.flushPart();
        }
        super.write(b, off, len);
    }

    public void write(int b) throws IOException {
        if (this.dirtyHeaders) {
            this.flushPart();
        }
        super.write(b);
    }

    public void close() throws IOException {
        if (this.dirtyHeaders) {
            this.flushPart();
        }
        if (this.boundary != null) {
            this.getWrappedStream().write(13);
            this.getWrappedStream().write(10);
            this.getWrappedStream().write(45);
            this.getWrappedStream().write(45);
            this.getWrappedStream().write(this.boundary);
            this.getWrappedStream().write(45);
            this.getWrappedStream().write(45);
            this.getWrappedStream().write(13);
            this.getWrappedStream().write(10);
            this.boundary = null;
            this.rootPart = false;
        }
        this.getWrappedStream().close();
    }
}

