/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.transport.mime;

import com.idoox.transport.util.Headers;
import com.idoox.transport.util.ReadLine;
import java.io.IOException;
import java.io.PushbackInputStream;
import java.util.Set;
import org.idoox.transport.InputMessage;
import org.idoox.transport.InputMessageWrapper;

public class MultipartInputMessage
extends InputMessageWrapper {
    protected byte[] boundary = null;
    private byte[] boundaryString;
    protected Headers headers;
    private ReadLine line;
    private boolean firstPart = true;
    private String multipartType;
    private short numMaxOmit = 1;
    private short numOmit = 0;
    private boolean endOfPart = false;
    private boolean endOfStream = false;

    public MultipartInputMessage(InputMessage message) {
        super(message);
    }

    public Set getHeaderNames() throws IOException {
        if (this.boundary == null || this.firstPart) {
            return super.getHeaderNames();
        }
        return this.headers.getNames();
    }

    public String getContentType() throws IOException {
        if (this.boundary == null || this.firstPart) {
            return super.getContentType();
        }
        return this.headers.get("content-type");
    }

    public String getStringHeader(String name) throws IOException {
        if (this.boundary == null || this.firstPart) {
            return super.getStringHeader(name);
        }
        if ("content-id".equalsIgnoreCase(name)) {
            String cid = this.headers.get(name);
            if (cid != null && cid.charAt(0) == '<' && cid.charAt(cid.length() - 1) == '>') {
                cid = cid.substring(1, cid.length() - 1);
            }
            return cid;
        }
        return this.headers.get(name);
    }

    public int getIntHeader(String name) throws IOException {
        if (this.boundary == null || this.firstPart) {
            return super.getIntHeader(name);
        }
        String value = this.headers.get(name);
        if (value == null) {
            return -1;
        }
        return Integer.parseInt(value);
    }

    public long getDateHeader(String name) throws IOException {
        if (this.boundary == null || this.firstPart) {
            return super.getDateHeader(name);
        }
        return this.headers.getDate(name);
    }

    public String getMultipartType() throws IOException {
        String ct;
        if (this.multipartType != null) {
            return this.multipartType;
        }
        this.multipartType = super.getMultipartType();
        String string = ct = this.multipartType != null ? this.multipartType : super.getContentType();
        if (ct == null) {
            return null;
        }
        String lowerCt = ct.toLowerCase();
        if (lowerCt.startsWith("multipart/")) {
            int semicolon = ct.indexOf(59);
            if (semicolon == -1) {
                throw new IOException("Multipart invalid content-type declaration");
            }
            this.multipartType = ct.substring(0, semicolon);
            int boundIndex = lowerCt.indexOf("boundary=", semicolon);
            if (boundIndex == -1) {
                throw new IOException("Multipart invalid content-type declaration: boundary string is missing");
            }
            int end = ct.indexOf(59, boundIndex);
            if (end == -1) {
                end = ct.length();
            }
            if (boundIndex + 9 >= end) {
                throw new IOException("Multipart invalid content-type declaration: boundary string is corrupted");
            }
            if (ct.charAt(boundIndex + 9) == '\"') {
                int comma = ct.indexOf(34, boundIndex + 10);
                if (comma == -1) {
                    this.boundary = new byte[end - (boundIndex + 10)];
                    ct.getBytes(boundIndex + 10, end, this.boundary, 0);
                } else {
                    this.boundary = new byte[comma - (boundIndex + 10)];
                    ct.getBytes(boundIndex + 10, comma, this.boundary, 0);
                }
            } else {
                this.boundary = new byte[end - (boundIndex + 9)];
                ct.getBytes(boundIndex + 9, end, this.boundary, 0);
            }
            if (this.headers == null) {
                this.headers = new Headers(0);
            } else {
                this.headers.clear();
            }
            this.boundaryString = new byte[this.boundary.length + 2];
            this.boundaryString[0] = 45;
            this.boundaryString[1] = 45;
            System.arraycopy(this.boundary, 0, this.boundaryString, 2, this.boundary.length);
            while (this.numMaxOmit < this.boundaryString.length && this.boundaryString[this.numMaxOmit] != 13) {
                this.numMaxOmit = (short)(this.numMaxOmit + 1);
            }
            this.setWrappedStream(new PushbackInputStream(this.getWrappedStream(), this.boundaryString.length + 4));
        }
        return this.multipartType;
    }

    public boolean nextPart() throws IOException {
        if (this.boundary != null) {
            this.numOmit = 0;
            if (!this.endOfPart) {
                while (this.read() >= 0) {
                }
            }
            if (this.endOfStream) {
                return false;
            }
            this.endOfPart = false;
            if (this.line == null) {
                this.line = new ReadLine(this);
            }
            this.headers.read(this.line);
            if (this.firstPart) {
                this.boundaryString = new byte[this.boundary.length + 4];
                this.boundaryString[0] = 13;
                this.boundaryString[1] = 10;
                this.boundaryString[2] = 45;
                this.boundaryString[3] = 45;
                System.arraycopy(this.boundary, 0, this.boundaryString, 4, this.boundary.length);
                this.firstPart = false;
            }
            return true;
        }
        return super.nextPart();
    }

    public int read(byte[] b) throws IOException {
        if (this.boundary == null) {
            return super.read(b);
        }
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.boundary == null) {
            return super.read(b, off, len);
        }
        int ch = this.read();
        if (ch == -1) {
            return -1;
        }
        b[off] = (byte)ch;
        int num = 1;
        try {
            while (num < len && (ch = this.read()) != -1) {
                b[off + num] = (byte)ch;
                ++num;
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        return num;
    }

    public int read() throws IOException {
        int ch;
        if (this.boundary == null) {
            return super.read();
        }
        if (this.endOfPart || this.endOfStream) {
            return -1;
        }
        if (this.numOmit > 0) {
            int ch2 = super.read();
            if (ch2 >= 0) {
                if (this.numOmit > this.numMaxOmit) {
                    this.numOmit = this.numMaxOmit;
                }
                this.numOmit = (short)(this.numOmit - 1);
            }
            return ch2;
        }
        while (true) {
            ch = super.read();
            if (this.numOmit >= this.boundaryString.length) {
                int ch2 = super.read();
                this.numOmit = 0;
                if (ch == 45 && ch2 == 45) {
                    this.endOfStream = true;
                } else {
                    if (ch >= 0 && ch != 13) {
                        ((PushbackInputStream)this.getWrappedStream()).unread(ch);
                        this.numOmit = (short)(this.numOmit + 1);
                    }
                    if (ch2 >= 0 && ch2 != 10) {
                        ((PushbackInputStream)this.getWrappedStream()).unread(ch2);
                        this.numOmit = (short)(this.numOmit + 1);
                    }
                }
                this.endOfPart = true;
                return -1;
            }
            if (this.boundaryString[this.numOmit] != ch) break;
            this.numOmit = (short)(this.numOmit + 1);
        }
        if (this.numOmit > 0) {
            ((PushbackInputStream)this.getWrappedStream()).unread(ch);
            ((PushbackInputStream)this.getWrappedStream()).unread(this.boundaryString, 0, this.numOmit);
            ch = super.read();
            if (ch >= 0) {
                this.numOmit = (short)(this.numOmit - 1);
            }
        }
        return ch;
    }

    public void close() throws IOException {
        super.close();
    }
}

