/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.transport.mail;

import com.idoox.debug.Category;
import com.idoox.transport.mail.MailURI;
import com.idoox.transport.util.ServerConnectionImpl;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.idoox.config.Configurable;
import org.idoox.transport.InputMessage;
import org.idoox.transport.Transport;
import org.idoox.transport.TransportMethod;
import org.idoox.transport.TransportStartException;
import org.idoox.transport.URI;
import org.idoox.transport.client.ClientConnection;
import org.idoox.transport.client.Endpoint;
import org.idoox.transport.config.MailConfig;
import org.idoox.transport.server.ConnectionHandler;
import org.idoox.util.RuntimeWrappedException;

public class Mail
implements Transport {
    public static final String MAIL_INPUT_PASSWORD = "mail.input.password";
    private static final Category log = Category.getCategory("com.idoox.transport.Mail");
    private static HashSet methods = new HashSet(4);
    private Output output;
    private Input input;
    private Configurable config;
    private Endpoint serverEndpoint;
    private static int DEFAULT_SLEEP_INTERVAL;
    private ConnectionHandler handler;
    private boolean started = false;
    private Object lock = new Object();
    static /* synthetic */ Class class$org$idoox$transport$config$MailConfig;

    public void load(Configurable c) {
        MailConfig config = (MailConfig)c.narrow(class$org$idoox$transport$config$MailConfig == null ? (class$org$idoox$transport$config$MailConfig = Mail.class$("org.idoox.transport.config.MailConfig")) : class$org$idoox$transport$config$MailConfig);
        this.config = c;
        Input input = new Input();
        if (config.getInput() == null) {
            throw new RuntimeException(c.getName() + " transport doesn't contain input section");
        }
        try {
            input.server = config.getInput().getServer() != null ? new Endpoint(config.getInput().getServer()) : null;
        }
        catch (MalformedURLException e) {
            throw new RuntimeWrappedException(e);
        }
        input.password = config.getInput().getPassword();
        try {
            input.sleepInterval = config.getInput().getSleepInterval();
        }
        catch (Exception e) {
            input.sleepInterval = DEFAULT_SLEEP_INTERVAL;
        }
        this.config.addVetoableChangeListener(input);
        this.input = input;
        Output output = new Output();
        if (config.getOutput() == null) {
            throw new RuntimeException(c.getName() + " transport doesn't contain output section");
        }
        try {
            output.server = config.getOutput().getServer() != null ? new Endpoint(config.getOutput().getServer()) : null;
        }
        catch (MalformedURLException e) {
            throw new RuntimeWrappedException(e);
        }
        output.from = config.getOutput().getFrom();
        this.serverEndpoint = new Endpoint(config.getScheme(), null, null, -1, null, output.from);
        this.config.addVetoableChangeListener(output);
        this.output = output;
    }

    public synchronized void destroy() {
        if (this.started) {
            this.stop();
        }
        if (this.input != null) {
            this.config.removeVetoableChangeListener(this.input);
        }
        if (this.output != null) {
            this.config.removeVetoableChangeListener(this.output);
        }
    }

    public synchronized void start(URI endpoint) throws TransportStartException {
        FetcherThread fetcher;
        if (this.started) {
            this.stop();
        }
        if (endpoint != null) {
            this.serverEndpoint = new Endpoint(endpoint);
        }
        if (this.input.server == null) {
            throw new TransportStartException("Couldn't start '" + this.serverEndpoint + "' server - input server isn't specified");
        }
        this.output.from = this.serverEndpoint.getPath();
        if (this.output.from == null) {
            throw new TransportStartException("Couldn't start '" + this.serverEndpoint + "' server - reverse path (output/from) isn't specified");
        }
        log.info("Starting '" + this.serverEndpoint + "' server");
        this.started = true;
        FetcherThread fetcherThread = fetcher = new FetcherThread();
        synchronized (fetcherThread) {
            fetcher.start();
            try {
                fetcher.wait();
                if (fetcher.exception != null) {
                    throw new TransportStartException(fetcher.exception);
                }
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
    }

    public synchronized void stop() {
        if (!this.started) {
            return;
        }
        log.info("Stopping '" + this.serverEndpoint + "' server");
        this.started = false;
    }

    public synchronized boolean isStarted() {
        return this.started;
    }

    protected void handle(Object object) {
    }

    public ConnectionHandler setHandler(ConnectionHandler handler) {
        ConnectionHandler oldHandler = this.handler;
        Object object = this.lock;
        synchronized (object) {
            this.handler = handler;
            this.lock.notify();
        }
        return oldHandler;
    }

    public synchronized ClientConnection newConnection(URI uri, TransportMethod method, Map properties) throws IOException {
        String value;
        String value2;
        Endpoint outServer = this.output.server;
        if (properties != null && (value2 = (String)properties.get("mail.output.server")) != null) {
            outServer = new Endpoint(value2);
        }
        if (outServer == null) {
            throw new IOException("Output server for '" + this.serverEndpoint + "' transport isn't specified");
        }
        String location = uri.getLocation();
        if (location != null && location.length() > 0 && location.charAt(0) != '/') {
            location = '/' + location;
        }
        Endpoint endpoint = new Endpoint(outServer, location);
        String from = this.serverEndpoint.getPath();
        if (properties != null && (value = (String)properties.get("mail.output.from")) != null) {
            from = value;
        }
        if (from != null && from.length() > 0) {
            endpoint.setParameter("from", from);
        }
        return endpoint.newConnection(method, properties);
    }

    public Set getMethods() {
        return methods;
    }

    public int getType() {
        int type = 2;
        if (this.input != null && this.input.server != null) {
            type |= 1;
        }
        return type;
    }

    public String getLocalPath(URI endpoint) {
        if (!this.output.from.equals(endpoint.getPath())) {
            return null;
        }
        return new MailURI(endpoint).getPath();
    }

    public Endpoint[] getAbsolutePath(String path) throws MalformedURLException {
        Endpoint endpoint = new Endpoint(this.serverEndpoint);
        endpoint.setQuery("x-wasp-path=" + path);
        return new Endpoint[]{endpoint};
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        methods.add(TransportMethod.POST);
        DEFAULT_SLEEP_INTERVAL = 1000;
    }

    class FetcherThread
    extends Thread {
        public Exception exception;
        private boolean firstRun = true;

        public FetcherThread() {
            super("MailFetcher");
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void run() {
            HashMap<String, String> conProperties = null;
            if (((Mail)Mail.this).input.password != null) {
                conProperties = new HashMap<String, String>();
                conProperties.put(Mail.MAIL_INPUT_PASSWORD, ((Mail)Mail.this).input.password);
            }
            try {
                while (true) {
                    if (!Mail.this.started) {
                        return;
                    }
                    while (Mail.this.started) {
                        Object var18_19;
                        InputMessage message;
                        int sc = 404;
                        ClientConnection con = ((Mail)Mail.this).input.server.newConnection(TransportMethod.GET, conProperties);
                        FetcherThread fetcherThread = this;
                        // MONITORENTER : fetcherThread
                        if (this.firstRun) {
                            FetcherThread fetcherThread2 = this;
                            // MONITORENTER : fetcherThread2
                            this.exception = null;
                            this.firstRun = false;
                            this.notify();
                            // MONITOREXIT : fetcherThread2
                        }
                        // MONITOREXIT : fetcherThread
                        if (con != null && (message = con.getInputMessage()) != null) {
                            sc = message.getStatusCode();
                        }
                        if (sc == 404) break;
                        message = con.getInputMessage();
                        try {
                            String strMethod = message.getStringHeader("x-wasp-method");
                            TransportMethod method = strMethod != null ? TransportMethod.fromString(strMethod) : TransportMethod.POST;
                            HashMap query = null;
                            Set headerNames = message.getHeaderNames();
                            if (headerNames != null) {
                                query = new HashMap(headerNames.size());
                                Iterator i = headerNames.iterator();
                                while (i.hasNext()) {
                                    String paramName = (String)i.next();
                                    String paramValue = message.getStringHeader(paramName);
                                    ArrayList<String> paramValues = new ArrayList<String>(1);
                                    paramValues.add(paramValue);
                                    query.put(paramName, paramValues);
                                }
                            }
                            String path = message.getStringHeader("to");
                            Endpoint endpoint = new Endpoint(Mail.this.serverEndpoint.getScheme(), null, null, -1, null, path, null, query);
                            MailURI uri = new MailURI(endpoint);
                            String clientAddress = message.getStringHeader("x-wasp-client");
                            if (clientAddress == null) {
                                clientAddress = message.getStringHeader("from");
                            }
                            if (clientAddress == null) {
                                clientAddress = message.getStringHeader("return-path");
                            }
                            if (clientAddress.length() > 0 && clientAddress.charAt(0) == '<' && clientAddress.charAt(clientAddress.length() - 1) == '>') {
                                clientAddress = clientAddress.substring(1, clientAddress.length() - 1);
                            }
                            ServerConnectionImpl serverConnection = new ServerConnectionImpl(method, uri, clientAddress);
                            serverConnection.setInputMessage(message);
                            serverConnection.setOutputMessage(null);
                            if (Mail.this.handler == null) {
                                Object object = Mail.this.lock;
                                // MONITORENTER : object
                                Mail.this.lock.wait();
                                // MONITOREXIT : object
                            }
                            switch (method.value()) {
                                case 1: {
                                    Mail.this.handler.handleGet(serverConnection);
                                    break;
                                }
                                case 0: {
                                    Mail.this.handler.handlePost(serverConnection);
                                    break;
                                }
                                case 2: {
                                    Mail.this.handler.handlePut(serverConnection);
                                    break;
                                }
                                case 3: {
                                    Mail.this.handler.handleDelete(serverConnection);
                                    break;
                                }
                                default: {
                                    log.error("Can't handle method " + method);
                                }
                            }
                            var18_19 = null;
                            message.close();
                        }
                        catch (Throwable throwable) {
                            var18_19 = null;
                            message.close();
                            throw throwable;
                        }
                    }
                    Thread.sleep(((Mail)Mail.this).input.sleepInterval);
                }
            }
            catch (IOException e) {
                if (this.firstRun) {
                    FetcherThread con = this;
                    // MONITORENTER : con
                    this.firstRun = false;
                    this.exception = e;
                    this.notify();
                    // MONITOREXIT : con
                } else {
                    log.error("Error while trying to fetch new messages from " + ((Mail)Mail.this).input.server, e);
                }
                Mail.this.started = false;
                return;
            }
            catch (InterruptedException e) {
                Mail.this.started = false;
            }
        }
    }

    public class Output
    implements VetoableChangeListener {
        public Endpoint server;
        public String from;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public synchronized void vetoableChange(PropertyChangeEvent event) throws PropertyVetoException {
            if (event.getPropertyName().equals("server")) {
                try {
                    this.server = null;
                    if (event.getNewValue() == null) return;
                    this.server = new Endpoint((String)event.getNewValue());
                    return;
                }
                catch (MalformedURLException e) {
                    throw new PropertyVetoException(e.getMessage(), event);
                }
            } else {
                if (!event.getPropertyName().equals("from")) return;
                this.from = (String)event.getNewValue();
                Mail.this.serverEndpoint.setPath(this.from);
            }
        }
    }

    public class Input
    implements VetoableChangeListener {
        public Endpoint server;
        public String password;
        public int sleepInterval;

        public synchronized void vetoableChange(PropertyChangeEvent event) throws PropertyVetoException {
            if (event.getPropertyName().equals("server")) {
                try {
                    if (event.getNewValue() != null) {
                        this.server = new Endpoint((String)event.getNewValue());
                    }
                    this.server = null;
                }
                catch (MalformedURLException e) {
                    throw new PropertyVetoException(e.getMessage(), event);
                }
            } else if (event.getPropertyName().equals("password")) {
                this.password = (String)event.getNewValue();
            } else if (event.getPropertyName().equals("sleepInterval")) {
                this.sleepInterval = event.getNewValue() != null ? (Integer)event.getNewValue() : DEFAULT_SLEEP_INTERVAL;
            }
        }
    }
}

