/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.transport.jar.client;

import com.idoox.transport.jar.client.JarResponse;
import java.io.IOException;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.idoox.transport.InputMessage;
import org.idoox.transport.OutputMessage;
import org.idoox.transport.TransportMethod;
import org.idoox.transport.URI;
import org.idoox.transport.client.ClientConnection;
import org.idoox.transport.client.Endpoint;

public class JarConnection
implements ClientConnection {
    protected URI endpoint;
    protected TransportMethod method;
    protected OutputMessage request;
    protected InputMessage response;
    private static String SEPARATOR = "!/";

    public JarConnection(URI endpoint, TransportMethod method) throws IOException {
        if (method == TransportMethod.GET) {
            String nestedString = endpoint.toExternalForm().substring(endpoint.getScheme().length() + 1);
            String entryName = "";
            int separator = nestedString.indexOf(SEPARATOR);
            if (separator != -1) {
                entryName = nestedString.substring(separator + 2);
                nestedString = nestedString.substring(0, separator);
            }
            Endpoint nestedEndpoint = new Endpoint(nestedString);
            ClientConnection connection = nestedEndpoint.newConnection(method);
            this.request = connection.getOutputMessage();
            JarInputStream jarStream = new JarInputStream(connection.getInputMessage());
            this.response = new JarResponse(connection.getInputMessage(), jarStream);
            JarEntry entry = jarStream.getNextJarEntry();
            while (entry != null) {
                if (!entry.getName().equals(entryName)) {
                    entry = jarStream.getNextJarEntry();
                    continue;
                }
                break;
            }
        } else {
            throw new IOException("Method " + method + " isn't supported for JAR transport");
        }
        this.endpoint = endpoint;
        this.method = method;
    }

    public void setTimeout(int time) {
    }

    public InputMessage getInputMessage() {
        return this.response;
    }

    public void setInputMessage(InputMessage message) {
        this.response = message;
    }

    public OutputMessage getOutputMessage() {
        return this.request;
    }

    public void setOutputMessage(OutputMessage message) {
        this.request = message;
    }

    public TransportMethod getMethod() {
        return this.method;
    }

    public URI getURI() {
        return this.endpoint;
    }
}

