/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.transport.http.server;

import com.mortbay.HTTP.HttpRequest;
import java.util.List;
import java.util.Set;
import org.idoox.transport.URI;

public class JettyURI
implements URI {
    private HttpRequest request;
    private String uri;
    private String context;
    private String location;
    private String path;
    private String fragment;

    public JettyURI(HttpRequest request, String context) throws IndexOutOfBoundsException {
        this.request = request;
        this.context = context;
        this.parsePath(this.request.getPath());
    }

    protected JettyURI(JettyURI src) {
        this.request = src.request;
        this.uri = src.uri;
        this.context = src.context;
        this.location = src.location;
        this.path = src.path;
        this.fragment = src.fragment;
    }

    private void parsePath(String path) {
        this.path = null;
        this.fragment = null;
        int find = path.indexOf(35);
        if (find != -1) {
            this.path = this.context != null ? path.substring(this.context.length(), find) : path.substring(0, find);
            this.fragment = path.substring(find + 1);
        } else {
            this.path = this.context != null ? path.substring(this.context.length()) : path;
        }
    }

    public String getScheme() {
        return this.request.getScheme();
    }

    public String getUserinfo() {
        return null;
    }

    public String getHost() {
        return this.request.getHost();
    }

    public int getPort() {
        return this.request.getPort();
    }

    public String getContextPath() {
        return this.context;
    }

    public String getLocation() {
        if (this.location == null) {
            StringBuffer buffer = new StringBuffer(500);
            if (this.path != null && this.path.length() > 0) {
                buffer.append(this.path);
            }
            if (this.fragment != null && this.fragment.length() > 0) {
                buffer.append('#');
                buffer.append(this.fragment);
            }
            if (this.request.getQuery() != null) {
                buffer.append('?');
                buffer.append(this.request.getQuery());
            }
            this.location = buffer.toString();
        }
        return this.location;
    }

    public String getPath() {
        return this.path;
    }

    public String getQuery() {
        return this.request.getQuery();
    }

    public Set getParameterNames() {
        return this.request.getParameterNames();
    }

    public String getParameter(String name) {
        return this.request.getParameter(name);
    }

    public String[] getParameters(String name) {
        List parameters = this.request.getParameterValues(name);
        if (parameters == null) {
            return null;
        }
        return parameters.toArray(new String[0]);
    }

    public String getFragment() {
        return this.fragment;
    }

    public String toExternalForm() {
        if (this.uri == null) {
            this.uri = new String(this.request.getRequestURL());
        }
        return this.uri;
    }
}

