/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.transport.http.client;

import com.idoox.transport.http.ChunkableInputStream;
import com.idoox.transport.http.ChunkableOutputStream;
import com.idoox.transport.http.client.HttpPool;
import com.idoox.transport.http.client.HttpRequest;
import com.idoox.transport.util.Bytes;
import com.idoox.transport.util.Headers;
import com.idoox.transport.util.ReadLine;
import com.idoox.transport.util.SocketEx;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.Set;
import org.idoox.transport.RawInputMessage;
import org.idoox.transport.client.Endpoint;
import org.idoox.util.RuntimeWrappedException;
import org.idoox.wasp.InstanceNotFoundException;
import org.systinet.wasp.webservice.Current;

public class HttpResponse
extends RawInputMessage {
    private SocketEx socket;
    private HttpRequest request;
    private boolean finishRequest;
    private int statusCode;
    private String statusMessage;
    private Headers headers;
    private boolean isInit = false;
    private boolean doClose = false;
    private boolean close = false;
    public static byte SPACE = (byte)32;

    public HttpResponse(SocketEx socket, HttpRequest request, boolean finishRequest) {
        super(socket.input);
        this.socket = socket;
        this.request = request;
        this.finishRequest = finishRequest;
        this.headers = new Headers(13);
    }

    public int getStatusCode() throws IOException {
        this.letsGo();
        return this.statusCode;
    }

    public String getStatusMessage() throws IOException {
        this.letsGo();
        return this.statusMessage;
    }

    public Set getHeaderNames() throws IOException {
        this.letsGo();
        return this.headers.getNames();
    }

    public String getStringHeader(String name) throws IOException {
        this.letsGo();
        return this.headers.get(name);
    }

    public int read() throws IOException {
        this.letsGo();
        try {
            return this.getWrappedStream().read();
        }
        catch (IOException e) {
            this.doClose = true;
            throw e;
        }
    }

    public int read(byte[] b) throws IOException {
        this.letsGo();
        try {
            return this.getWrappedStream().read(b);
        }
        catch (IOException e) {
            this.doClose = true;
            throw e;
        }
    }

    public int read(byte[] b, int off, int len) throws IOException {
        this.letsGo();
        try {
            return this.getWrappedStream().read(b, off, len);
        }
        catch (IOException e) {
            this.doClose = true;
            throw e;
        }
    }

    public long skip(long n) throws IOException {
        this.letsGo();
        try {
            return this.getWrappedStream().skip(n);
        }
        catch (IOException e) {
            this.doClose = true;
            throw e;
        }
    }

    public int available() throws IOException {
        this.letsGo();
        try {
            return this.getWrappedStream().available();
        }
        catch (IOException e) {
            this.doClose = true;
            throw e;
        }
    }

    public synchronized void close() throws IOException {
        if (this.close) {
            return;
        }
        this.letsGo();
        if (!this.request.isClosed(this)) {
            return;
        }
        this.close = true;
        this.getWrappedStream().close();
        if (this.doClose) {
            this.socket.close();
        } else {
            this.socket.release();
        }
    }

    public void mark(int readlimit) {
        try {
            this.letsGo();
            this.getWrappedStream().mark(readlimit);
        }
        catch (IOException e) {
            this.doClose = true;
        }
    }

    public void reset() throws IOException {
        this.letsGo();
        try {
            this.getWrappedStream().reset();
        }
        catch (IOException e) {
            this.doClose = true;
            throw e;
        }
    }

    public boolean markSupported() {
        try {
            this.letsGo();
            return this.getWrappedStream().markSupported();
        }
        catch (IOException e) {
            this.doClose = true;
            return false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void letsGo() throws IOException {
        if (this.isInit) {
            return;
        }
        this.isInit = true;
        if (this.finishRequest) {
            this.request.close();
        }
        try {
            if (!this.request.canResponseGo() && Current.getProcessingType() == 1 && Current.getCallContext().getContextData().containsKey("org.systinet.wasp.client.RAWInvocationHelper.DontWaitForRequest")) {
                throw new IllegalStateException("HTTP response accessed before the request was sent and there is no thread able to send it. This would ALWAYS result in a deadlock!");
            }
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            // empty catch block
        }
        HttpRequest httpRequest = this.request;
        synchronized (httpRequest) {
            try {
                if (!this.request.canResponseGo()) {
                    this.request.wait();
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeWrappedException(e);
            }
        }
        int i = 0;
        if (i >= 2) return;
        {
            while (true) {
                String location;
                this.setWrappedStream(this.socket.input);
                ReadLine line = ((ChunkableInputStream)this.getWrappedStream()).line;
                line.read();
                int space1 = Bytes.indexOf(line.buffer, 0, line.count, SPACE);
                if (space1 == -1 || line.count < 8) {
                    throw new IOException("Malformed status line from HTTP server " + this.socket);
                }
                byte vernum = line.buffer[5];
                if (vernum < 48 || vernum > 57) {
                    throw new IOException("Malformed status line from HTTP server " + this.socket);
                }
                float version = vernum - 48;
                vernum = line.buffer[7];
                if (vernum < 48 || vernum > 57) {
                    throw new IOException("Malformed status line from HTTP server " + this.socket);
                }
                ((HttpPool.HttpSocketData)this.socket.ext).serverVersion = version = (float)((double)version + (double)(vernum - 48) / 10.0);
                int space2 = Bytes.indexOf(line.buffer, space1 + 1, line.count - (space1 + 1), SPACE);
                this.statusCode = space2 != -1 ? Bytes.parseInt(line.buffer, space1 + 1, space2 - (space1 + 1)) : Bytes.parseInt(line.buffer, space1 + 1, line.count - (space1 + 1));
                this.statusMessage = space2 != -1 ? new String(line.buffer, 0, space2 + 1, line.count - (space2 + 1)) : "";
                line.setInputStream(((ChunkableInputStream)this.getWrappedStream()).getRawStream());
                this.headers.read(line);
                if (this.statusCode >= 100 && this.statusCode < 200) continue;
                String te = this.getStringHeader("Transfer-Encoding");
                int cl = this.getIntHeader("Content-length");
                if (te != null && te.toLowerCase().indexOf("chunked") != -1) {
                    ((ChunkableInputStream)this.getWrappedStream()).setChunking(true);
                    ((ChunkableInputStream)this.getWrappedStream()).setContentLength(0);
                    ((ChunkableInputStream)this.getWrappedStream()).setHaveLength(true);
                } else {
                    ((ChunkableInputStream)this.getWrappedStream()).setChunking(false);
                    if (cl >= 0) {
                        ((ChunkableInputStream)this.getWrappedStream()).setContentLength(cl);
                        ((ChunkableInputStream)this.getWrappedStream()).setHaveLength(true);
                    } else {
                        ((ChunkableInputStream)this.getWrappedStream()).setHaveLength(false);
                    }
                }
                String connection = ((HttpPool.HttpSocketData)this.socket.ext).useProxy ? this.getStringHeader("Proxy-connection") : this.getStringHeader("Connection");
                this.doClose = connection != null && connection.toLowerCase().indexOf("close") != -1;
                if (this.statusCode < 300 || this.statusCode >= 400 || (location = this.getStringHeader("Location")) == null) return;
                Endpoint newEndpoint = location.indexOf(58) == -1 ? new Endpoint(this.request.getEndpoint(), location) : new Endpoint(location);
                String server = newEndpoint.getHost();
                int port = newEndpoint.getPort();
                if (port <= 0) {
                    port = 80;
                }
                if (server == null) return;
                int timeout = this.socket.getTimeout();
                Map properties = this.socket.getProperties();
                HttpPool pool = ((HttpPool.HttpSocketData)this.socket.ext).pool;
                this.close();
                OutputStream buffer = ((ChunkableOutputStream)this.socket.output).getBufferStream();
                this.socket = pool.get(null, server, port, timeout, 0, properties);
                ((ChunkableOutputStream)this.socket.output).setBufferStream(buffer);
                this.setWrappedStream(this.socket.input);
                this.request.init(this.socket, newEndpoint);
                this.request.resend();
            }
        }
    }
}

