/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.transport.http.client;

import com.idoox.transport.http.ChunkableOutputStream;
import com.idoox.transport.http.client.HttpPool;
import com.idoox.transport.http.client.HttpResponse;
import com.idoox.transport.util.Headers;
import com.idoox.transport.util.SocketEx;
import com.idoox.transport.util.TransportMethodHelper;
import com.idoox.transport.util.WriteLine;
import com.idoox.wasp.Constants;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import org.idoox.transport.RawOutputMessage;
import org.idoox.transport.TransportMethod;
import org.idoox.transport.URI;
import org.idoox.util.Base64;
import org.idoox.util.RuntimeWrappedException;
import org.systinet.wasp.Version;

public class HttpRequest
extends RawOutputMessage {
    private static final byte SPACE = 32;
    private static final byte[] HTTP;
    private static final byte[] CRLF;
    private SocketEx socket;
    private boolean chunking;
    private TransportMethod method;
    private URI endpoint;
    private String path;
    private Headers headers;
    private boolean committedHeaders = false;
    private boolean checkResponse;
    private HttpResponse response;
    private boolean canResponseGo = false;
    private boolean close = false;

    public HttpRequest(SocketEx socket, URI endpoint, TransportMethod method, boolean chunking, boolean checkResponse) throws IOException {
        super(socket.output);
        this.chunking = chunking;
        this.method = method;
        this.checkResponse = checkResponse;
        this.headers = new Headers(13);
        this.init(socket, endpoint);
    }

    public void init(SocketEx socket, URI endpoint) {
        String basicAuth;
        String proxyAuth;
        this.init(socket);
        this.headers.set("User-Agent", Version.getVersion());
        this.endpoint = endpoint;
        this.path = ((HttpPool.HttpSocketData)socket.ext).useProxy ? endpoint.toExternalForm() : endpoint.getLocation();
        if (this.path == null || this.path.length() == 0) {
            this.path = "/";
        }
        if (this.chunking && (this.method == TransportMethod.POST || this.method == TransportMethod.PUT)) {
            ((ChunkableOutputStream)this.getWrappedStream()).setChunking(true);
        } else {
            ((ChunkableOutputStream)this.getWrappedStream()).setChunking(false);
        }
        if (endpoint.getPort() >= 0) {
            this.headers.set("Host", endpoint.getHost() + ':' + endpoint.getPort());
        } else {
            this.headers.set("Host", endpoint.getHost());
        }
        if (((ChunkableOutputStream)this.getWrappedStream()).isChunking()) {
            this.headers.set("Transfer-Encoding", "chunked");
        } else {
            this.headers.remove("Transfer-Encoding");
        }
        this.headers.set("Connection", "keep-alive");
        if (((HttpPool.HttpSocketData)socket.ext).useProxy) {
            this.headers.set("Proxy-Connection", "keep-alive");
        }
        if ((proxyAuth = HttpRequest.getProxyAuthString(socket, this.getProxyUsernameKey(), this.getProxyPasswordKey())) != null) {
            this.setStringHeader("Proxy-Authorization", proxyAuth);
        }
        if ((basicAuth = HttpRequest.getBasicAuthString(socket, this.getBasicUsernameKey(), this.getBasicPasswordKey())) != null) {
            this.setStringHeader("Authorization", basicAuth);
        }
    }

    public URI getEndpoint() {
        return this.endpoint;
    }

    protected String getProxyUsernameKey() {
        return "http.proxyUserName";
    }

    protected String getProxyPasswordKey() {
        return "http.proxyPassword";
    }

    protected String getBasicUsernameKey() {
        return "http.basicUserName";
    }

    protected String getBasicPasswordKey() {
        return "http.basicPassword";
    }

    public void init(SocketEx socket) {
        this.socket = socket;
        this.close = false;
        this.committedHeaders = false;
        this.response = null;
        this.canResponseGo = false;
        this.setWrappedStream(this.socket.output);
    }

    public static String getProxyAuthString(SocketEx socket, String usernameKey, String passwordKey) {
        String proxyAuthName = null;
        String proxyAuthPass = null;
        Map props = socket.getProperties();
        if (props != null) {
            proxyAuthName = (String)props.get(usernameKey);
            proxyAuthPass = (String)props.get(passwordKey);
        }
        if (proxyAuthName == null) {
            proxyAuthName = System.getProperty(usernameKey);
            proxyAuthPass = System.getProperty(passwordKey);
        }
        if (proxyAuthName != null) {
            if (proxyAuthPass == null) {
                proxyAuthPass = "";
            }
            try {
                byte[] user_pass = (proxyAuthName + ":" + proxyAuthPass).getBytes(Constants.UTF_8);
                user_pass = Base64.encode(user_pass, false);
                String basicAuth = "Basic " + new String(user_pass, Constants.UTF_8);
                return basicAuth;
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeWrappedException(e);
            }
        }
        return null;
    }

    public static String getBasicAuthString(SocketEx socket, String usernameKey, String passwordKey) {
        String basicAuthName = null;
        String basicAuthPass = null;
        Map props = socket.getProperties();
        if (props == null) {
            return null;
        }
        basicAuthName = (String)props.get(usernameKey);
        basicAuthPass = (String)props.get(passwordKey);
        if (basicAuthName == null) {
            return null;
        }
        if (basicAuthPass == null) {
            basicAuthPass = "";
        }
        try {
            byte[] user_pass = (basicAuthName + ":" + basicAuthPass).getBytes(Constants.UTF_8);
            user_pass = Base64.encode(user_pass, false);
            String basicAuth = "Basic " + new String(user_pass, Constants.UTF_8);
            return basicAuth;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeWrappedException(e);
        }
    }

    public void setStatusCode(int sc) {
        this.setIntHeader("x-wasp-sc", sc);
    }

    public void setStringHeader(String name, String value) {
        if (this.committedHeaders) {
            throw new RuntimeException("Headers already committed");
        }
        this.headers.set(name, value);
    }

    public void write(int b) throws IOException {
        if (!this.committedHeaders && ((ChunkableOutputStream)this.getWrappedStream()).isChunking()) {
            this.letsGo(false);
        }
        try {
            super.write(b);
        }
        catch (IOException e) {
            if (((ChunkableOutputStream)this.getWrappedStream()).isChunking()) {
                this.letsGo(false);
                super.write(b);
            }
            throw e;
        }
    }

    public void write(byte[] b) throws IOException {
        if (!this.committedHeaders && ((ChunkableOutputStream)this.getWrappedStream()).isChunking()) {
            this.letsGo(false);
        }
        try {
            super.write(b, 0, b.length);
        }
        catch (IOException e) {
            if (((ChunkableOutputStream)this.getWrappedStream()).isChunking()) {
                this.letsGo(false);
                super.write(b, 0, b.length);
            }
            throw e;
        }
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (!this.committedHeaders && ((ChunkableOutputStream)this.getWrappedStream()).isChunking()) {
            this.letsGo(false);
        }
        try {
            super.write(b, off, len);
        }
        catch (IOException e) {
            if (((ChunkableOutputStream)this.getWrappedStream()).isChunking()) {
                this.letsGo(false);
                super.write(b, off, len);
            }
            throw e;
        }
    }

    public void flush() throws IOException {
        this.letsGo(false);
    }

    public synchronized boolean isClosed(HttpResponse response) {
        this.response = response;
        return this.close;
    }

    public synchronized void close() throws IOException {
        if (this.close) {
            return;
        }
        this.letsGo(true);
        this.close = true;
        if (this.response != null) {
            this.response.close();
        }
        if (this.checkResponse) {
            this.response = new HttpResponse(this.socket, this, false);
            if (this.response.getStatusCode() >= 300) {
                this.response.close();
                throw new IOException("HTTP server " + this.socket + " returned an error: " + this.response.getStatusCode() + " - " + this.response.getStatusMessage());
            }
            this.response.close();
        }
        this.response = null;
    }

    public boolean canResponseGo() {
        return this.canResponseGo;
    }

    public void resend() throws IOException {
        this.committedHeaders = false;
        this.close = false;
        ((ChunkableOutputStream)this.getWrappedStream()).restore();
        this.close();
    }

    private void letsGo(boolean close) throws IOException {
        int i = 0;
        while (i < 2) {
            try {
                boolean committed = false;
                if (!this.committedHeaders) {
                    boolean chunking = ((ChunkableOutputStream)this.getWrappedStream()).isChunking();
                    if (close || chunking) {
                        OutputStream rawOutput = ((ChunkableOutputStream)this.getWrappedStream()).getRawStream();
                        WriteLine line = ((ChunkableOutputStream)this.getWrappedStream()).line;
                        rawOutput.write(TransportMethodHelper.toBytes(this.method));
                        rawOutput.write(32);
                        line.write(this.path, false);
                        rawOutput.write(32);
                        rawOutput.write(HTTP);
                        rawOutput.write(CRLF);
                        if (close && !((ChunkableOutputStream)this.getWrappedStream()).isChunking() && (this.method == TransportMethod.POST || this.method == TransportMethod.PUT)) {
                            this.setIntHeader("Content-length", ((ChunkableOutputStream)this.getWrappedStream()).getContentLength());
                        }
                        this.headers.write(line);
                        this.committedHeaders = true;
                        committed = true;
                    }
                }
                this.getWrappedStream().flush();
                if (close) {
                    this.getWrappedStream().close();
                }
                if (!committed || this.canResponseGo) break;
                HttpRequest chunking = this;
                synchronized (chunking) {
                    this.canResponseGo = true;
                    this.notify();
                    break;
                }
            }
            catch (InterruptedIOException e) {
                throw e;
            }
            catch (IOException e) {
                boolean chunking;
                OutputStream buffer;
                if (i == 0 && !this.socket.isFresh()) {
                    try {
                        this.socket.close();
                    }
                    catch (IOException _e) {
                        // empty catch block
                    }
                    buffer = ((ChunkableOutputStream)this.socket.output).getBufferStream();
                    chunking = ((ChunkableOutputStream)this.socket.output).isChunking();
                    try {
                        this.socket.open();
                    }
                    catch (IOException _e) {
                        if (!this.canResponseGo) {
                            HttpRequest httpRequest = this;
                            synchronized (httpRequest) {
                                this.canResponseGo = true;
                                this.notify();
                            }
                        }
                        throw _e;
                    }
                }
                if (!this.canResponseGo) {
                    HttpRequest httpRequest = this;
                    synchronized (httpRequest) {
                        this.canResponseGo = true;
                        this.notify();
                    }
                }
                throw e;
                ((ChunkableOutputStream)this.socket.output).setBufferStream(buffer);
                ((ChunkableOutputStream)this.socket.output).setChunking(chunking);
                this.setWrappedStream(this.socket.output);
                this.committedHeaders = false;
                ++i;
            }
        }
    }

    static {
        try {
            HTTP = "HTTP/1.1".getBytes("US-ASCII");
            CRLF = "\r\n".getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeWrappedException(e);
        }
    }
}

