/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.transport.http.client;

import com.idoox.transport.http.ChunkableInputStream;
import com.idoox.transport.http.ChunkableOutputStream;
import com.idoox.transport.util.SocketEx;
import com.idoox.transport.util.SocketPool;
import com.idoox.util.ThreadPool;
import java.io.IOException;
import java.net.BindException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.StringTokenizer;

public class HttpPool
extends SocketPool {
    private String proxyHost;
    private int proxyPort;
    private Set nonProxyHosts;
    private ConnectPool connectPool = new ConnectPool(0, 50, true);
    private int chunkSize = 16384;

    public HttpPool(int initialSize) {
        super(initialSize);
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    public void setChunkSize(int chunkSize) {
        this.chunkSize = chunkSize;
    }

    public void setNonProxyHosts(String nonProxyHosts) {
        this.nonProxyHosts = null;
        if (nonProxyHosts != null) {
            StringTokenizer hostsTokenizer = new StringTokenizer(nonProxyHosts, ",", false);
            this.nonProxyHosts = new HashSet(0);
            while (hostsTokenizer.hasMoreTokens()) {
                try {
                    this.nonProxyHosts.add(InetAddress.getByName(hostsTokenizer.nextToken()));
                }
                catch (UnknownHostException unknownHostException) {
                    // empty catch block
                }
            }
        }
    }

    protected Socket newSocket(SocketEx socket, String server, int port, int timeout) throws IOException {
        Object i;
        boolean nonProxyHost = false;
        if (this.proxyHost != null) {
            if (this.nonProxyHosts != null) {
                try {
                    InetAddress serverAddress = InetAddress.getByName(server);
                    i = this.nonProxyHosts.iterator();
                    while (i.hasNext()) {
                        InetAddress host = (InetAddress)i.next();
                        if (!host.equals(serverAddress)) continue;
                        nonProxyHost = true;
                        break;
                    }
                }
                catch (UnknownHostException e) {
                    // empty catch block
                }
            }
            if (!nonProxyHost) {
                server = this.proxyHost;
                port = this.proxyPort;
            }
        }
        SocketHolder holder = new SocketHolder(server, port);
        try {
            i = holder;
            synchronized (i) {
                this.connectPool.job(holder);
                if (timeout < 0) {
                    holder.wait();
                } else {
                    holder.wait(timeout);
                }
            }
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        if (holder.exception != null) {
            if (holder.exception instanceof ConnectException) {
                throw new ConnectException("Connection to " + socket + " refused");
            }
            throw holder.exception;
        }
        if (holder.socket == null) {
            throw new NoRouteToHostException("Connection to " + socket + " timed out");
        }
        if (timeout >= 0) {
            holder.socket.setSoTimeout(timeout);
        }
        socket.ext = new HttpSocketData(0.0f, this, !nonProxyHost && this.proxyHost != null);
        return holder.socket;
    }

    protected void hello(SocketEx socket, String userinfo, String host, int port) throws IOException {
        socket.input = new ChunkableInputStream(socket.input);
        socket.output = new ChunkableOutputStream(socket.output, this.chunkSize);
    }

    public void clear() {
        this.connectPool.destroy();
        super.clear();
    }

    static class ConnectPool
    extends ThreadPool {
        private static int RETRY_COUNT = 3;
        private static int RETRY_INTERVAL = 100;
        private static int BIND_RETRY_COUNT = 100;
        private static int BIND_RETRY_INTERVAL = 10;

        public ConnectPool(int minThreads, int maxThreads, boolean daemon) {
            super("SocketConnect", minThreads, maxThreads, daemon);
        }

        protected void handle(Object object) {
            SocketHolder holder = (SocketHolder)object;
            Socket socket = null;
            boolean connected = false;
            int retry_count = 0;
            int bind_retry_count = 0;
            Random random = null;
            while (!connected) {
                try {
                    socket = new Socket(holder.server, holder.port);
                    connected = true;
                }
                catch (BindException e) {
                    if (random == null) {
                        random = new Random();
                    }
                    if (++bind_retry_count < BIND_RETRY_COUNT) {
                        try {
                            int i = random.nextInt(BIND_RETRY_INTERVAL);
                            Thread.sleep(i * bind_retry_count);
                        }
                        catch (InterruptedException e1) {}
                        continue;
                    }
                    holder.exception = e;
                    break;
                }
                catch (IOException e) {
                    if (random == null) {
                        random = new Random();
                    }
                    if (++retry_count < RETRY_COUNT) {
                        try {
                            Thread.sleep(random.nextInt(RETRY_INTERVAL));
                        }
                        catch (InterruptedException e1) {}
                        continue;
                    }
                    holder.exception = e;
                    break;
                }
            }
            SocketHolder socketHolder = holder;
            synchronized (socketHolder) {
                holder.socket = socket;
                holder.notify();
            }
        }

        static {
            String value = System.getProperty("wasp.transport.http.connectRetryCount");
            if (value != null) {
                RETRY_COUNT = Integer.parseInt(value);
            }
            if ((value = System.getProperty("wasp.transport.http.connectRetryInterval")) != null) {
                RETRY_INTERVAL = Integer.parseInt(value);
            }
            if ((value = System.getProperty("wasp.transport.http.connectBindRetryCount")) != null) {
                BIND_RETRY_COUNT = Integer.parseInt(value);
            }
            if ((value = System.getProperty("wasp.transport.http.connectBindRetryInterval")) != null) {
                BIND_RETRY_INTERVAL = Integer.parseInt(value);
            }
        }
    }

    static class SocketHolder {
        public Socket socket;
        public String server;
        public int port;
        public IOException exception;

        public SocketHolder(String server, int port) {
            this.server = server;
            this.port = port;
        }
    }

    public static class HttpSocketData {
        public float serverVersion;
        public HttpPool pool;
        public boolean useProxy;

        public HttpSocketData(float serverVersion, HttpPool pool, boolean useProxy) {
            this.serverVersion = serverVersion;
            this.pool = pool;
            this.useProxy = useProxy;
        }
    }
}

